/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.hydromatic.optiq.runtime.FlatLists;
import org.eigenbase.rel.AbstractRelNode;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelVisitor;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexChecker;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JoinRelBase
extends AbstractRelNode {
    protected final RexNode condition;
    protected RelNode left;
    protected RelNode right;
    protected final ImmutableSet<String> variablesStopped;
    protected JoinRelType joinType;

    protected JoinRelBase(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped) {
        super(cluster, traits);
        this.left = left;
        this.right = right;
        this.condition = condition;
        this.variablesStopped = ImmutableSet.copyOf(variablesStopped);
        assert (joinType != null);
        assert (condition != null);
        this.joinType = joinType;
    }

    @Override
    public List<RexNode> getChildExps() {
        return ImmutableList.of((Object)this.condition);
    }

    public RexNode getCondition() {
        return this.condition;
    }

    @Override
    public List<RelNode> getInputs() {
        return FlatLists.of(this.left, this.right);
    }

    public JoinRelType getJoinType() {
        return this.joinType;
    }

    public RelNode getLeft() {
        return this.left;
    }

    public RelNode getRight() {
        return this.right;
    }

    public boolean isValid_(boolean fail) {
        if (!super.isValid(fail)) {
            return false;
        }
        if (this.getRowType().getFieldCount() != this.getSystemFieldList().size() + this.left.getRowType().getFieldCount() + this.right.getRowType().getFieldCount()) {
            assert (!fail) : "field count mismatch";
            return false;
        }
        if (this.condition != null) {
            if (this.condition.getType().getSqlTypeName() != SqlTypeName.BOOLEAN) {
                assert (!fail) : "condition must be boolean: " + this.condition.getType();
                return false;
            }
            RexChecker checker = new RexChecker(this.getCluster().getTypeFactory().builder().addAll(this.getSystemFieldList()).addAll(this.getLeft().getRowType().getFieldList()).addAll(this.getRight().getRowType().getFieldList()).build(), fail);
            this.condition.accept(checker);
            if (checker.getFailureCount() > 0) {
                assert (!fail) : checker.getFailureCount() + " failures in condition " + this.condition;
                return false;
            }
        }
        return true;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        double rowCount = RelMetadataQuery.getRowCount(this);
        return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0);
    }

    public static double estimateJoinedRows(JoinRelBase joinRel, RexNode condition) {
        double product = RelMetadataQuery.getRowCount(joinRel.getLeft()) * RelMetadataQuery.getRowCount(joinRel.getRight());
        return product * RelMetadataQuery.getSelectivity(joinRel, condition);
    }

    @Override
    public double getRows() {
        return JoinRelBase.estimateJoinedRows(this, this.condition);
    }

    @Override
    public Set<String> getVariablesStopped() {
        return this.variablesStopped;
    }

    @Override
    public void childrenAccept(RelVisitor visitor) {
        visitor.visit(this.left, 0, this);
        visitor.visit(this.right, 1, this);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).input("left", this.left).input("right", this.right).item("condition", this.condition).item("joinType", this.joinType.name().toLowerCase()).itemIf("systemFields", this.getSystemFieldList(), !this.getSystemFieldList().isEmpty());
    }

    @Override
    public void replaceInput(int ordinalInParent, RelNode p) {
        switch (ordinalInParent) {
            case 0: {
                this.left = p;
                break;
            }
            case 1: {
                this.right = p;
                break;
            }
            default: {
                throw Util.newInternal();
            }
        }
    }

    @Override
    protected RelDataType deriveRowType() {
        return JoinRelBase.deriveJoinRowType(this.left.getRowType(), this.right.getRowType(), this.joinType, this.getCluster().getTypeFactory(), null, this.getSystemFieldList());
    }

    public List<RelDataTypeField> getSystemFieldList() {
        return Collections.emptyList();
    }

    public static RelDataType deriveJoinRowType(RelDataType leftType, RelDataType rightType, JoinRelType joinType, RelDataTypeFactory typeFactory, List<String> fieldNameList, List<RelDataTypeField> systemFieldList) {
        assert (systemFieldList != null);
        switch (joinType) {
            case LEFT: {
                rightType = typeFactory.createTypeWithNullability(rightType, true);
                break;
            }
            case RIGHT: {
                leftType = typeFactory.createTypeWithNullability(leftType, true);
                break;
            }
            case FULL: {
                leftType = typeFactory.createTypeWithNullability(leftType, true);
                rightType = typeFactory.createTypeWithNullability(rightType, true);
                break;
            }
        }
        return JoinRelBase.createJoinType(typeFactory, leftType, rightType, fieldNameList, systemFieldList);
    }

    public static RelDataType createJoinType(RelDataTypeFactory typeFactory, RelDataType leftType, RelDataType rightType, List<String> fieldNameList, List<RelDataTypeField> systemFieldList) {
        assert (fieldNameList == null || fieldNameList.size() == systemFieldList.size() + leftType.getFieldCount() + rightType.getFieldCount());
        List<String> nameList = new ArrayList<String>();
        ArrayList<RelDataType> typeList = new ArrayList<RelDataType>();
        HashSet<String> uniqueNameList = new HashSet<String>();
        JoinRelBase.addFields(systemFieldList, typeList, nameList, uniqueNameList);
        JoinRelBase.addFields(leftType.getFieldList(), typeList, nameList, uniqueNameList);
        if (rightType != null) {
            JoinRelBase.addFields(rightType.getFieldList(), typeList, nameList, uniqueNameList);
        }
        if (fieldNameList != null) {
            assert (fieldNameList.size() == nameList.size());
            nameList = fieldNameList;
        }
        return typeFactory.createStructType(typeList, nameList);
    }

    private static void addFields(List<RelDataTypeField> fieldList, List<RelDataType> typeList, List<String> nameList, HashSet<String> uniqueNameList) {
        for (RelDataTypeField field : fieldList) {
            String name = field.getName();
            if (uniqueNameList.contains(name)) {
                String nameBase = name;
                int j = 0;
                while (uniqueNameList.contains(name = nameBase + j)) {
                    ++j;
                }
            }
            nameList.add(name);
            uniqueNameList.add(name);
            typeList.add(field.getType());
        }
    }

    @Override
    public final JoinRelBase copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.size() == 2);
        return this.copy(traitSet, this.getCondition(), inputs.get(0), inputs.get(1), this.joinType);
    }

    public abstract JoinRelBase copy(RelTraitSet var1, RexNode var2, RelNode var3, RelNode var4, JoinRelType var5);
}

