/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.jdbc;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import net.hydromatic.linq4j.expressions.BlockBuilder;
import net.hydromatic.linq4j.expressions.BlockStatement;
import net.hydromatic.linq4j.expressions.CatchBlock;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.MethodCallExpression;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.linq4j.expressions.UnaryExpression;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.Schemas;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.impl.jdbc.JdbcConvention;
import net.hydromatic.optiq.impl.jdbc.JdbcImplementor;
import net.hydromatic.optiq.impl.jdbc.JdbcRel;
import net.hydromatic.optiq.impl.jdbc.JdbcSchema;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import net.hydromatic.optiq.rules.java.EnumerableRel;
import net.hydromatic.optiq.rules.java.EnumerableRelImplementor;
import net.hydromatic.optiq.rules.java.JavaRowFormat;
import net.hydromatic.optiq.rules.java.PhysType;
import net.hydromatic.optiq.rules.java.PhysTypeImpl;
import net.hydromatic.optiq.runtime.Hook;
import net.hydromatic.optiq.runtime.SqlFunctions;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.convert.ConverterRelImpl;
import org.eigenbase.relopt.ConventionTraitDef;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlDialect;
import org.eigenbase.sql.type.SqlTypeName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcToEnumerableConverter
extends ConverterRelImpl
implements EnumerableRel {
    protected JdbcToEnumerableConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, ConventionTraitDef.INSTANCE, traits, input);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new JdbcToEnumerableConverter(this.getCluster(), traitSet, JdbcToEnumerableConverter.sole(inputs));
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return super.computeSelfCost(planner).multiplyBy(0.1);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        Expression calendar_;
        BlockBuilder builder0 = new BlockBuilder(false);
        JdbcRel child = (JdbcRel)this.getChild();
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.prefer(JavaRowFormat.CUSTOM));
        JdbcConvention jdbcConvention = (JdbcConvention)child.getConvention();
        String sql = this.generateSql(jdbcConvention.dialect);
        if (OptiqPrepareImpl.DEBUG) {
            System.out.println("[" + sql + "]");
        }
        Hook.QUERY_PLAN.run(sql);
        Expression sql_ = builder0.append("sql", (Expression)Expressions.constant((Object)sql));
        int fieldCount = this.getRowType().getFieldCount();
        BlockBuilder builder = new BlockBuilder();
        ParameterExpression resultSet_ = Expressions.parameter((int)16, ResultSet.class, (String)builder.newName("resultSet"));
        CalendarPolicy calendarPolicy = CalendarPolicy.of(jdbcConvention.dialect);
        switch (calendarPolicy) {
            case LOCAL: {
                calendar_ = builder0.append("calendar", (Expression)Expressions.call(Calendar.class, (String)"getInstance", (Expression[])new Expression[]{this.getTimeZoneExpression(implementor)}));
                break;
            }
            default: {
                calendar_ = null;
            }
        }
        if (fieldCount == 1) {
            ParameterExpression value_ = Expressions.parameter(Object.class, (String)builder.newName("value"));
            builder.add((Statement)Expressions.declare((int)0, (ParameterExpression)value_, null));
            this.generateGet(implementor, physType, builder, resultSet_, 0, (Expression)value_, calendar_, calendarPolicy);
            builder.add((Statement)Expressions.return_(null, (Expression)value_));
        } else {
            Expression values_ = builder.append("values", (Expression)Expressions.newArrayBounds(Object.class, (int)1, (Expression)Expressions.constant((Object)fieldCount)));
            for (int i = 0; i < fieldCount; ++i) {
                this.generateGet(implementor, physType, builder, resultSet_, i, (Expression)Expressions.arrayIndex((Expression)values_, (Expression)Expressions.constant((Object)i)), calendar_, calendarPolicy);
            }
            builder.add((Statement)Expressions.return_(null, (Expression)values_));
        }
        ParameterExpression e_ = Expressions.parameter(SQLException.class, (String)builder.newName("e"));
        Expression rowBuilderFactory_ = builder0.append("rowBuilderFactory", (Expression)Expressions.lambda((BlockStatement)Expressions.block((Statement[])new Statement[]{Expressions.return_(null, (Expression)Expressions.lambda((BlockStatement)Expressions.block((Statement[])new Statement[]{Expressions.tryCatch((Statement)builder.toBlock(), (CatchBlock[])new CatchBlock[]{Expressions.catch_((ParameterExpression)e_, (Statement)Expressions.throw_((Expression)Expressions.new_(RuntimeException.class, (Expression[])new Expression[]{e_})))})}), (ParameterExpression[])new ParameterExpression[0]))}), (ParameterExpression[])new ParameterExpression[]{resultSet_}));
        Expression enumerable = builder0.append("enumerable", (Expression)Expressions.call((Method)BuiltinMethod.RESULT_SET_ENUMERABLE_OF.method, (Expression[])new Expression[]{Expressions.call((Expression)Schemas.unwrap(jdbcConvention.expression, JdbcSchema.class), (Method)BuiltinMethod.JDBC_SCHEMA_DATA_SOURCE.method, (Expression[])new Expression[0]), sql_, rowBuilderFactory_}));
        builder0.add((Statement)Expressions.return_(null, (Expression)enumerable));
        return implementor.result(physType, builder0.toBlock());
    }

    private UnaryExpression getTimeZoneExpression(EnumerableRelImplementor implementor) {
        return Expressions.convert_((Expression)Expressions.call((Expression)implementor.getRootExpression(), (String)"get", (Expression[])new Expression[]{Expressions.constant((Object)"timeZone")}), TimeZone.class);
    }

    private void generateGet(EnumerableRelImplementor implementor, PhysType physType, BlockBuilder builder, ParameterExpression resultSet_, int i, Expression target, Expression calendar_, CalendarPolicy calendarPolicy) {
        MethodCallExpression source;
        Primitive primitive = Primitive.ofBoxOr((Type)physType.fieldClass(i));
        RelDataType fieldType = physType.getRowType().getFieldList().get(i).getType();
        ArrayList<Object> dateTimeArgs = new ArrayList<Object>();
        dateTimeArgs.add(Expressions.constant((Object)(i + 1)));
        SqlTypeName sqlTypeName = fieldType.getSqlTypeName();
        boolean offset = false;
        switch (calendarPolicy) {
            case LOCAL: {
                dateTimeArgs.add(calendar_);
                break;
            }
            case NULL: {
                dateTimeArgs.add(Expressions.constant(null));
                break;
            }
            case DIRECT: {
                sqlTypeName = SqlTypeName.ANY;
                break;
            }
            case SHIFT: {
                switch (sqlTypeName) {
                    case TIMESTAMP: 
                    case DATE: {
                        offset = true;
                    }
                }
            }
        }
        switch (sqlTypeName) {
            case TIMESTAMP: 
            case DATE: 
            case TIME: {
                source = Expressions.call((Method)this.getMethod(sqlTypeName, fieldType.isNullable(), offset), (Iterable)Expressions.list().append((Object)Expressions.call((Expression)resultSet_, (Method)this.getMethod2(sqlTypeName), dateTimeArgs)).appendIf(offset, (Object)this.getTimeZoneExpression(implementor)));
                break;
            }
            default: {
                source = Expressions.call((Expression)resultSet_, (String)this.jdbcGetMethod(primitive), (Expression[])new Expression[]{Expressions.constant((Object)(i + 1))});
            }
        }
        builder.add(Expressions.statement((Expression)Expressions.assign((Expression)target, (Expression)source)));
    }

    private Method getMethod(SqlTypeName sqlTypeName, boolean nullable, boolean offset) {
        switch (sqlTypeName) {
            case DATE: {
                return (nullable ? BuiltinMethod.DATE_TO_INT_OPTIONAL : BuiltinMethod.DATE_TO_INT).method;
            }
            case TIME: {
                return (nullable ? BuiltinMethod.TIME_TO_INT_OPTIONAL : BuiltinMethod.TIME_TO_INT).method;
            }
            case TIMESTAMP: {
                return (nullable ? (offset ? BuiltinMethod.TIMESTAMP_TO_LONG_OPTIONAL_OFFSET : BuiltinMethod.TIMESTAMP_TO_LONG_OPTIONAL) : (offset ? BuiltinMethod.TIMESTAMP_TO_LONG_OFFSET : BuiltinMethod.TIMESTAMP_TO_LONG)).method;
            }
        }
        throw new AssertionError((Object)((Object)((Object)sqlTypeName) + ":" + nullable));
    }

    private Method getMethod2(SqlTypeName sqlTypeName) {
        switch (sqlTypeName) {
            case DATE: {
                return BuiltinMethod.RESULT_SET_GET_DATE2.method;
            }
            case TIME: {
                return BuiltinMethod.RESULT_SET_GET_TIME2.method;
            }
            case TIMESTAMP: {
                return BuiltinMethod.RESULT_SET_GET_TIMESTAMP2.method;
            }
        }
        throw new AssertionError((Object)sqlTypeName);
    }

    private String jdbcGetMethod(Primitive primitive) {
        return primitive == null ? "getObject" : "get" + SqlFunctions.initcap(primitive.primitiveName);
    }

    private String generateSql(SqlDialect dialect) {
        JdbcImplementor jdbcImplementor = new JdbcImplementor(dialect, (JavaTypeFactory)this.getCluster().getTypeFactory());
        JdbcImplementor.Result result = jdbcImplementor.visitChild(0, this.getChild());
        return result.asQuery().toSqlString(dialect).getSql();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CalendarPolicy {
        NONE,
        NULL,
        LOCAL,
        DIRECT,
        SHIFT;


        static CalendarPolicy of(SqlDialect dialect) {
            switch (dialect.getDatabaseProduct()) {
                case MYSQL: {
                    return SHIFT;
                }
            }
            return NULL;
        }
    }
}

