/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.jdbc;

import java.util.Collections;
import java.util.List;
import net.hydromatic.optiq.impl.jdbc.JdbcConvention;
import net.hydromatic.optiq.impl.jdbc.JdbcImplementor;
import net.hydromatic.optiq.impl.jdbc.JdbcRel;
import net.hydromatic.optiq.impl.jdbc.JdbcRules;
import net.hydromatic.optiq.impl.jdbc.JdbcTable;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.TableAccessRelBase;
import org.eigenbase.rel.rules.PushFilterPastSetOpRule;
import org.eigenbase.rel.rules.RemoveTrivialProjectRule;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.sql.SqlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcTableScan
extends TableAccessRelBase
implements JdbcRel {
    final JdbcTable jdbcTable;

    protected JdbcTableScan(RelOptCluster cluster, RelOptTable table, JdbcTable jdbcTable, JdbcConvention jdbcConvention) {
        super(cluster, cluster.traitSetOf(jdbcConvention), table);
        this.jdbcTable = jdbcTable;
        assert (jdbcTable != null);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return new JdbcTableScan(this.getCluster(), this.table, this.jdbcTable, (JdbcConvention)this.getConvention());
    }

    @Override
    public void register(RelOptPlanner planner) {
        JdbcConvention out = (JdbcConvention)this.getConvention();
        for (RelOptRule rule : JdbcRules.rules(out)) {
            planner.addRule(rule);
        }
        planner.addRule(PushFilterPastSetOpRule.INSTANCE);
        planner.addRule(RemoveTrivialProjectRule.INSTANCE);
    }

    @Override
    public JdbcImplementor.Result implement(JdbcImplementor implementor) {
        return implementor.result((SqlNode)this.jdbcTable.tableName(), Collections.singletonList(JdbcImplementor.Clause.FROM), this);
    }
}

