/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eigenbase.util.Util;

public class OptionsList {
    private final ArrayList<Group> optionGroups = new ArrayList();
    private final ArrayList<Option> options = new ArrayList();

    public OptionsList() {
    }

    public OptionsList(Option[] options) {
        Collections.addAll(this.options, options);
    }

    public void add(Option option) {
        this.options.add(option);
    }

    public void constrain(Option[] options, int minCount, int maxCount) {
        Option[] optionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            if (option.required) {
                throw new AssertionError((Object)"!options[i].required");
            }
            ++n2;
        }
        this.optionGroups.add(new Group(minCount, maxCount, options));
    }

    public void parse(String[] args) {
        Option[] options = this.toArray();
        final HashSet usedOptions = new HashSet();
        Option[] optionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            option.setHandler(new OptionHandler(){

                public void invalidValue(Option option, String value) {
                }

                public void set(Option option, Object value, boolean explicit) {
                    usedOptions.add(option);
                }
            });
            ++n2;
        }
        int i = 0;
        while (i < args.length) {
            Option[] optionArray2 = options;
            int n3 = options.length;
            n = 0;
            while (n < n3) {
                int k;
                Option option = optionArray2[n];
                if (!usedOptions.contains(option) && (k = option.match(args, i)) > i) break;
                ++n;
            }
            ++i;
        }
        optionArray = options;
        n = options.length;
        int n4 = 0;
        while (n4 < n) {
            Option option = optionArray[n4];
            if (option.required && !usedOptions.contains(option)) {
                throw new RuntimeException("Mandatory option '" + option.getName() + "' was not specified");
            }
            ++n4;
        }
        for (Group group : this.optionGroups) {
            int count = 0;
            int j = 0;
            while (j < options.length) {
                Option option = group.options[j];
                if (usedOptions.contains(option)) {
                    ++count;
                }
                ++j;
            }
            if (count > group.maxCount) {
                throw new RuntimeException("More than " + group.maxCount + " of the following options were specified: " + group.description);
            }
            if (count >= group.minCount) continue;
            throw new RuntimeException("Fewer than " + group.minCount + " of the following options were specified: " + group.description);
        }
        Option[] optionArray3 = options;
        n = options.length;
        int n5 = 0;
        while (n5 < n) {
            Option option = optionArray3[n5];
            if (!usedOptions.contains(option) && option.defaultValue != null) {
                option.set(option.defaultValue, false);
            }
            ++n5;
        }
    }

    public Option[] toArray() {
        return this.options.toArray(new Option[this.options.size()]);
    }

    public class BasicOptionHandler
    implements OptionHandler {
        public void invalidValue(Option option, String value) {
        }

        public void set(Option option, Object value, boolean isExplicit) {
        }
    }

    public static class BooleanOption
    extends Option {
        public BooleanOption(String flag, String option, String description, boolean required, boolean anonymous, boolean defaultValue) {
            super(flag, option, description, required, anonymous, defaultValue);
        }

        public boolean booleanValue() {
            return (Boolean)this.value;
        }

        protected void readArg(String arg) {
            if (arg.equals("true")) {
                this.set(Boolean.TRUE, true);
            } else if (arg.equals("false")) {
                this.set(Boolean.FALSE, true);
            } else {
                this.valueError(arg);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumeratedOption
    extends Option {
        private final Class<? extends Enum> enumeration;

        public EnumeratedOption(String flag, String option, String description, boolean required, boolean anonymous, Enum defaultValue, Class<? extends Enum> enumeration) {
            super(flag, option, description, required, anonymous, defaultValue);
            this.enumeration = enumeration;
        }

        @Override
        protected void readArg(String arg) {
            Enum value = Util.enumVal(this.enumeration, arg);
            if (value == null) {
                this.valueError(arg);
            } else {
                this.set(value, true);
            }
        }
    }

    private static class Group {
        private final String description;
        private final Option[] options;
        private final int maxCount;
        private final int minCount;

        Group(int maxCount, int minCount, Option[] options) {
            this.maxCount = maxCount;
            this.minCount = minCount;
            this.options = options;
            StringBuilder buf = new StringBuilder("{");
            int j = 0;
            while (j < this.options.length) {
                Option option = this.options[j];
                if (j > 0) {
                    buf.append(", ");
                }
                buf.append(option.getName());
                ++j;
            }
            buf.append("}");
            this.description = buf.toString();
        }
    }

    public static class NumberOption
    extends Option {
        public NumberOption(String flag, String option, String description, boolean required, boolean anonymous, Number defaultValue) {
            super(flag, option, description, required, anonymous, defaultValue);
        }

        public double doubleValue() {
            return ((Number)this.value).doubleValue();
        }

        public int intValue() {
            return ((Number)this.value).intValue();
        }

        protected void readArg(String arg) {
            try {
                long value = Long.parseLong(arg);
                this.set(value, true);
            }
            catch (NumberFormatException e) {
                try {
                    double doubleValue = Double.parseDouble(arg);
                    this.set(doubleValue, true);
                }
                catch (NumberFormatException e1) {
                    this.valueError(arg);
                }
            }
        }
    }

    public static abstract class Option {
        protected Object value;
        private final Object defaultValue;
        private final String description;
        private final String flag;
        private final String name;
        private final boolean required;
        private List<OptionHandler> handlers = new ArrayList<OptionHandler>();

        Option(String flag, String option, String description, boolean required, boolean anonymous, Object defaultValue) {
            this.flag = flag;
            this.name = option;
            this.required = required;
            this.defaultValue = defaultValue;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public void setHandler(OptionHandler handler) {
            this.handlers.add(handler);
        }

        public String getName() {
            return this.name != null ? this.name : this.flag;
        }

        public Object getValue() {
            return this.value;
        }

        public int match(String[] args, int i) {
            String arg = args[i];
            if (arg.startsWith("-") && this.flag != null && arg.equals("-" + this.flag)) {
                if (this instanceof BooleanOption) {
                    this.set(true, true);
                    return i + 1;
                }
                if (i < args.length - 1) {
                    this.readArg(args[i + 1]);
                    return i + 2;
                }
            }
            if (this.name != null && arg.startsWith(String.valueOf(this.name) + "=")) {
                this.readArg(arg.substring((String.valueOf(this.name) + "=").length()));
                return i + 1;
            }
            return i;
        }

        public void set(Object value, boolean isExplicit) {
            this.value = value;
            for (OptionHandler handler : this.handlers) {
                handler.set(this, value, isExplicit);
            }
        }

        protected abstract void readArg(String var1);

        protected void valueError(String arg) {
            for (OptionHandler handler : this.handlers) {
                handler.invalidValue(this, arg);
            }
        }
    }

    static interface OptionHandler {
        public void invalidValue(Option var1, String var2);

        public void set(Option var1, Object var2, boolean var3);
    }

    public static class StringOption
    extends Option {
        public StringOption(String flag, String option, String description, boolean required, boolean anonymous, String defaultValue) {
            super(flag, option, description, required, anonymous, defaultValue);
        }

        public String stringValue() {
            return (String)this.value;
        }

        protected void readArg(String arg) {
            this.set(arg, true);
        }
    }
}

