/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.Linq4j;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerIntervalSet
extends AbstractSet<Integer> {
    private final String s;

    private IntegerIntervalSet(String s) {
        this.s = s;
    }

    private static void visit(String s, Handler handler) {
        String[] split;
        String[] stringArray = split = s.split(",");
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s1 = stringArray[n2];
            if (!s1.isEmpty()) {
                String[] split1;
                boolean exclude = false;
                if (s1.startsWith("-")) {
                    s1 = s1.substring(1);
                    exclude = true;
                }
                if ((split1 = s1.split("-")).length == 1) {
                    int n3 = Integer.parseInt(split1[0]);
                    handler.range(n3, n3, exclude);
                } else {
                    int n0 = Integer.parseInt(split1[0]);
                    int n1 = Integer.parseInt(split1[1]);
                    handler.range(n0, n1, exclude);
                }
            }
            ++n2;
        }
    }

    public static Set<Integer> of(String s) {
        return new IntegerIntervalSet(s);
    }

    @Override
    public Iterator<Integer> iterator() {
        return Linq4j.enumeratorIterator(this.enumerator());
    }

    @Override
    public int size() {
        int n = 0;
        Enumerator<Integer> e = this.enumerator();
        while (e.moveNext()) {
            ++n;
        }
        return n;
    }

    private Enumerator<Integer> enumerator() {
        final int[] bounds = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
        IntegerIntervalSet.visit(this.s, new Handler(){

            public void range(int start, int end, boolean exclude) {
                if (!exclude) {
                    bounds[0] = Math.min(bounds[0], start);
                    bounds[1] = Math.max(bounds[1], end);
                }
            }
        });
        return new Enumerator<Integer>(){
            int i;
            {
                this.i = nArray[0] - 1;
            }

            public Integer current() {
                return this.i;
            }

            public boolean moveNext() {
                do {
                    if (++this.i <= bounds[1]) continue;
                    return false;
                } while (!IntegerIntervalSet.this.contains(this.i));
                return true;
            }

            public void reset() {
                this.i = bounds[0] - 1;
            }

            public void close() {
            }
        };
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof Number && this.contains(((Number)o).intValue());
    }

    public boolean contains(final int n) {
        final boolean[] bs = new boolean[1];
        IntegerIntervalSet.visit(this.s, new Handler(){

            public void range(int start, int end, boolean exclude) {
                if (start <= n && n <= end) {
                    bs[0] = !exclude;
                }
            }
        });
        return bs[0];
    }

    private static interface Handler {
        public void range(int var1, int var2, boolean var3);
    }
}

