/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util;

import java.util.AbstractList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeList<T>
extends AbstractList<T> {
    private final List<T>[] lists;

    public CompositeList(List<T> ... lists) {
        this.lists = lists;
    }

    public static <T> CompositeList<T> of(List<T> ... lists) {
        return new CompositeList<T>(lists);
    }

    @Override
    public T get(int index) {
        List<T>[] listArray = this.lists;
        int n = this.lists.length;
        int n2 = 0;
        while (n2 < n) {
            List<T> list = listArray[n2];
            int nextIndex = index - list.size();
            if (nextIndex < 0) {
                return list.get(index);
            }
            index = nextIndex;
            ++n2;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int size() {
        int n = 0;
        List<T>[] listArray = this.lists;
        int n2 = this.lists.length;
        int n3 = 0;
        while (n3 < n2) {
            List<T> list = listArray[n3];
            n += list.size();
            ++n3;
        }
        return n;
    }
}

