/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;

public class BarfingInvocationHandler
implements InvocationHandler {
    protected BarfingInvocationHandler() {
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> clazz = this.getClass();
        Method matchingMethod = null;
        try {
            matchingMethod = clazz.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            throw this.noMethod(method);
        }
        catch (SecurityException e) {
            throw this.noMethod(method);
        }
        if (matchingMethod.getReturnType() != method.getReturnType()) {
            throw this.noMethod(method);
        }
        try {
            return matchingMethod.invoke((Object)this, args);
        }
        catch (UndeclaredThrowableException e) {
            throw e.getCause();
        }
    }

    protected UnsupportedOperationException noMethod(Method method) {
        StringBuilder buf = new StringBuilder();
        Class<?>[] parameterTypes = method.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(parameterTypes[i].getName());
            ++i;
        }
        String signature = String.valueOf(method.getReturnType().getName()) + " " + method.getDeclaringClass().getName() + "." + method.getName() + "(" + buf.toString() + ")";
        return new UnsupportedOperationException(signature);
    }
}

