/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import com.google.common.collect.ImmutableList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.linq4j.Ord;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.resource.Feature;
import org.eigenbase.sql.JoinConditionType;
import org.eigenbase.sql.JoinType;
import org.eigenbase.sql.SqlAccessEnum;
import org.eigenbase.sql.SqlBasicCall;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlDataTypeSpec;
import org.eigenbase.sql.SqlDelete;
import org.eigenbase.sql.SqlDynamicParam;
import org.eigenbase.sql.SqlExplain;
import org.eigenbase.sql.SqlFunction;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlInsert;
import org.eigenbase.sql.SqlIntervalQualifier;
import org.eigenbase.sql.SqlJoin;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlMerge;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlOperatorTable;
import org.eigenbase.sql.SqlOrderBy;
import org.eigenbase.sql.SqlSampleSpec;
import org.eigenbase.sql.SqlSelect;
import org.eigenbase.sql.SqlSyntax;
import org.eigenbase.sql.SqlUpdate;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.SqlWindow;
import org.eigenbase.sql.SqlWith;
import org.eigenbase.sql.SqlWithItem;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.util.SqlShuttle;
import org.eigenbase.sql.util.SqlVisitor;
import org.eigenbase.sql.validate.AggFinder;
import org.eigenbase.sql.validate.AggregatingScope;
import org.eigenbase.sql.validate.AggregatingSelectScope;
import org.eigenbase.sql.validate.AliasNamespace;
import org.eigenbase.sql.validate.DelegatingScope;
import org.eigenbase.sql.validate.EmptyScope;
import org.eigenbase.sql.validate.FieldNamespace;
import org.eigenbase.sql.validate.IdentifierNamespace;
import org.eigenbase.sql.validate.JoinNamespace;
import org.eigenbase.sql.validate.JoinScope;
import org.eigenbase.sql.validate.OverScope;
import org.eigenbase.sql.validate.ParameterScope;
import org.eigenbase.sql.validate.SelectNamespace;
import org.eigenbase.sql.validate.SelectScope;
import org.eigenbase.sql.validate.SetopNamespace;
import org.eigenbase.sql.validate.SqlConformance;
import org.eigenbase.sql.validate.SqlIdentifierMoniker;
import org.eigenbase.sql.validate.SqlMoniker;
import org.eigenbase.sql.validate.SqlMonikerImpl;
import org.eigenbase.sql.validate.SqlMonikerType;
import org.eigenbase.sql.validate.SqlScopedShuttle;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorCatalogReader;
import org.eigenbase.sql.validate.SqlValidatorNamespace;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.sql.validate.SqlValidatorTable;
import org.eigenbase.sql.validate.SqlValidatorUtil;
import org.eigenbase.sql.validate.SqlValidatorWithHints;
import org.eigenbase.sql.validate.WithNamespace;
import org.eigenbase.sql.validate.WithScope;
import org.eigenbase.trace.EigenbaseTrace;
import org.eigenbase.util.EigenbaseException;
import org.eigenbase.util.IdentityHashSet;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Static;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlValidatorImpl
implements SqlValidatorWithHints {
    public static final Logger TRACER = EigenbaseTrace.PARSER_LOGGER;
    public static final String UPDATE_SRC_ALIAS = "SYS$SRC";
    public static final String UPDATE_TGT_ALIAS = "SYS$TGT";
    public static final String UPDATE_ANON_PREFIX = "SYS$ANON";
    private final SqlOperatorTable opTab;
    final SqlValidatorCatalogReader catalogReader;
    protected final Map<String, IdInfo> idPositions = new HashMap<String, IdInfo>();
    protected final Map<SqlNode, SqlValidatorScope> scopes = new IdentityHashMap<SqlNode, SqlValidatorScope>();
    private final Map<SqlSelect, SqlValidatorScope> whereScopes = new IdentityHashMap<SqlSelect, SqlValidatorScope>();
    private final Map<SqlSelect, SqlValidatorScope> selectScopes = new IdentityHashMap<SqlSelect, SqlValidatorScope>();
    private final Map<SqlSelect, SqlValidatorScope> orderScopes = new IdentityHashMap<SqlSelect, SqlValidatorScope>();
    private final Map<SqlSelect, SqlValidatorScope> cursorScopes = new IdentityHashMap<SqlSelect, SqlValidatorScope>();
    protected final Map<SqlNode, SqlValidatorNamespace> namespaces = new IdentityHashMap<SqlNode, SqlValidatorNamespace>();
    private final Set<SqlNode> cursorSet = new IdentityHashSet<SqlNode>();
    protected final Stack<FunctionParamInfo> functionCallStack = new Stack();
    private int nextGeneratedId;
    protected final RelDataTypeFactory typeFactory;
    protected final RelDataType unknownType;
    private final RelDataType booleanType;
    private final Map<SqlNode, RelDataType> nodeToTypeMap = new IdentityHashMap<SqlNode, RelDataType>();
    private final AggFinder aggFinder = new AggFinder(false);
    private final AggFinder aggOrOverFinder = new AggFinder(true);
    private final SqlConformance conformance;
    private final Map<SqlNode, SqlNode> originalExprs = new HashMap<SqlNode, SqlNode>();
    protected boolean expandIdentifiers;
    protected boolean expandColumnReferences;
    private boolean rewriteCalls;
    private boolean validatingSqlMerge;

    protected SqlValidatorImpl(SqlOperatorTable opTab, SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory, SqlConformance conformance) {
        Linq4j.requireNonNull((Object)opTab);
        Linq4j.requireNonNull((Object)catalogReader);
        Linq4j.requireNonNull((Object)typeFactory);
        Linq4j.requireNonNull((Object)((Object)conformance));
        this.opTab = opTab;
        this.catalogReader = catalogReader;
        this.typeFactory = typeFactory;
        this.conformance = conformance;
        this.unknownType = typeFactory.createSqlType(SqlTypeName.NULL);
        this.booleanType = typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        this.rewriteCalls = true;
        this.expandColumnReferences = true;
    }

    @Override
    public SqlConformance getConformance() {
        return this.conformance;
    }

    @Override
    public SqlValidatorCatalogReader getCatalogReader() {
        return this.catalogReader;
    }

    @Override
    public SqlOperatorTable getOperatorTable() {
        return this.opTab;
    }

    @Override
    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public RelDataType getUnknownType() {
        return this.unknownType;
    }

    @Override
    public SqlNodeList expandStar(SqlNodeList selectList, SqlSelect select, boolean includeSystemVars) {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        ArrayList<Map.Entry<String, RelDataType>> types = new ArrayList<Map.Entry<String, RelDataType>>();
        int i = 0;
        while (i < selectList.size()) {
            SqlNode selectItem = selectList.get(i);
            this.expandSelectItem(selectItem, select, list, new LinkedHashSet<String>(), types, includeSystemVars);
            ++i;
        }
        this.getRawSelectScope(select).setExpandedSelectList(list);
        return new SqlNodeList(list, SqlParserPos.ZERO);
    }

    @Override
    public void declareCursor(SqlSelect select, SqlValidatorScope parentScope) {
        this.cursorSet.add(select);
        FunctionParamInfo funcParamInfo = this.functionCallStack.peek();
        Map<Integer, SqlSelect> cursorMap = funcParamInfo.cursorPosToSelectMap;
        int numCursors = cursorMap.size();
        cursorMap.put(numCursors, select);
        SelectScope cursorScope = new SelectScope(parentScope, null, select);
        this.cursorScopes.put(select, cursorScope);
        SelectNamespace selectNs = this.createSelectNamespace(select, select);
        String alias = this.deriveAlias(select, this.nextGeneratedId++);
        this.registerNamespace(cursorScope, alias, selectNs, false);
    }

    @Override
    public void pushFunctionCall() {
        FunctionParamInfo funcInfo = new FunctionParamInfo();
        this.functionCallStack.push(funcInfo);
    }

    @Override
    public void popFunctionCall() {
        this.functionCallStack.pop();
    }

    @Override
    public String getParentCursor(String columnListParamName) {
        FunctionParamInfo funcParamInfo = this.functionCallStack.peek();
        Map<String, String> parentCursorMap = funcParamInfo.columnListParamToParentCursorMap;
        return parentCursorMap.get(columnListParamName);
    }

    private boolean expandSelectItem(SqlNode sqlNode, SqlSelect sqlSelect, List<SqlNode> list, Set<String> set, List<Map.Entry<String, RelDataType>> list2, boolean bl) {
        throw new Error("Unresolved compilation problem: \n\tThe method unknownIdentifier(String) from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    @Override
    public SqlNode validate(SqlNode topNode) {
        EmptyScope scope = new EmptyScope(this);
        SqlNode topNode2 = this.validateScopedExpression(topNode, scope);
        RelDataType type = this.getValidatedNodeType(topNode2);
        Util.discard(type);
        return topNode2;
    }

    @Override
    public List<SqlMoniker> lookupHints(SqlNode topNode, SqlParserPos pos) {
        SqlValidatorNamespace ns;
        EmptyScope scope = new EmptyScope(this);
        SqlNode outermostNode = this.performUnconditionalRewrites(topNode, false);
        this.cursorSet.add(outermostNode);
        if (outermostNode.isA(SqlKind.TOP_LEVEL)) {
            this.registerQuery(scope, null, outermostNode, outermostNode, null, false);
        }
        if ((ns = this.getNamespace(outermostNode)) == null) {
            throw Util.newInternal("Not a query: " + outermostNode);
        }
        ArrayList<SqlMoniker> hintList = new ArrayList<SqlMoniker>();
        this.lookupSelectHints(ns, pos, hintList);
        return hintList;
    }

    @Override
    public SqlMoniker lookupQualifiedName(SqlNode topNode, SqlParserPos pos) {
        String posString = pos.toString();
        IdInfo info = this.idPositions.get(posString);
        if (info != null) {
            return new SqlIdentifierMoniker(info.scope.fullyQualify(info.id));
        }
        return null;
    }

    void lookupSelectHints(SqlSelect select, SqlParserPos pos, List<SqlMoniker> hintList) {
        IdInfo info = this.idPositions.get(pos.toString());
        if (info == null || info.scope == null) {
            SqlNode fromNode = select.getFrom();
            SqlValidatorScope fromScope = this.getFromScope(select);
            this.lookupFromHints(fromNode, fromScope, pos, hintList);
        } else {
            this.lookupNameCompletionHints(info.scope, (List<String>)info.id.names, info.id.getParserPosition(), hintList);
        }
    }

    private void lookupSelectHints(SqlValidatorNamespace ns, SqlParserPos pos, List<SqlMoniker> hintList) {
        SqlNode node = ns.getNode();
        if (node instanceof SqlSelect) {
            this.lookupSelectHints((SqlSelect)node, pos, hintList);
        }
    }

    private void lookupFromHints(SqlNode node, SqlValidatorScope scope, SqlParserPos pos, List<SqlMoniker> hintList) {
        SqlValidatorNamespace ns = this.getNamespace(node);
        if (ns.isWrapperFor(IdentifierNamespace.class)) {
            IdentifierNamespace idNs = ns.unwrap(IdentifierNamespace.class);
            SqlIdentifier id = idNs.getId();
            int i = 0;
            while (i < id.names.size()) {
                if (pos.toString().equals(id.getComponent(i).getParserPosition().toString())) {
                    ArrayList<SqlMoniker> objNames = new ArrayList<SqlMoniker>();
                    SqlValidatorUtil.getSchemaObjectMonikers(this.getCatalogReader(), (List<String>)id.names.subList(0, i + 1), objNames);
                    for (SqlMoniker objName : objNames) {
                        if (objName.getType() == SqlMonikerType.FUNCTION) continue;
                        hintList.add(objName);
                    }
                    return;
                }
                ++i;
            }
        }
        switch (node.getKind()) {
            case JOIN: {
                this.lookupJoinHints((SqlJoin)node, scope, pos, hintList);
                break;
            }
            default: {
                this.lookupSelectHints(ns, pos, hintList);
            }
        }
    }

    private void lookupJoinHints(SqlJoin join, SqlValidatorScope scope, SqlParserPos pos, List<SqlMoniker> hintList) {
        SqlNode left = join.getLeft();
        SqlNode right = join.getRight();
        SqlNode condition = join.getCondition();
        this.lookupFromHints(left, scope, pos, hintList);
        if (hintList.size() > 0) {
            return;
        }
        this.lookupFromHints(right, scope, pos, hintList);
        if (hintList.size() > 0) {
            return;
        }
        JoinConditionType conditionType = join.getConditionType();
        SqlValidatorScope joinScope = this.scopes.get(join);
        switch (conditionType) {
            case ON: {
                condition.findValidOptions(this, joinScope, pos, hintList);
                return;
            }
        }
    }

    public final void lookupNameCompletionHints(SqlValidatorScope scope, List<String> names, SqlParserPos pos, List<SqlMoniker> hintList) {
        List<String> subNames = Util.skipLast(names);
        if (subNames.size() > 0) {
            SqlValidatorNamespace ns = null;
            for (String name : subNames) {
                if ((ns = ns == null ? scope.resolve(name, null, null) : ns.lookupChild(name)) == null) break;
            }
            if (ns != null) {
                RelDataType rowType = ns.getRowType();
                for (RelDataTypeField field : rowType.getFieldList()) {
                    hintList.add(new SqlMonikerImpl(field.getName(), SqlMonikerType.COLUMN));
                }
            }
            SqlValidatorImpl.findAllValidFunctionNames(names, this, hintList, pos);
        } else {
            scope.findAliases(hintList);
            SelectScope selectScope = SqlValidatorUtil.getEnclosingSelectScope(scope);
            if (selectScope != null && selectScope.getChildren().size() == 1) {
                RelDataType rowType = selectScope.getChildren().get(0).getRowType();
                for (RelDataTypeField field : rowType.getFieldList()) {
                    hintList.add(new SqlMonikerImpl(field.getName(), SqlMonikerType.COLUMN));
                }
            }
        }
        SqlValidatorImpl.findAllValidUdfNames(names, this, hintList);
    }

    private static void findAllValidUdfNames(List<String> names, SqlValidator validator, List<SqlMoniker> result) {
        ArrayList<SqlMoniker> objNames = new ArrayList<SqlMoniker>();
        SqlValidatorUtil.getSchemaObjectMonikers(validator.getCatalogReader(), names, objNames);
        for (SqlMoniker objName : objNames) {
            if (objName.getType() != SqlMonikerType.FUNCTION) continue;
            result.add(objName);
        }
    }

    private static void findAllValidFunctionNames(List<String> names, SqlValidator validator, List<SqlMoniker> result, SqlParserPos pos) {
        if (names.size() > 1) {
            return;
        }
        for (SqlOperator op : validator.getOperatorTable().getOperatorList()) {
            SqlIdentifier curOpId = new SqlIdentifier(op.getName(), pos);
            SqlCall call = SqlUtil.makeCall(validator.getOperatorTable(), curOpId);
            if (call != null) {
                result.add(new SqlMonikerImpl(op.getName(), SqlMonikerType.FUNCTION));
                continue;
            }
            if (op.getSyntax() != SqlSyntax.FUNCTION && op.getSyntax() != SqlSyntax.PREFIX) continue;
            if (op.getOperandTypeChecker() != null) {
                String sig = op.getAllowedSignatures();
                sig = sig.replaceAll("'", "");
                result.add(new SqlMonikerImpl(sig, SqlMonikerType.FUNCTION));
                continue;
            }
            result.add(new SqlMonikerImpl(op.getName(), SqlMonikerType.FUNCTION));
        }
    }

    public SqlNode validateParameterizedExpression(SqlNode topNode, Map<String, RelDataType> nameToTypeMap) {
        ParameterScope scope = new ParameterScope(this, nameToTypeMap);
        return this.validateScopedExpression(topNode, scope);
    }

    private SqlNode validateScopedExpression(SqlNode topNode, SqlValidatorScope scope) {
        SqlNode outermostNode = this.performUnconditionalRewrites(topNode, false);
        this.cursorSet.add(outermostNode);
        if (TRACER.isLoggable(Level.FINER)) {
            TRACER.finer("After unconditional rewrite: " + outermostNode.toString());
        }
        if (outermostNode.isA(SqlKind.TOP_LEVEL)) {
            this.registerQuery(scope, null, outermostNode, outermostNode, null, false);
        }
        outermostNode.validate(this, scope);
        if (!outermostNode.isA(SqlKind.TOP_LEVEL)) {
            this.deriveType(scope, outermostNode);
        }
        if (TRACER.isLoggable(Level.FINER)) {
            TRACER.finer("After validation: " + outermostNode.toString());
        }
        return outermostNode;
    }

    @Override
    public void validateQuery(SqlNode node, SqlValidatorScope scope) {
        SqlValidatorNamespace ns = this.getNamespace(node, scope);
        if (node.getKind() == SqlKind.TABLESAMPLE) {
            List<SqlNode> operands = ((SqlCall)node).getOperandList();
            SqlSampleSpec sampleSpec = SqlLiteral.sampleValue(operands.get(1));
            if (sampleSpec instanceof SqlSampleSpec.SqlTableSampleSpec) {
                this.validateFeature(Static.RESOURCE.sQLFeature_T613(), node.getParserPosition());
            } else if (sampleSpec instanceof SqlSampleSpec.SqlSubstitutionSampleSpec) {
                this.validateFeature(Static.RESOURCE.sQLFeatureExt_T613_Substitution(), node.getParserPosition());
            }
        }
        this.validateNamespace(ns);
        this.validateAccess(node, ns.getTable(), SqlAccessEnum.SELECT);
    }

    protected void validateNamespace(SqlValidatorNamespace namespace) {
        namespace.validate();
        if (namespace.getNode() != null) {
            this.setValidatedNodeType(namespace.getNode(), namespace.getRowType());
        }
    }

    public SqlValidatorScope getCursorScope(SqlSelect select) {
        return this.cursorScopes.get(select);
    }

    @Override
    public SqlValidatorScope getWhereScope(SqlSelect select) {
        return this.whereScopes.get(select);
    }

    @Override
    public SqlValidatorScope getSelectScope(SqlSelect select) {
        return this.selectScopes.get(select);
    }

    @Override
    public SelectScope getRawSelectScope(SqlSelect select) {
        SqlValidatorScope scope = this.getSelectScope(select);
        if (scope instanceof AggregatingSelectScope) {
            scope = ((AggregatingSelectScope)scope).getParent();
        }
        return (SelectScope)scope;
    }

    @Override
    public SqlValidatorScope getHavingScope(SqlSelect select) {
        return this.selectScopes.get(select);
    }

    @Override
    public SqlValidatorScope getGroupScope(SqlSelect select) {
        return this.whereScopes.get(select);
    }

    @Override
    public SqlValidatorScope getFromScope(SqlSelect select) {
        return this.scopes.get(select);
    }

    @Override
    public SqlValidatorScope getOrderScope(SqlSelect select) {
        return this.orderScopes.get(select);
    }

    @Override
    public SqlValidatorScope getJoinScope(SqlNode node) {
        switch (node.getKind()) {
            case AS: {
                return this.getJoinScope((SqlNode)((SqlCall)node).operand(0));
            }
        }
        return this.scopes.get(node);
    }

    @Override
    public SqlValidatorScope getOverScope(SqlNode node) {
        return this.scopes.get(node);
    }

    private SqlValidatorNamespace getNamespace(SqlNode node, SqlValidatorScope scope) {
        if (node instanceof SqlIdentifier && scope instanceof DelegatingScope) {
            SqlValidatorNamespace ns;
            SqlIdentifier id = (SqlIdentifier)node;
            SqlValidatorScope parentScope = ((DelegatingScope)scope).getParent();
            if (id.isSimple() && (ns = parentScope.resolve(id.getSimple(), null, null)) != null) {
                return ns;
            }
        }
        return this.getNamespace(node);
    }

    @Override
    public SqlValidatorNamespace getNamespace(SqlNode node) {
        switch (node.getKind()) {
            case AS: {
                SqlValidatorNamespace ns = this.namespaces.get(node);
                if (ns != null) {
                    return ns;
                }
            }
            case ORDER_BY: 
            case OVER: 
            case TABLESAMPLE: 
            case COLLECTION_TABLE: {
                return this.getNamespace((SqlNode)((SqlCall)node).operand(0));
            }
        }
        return this.namespaces.get(node);
    }

    protected SqlNode performUnconditionalRewrites(SqlNode node, boolean underFrom) {
        if (node == null) {
            return node;
        }
        if (node instanceof SqlCall) {
            List<SqlOperator> overloads;
            SqlFunction function;
            if (node instanceof SqlMerge) {
                this.validatingSqlMerge = true;
            }
            SqlCall call = (SqlCall)node;
            SqlKind kind = call.getKind();
            List<SqlNode> operands = call.getOperandList();
            int i = 0;
            while (i < operands.size()) {
                boolean childUnderFrom;
                SqlNode operand = operands.get(i);
                SqlNode newOperand = this.performUnconditionalRewrites(operand, childUnderFrom = kind == SqlKind.SELECT ? i == 2 : (kind == SqlKind.AS && i == 0 ? underFrom : false));
                if (newOperand != null && newOperand != operand) {
                    call.setOperand(i, newOperand);
                }
                ++i;
            }
            if (call.getOperator() instanceof SqlFunction && (function = (SqlFunction)call.getOperator()).getFunctionType() == null && (overloads = this.opTab.lookupOperatorOverloads(function.getNameAsId(), null, SqlSyntax.FUNCTION)).size() == 1) {
                ((SqlBasicCall)call).setOperator(overloads.get(0));
            }
            if (this.rewriteCalls) {
                node = call.getOperator().rewriteCall(this, call);
            }
        } else if (node instanceof SqlNodeList) {
            SqlNodeList list = (SqlNodeList)node;
            int i = 0;
            int count = list.size();
            while (i < count) {
                SqlNode operand = list.get(i);
                SqlNode newOperand = this.performUnconditionalRewrites(operand, false);
                if (newOperand != null) {
                    list.getList().set(i, newOperand);
                }
                ++i;
            }
        }
        SqlKind kind = node.getKind();
        switch (kind) {
            case VALUES: {
                return node;
            }
            case ORDER_BY: {
                SqlSelect select;
                SqlOrderBy orderBy = (SqlOrderBy)node;
                if (orderBy.query instanceof SqlSelect && (select = (SqlSelect)orderBy.query).getOrderList() == null) {
                    select.setOrderBy(orderBy.orderList);
                    select.setOffset(orderBy.offset);
                    select.setFetch(orderBy.fetch);
                    return select;
                }
                SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
                selectList.add(new SqlIdentifier("*", SqlParserPos.ZERO));
                return new SqlSelect(SqlParserPos.ZERO, null, selectList, orderBy.query, null, null, null, null, orderBy.orderList, orderBy.offset, orderBy.fetch);
            }
            case EXPLICIT_TABLE: {
                SqlCall call = (SqlCall)node;
                SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
                selectList.add(new SqlIdentifier("*", SqlParserPos.ZERO));
                return new SqlSelect(SqlParserPos.ZERO, null, selectList, (SqlNode)call.operand(0), null, null, null, null, null, null, null);
            }
            case DELETE: {
                SqlCall call = (SqlDelete)node;
                SqlSelect select = this.createSourceSelectForDelete((SqlDelete)call);
                ((SqlDelete)call).setSourceSelect(select);
                break;
            }
            case UPDATE: {
                SqlNode selfJoinSrcExpr;
                SqlCall call = (SqlUpdate)node;
                SqlSelect select = this.createSourceSelectForUpdate((SqlUpdate)call);
                ((SqlUpdate)call).setSourceSelect(select);
                if (this.validatingSqlMerge || (selfJoinSrcExpr = this.getSelfJoinExprForUpdate(((SqlUpdate)call).getTargetTable(), UPDATE_SRC_ALIAS)) == null) break;
                node = this.rewriteUpdateToMerge((SqlUpdate)call, selfJoinSrcExpr);
                break;
            }
            case MERGE: {
                SqlCall call = (SqlMerge)node;
                this.rewriteMerge((SqlMerge)call);
            }
        }
        return node;
    }

    private void rewriteMerge(SqlMerge call) {
        SqlNodeList selectList;
        SqlUpdate updateStmt = call.getUpdateCall();
        if (updateStmt != null) {
            selectList = (SqlNodeList)updateStmt.getSourceSelect().getSelectList().clone();
        } else {
            selectList = new SqlNodeList(SqlParserPos.ZERO);
            selectList.add(new SqlIdentifier("*", SqlParserPos.ZERO));
        }
        SqlNode targetTable = call.getTargetTable();
        if (call.getAlias() != null) {
            targetTable = SqlValidatorUtil.addAlias(targetTable, call.getAlias().getSimple());
        }
        SqlNode sourceTableRef = call.getSourceTableRef();
        SqlInsert insertCall = call.getInsertCall();
        JoinType joinType = insertCall == null ? JoinType.INNER : JoinType.LEFT;
        SqlNode leftJoinTerm = (SqlNode)sourceTableRef.clone();
        SqlJoin outerJoin = new SqlJoin(SqlParserPos.ZERO, leftJoinTerm, SqlLiteral.createBoolean(false, SqlParserPos.ZERO), joinType.symbol(SqlParserPos.ZERO), targetTable, JoinConditionType.ON.symbol(SqlParserPos.ZERO), call.getCondition());
        SqlSelect select = new SqlSelect(SqlParserPos.ZERO, null, selectList, outerJoin, null, null, null, null, null, null, null);
        call.setSourceSelect(select);
        if (insertCall != null) {
            SqlSelect valuesSelect = (SqlSelect)insertCall.getSource();
            SqlCall valuesCall = (SqlCall)valuesSelect.getFrom();
            SqlCall rowCall = (SqlCall)valuesCall.operand(0);
            selectList = new SqlNodeList(rowCall.getOperandList(), SqlParserPos.ZERO);
            SqlNode insertSource = (SqlNode)sourceTableRef.clone();
            select = new SqlSelect(SqlParserPos.ZERO, null, selectList, insertSource, null, null, null, null, null, null, null);
            insertCall.setSource(select);
        }
    }

    private SqlNode rewriteUpdateToMerge(SqlUpdate updateCall, SqlNode selfJoinSrcExpr) {
        if (updateCall.getAlias() == null) {
            updateCall.setAlias(new SqlIdentifier(UPDATE_TGT_ALIAS, SqlParserPos.ZERO));
        }
        SqlNode selfJoinTgtExpr = this.getSelfJoinExprForUpdate(updateCall.getTargetTable(), updateCall.getAlias().getSimple());
        assert (selfJoinTgtExpr != null);
        SqlNode condition = updateCall.getCondition();
        SqlCall selfJoinCond = SqlStdOperatorTable.EQUALS.createCall(SqlParserPos.ZERO, selfJoinSrcExpr, selfJoinTgtExpr);
        condition = condition == null ? selfJoinCond : SqlStdOperatorTable.AND.createCall(SqlParserPos.ZERO, selfJoinCond, condition);
        SqlIdentifier target = (SqlIdentifier)updateCall.getTargetTable().clone(SqlParserPos.ZERO);
        IdentifierNamespace ns = new IdentifierNamespace(this, target, null, null);
        RelDataType rowType = ns.getRowType();
        SqlNode source = updateCall.getTargetTable().clone(SqlParserPos.ZERO);
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        int i = 1;
        for (RelDataTypeField field : rowType.getFieldList()) {
            SqlIdentifier col = new SqlIdentifier(field.getName(), SqlParserPos.ZERO);
            selectList.add(SqlValidatorUtil.addAlias(col, UPDATE_ANON_PREFIX + i));
            ++i;
        }
        source = new SqlSelect(SqlParserPos.ZERO, null, selectList, source, null, null, null, null, null, null, null);
        source = SqlValidatorUtil.addAlias(source, UPDATE_SRC_ALIAS);
        SqlMerge mergeCall = new SqlMerge(updateCall.getParserPosition(), target, condition, source, updateCall, null, null, updateCall.getAlias());
        this.rewriteMerge(mergeCall);
        return mergeCall;
    }

    protected SqlNode getSelfJoinExprForUpdate(SqlIdentifier table, String alias) {
        return null;
    }

    protected SqlSelect createSourceSelectForUpdate(SqlUpdate call) {
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        selectList.add(new SqlIdentifier("*", SqlParserPos.ZERO));
        int ordinal = 0;
        for (SqlNode exp : call.getSourceExpressionList()) {
            String alias = SqlUtil.deriveAliasFromOrdinal(ordinal);
            selectList.add(SqlValidatorUtil.addAlias(exp, alias));
            ++ordinal;
        }
        SqlNode sourceTable = call.getTargetTable();
        if (call.getAlias() != null) {
            sourceTable = SqlValidatorUtil.addAlias(sourceTable, call.getAlias().getSimple());
        }
        return new SqlSelect(SqlParserPos.ZERO, null, selectList, sourceTable, call.getCondition(), null, null, null, null, null, null);
    }

    protected SqlSelect createSourceSelectForDelete(SqlDelete call) {
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        selectList.add(new SqlIdentifier("*", SqlParserPos.ZERO));
        SqlNode sourceTable = call.getTargetTable();
        if (call.getAlias() != null) {
            sourceTable = SqlValidatorUtil.addAlias(sourceTable, call.getAlias().getSimple());
        }
        return new SqlSelect(SqlParserPos.ZERO, null, selectList, sourceTable, call.getCondition(), null, null, null, null, null, null);
    }

    RelDataType getTableConstructorRowType(SqlCall values, SqlValidatorScope scope) {
        List<SqlNode> rows = values.getOperandList();
        assert (rows.size() >= 1);
        ArrayList<RelDataType> rowTypes = new ArrayList<RelDataType>();
        for (SqlNode row : rows) {
            assert (row.getKind() == SqlKind.ROW);
            SqlCall rowConstructor = (SqlCall)row;
            ArrayList<String> aliasList = new ArrayList<String>();
            ArrayList<RelDataType> typeList = new ArrayList<RelDataType>();
            for (Ord column : Ord.zip(rowConstructor.getOperandList())) {
                String alias = this.deriveAlias((SqlNode)column.e, column.i);
                aliasList.add(alias);
                RelDataType type = this.deriveType(scope, (SqlNode)column.e);
                typeList.add(type);
            }
            rowTypes.add(this.typeFactory.createStructType(typeList, aliasList));
        }
        if (rows.size() == 1) {
            return (RelDataType)rowTypes.get(0);
        }
        return this.typeFactory.leastRestrictive(rowTypes);
    }

    @Override
    public RelDataType getValidatedNodeType(SqlNode node) {
        RelDataType type = this.getValidatedNodeTypeIfKnown(node);
        if (type == null) {
            throw Util.needToImplement(node);
        }
        return type;
    }

    @Override
    public RelDataType getValidatedNodeTypeIfKnown(SqlNode node) {
        RelDataType type = this.nodeToTypeMap.get(node);
        if (type != null) {
            return type;
        }
        SqlValidatorNamespace ns = this.getNamespace(node);
        if (ns != null) {
            return ns.getRowType();
        }
        SqlNode original = this.originalExprs.get(node);
        if (original != null) {
            return this.getValidatedNodeType(original);
        }
        return null;
    }

    @Override
    public void setValidatedNodeType(SqlNode node, RelDataType type) {
        this.setValidatedNodeTypeImpl(node, type);
    }

    @Override
    public void removeValidatedNodeType(SqlNode node) {
        this.nodeToTypeMap.remove(node);
    }

    void setValidatedNodeTypeImpl(SqlNode node, RelDataType type) {
        Util.pre(type != null, "type != null");
        Util.pre(node != null, "node != null");
        if (type.equals(this.unknownType)) {
            return;
        }
        this.nodeToTypeMap.put(node, type);
    }

    @Override
    public RelDataType deriveType(SqlValidatorScope scope, SqlNode expr) {
        Util.pre(scope != null, "scope != null");
        Util.pre(expr != null, "expr != null");
        RelDataType type = this.nodeToTypeMap.get(expr);
        if (type != null) {
            return type;
        }
        SqlValidatorNamespace ns = this.getNamespace(expr);
        if (ns != null) {
            return ns.getRowType();
        }
        type = this.deriveTypeImpl(scope, expr);
        Util.permAssert(type != null, "SqlValidator.deriveTypeInternal returned null");
        this.setValidatedNodeTypeImpl(expr, type);
        return type;
    }

    RelDataType deriveTypeImpl(SqlValidatorScope scope, SqlNode operand) {
        DeriveTypeVisitor v = new DeriveTypeVisitor(scope);
        return operand.accept(v);
    }

    public RelDataType deriveConstructorType(SqlValidatorScope sqlValidatorScope, SqlCall sqlCall, SqlFunction sqlFunction, SqlFunction sqlFunction2, List<RelDataType> list) {
        throw new Error("Unresolved compilation problem: \n\tThe method unknownDatatypeName(String) from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    public EigenbaseException handleUnresolvedFunction(SqlCall sqlCall, SqlFunction sqlFunction, List<RelDataType> list) {
        throw new Error("Unresolved compilation problems: \n\tThe method invalidArgCount(String, int) from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method validatorUnknownFunction(String) from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    protected void inferUnknownTypes(RelDataType relDataType, SqlValidatorScope sqlValidatorScope, SqlNode sqlNode) {
        throw new Error("Unresolved compilation problems: \n\tThe method nullIllegal() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method dynamicParamIllegal() from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    protected void addToSelectList(List<SqlNode> list, Set<String> aliases, List<Map.Entry<String, RelDataType>> fieldList, SqlNode exp, SqlValidatorScope scope, boolean includeSystemVars) {
        String uniqueAlias;
        String alias = SqlValidatorUtil.getAlias(exp, -1);
        if (!alias.equals(uniqueAlias = SqlValidatorUtil.uniquify(alias, aliases, SqlValidatorUtil.EXPR_SUGGESTER))) {
            exp = SqlValidatorUtil.addAlias(exp, uniqueAlias);
        }
        fieldList.add(Pair.of(uniqueAlias, this.deriveType(scope, exp)));
        list.add(exp);
    }

    @Override
    public String deriveAlias(SqlNode node, int ordinal) {
        return SqlValidatorUtil.getAlias(node, ordinal);
    }

    @Override
    public void setIdentifierExpansion(boolean expandIdentifiers) {
        this.expandIdentifiers = expandIdentifiers;
    }

    @Override
    public void setColumnReferenceExpansion(boolean expandColumnReferences) {
        this.expandColumnReferences = expandColumnReferences;
    }

    @Override
    public boolean getColumnReferenceExpansion() {
        return this.expandColumnReferences;
    }

    @Override
    public void setCallRewrite(boolean rewriteCalls) {
        this.rewriteCalls = rewriteCalls;
    }

    @Override
    public boolean shouldExpandIdentifiers() {
        return this.expandIdentifiers;
    }

    protected boolean shouldAllowIntermediateOrderBy() {
        return true;
    }

    protected void registerNamespace(SqlValidatorScope usingScope, String alias, SqlValidatorNamespace ns, boolean forceNullable) {
        if (forceNullable) {
            ns.makeNullable();
        }
        this.namespaces.put(ns.getNode(), ns);
        if (usingScope != null) {
            usingScope.addChild(ns, alias);
        }
    }

    private SqlNode registerFrom(SqlValidatorScope parentScope, SqlValidatorScope usingScope, SqlNode node, SqlNode enclosingNode, String alias, boolean forceNullable) {
        SqlKind kind = node.getKind();
        SqlNode newNode = node;
        if (alias == null) {
            switch (kind) {
                case IDENTIFIER: 
                case OVER: {
                    alias = this.deriveAlias(node, -1);
                    if (alias == null) {
                        alias = this.deriveAlias(node, this.nextGeneratedId++);
                    }
                    if (!this.shouldExpandIdentifiers()) break;
                    newNode = SqlValidatorUtil.addAlias(node, alias);
                    break;
                }
                case SELECT: 
                case OTHER_FUNCTION: 
                case UNION: 
                case EXCEPT: 
                case INTERSECT: 
                case VALUES: 
                case UNNEST: 
                case COLLECTION_TABLE: {
                    alias = this.deriveAlias(node, this.nextGeneratedId++);
                    if (!this.shouldExpandIdentifiers()) break;
                    newNode = SqlValidatorUtil.addAlias(node, alias);
                }
            }
        }
        switch (kind) {
            case AS: {
                Object expr;
                SqlNode newExpr;
                SqlCall call = (SqlCall)node;
                if (alias == null) {
                    alias = ((SqlNode)call.operand(1)).toString();
                }
                SqlValidatorScope usingScope2 = usingScope;
                if (call.operandCount() > 2) {
                    usingScope2 = null;
                }
                if ((newExpr = this.registerFrom(parentScope, usingScope2, (SqlNode)(expr = call.operand(0)), enclosingNode, alias, forceNullable)) != expr) {
                    call.setOperand(0, newExpr);
                }
                if (call.operandCount() > 2) {
                    this.registerNamespace(usingScope, alias, new AliasNamespace(this, call, enclosingNode), false);
                }
                return node;
            }
            case TABLESAMPLE: {
                SqlCall call = (SqlCall)node;
                Object expr = call.operand(0);
                SqlNode newExpr = this.registerFrom(parentScope, usingScope, (SqlNode)expr, enclosingNode, alias, forceNullable);
                if (newExpr != expr) {
                    call.setOperand(0, newExpr);
                }
                return node;
            }
            case JOIN: {
                SqlValidatorScope rightParentScope;
                SqlNode newRight;
                SqlJoin join = (SqlJoin)node;
                JoinScope joinScope = new JoinScope(parentScope, usingScope, join);
                this.scopes.put(join, joinScope);
                SqlNode left = join.getLeft();
                SqlNode right = join.getRight();
                boolean rightIsLateral = false;
                if (right.getKind() == SqlKind.LATERAL || right.getKind() == SqlKind.AS && ((SqlNode)((SqlCall)right).operand(0)).getKind() == SqlKind.LATERAL) {
                    rightIsLateral = true;
                }
                boolean forceLeftNullable = forceNullable;
                boolean forceRightNullable = forceNullable;
                switch (join.getJoinType()) {
                    case LEFT: {
                        forceRightNullable = true;
                        break;
                    }
                    case RIGHT: {
                        forceLeftNullable = true;
                        break;
                    }
                    case FULL: {
                        forceLeftNullable = true;
                        forceRightNullable = true;
                    }
                }
                SqlNode newLeft = this.registerFrom(parentScope, joinScope, left, left, null, forceLeftNullable);
                if (newLeft != left) {
                    join.setLeft(newLeft);
                }
                if ((newRight = this.registerFrom(rightParentScope = rightIsLateral ? joinScope : parentScope, joinScope, right, right, null, forceRightNullable)) != right) {
                    join.setRight(newRight);
                }
                JoinNamespace joinNamespace = new JoinNamespace(this, join);
                this.registerNamespace(null, null, joinNamespace, forceNullable);
                return join;
            }
            case IDENTIFIER: {
                SqlIdentifier id = (SqlIdentifier)node;
                IdentifierNamespace newNs = new IdentifierNamespace(this, id, enclosingNode, parentScope);
                this.registerNamespace(usingScope, alias, newNs, forceNullable);
                return newNode;
            }
            case LATERAL: {
                return this.registerFrom(parentScope, usingScope, (SqlNode)((SqlCall)node).operand(0), enclosingNode, alias, forceNullable);
            }
            case COLLECTION_TABLE: {
                SqlCall call = (SqlCall)node;
                Object operand = call.operand(0);
                SqlNode newOperand = this.registerFrom(parentScope, usingScope, (SqlNode)operand, enclosingNode, alias, forceNullable);
                if (newOperand != operand) {
                    call.setOperand(0, newOperand);
                }
                return newNode;
            }
            case SELECT: 
            case OTHER_FUNCTION: 
            case WITH: 
            case UNION: 
            case EXCEPT: 
            case INTERSECT: 
            case VALUES: 
            case UNNEST: {
                this.registerQuery(parentScope, usingScope, node, enclosingNode, alias, forceNullable);
                return newNode;
            }
            case OVER: {
                if (!this.shouldAllowOverRelation()) {
                    throw Util.unexpected(kind);
                }
                SqlCall call = (SqlCall)node;
                OverScope overScope = new OverScope(usingScope, call);
                this.scopes.put(call, overScope);
                Object operand = call.operand(0);
                SqlNode newOperand = this.registerFrom(parentScope, overScope, (SqlNode)operand, enclosingNode, alias, forceNullable);
                if (newOperand != operand) {
                    call.setOperand(0, newOperand);
                }
                for (Pair p : overScope.children) {
                    this.registerNamespace(usingScope, (String)p.left, (SqlValidatorNamespace)p.right, forceNullable);
                }
                return newNode;
            }
        }
        throw Util.unexpected(kind);
    }

    protected boolean shouldAllowOverRelation() {
        return false;
    }

    protected SelectNamespace createSelectNamespace(SqlSelect select, SqlNode enclosingNode) {
        return new SelectNamespace(this, select, enclosingNode);
    }

    protected SetopNamespace createSetopNamespace(SqlCall call, SqlNode enclosingNode) {
        return new SetopNamespace(this, call, enclosingNode);
    }

    private void registerQuery(SqlValidatorScope parentScope, SqlValidatorScope usingScope, SqlNode node, SqlNode enclosingNode, String alias, boolean forceNullable) {
        this.registerQuery(parentScope, usingScope, node, enclosingNode, alias, forceNullable, true);
    }

    private void registerQuery(SqlValidatorScope sqlValidatorScope, SqlValidatorScope sqlValidatorScope2, SqlNode sqlNode, SqlNode sqlNode2, String string, boolean bl, boolean bl2) {
        throw new Error("Unresolved compilation problem: \n\tThe method aggregateIllegalInOrderBy() from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    private void registerSetop(SqlValidatorScope parentScope, SqlValidatorScope usingScope, SqlNode node, SqlNode enclosingNode, String alias, boolean forceNullable) {
        SqlCall call = (SqlCall)node;
        SetopNamespace setopNamespace = this.createSetopNamespace(call, enclosingNode);
        this.registerNamespace(usingScope, alias, setopNamespace, forceNullable);
        this.scopes.put(call, parentScope);
        for (SqlNode operand : call.getOperandList()) {
            this.registerQuery(parentScope, null, operand, operand, null, false);
        }
    }

    private void registerWith(SqlValidatorScope parentScope, SqlValidatorScope usingScope, SqlWith with, SqlNode enclosingNode, String alias, boolean forceNullable, boolean checkUpdate) {
        WithNamespace withNamespace = new WithNamespace(this, with, parentScope, enclosingNode);
        this.registerNamespace(usingScope, alias, withNamespace, forceNullable);
        SqlValidatorScope scope = parentScope;
        for (SqlNode withItem_ : with.withList) {
            SqlWithItem withItem = (SqlWithItem)withItem_;
            WithScope withScope = new WithScope(scope, withItem);
            this.scopes.put(withItem, withScope);
            this.registerQuery(scope, usingScope, withItem.query, with, withItem.name.getSimple(), false);
            scope = withScope;
        }
        this.registerQuery(scope, null, with.body, enclosingNode, alias, forceNullable, checkUpdate);
    }

    @Override
    public boolean isAggregate(SqlSelect select) {
        return select.getGroup() != null || select.getHaving() != null || this.aggFinder.findAgg(select.getSelectList()) != null;
    }

    @Override
    public boolean isAggregate(SqlNode selectNode) {
        return this.aggFinder.findAgg(selectNode) != null;
    }

    private void validateNodeFeature(SqlNode node) {
        switch (node.getKind()) {
            case MULTISET_VALUE_CONSTRUCTOR: {
                this.validateFeature(Static.RESOURCE.sQLFeature_S271(), node.getParserPosition());
            }
        }
    }

    private void registerSubqueries(SqlValidatorScope parentScope, SqlNode node) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (node == null) {
                            return;
                        }
                        if (!node.getKind().belongsTo(SqlKind.QUERY)) break block4;
                        this.registerQuery(parentScope, null, node, node, null, false);
                        break block5;
                    }
                    if (node.getKind() != SqlKind.MULTISET_QUERY_CONSTRUCTOR) break block6;
                    this.registerQuery(parentScope, null, node, node, null, false);
                    break block5;
                }
                if (!(node instanceof SqlCall)) break block7;
                this.validateNodeFeature(node);
                SqlCall call = (SqlCall)node;
                int i = 0;
                while (i < call.operandCount()) {
                    this.registerOperandSubqueries(parentScope, call, i);
                    ++i;
                }
                break block5;
            }
            if (!(node instanceof SqlNodeList)) break block5;
            SqlNodeList list = (SqlNodeList)node;
            int i = 0;
            int count = list.size();
            while (i < count) {
                SqlNode listNode = list.get(i);
                if (listNode.getKind().belongsTo(SqlKind.QUERY)) {
                    listNode = SqlStdOperatorTable.SCALAR_QUERY.createCall(listNode.getParserPosition(), listNode);
                    list.set(i, listNode);
                }
                this.registerSubqueries(parentScope, listNode);
                ++i;
            }
        }
    }

    private void registerOperandSubqueries(SqlValidatorScope parentScope, SqlCall call, int operandOrdinal) {
        Object operand = call.operand(operandOrdinal);
        if (operand == null) {
            return;
        }
        if (((SqlNode)operand).getKind().belongsTo(SqlKind.QUERY) && call.getOperator().argumentMustBeScalar(operandOrdinal)) {
            operand = SqlStdOperatorTable.SCALAR_QUERY.createCall(((SqlNode)operand).getParserPosition(), new SqlNode[]{operand});
            call.setOperand(operandOrdinal, (SqlNode)operand);
        }
        this.registerSubqueries(parentScope, (SqlNode)operand);
    }

    @Override
    public void validateIdentifier(SqlIdentifier id, SqlValidatorScope scope) {
        SqlIdentifier fqId = scope.fullyQualify(id);
        if (this.expandColumnReferences) {
            id.assignNamesFrom(fqId);
        } else {
            Util.discard(fqId);
        }
    }

    @Override
    public void validateLiteral(SqlLiteral sqlLiteral) {
        throw new Error("Unresolved compilation problems: \n\tThe method numberLiteralOutOfRange(String) from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method binaryLiteralOdd() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method dateLiteralOutOfRange(String) from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    private void validateLiteralAsDouble(SqlLiteral sqlLiteral) {
        throw new Error("Unresolved compilation problem: \n\tThe method numberLiteralOutOfRange(String) from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    @Override
    public void validateIntervalQualifier(SqlIntervalQualifier sqlIntervalQualifier) {
        throw new Error("Unresolved compilation problems: \n\tThe method intervalStartPrecisionOutOfRange(int, String) from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method intervalFractionalSecondPrecisionOutOfRange(int, String) from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    protected void validateFrom(SqlNode node, RelDataType targetRowType, SqlValidatorScope scope) {
        Util.pre(targetRowType != null, "targetRowType != null");
        switch (node.getKind()) {
            case AS: {
                this.validateFrom((SqlNode)((SqlCall)node).operand(0), targetRowType, scope);
                break;
            }
            case VALUES: {
                this.validateValues((SqlCall)node, targetRowType, scope);
                break;
            }
            case JOIN: {
                this.validateJoin((SqlJoin)node, scope);
                break;
            }
            case OVER: {
                this.validateOver((SqlCall)node, scope);
                break;
            }
            default: {
                this.validateQuery(node, scope);
            }
        }
        this.getNamespace(node, scope).validate();
    }

    protected void validateOver(SqlCall call, SqlValidatorScope scope) {
        throw Util.newInternal("OVER unexpected in this context");
    }

    protected void validateJoin(SqlJoin sqlJoin, SqlValidatorScope sqlValidatorScope) {
        throw new Error("Unresolved compilation problems: \n\tThe method naturalOrUsingColumnNotCompatible(String, String, String) from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method naturalDisallowsOnOrUsing() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method naturalOrUsingColumnNotCompatible(String, String, String) from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method joinRequiresCondition() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method crossJoinDisallowsCondition() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method crossJoinDisallowsCondition() from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    private void validateNoAggs(SqlNode sqlNode, String string) {
        throw new Error("Unresolved compilation problems: \n\tThe method windowedAggregateIllegalInClause(String) from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method aggregateIllegalInClause(String) from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    private RelDataType validateUsingCol(SqlIdentifier sqlIdentifier, SqlNode sqlNode) {
        throw new Error("Unresolved compilation problems: \n\tThe method columnInUsingNotUnique(String) from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method columnNotFound(String) from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    protected void validateSelect(SqlSelect sqlSelect, RelDataType relDataType) {
        throw new Error("Unresolved compilation problem: \n\tThe method fromAliasDuplicate(String) from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    protected void validateWindowClause(SqlSelect sqlSelect) {
        throw new Error("Unresolved compilation problems: \n\tThe method windowNameMustBeSimple() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method duplicateWindowName() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method dupWindowSpec() from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    @Override
    public void validateWith(SqlWith with, SqlValidatorScope scope) {
        SqlValidatorNamespace namespace = this.getNamespace(with);
        this.validateNamespace(namespace);
    }

    @Override
    public void validateWithItem(SqlWithItem sqlWithItem) {
        throw new Error("Unresolved compilation problems: \n\tThe method columnCountMismatch() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method duplicateNameInColumnList(String) from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method duplicateColumnAndNoColumnList(String) from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    @Override
    public SqlValidatorScope getWithScope(SqlNode withItem) {
        assert (withItem.getKind() == SqlKind.WITH_ITEM);
        return this.scopes.get(withItem);
    }

    protected void validateOrderList(SqlSelect sqlSelect) {
        throw new Error("Unresolved compilation problem: \n\tThe method invalidOrderByPos() from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    private void validateOrderItem(SqlSelect select, SqlNode orderItem) {
        if (SqlUtil.isCallTo(orderItem, SqlStdOperatorTable.DESC)) {
            this.validateFeature(Static.RESOURCE.sQLConformance_OrderByDesc(), orderItem.getParserPosition());
            this.validateOrderItem(select, (SqlNode)((SqlCall)orderItem).operand(0));
            return;
        }
        SqlValidatorScope orderScope = this.getOrderScope(select);
        this.validateExpr(orderItem, orderScope);
    }

    @Override
    public SqlNode expandOrderExpr(SqlSelect select, SqlNode orderExpr) {
        return new OrderExpressionExpander(select, orderExpr).go();
    }

    protected void validateGroupClause(SqlSelect sqlSelect) {
        throw new Error("Unresolved compilation problem: \n\tThe method aggregateIllegalInGroupBy() from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    protected void validateWhereClause(SqlSelect select) {
        SqlNode where = select.getWhere();
        if (where == null) {
            return;
        }
        SqlValidatorScope whereScope = this.getWhereScope(select);
        this.validateWhereOrOn(whereScope, where, "WHERE");
    }

    protected void validateWhereOrOn(SqlValidatorScope sqlValidatorScope, SqlNode sqlNode, String string) {
        throw new Error("Unresolved compilation problem: \n\tThe method condMustBeBoolean(String) from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    protected void validateHavingClause(SqlSelect sqlSelect) {
        throw new Error("Unresolved compilation problem: \n\tThe method havingMustBeBoolean() from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    protected RelDataType validateSelectList(SqlNodeList selectItems, SqlSelect select, RelDataType targetRowType) {
        SqlValidatorScope selectScope = this.getSelectScope(select);
        ArrayList<SqlNode> expandedSelectItems = new ArrayList<SqlNode>();
        HashSet<String> aliases = new HashSet<String>();
        ArrayList<Map.Entry<String, RelDataType>> fieldList = new ArrayList<Map.Entry<String, RelDataType>>();
        int i = 0;
        while (i < selectItems.size()) {
            SqlNode selectItem = selectItems.get(i);
            if (selectItem instanceof SqlSelect) {
                this.handleScalarSubQuery(select, (SqlSelect)selectItem, expandedSelectItems, aliases, fieldList);
            } else {
                this.expandSelectItem(selectItem, select, expandedSelectItems, aliases, fieldList, false);
            }
            ++i;
        }
        if (selectScope instanceof AggregatingScope) {
            AggregatingScope aggScope = (AggregatingScope)selectScope;
            for (SqlNode selectItem : expandedSelectItems) {
                boolean matches = aggScope.checkAggregateExpr(selectItem, true);
                Util.discard(matches);
            }
        }
        SqlNodeList newSelectList = new SqlNodeList(expandedSelectItems, selectItems.getParserPosition());
        if (this.shouldExpandIdentifiers()) {
            select.setSelectList(newSelectList);
        }
        this.getRawSelectScope(select).setExpandedSelectList(expandedSelectItems);
        this.inferUnknownTypes(targetRowType, selectScope, newSelectList);
        for (SqlNode selectItem : expandedSelectItems) {
            this.validateExpr(selectItem, selectScope);
        }
        assert (fieldList.size() >= aliases.size());
        return this.typeFactory.createStructType(fieldList);
    }

    private void validateExpr(SqlNode expr, SqlValidatorScope scope) {
        expr.validateExpr(this, scope);
        scope.validateExpr(expr);
    }

    private void handleScalarSubQuery(SqlSelect sqlSelect, SqlSelect sqlSelect2, List<SqlNode> list, Set<String> set, List<Map.Entry<String, RelDataType>> list2) {
        throw new Error("Unresolved compilation problem: \n\tThe method onlyScalarSubqueryAllowed() from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    protected RelDataType createTargetRowType(SqlValidatorTable sqlValidatorTable, SqlNodeList sqlNodeList, boolean bl) {
        throw new Error("Unresolved compilation problems: \n\tThe method unknownTargetColumn(String) from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method duplicateTargetColumn(String) from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    @Override
    public void validateInsert(SqlInsert insert) {
        SqlValidatorNamespace targetNamespace = this.getNamespace(insert);
        this.validateNamespace(targetNamespace);
        SqlValidatorTable table = targetNamespace.getTable();
        RelDataType targetRowType = this.createTargetRowType(table, insert.getTargetColumnList(), false);
        SqlNode source = insert.getSource();
        if (source instanceof SqlSelect) {
            SqlSelect sqlSelect = (SqlSelect)source;
            this.validateSelect(sqlSelect, targetRowType);
        } else {
            SqlValidatorScope scope = this.scopes.get(source);
            this.validateQuery(source, scope);
        }
        RelDataType sourceRowType = this.getNamespace(source).getRowType();
        RelDataType logicalTargetRowType = this.getLogicalTargetRowType(targetRowType, insert);
        this.setValidatedNodeType(insert, logicalTargetRowType);
        RelDataType logicalSourceRowType = this.getLogicalSourceRowType(sourceRowType, insert);
        this.checkFieldCount(insert, logicalSourceRowType, logicalTargetRowType);
        this.checkTypeAssignment(logicalSourceRowType, logicalTargetRowType, insert);
        this.validateAccess(insert.getTargetTable(), table, SqlAccessEnum.INSERT);
    }

    private void checkFieldCount(SqlNode sqlNode, RelDataType relDataType, RelDataType relDataType2) {
        throw new Error("Unresolved compilation problem: \n\tThe method unmatchInsertColumn(int, int) from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    protected RelDataType getLogicalTargetRowType(RelDataType targetRowType, SqlInsert insert) {
        return targetRowType;
    }

    protected RelDataType getLogicalSourceRowType(RelDataType sourceRowType, SqlInsert insert) {
        return sourceRowType;
    }

    protected void checkTypeAssignment(RelDataType relDataType, RelDataType relDataType2, SqlNode sqlNode) {
        throw new Error("Unresolved compilation problem: \n\tThe method typeNotAssignable(String, String, String, String) from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    private SqlNode getNthExpr(SqlNode query, int ordinal, int sourceCount) {
        if (query instanceof SqlInsert) {
            SqlInsert insert = (SqlInsert)query;
            if (insert.getTargetColumnList() != null) {
                return insert.getTargetColumnList().get(ordinal);
            }
            return this.getNthExpr(insert.getSource(), ordinal, sourceCount);
        }
        if (query instanceof SqlUpdate) {
            SqlUpdate update = (SqlUpdate)query;
            if (update.getTargetColumnList() != null) {
                return update.getTargetColumnList().get(ordinal);
            }
            if (update.getSourceExpressionList() != null) {
                return update.getSourceExpressionList().get(ordinal);
            }
            return this.getNthExpr(update.getSourceSelect(), ordinal, sourceCount);
        }
        if (query instanceof SqlSelect) {
            SqlSelect select = (SqlSelect)query;
            if (select.getSelectList().size() == sourceCount) {
                return select.getSelectList().get(ordinal);
            }
            return query;
        }
        return query;
    }

    @Override
    public void validateDelete(SqlDelete call) {
        SqlSelect sqlSelect = call.getSourceSelect();
        this.validateSelect(sqlSelect, this.unknownType);
        IdentifierNamespace targetNamespace = this.getNamespace(call.getTargetTable()).unwrap(IdentifierNamespace.class);
        this.validateNamespace(targetNamespace);
        SqlValidatorTable table = targetNamespace.getTable();
        this.validateAccess(call.getTargetTable(), table, SqlAccessEnum.DELETE);
    }

    @Override
    public void validateUpdate(SqlUpdate call) {
        IdentifierNamespace targetNamespace = this.getNamespace(call.getTargetTable()).unwrap(IdentifierNamespace.class);
        this.validateNamespace(targetNamespace);
        SqlValidatorTable table = targetNamespace.getTable();
        RelDataType targetRowType = this.createTargetRowType(table, call.getTargetColumnList(), true);
        SqlSelect select = call.getSourceSelect();
        this.validateSelect(select, targetRowType);
        RelDataType sourceRowType = this.getNamespace(select).getRowType();
        this.checkTypeAssignment(sourceRowType, targetRowType, call);
        this.validateAccess(call.getTargetTable(), table, SqlAccessEnum.UPDATE);
    }

    @Override
    public void validateMerge(SqlMerge call) {
        SqlSelect sqlSelect = call.getSourceSelect();
        IdentifierNamespace targetNamespace = (IdentifierNamespace)this.getNamespace(call.getTargetTable());
        this.validateNamespace(targetNamespace);
        SqlValidatorTable table = targetNamespace.getTable();
        this.validateAccess(call.getTargetTable(), table, SqlAccessEnum.UPDATE);
        RelDataType targetRowType = this.unknownType;
        if (call.getUpdateCall() != null) {
            targetRowType = this.createTargetRowType(table, call.getUpdateCall().getTargetColumnList(), true);
        }
        if (call.getInsertCall() != null) {
            targetRowType = this.createTargetRowType(table, call.getInsertCall().getTargetColumnList(), false);
        }
        this.validateSelect(sqlSelect, targetRowType);
        if (call.getUpdateCall() != null) {
            this.validateUpdate(call.getUpdateCall());
        }
        if (call.getInsertCall() != null) {
            this.validateInsert(call.getInsertCall());
        }
    }

    private void validateAccess(SqlNode sqlNode, SqlValidatorTable sqlValidatorTable, SqlAccessEnum sqlAccessEnum) {
        throw new Error("Unresolved compilation problem: \n\tThe method accessNotAllowed(String, String) from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    protected void validateValues(SqlCall sqlCall, RelDataType relDataType, SqlValidatorScope sqlValidatorScope) {
        throw new Error("Unresolved compilation problems: \n\tThe method incompatibleValueType(String) from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method incompatibleValueType(String) from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    @Override
    public void validateDataType(SqlDataTypeSpec dataType) {
    }

    @Override
    public void validateDynamicParam(SqlDynamicParam dynamicParam) {
    }

    protected SqlWindow getWindowByName(SqlIdentifier sqlIdentifier, SqlValidatorScope sqlValidatorScope) {
        throw new Error("Unresolved compilation problem: \n\tThe method windowNotFound(String) from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    @Override
    public SqlWindow resolveWindow(SqlNode sqlNode, SqlValidatorScope sqlValidatorScope, boolean bl) {
        throw new Error("Unresolved compilation problem: \n\tThe method windowNotFound(String) from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    public SqlNode getOriginal(SqlNode expr) {
        SqlNode original = this.originalExprs.get(expr);
        if (original == null) {
            original = expr;
        }
        return original;
    }

    public void setOriginal(SqlNode expr, SqlNode original) {
        if (this.originalExprs.get(expr) == null) {
            this.originalExprs.put(expr, original);
        }
    }

    SqlValidatorNamespace lookupFieldNamespace(RelDataType rowType, String name) {
        RelDataTypeField field = this.catalogReader.field(rowType, name);
        return new FieldNamespace(this, field.getType());
    }

    @Override
    public void validateWindow(SqlNode windowOrId, SqlValidatorScope scope, SqlCall call) {
        SqlWindow targetWindow;
        switch (windowOrId.getKind()) {
            case IDENTIFIER: {
                targetWindow = this.getWindowByName((SqlIdentifier)windowOrId, scope);
                break;
            }
            case WINDOW: {
                targetWindow = (SqlWindow)windowOrId;
                break;
            }
            default: {
                throw Util.unexpected(windowOrId.getKind());
            }
        }
        assert (targetWindow.getWindowCall() == null);
        targetWindow.setWindowCall(call);
        targetWindow.validate(this, scope);
        targetWindow.setWindowCall(null);
    }

    @Override
    public void validateAggregateParams(SqlCall sqlCall, SqlValidatorScope sqlValidatorScope) {
        throw new Error("Unresolved compilation problem: \n\tThe method nestedAggIllegal() from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    @Override
    public void validateCall(SqlCall call, SqlValidatorScope scope) {
        SqlOperator operator = call.getOperator();
        if (call.operandCount() == 0 && operator.getSyntax() == SqlSyntax.FUNCTION_ID && !call.isExpanded()) {
            throw this.handleUnresolvedFunction(call, (SqlFunction)operator, (List<RelDataType>)ImmutableList.of());
        }
        SqlValidatorScope operandScope = scope.getOperandScope(call);
        operator.validateCall(call, this, scope, operandScope);
    }

    protected void validateFeature(Feature feature, SqlParserPos sqlParserPos) {
        throw new Error("Unresolved compilation problem: \n\tThe method getProperties() is undefined for the type Feature\n");
    }

    @Override
    public SqlNode expand(SqlNode expr, SqlValidatorScope scope) {
        Expander expander = new Expander(this, scope);
        SqlNode newExpr = expr.accept(expander);
        if (expr != newExpr) {
            this.setOriginal(newExpr, expr);
        }
        return newExpr;
    }

    @Override
    public boolean isSystemField(RelDataTypeField field) {
        return false;
    }

    @Override
    public List<List<String>> getFieldOrigins(SqlNode sqlQuery) {
        if (sqlQuery instanceof SqlExplain) {
            return Collections.emptyList();
        }
        RelDataType rowType = this.getValidatedNodeType(sqlQuery);
        int fieldCount = rowType.getFieldCount();
        if (!sqlQuery.isA(SqlKind.QUERY)) {
            return Collections.nCopies(fieldCount, null);
        }
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        int i = 0;
        while (i < fieldCount) {
            List<String> origin = this.getFieldOrigin(sqlQuery, i);
            list.add(origin);
            ++i;
        }
        return list;
    }

    private List<String> getFieldOrigin(SqlNode sqlQuery, int i) {
        if (sqlQuery instanceof SqlSelect) {
            SqlSelect sqlSelect = (SqlSelect)sqlQuery;
            SelectScope scope = this.getRawSelectScope(sqlSelect);
            List<SqlNode> selectList = scope.getExpandedSelectList();
            SqlNode selectItem = selectList.get(i);
            if (SqlUtil.isCallTo(selectItem, SqlStdOperatorTable.AS)) {
                selectItem = ((SqlCall)selectItem).operand(0);
            }
            if (selectItem instanceof SqlIdentifier) {
                SqlIdentifier id = (SqlIdentifier)selectItem;
                SqlValidatorNamespace namespace = null;
                ArrayList<String> origin = new ArrayList<String>();
                for (String name : id.names) {
                    if (namespace == null) {
                        namespace = scope.resolve(name, null, null);
                        SqlValidatorTable table = namespace.getTable();
                        if (table != null) {
                            origin.addAll(table.getQualifiedName());
                            continue;
                        }
                        return null;
                    }
                    if ((namespace = namespace.lookupChild(name)) != null) {
                        origin.add(name);
                        continue;
                    }
                    return null;
                }
                return origin;
            }
        }
        return null;
    }

    @Override
    public RelDataType getParameterRowType(SqlNode sqlQuery) {
        final ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        sqlQuery.accept(new SqlShuttle(){

            public SqlNode visit(SqlDynamicParam param) {
                RelDataType type = SqlValidatorImpl.this.getValidatedNodeType(param);
                types.add(type);
                return param;
            }
        });
        return this.typeFactory.createStructType(types, (List<String>)new AbstractList<String>(){

            @Override
            public String get(int index) {
                return "?" + index;
            }

            @Override
            public int size() {
                return types.size();
            }
        });
    }

    public void validateColumnListParams(SqlFunction function, List<RelDataType> argTypes, List<SqlNode> operands) {
        throw new UnsupportedOperationException();
    }

    private static class DeleteNamespace
    extends DmlNamespace {
        private final SqlDelete node;

        public DeleteNamespace(SqlValidatorImpl validator, SqlDelete node, SqlNode enclosingNode, SqlValidatorScope parentScope) {
            super(validator, node.getTargetTable(), enclosingNode, parentScope);
            this.node = node;
            assert (node != null);
        }

        public SqlDelete getNode() {
            return this.node;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeriveTypeVisitor
    implements SqlVisitor<RelDataType> {
        private final SqlValidatorScope scope;

        public DeriveTypeVisitor(SqlValidatorScope scope) {
            this.scope = scope;
        }

        @Override
        public RelDataType visit(SqlLiteral literal) {
            return literal.createSqlType(SqlValidatorImpl.this.typeFactory);
        }

        @Override
        public RelDataType visit(SqlCall call) {
            SqlOperator operator = call.getOperator();
            return operator.deriveType(SqlValidatorImpl.this, this.scope, call);
        }

        @Override
        public RelDataType visit(SqlNodeList nodeList) {
            throw Util.needToImplement(nodeList);
        }

        @Override
        public RelDataType visit(SqlIdentifier sqlIdentifier) {
            throw new Error("Unresolved compilation problems: \n\tThe method unknownIdentifier(String) from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method unknownField(String) from the type EigenbaseNewResource refers to the missing type ExInst\n");
        }

        @Override
        public RelDataType visit(SqlDataTypeSpec dataType) {
            SqlValidatorImpl.this.validateDataType(dataType);
            return dataType.deriveType(SqlValidatorImpl.this);
        }

        @Override
        public RelDataType visit(SqlDynamicParam param) {
            return SqlValidatorImpl.this.unknownType;
        }

        @Override
        public RelDataType visit(SqlIntervalQualifier intervalQualifier) {
            return SqlValidatorImpl.this.typeFactory.createSqlIntervalType(intervalQualifier);
        }
    }

    public static class DmlNamespace
    extends IdentifierNamespace {
        protected DmlNamespace(SqlValidatorImpl validator, SqlIdentifier id, SqlNode enclosingNode, SqlValidatorScope parentScope) {
            super(validator, id, enclosingNode, parentScope);
        }
    }

    private static class Expander
    extends SqlScopedShuttle {
        private final SqlValidatorImpl validator;

        public Expander(SqlValidatorImpl validator, SqlValidatorScope scope) {
            super(scope);
            this.validator = validator;
        }

        public SqlNode visit(SqlIdentifier id) {
            SqlCall call = SqlUtil.makeCall(this.validator.getOperatorTable(), id);
            if (call != null) {
                return call.accept(this);
            }
            SqlIdentifier fqId = this.getScope().fullyQualify(id);
            this.validator.setOriginal(fqId, id);
            return fqId;
        }

        protected SqlNode visitScoped(SqlCall call) {
            switch (call.getKind()) {
                case SCALAR_QUERY: {
                    return call;
                }
            }
            SqlShuttle.CallCopyingArgHandler argHandler = new SqlShuttle.CallCopyingArgHandler(call, false);
            call.getOperator().acceptCall(this, call, true, argHandler);
            SqlNode result = (SqlNode)argHandler.result();
            this.validator.setOriginal(result, call);
            return result;
        }
    }

    protected static class FunctionParamInfo {
        public final Map<Integer, SqlSelect> cursorPosToSelectMap = new HashMap<Integer, SqlSelect>();
        public final Map<String, String> columnListParamToParentCursorMap = new HashMap<String, String>();
    }

    protected static class IdInfo {
        public final SqlValidatorScope scope;
        public final SqlIdentifier id;

        public IdInfo(SqlValidatorScope scope, SqlIdentifier id) {
            this.scope = scope;
            this.id = id;
        }
    }

    private static class InsertNamespace
    extends DmlNamespace {
        private final SqlInsert node;

        public InsertNamespace(SqlValidatorImpl validator, SqlInsert node, SqlNode enclosingNode, SqlValidatorScope parentScope) {
            super(validator, node.getTargetTable(), enclosingNode, parentScope);
            this.node = node;
            assert (node != null);
        }

        public SqlInsert getNode() {
            return this.node;
        }
    }

    private static class MergeNamespace
    extends DmlNamespace {
        private final SqlMerge node;

        public MergeNamespace(SqlValidatorImpl validator, SqlMerge node, SqlNode enclosingNode, SqlValidatorScope parentScope) {
            super(validator, node.getTargetTable(), enclosingNode, parentScope);
            this.node = node;
            assert (node != null);
        }

        public SqlMerge getNode() {
            return this.node;
        }
    }

    class OrderExpressionExpander
    extends SqlScopedShuttle {
        private final List<String> aliasList;
        private final SqlSelect select;
        private final SqlNode root;

        OrderExpressionExpander(SqlSelect select, SqlNode root) {
            super(SqlValidatorImpl.this.getOrderScope(select));
            this.select = select;
            this.root = root;
            this.aliasList = SqlValidatorImpl.this.getNamespace(select).getRowType().getFieldNames();
        }

        public SqlNode go() {
            return this.root.accept(this);
        }

        public SqlNode visit(SqlLiteral sqlLiteral) {
            throw new Error("Unresolved compilation problem: \n\tThe method orderByOrdinalOutOfRange() from the type EigenbaseNewResource refers to the missing type ExInst\n");
        }

        private SqlNode nthSelectItem(int ordinal, SqlParserPos pos) {
            SqlCall call;
            SqlNodeList expandedSelectList = SqlValidatorImpl.this.expandStar(this.select.getSelectList(), this.select, false);
            SqlNode expr = expandedSelectList.get(ordinal);
            if (expr instanceof SqlCall && (call = (SqlCall)expr).getOperator() == SqlStdOperatorTable.AS) {
                expr = call.operand(0);
            }
            if (expr instanceof SqlIdentifier) {
                expr = this.getScope().fullyQualify((SqlIdentifier)expr);
            }
            return expr.clone(pos);
        }

        public SqlNode visit(SqlIdentifier id) {
            if (id.isSimple() && SqlValidatorImpl.this.getConformance().isSortByAlias()) {
                String alias = id.getSimple();
                SqlValidatorNamespace selectNs = SqlValidatorImpl.this.getNamespace(this.select);
                RelDataType rowType = selectNs.getRowTypeSansSystemColumns();
                RelDataTypeField field = SqlValidatorImpl.this.catalogReader.field(rowType, alias);
                if (field != null) {
                    return this.nthSelectItem(field.getIndex(), id.getParserPosition());
                }
            }
            return this.getScope().fullyQualify(id);
        }

        protected SqlNode visitScoped(SqlCall call) {
            if (call instanceof SqlSelect) {
                return call;
            }
            return super.visitScoped(call);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        UNVALIDATED,
        IN_PROGRESS,
        VALID;

    }

    private static class UpdateNamespace
    extends DmlNamespace {
        private final SqlUpdate node;

        public UpdateNamespace(SqlValidatorImpl validator, SqlUpdate node, SqlNode enclosingNode, SqlValidatorScope parentScope) {
            super(validator, node.getTargetTable(), enclosingNode, parentScope);
            this.node = node;
            assert (node != null);
        }

        public SqlUpdate getNode() {
            return this.node;
        }
    }
}

