/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import java.util.AbstractList;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.reltype.RelDataTypeImpl;
import org.eigenbase.reltype.RelProtoDataType;
import org.eigenbase.sql.ExplicitOperatorBinding;
import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlOperatorBinding;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.type.ExplicitReturnTypeInference;
import org.eigenbase.sql.type.MatchReturnTypeInference;
import org.eigenbase.sql.type.OrdinalReturnTypeInference;
import org.eigenbase.sql.type.SqlReturnTypeInference;
import org.eigenbase.sql.type.SqlReturnTypeInferenceChain;
import org.eigenbase.sql.type.SqlTypeFamily;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.type.SqlTypeTransform;
import org.eigenbase.sql.type.SqlTypeTransformCascade;
import org.eigenbase.sql.type.SqlTypeTransforms;
import org.eigenbase.sql.type.SqlTypeUtil;

public abstract class ReturnTypes {
    public static final SqlReturnTypeInference ARG0 = new OrdinalReturnTypeInference(0);
    public static final SqlReturnTypeInference ARG0_NULLABLE_VARYING = ReturnTypes.cascade(ARG0, SqlTypeTransforms.TO_NULLABLE, SqlTypeTransforms.TO_VARYING);
    public static final SqlReturnTypeInference ARG0_NULLABLE = ReturnTypes.cascade(ARG0, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference ARG0_FORCE_NULLABLE = ReturnTypes.cascade(ARG0, SqlTypeTransforms.FORCE_NULLABLE);
    public static final SqlReturnTypeInference ARG0_INTERVAL = new MatchReturnTypeInference(0, SqlTypeFamily.DATETIME_INTERVAL.getTypeNames());
    public static final SqlReturnTypeInference ARG0_INTERVAL_NULLABLE = ReturnTypes.cascade(ARG0_INTERVAL, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference ARG1 = new OrdinalReturnTypeInference(1);
    public static final SqlReturnTypeInference ARG1_NULLABLE = ReturnTypes.cascade(ARG1, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference ARG2 = new OrdinalReturnTypeInference(2);
    public static final SqlReturnTypeInference ARG2_NULLABLE = ReturnTypes.cascade(ARG2, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference BOOLEAN = ReturnTypes.explicit(SqlTypeName.BOOLEAN);
    public static final SqlReturnTypeInference BOOLEAN_NULLABLE = ReturnTypes.cascade(BOOLEAN, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference BOOLEAN_NOT_NULL = ReturnTypes.cascade(BOOLEAN, SqlTypeTransforms.TO_NOT_NULLABLE);
    public static final SqlReturnTypeInference DATE = ReturnTypes.explicit(SqlTypeName.DATE);
    public static final SqlReturnTypeInference TIME = ReturnTypes.explicit(SqlTypeName.TIME, 0);
    public static final SqlReturnTypeInference TIME_NULLABLE = ReturnTypes.cascade(TIME, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference DOUBLE = ReturnTypes.explicit(SqlTypeName.DOUBLE);
    public static final SqlReturnTypeInference DOUBLE_NULLABLE = ReturnTypes.cascade(DOUBLE, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference INTEGER = ReturnTypes.explicit(SqlTypeName.INTEGER);
    public static final SqlReturnTypeInference INTEGER_NULLABLE = ReturnTypes.cascade(INTEGER, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference BIGINT = ReturnTypes.explicit(SqlTypeName.BIGINT);
    public static final SqlReturnTypeInference BIGINT_FORCE_NULLABLE = ReturnTypes.cascade(BIGINT, SqlTypeTransforms.FORCE_NULLABLE);
    public static final SqlReturnTypeInference BIGINT_NULLABLE = ReturnTypes.cascade(BIGINT, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference VARCHAR_2000 = ReturnTypes.explicit(SqlTypeName.VARCHAR, 2000);
    public static final SqlReturnTypeInference HISTOGRAM = ReturnTypes.explicit(SqlTypeName.VARBINARY, 8);
    public static final SqlReturnTypeInference CURSOR = ReturnTypes.explicit(SqlTypeName.CURSOR);
    public static final SqlReturnTypeInference COLUMN_LIST = ReturnTypes.explicit(SqlTypeName.COLUMN_LIST);
    public static final SqlReturnTypeInference LEAST_RESTRICTIVE = new SqlReturnTypeInference(){

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            return opBinding.getTypeFactory().leastRestrictive(opBinding.collectOperandTypes());
        }
    };
    public static final SqlReturnTypeInference MULTISET = new SqlReturnTypeInference(){

        public RelDataType inferReturnType(final SqlOperatorBinding opBinding) {
            ExplicitOperatorBinding newBinding = new ExplicitOperatorBinding(opBinding, (List<RelDataType>)new AbstractList<RelDataType>(){

                @Override
                public RelDataType get(int index) {
                    RelDataType type = opBinding.getOperandType(index).getComponentType();
                    if (!$assertionsDisabled && type == null) {
                        throw new AssertionError();
                    }
                    return type;
                }

                @Override
                public int size() {
                    return opBinding.getOperandCount();
                }
            });
            RelDataType biggestElementType = LEAST_RESTRICTIVE.inferReturnType(newBinding);
            return opBinding.getTypeFactory().createMultisetType(biggestElementType, -1L);
        }
    };
    public static final SqlReturnTypeInference MULTISET_ELEMENT_NULLABLE = ReturnTypes.cascade(MULTISET, SqlTypeTransforms.TO_MULTISET_ELEMENT_TYPE);
    public static final SqlReturnTypeInference MULTISET_NULLABLE = ReturnTypes.cascade(MULTISET, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference MULTISET_PROJECT_ONLY = ReturnTypes.cascade(MULTISET, SqlTypeTransforms.ONLY_COLUMN);
    public static final SqlReturnTypeInference INTEGER_QUOTIENT_NULLABLE = ReturnTypes.chain(ARG0_INTERVAL_NULLABLE, LEAST_RESTRICTIVE);
    public static final SqlReturnTypeInference DECIMAL_SCALE0 = new SqlReturnTypeInference(){

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataType type1 = opBinding.getOperandType(0);
            if (SqlTypeUtil.isDecimal(type1)) {
                if (type1.getScale() == 0) {
                    return type1;
                }
                int p = type1.getPrecision();
                RelDataType ret = opBinding.getTypeFactory().createSqlType(SqlTypeName.DECIMAL, p, 0);
                if (type1.isNullable()) {
                    ret = opBinding.getTypeFactory().createTypeWithNullability(ret, true);
                }
                return ret;
            }
            return null;
        }
    };
    public static final SqlReturnTypeInference ARG0_OR_EXACT_NO_SCALE = ReturnTypes.chain(DECIMAL_SCALE0, ARG0);
    public static final SqlReturnTypeInference DECIMAL_PRODUCT = new SqlReturnTypeInference(){

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            RelDataType type1 = opBinding.getOperandType(0);
            RelDataType type2 = opBinding.getOperandType(1);
            return typeFactory.createDecimalProduct(type1, type2);
        }
    };
    public static final SqlReturnTypeInference DECIMAL_PRODUCT_NULLABLE = ReturnTypes.cascade(DECIMAL_PRODUCT, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference PRODUCT_NULLABLE = ReturnTypes.chain(DECIMAL_PRODUCT_NULLABLE, ARG0_INTERVAL_NULLABLE, LEAST_RESTRICTIVE);
    public static final SqlReturnTypeInference DECIMAL_QUOTIENT = new SqlReturnTypeInference(){

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            RelDataType type1 = opBinding.getOperandType(0);
            RelDataType type2 = opBinding.getOperandType(1);
            return typeFactory.createDecimalQuotient(type1, type2);
        }
    };
    public static final SqlReturnTypeInference DECIMAL_QUOTIENT_NULLABLE = ReturnTypes.cascade(DECIMAL_QUOTIENT, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference QUOTIENT_NULLABLE = ReturnTypes.chain(DECIMAL_QUOTIENT_NULLABLE, ARG0_INTERVAL_NULLABLE, LEAST_RESTRICTIVE);
    public static final SqlReturnTypeInference DECIMAL_SUM = new SqlReturnTypeInference(){

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataType type1 = opBinding.getOperandType(0);
            RelDataType type2 = opBinding.getOperandType(1);
            if (SqlTypeUtil.isExactNumeric(type1) && SqlTypeUtil.isExactNumeric(type2) && (SqlTypeUtil.isDecimal(type1) || SqlTypeUtil.isDecimal(type2))) {
                int p1 = type1.getPrecision();
                int p2 = type2.getPrecision();
                int s1 = type1.getScale();
                int s2 = type2.getScale();
                int scale = Math.max(s1, s2);
                if (!$assertionsDisabled && scale > 19) {
                    throw new AssertionError();
                }
                int precision = Math.max(p1 - s1, p2 - s2) + scale + 1;
                precision = Math.min(precision, 19);
                if (!$assertionsDisabled && precision <= 0) {
                    throw new AssertionError();
                }
                RelDataType ret = opBinding.getTypeFactory().createSqlType(SqlTypeName.DECIMAL, precision, scale);
                return ret;
            }
            return null;
        }
    };
    public static final SqlReturnTypeInference DECIMAL_SUM_NULLABLE = ReturnTypes.cascade(DECIMAL_SUM, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference NULLABLE_SUM = new SqlReturnTypeInferenceChain(DECIMAL_SUM_NULLABLE, LEAST_RESTRICTIVE);
    public static final SqlReturnTypeInference DYADIC_STRING_SUM_PRECISION = new SqlReturnTypeInference(){

        public RelDataType inferReturnType(SqlOperatorBinding sqlOperatorBinding) {
            throw new Error("Unresolved compilation problem: \n\tThe method typeNotComparable(String, String) from the type EigenbaseNewResource refers to the missing type ExInst\n");
        }
    };
    public static final SqlReturnTypeInference DYADIC_STRING_SUM_PRECISION_NULLABLE_VARYING = ReturnTypes.cascade(DYADIC_STRING_SUM_PRECISION, SqlTypeTransforms.TO_NULLABLE, SqlTypeTransforms.TO_VARYING);
    public static final SqlReturnTypeInference DYADIC_STRING_SUM_PRECISION_NULLABLE = ReturnTypes.cascade(DYADIC_STRING_SUM_PRECISION, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference SCOPE = new SqlReturnTypeInference(){

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            SqlCallBinding callBinding = (SqlCallBinding)opBinding;
            return callBinding.getValidator().getNamespace(callBinding.getCall()).getRowType();
        }
    };
    public static final SqlReturnTypeInference MULTISET_PROJECT0 = new SqlReturnTypeInference(){

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            if (!$assertionsDisabled && opBinding.getOperandCount() != 1) {
                throw new AssertionError();
            }
            RelDataType recordMultisetType = opBinding.getOperandType(0);
            RelDataType multisetType = recordMultisetType.getComponentType();
            if (!$assertionsDisabled && multisetType == null) {
                throw new AssertionError((Object)("expected a multiset type: " + recordMultisetType));
            }
            List<RelDataTypeField> fields = multisetType.getFieldList();
            if (!$assertionsDisabled && fields.size() <= 0) {
                throw new AssertionError();
            }
            RelDataType firstColType = fields.get(0).getType();
            return opBinding.getTypeFactory().createMultisetType(firstColType, -1L);
        }
    };
    public static final SqlReturnTypeInference MULTISET_RECORD = new SqlReturnTypeInference(){

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            if (!$assertionsDisabled && opBinding.getOperandCount() != 1) {
                throw new AssertionError();
            }
            RelDataType multisetType = opBinding.getOperandType(0);
            RelDataType componentType = multisetType.getComponentType();
            if (!$assertionsDisabled && componentType == null) {
                throw new AssertionError((Object)("expected a multiset type: " + multisetType));
            }
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            RelDataType type = typeFactory.builder().add(SqlUtil.deriveAliasFromOrdinal(0), componentType).build();
            return typeFactory.createMultisetType(type, -1L);
        }
    };
    public static final SqlReturnTypeInference RECORD_TO_SCALAR = new SqlReturnTypeInference(){

        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            if (!$assertionsDisabled && opBinding.getOperandCount() != 1) {
                throw new AssertionError();
            }
            RelDataType recordType = opBinding.getOperandType(0);
            boolean isStruct = recordType.isStruct();
            int fieldCount = recordType.getFieldCount();
            if (!($assertionsDisabled || isStruct && fieldCount == 1)) {
                throw new AssertionError();
            }
            RelDataTypeField fieldType = recordType.getFieldList().get(0);
            if (!$assertionsDisabled && fieldType == null) {
                throw new AssertionError((Object)("expected a record type with one field: " + recordType));
            }
            RelDataType firstColType = fieldType.getType();
            return opBinding.getTypeFactory().createTypeWithNullability(firstColType, true);
        }
    };

    private ReturnTypes() {
    }

    public static SqlReturnTypeInferenceChain chain(SqlReturnTypeInference ... rules) {
        return new SqlReturnTypeInferenceChain(rules);
    }

    public static SqlTypeTransformCascade cascade(SqlReturnTypeInference rule, SqlTypeTransform ... transforms) {
        return new SqlTypeTransformCascade(rule, transforms);
    }

    public static ExplicitReturnTypeInference explicit(RelProtoDataType protoType) {
        return new ExplicitReturnTypeInference(protoType);
    }

    public static ExplicitReturnTypeInference explicit(RelDataType type) {
        return ReturnTypes.explicit(RelDataTypeImpl.proto(type));
    }

    public static ExplicitReturnTypeInference explicit(SqlTypeName typeName) {
        return ReturnTypes.explicit(RelDataTypeImpl.proto(typeName));
    }

    public static ExplicitReturnTypeInference explicit(SqlTypeName typeName, int precision) {
        return ReturnTypes.explicit(RelDataTypeImpl.proto(typeName, precision));
    }
}

