/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.type.SqlOperandTypeInference;
import org.eigenbase.sql.type.SqlTypeName;

public abstract class InferTypes {
    public static final SqlOperandTypeInference FIRST_KNOWN = new SqlOperandTypeInference(){

        public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
            RelDataType unknownType;
            RelDataType knownType = unknownType = callBinding.getValidator().getUnknownType();
            for (SqlNode operand : callBinding.getCall().getOperandList()) {
                knownType = callBinding.getValidator().deriveType(callBinding.getScope(), operand);
                if (!knownType.equals(unknownType)) break;
            }
            int i = 0;
            while (i < operandTypes.length) {
                operandTypes[i] = knownType;
                ++i;
            }
        }
    };
    public static final SqlOperandTypeInference RETURN_TYPE = new SqlOperandTypeInference(){

        public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
            int i = 0;
            while (i < operandTypes.length) {
                operandTypes[i] = returnType.isStruct() ? returnType.getFieldList().get(i).getType() : returnType;
                ++i;
            }
        }
    };
    public static final SqlOperandTypeInference BOOLEAN = new SqlOperandTypeInference(){

        public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
            RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
            int i = 0;
            while (i < operandTypes.length) {
                operandTypes[i] = typeFactory.createSqlType(SqlTypeName.BOOLEAN);
                ++i;
            }
        }
    };
    public static final SqlOperandTypeInference VARCHAR_1024 = new SqlOperandTypeInference(){

        public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
            RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
            int i = 0;
            while (i < operandTypes.length) {
                operandTypes[i] = typeFactory.createSqlType(SqlTypeName.VARCHAR, 1024);
                ++i;
            }
        }
    };

    private InferTypes() {
    }
}

