/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.hydromatic.avatica.Casing;
import org.eigenbase.sql.SqlBinaryOperator;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlIntervalLiteral;
import org.eigenbase.sql.SqlIntervalQualifier;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlPostfixOperator;
import org.eigenbase.sql.SqlSpecialOperator;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.trace.EigenbaseTrace;
import org.eigenbase.util.EigenbaseContextException;
import org.eigenbase.util.SaffronProperties;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SqlParserUtil {
    static final Logger LOGGER = EigenbaseTrace.getParserTracer();

    private SqlParserUtil() {
    }

    public static String getCharacterSet(String s) {
        if (s.charAt(0) == '\'') {
            return null;
        }
        if (Character.toUpperCase(s.charAt(0)) == 'N') {
            return SaffronProperties.instance().defaultNationalCharset.get();
        }
        int i = s.indexOf("'");
        return s.substring(1, i);
    }

    public static String parseString(String s) {
        int i = s.indexOf("'");
        if (i > 0) {
            s = s.substring(i);
        }
        return SqlParserUtil.strip(s, "'", "'", "''", Casing.UNCHANGED);
    }

    public static BigDecimal parseDecimal(String s) {
        return new BigDecimal(s);
    }

    public static BigDecimal parseInteger(String s) {
        return new BigDecimal(s);
    }

    public static Date parseDate(String s) {
        return Date.valueOf(s);
    }

    public static Time parseTime(String s) {
        return Time.valueOf(s);
    }

    public static Timestamp parseTimestamp(String s) {
        return Timestamp.valueOf(s);
    }

    public static void checkDateFormat(String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        Util.discard(df);
    }

    public static long intervalToMillis(SqlIntervalLiteral.IntervalValue interval) {
        return SqlParserUtil.intervalToMillis(interval.getIntervalLiteral(), interval.getIntervalQualifier());
    }

    public static long intervalToMillis(String literal, SqlIntervalQualifier intervalQualifier) {
        int[] ret;
        Util.permAssert(!intervalQualifier.isYearMonth(), "interval must be day time");
        try {
            ret = intervalQualifier.evaluateIntervalLiteral(literal, intervalQualifier.getParserPosition());
            assert (ret != null);
        }
        catch (EigenbaseContextException e) {
            throw Util.newInternal(e, "while parsing day-to-second interval " + literal);
        }
        long l = 0L;
        long[] conv = new long[5];
        conv[4] = 1L;
        conv[3] = conv[4] * 1000L;
        conv[2] = conv[3] * 60L;
        conv[1] = conv[2] * 60L;
        conv[0] = conv[1] * 24L;
        int i = 1;
        while (i < ret.length) {
            l += conv[i - 1] * (long)ret[i];
            ++i;
        }
        return (long)ret[0] * l;
    }

    public static long intervalToMonths(SqlIntervalLiteral.IntervalValue interval) {
        return SqlParserUtil.intervalToMonths(interval.getIntervalLiteral(), interval.getIntervalQualifier());
    }

    public static long intervalToMonths(String literal, SqlIntervalQualifier intervalQualifier) {
        int[] ret;
        Util.permAssert(intervalQualifier.isYearMonth(), "interval must be year month");
        try {
            ret = intervalQualifier.evaluateIntervalLiteral(literal, intervalQualifier.getParserPosition());
            assert (ret != null);
        }
        catch (EigenbaseContextException e) {
            throw Util.newInternal(e, "error parsing year-to-month interval " + literal);
        }
        long l = 0L;
        long[] conv = new long[2];
        conv[1] = 1L;
        conv[0] = conv[1] * 12L;
        int i = 1;
        while (i < ret.length) {
            l += conv[i - 1] * (long)ret[i];
            ++i;
        }
        return (long)ret[0] * l;
    }

    public static int parsePositiveInt(String value) {
        if ((value = value.trim()).charAt(0) == '-') {
            throw new NumberFormatException(value);
        }
        return Integer.parseInt(value);
    }

    public static byte[] parseBinaryString(String s) {
        s = s.replaceAll(" ", "");
        s = s.replaceAll("\n", "");
        s = s.replaceAll("\t", "");
        s = s.replaceAll("\r", "");
        s = s.replaceAll("\f", "");
        if ((s = s.replaceAll("'", "")).length() == 0) {
            return new byte[0];
        }
        assert ((s.length() & 1) == 0);
        int lengthToBe = s.length() / 2;
        s = "ff" + s;
        BigInteger bigInt = new BigInteger(s, 16);
        byte[] ret = new byte[lengthToBe];
        System.arraycopy(bigInt.toByteArray(), 2, ret, 0, ret.length);
        return ret;
    }

    public static String strip(String s, String startQuote, String endQuote, String escape, Casing casing) {
        if (startQuote != null) {
            assert (endQuote != null);
            assert (startQuote.length() == 1);
            assert (endQuote.length() == 1);
            assert (escape != null);
            assert (s.startsWith(startQuote) && s.endsWith(endQuote)) : s;
            s = s.substring(1, s.length() - 1).replace(escape, endQuote);
        }
        switch (casing) {
            case TO_UPPER: {
                return s.toUpperCase();
            }
            case TO_LOWER: {
                return s.toLowerCase();
            }
        }
        return s;
    }

    public static String trim(String s, String chars) {
        if (s.length() == 0) {
            return "";
        }
        int start = 0;
        while (start < s.length()) {
            char c = s.charAt(start);
            if (chars.indexOf(c) < 0) break;
            ++start;
        }
        int stop = s.length();
        while (stop > start) {
            char c = s.charAt(stop - 1);
            if (chars.indexOf(c) < 0) break;
            --stop;
        }
        if (start >= stop) {
            return "";
        }
        return s.substring(start, stop);
    }

    public static StringAndPos findPos(String sql) {
        int[] end;
        int firstCaret = sql.indexOf(94);
        if (firstCaret < 0) {
            return new StringAndPos(sql, -1, null);
        }
        int secondCaret = sql.indexOf(94, firstCaret + 1);
        if (secondCaret < 0) {
            String sqlSansCaret = String.valueOf(sql.substring(0, firstCaret)) + sql.substring(firstCaret + 1);
            int[] start = SqlParserUtil.indexToLineCol(sql, firstCaret);
            SqlParserPos pos = new SqlParserPos(start[0], start[1]);
            return new StringAndPos(sqlSansCaret, firstCaret, pos);
        }
        String sqlSansCaret = String.valueOf(sql.substring(0, firstCaret)) + sql.substring(firstCaret + 1, secondCaret) + sql.substring(secondCaret + 1);
        int[] start = SqlParserUtil.indexToLineCol(sql, firstCaret);
        if (start[0] == (end = SqlParserUtil.indexToLineCol(sql, --secondCaret))[0]) {
            end[1] = end[1] - 1;
        }
        SqlParserPos pos = new SqlParserPos(start[0], start[1], end[0], end[1]);
        return new StringAndPos(sqlSansCaret, firstCaret, pos);
    }

    public static int[] indexToLineCol(String sql, int i) {
        int line = 0;
        int j = 0;
        while (true) {
            int prevj = j;
            if ((j = SqlParserUtil.nextLine(sql, j)) < 0 || j > i) {
                return new int[]{line + 1, i - prevj + 1};
            }
            ++line;
        }
    }

    public static int nextLine(String sql, int j) {
        int rn = sql.indexOf("\r\n", j);
        int r = sql.indexOf("\r", j);
        int n = sql.indexOf("\n", j);
        if (r < 0 && n < 0) {
            assert (rn < 0);
            return -1;
        }
        if (rn >= 0 && rn < n && rn <= r) {
            return rn + 2;
        }
        if (r >= 0 && r < n) {
            return r + 1;
        }
        return n + 1;
    }

    /*
     * Unable to fully structure code
     */
    public static int lineColToIndex(String sql, int line, int column) {
        --column;
        i = 0;
        if (true) ** GOTO lbl6
        do {
            i = SqlParserUtil.nextLine(sql, i);
lbl6:
            // 2 sources

            v0 = --line;
            --line;
        } while (v0 > 0);
        return i + column;
    }

    public static String addCarets(String sql, int line, int col, int endLine, int endCol) {
        int cut = SqlParserUtil.lineColToIndex(sql, line, col);
        String sqlWithCarets = String.valueOf(sql.substring(0, cut)) + "^" + sql.substring(cut);
        if (col != endCol || line != endLine) {
            cut = SqlParserUtil.lineColToIndex(sqlWithCarets, endLine, endCol);
            sqlWithCarets = ++cut < sqlWithCarets.length() ? String.valueOf(sqlWithCarets.substring(0, cut)) + "^" + sqlWithCarets.substring(cut) : String.valueOf(sqlWithCarets) + "^";
        }
        return sqlWithCarets;
    }

    public static String getTokenVal(String token) {
        int endIndex;
        if (!token.startsWith("\"")) {
            return null;
        }
        int startIndex = token.indexOf("\"");
        String tokenVal = token.substring(startIndex + 1, endIndex = token.lastIndexOf("\""));
        char c = tokenVal.charAt(0);
        if (Character.isLetter(c)) {
            return tokenVal;
        }
        return null;
    }

    public static ParsedCollation parseCollation(String string) {
        throw new Error("Unresolved compilation problem: \n\tThe method illegalLocaleFormat(String) from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    public static String[] toStringArray(List<String> list) {
        return list.toArray(new String[list.size()]);
    }

    public static SqlNode[] toNodeArray(List<SqlNode> list) {
        return list.toArray(new SqlNode[list.size()]);
    }

    public static SqlNode[] toNodeArray(SqlNodeList list) {
        return list.toArray();
    }

    public static String rightTrim(String s, char c) {
        int stop = s.length();
        while (stop > 0) {
            if (s.charAt(stop - 1) != c) break;
            --stop;
        }
        if (stop > 0) {
            return s.substring(0, stop);
        }
        return "";
    }

    public static <T> void replaceSublist(List<T> list, int start, int end, T o) {
        Util.pre(list != null, "list != null");
        Util.pre(start < end, "start < end");
        int i = end - 1;
        while (i > start) {
            list.remove(i);
            --i;
        }
        list.set(start, o);
    }

    public static SqlNode toTree(List<Object> list) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Attempting to reduce " + list);
        }
        SqlNode node = SqlParserUtil.toTreeEx(list, 0, 0, SqlKind.OTHER);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Reduced " + node);
        }
        return node;
    }

    public static SqlNode toTreeEx(List<Object> list, int start, int minPrec, SqlKind stopperKind) {
        int count;
        block0: while ((count = list.size()) > start + 1) {
            int i = start + 1;
            while (i < count) {
                SqlNode leftExp;
                int nextLeft;
                SqlOperator next;
                int previousRight;
                SqlOperator previous;
                SqlOperator current = ((ToTreeListItem)list.get(i)).op;
                SqlParserPos currentPos = ((ToTreeListItem)list.get(i)).pos;
                if (stopperKind != SqlKind.OTHER && current.getKind() == stopperKind) break block0;
                int left = current.getLeftPrec();
                int right = current.getRightPrec();
                if (left < minPrec) break block0;
                if (current instanceof SqlBinaryOperator) {
                    if (i == start + 1) {
                        previous = null;
                        previousRight = 0;
                    } else {
                        previous = ((ToTreeListItem)list.get(i - 2)).op;
                        previousRight = previous.getRightPrec();
                    }
                    if (i == count - 2) {
                        next = null;
                        nextLeft = 0;
                    } else {
                        next = ((ToTreeListItem)list.get(i + 2)).op;
                        nextLeft = next.getLeftPrec();
                        if (next.getKind() == stopperKind && stopperKind != SqlKind.OTHER) {
                            nextLeft = 0;
                        }
                    }
                    if (previousRight < left && right >= nextLeft) {
                        leftExp = (SqlNode)list.get(i - 1);
                        SqlNode rightExp = (SqlNode)list.get(i + 1);
                        SqlParserPos callPos = currentPos.plusAll(new SqlNode[]{leftExp, rightExp});
                        SqlCall newExp = current.createCall(callPos, leftExp, rightExp);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Reduced infix: " + newExp);
                        }
                        SqlParserUtil.replaceSublist(list, i - 1, i + 2, newExp);
                        break;
                    }
                    i += 2;
                    continue;
                }
                if (current instanceof SqlPostfixOperator) {
                    if (i == start + 1) {
                        previous = null;
                        previousRight = 0;
                    } else {
                        previous = ((ToTreeListItem)list.get(i - 2)).op;
                        previousRight = previous.getRightPrec();
                    }
                    if (previousRight < left) {
                        leftExp = (SqlNode)list.get(i - 1);
                        SqlParserPos callPos = currentPos.plusAll(new SqlNode[]{leftExp});
                        SqlCall newExp = current.createCall(callPos, leftExp);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Reduced postfix: " + newExp);
                        }
                        list.remove(i);
                        list.set(i - 1, newExp);
                        break;
                    }
                    ++i;
                    continue;
                }
                if (current instanceof SqlSpecialOperator) {
                    SqlSpecialOperator specOp = (SqlSpecialOperator)current;
                    if (i == start + 1) {
                        previous = null;
                        previousRight = 0;
                    } else {
                        previous = ((ToTreeListItem)list.get(i - 2)).op;
                        previousRight = previous.getRightPrec();
                    }
                    int nextOrdinal = i + 2;
                    if (i == count - 2) {
                        next = null;
                        nextLeft = 0;
                    } else {
                        next = null;
                        nextLeft = 0;
                        while (nextOrdinal < count) {
                            Object listItem = list.get(nextOrdinal);
                            if (listItem instanceof ToTreeListItem) {
                                next = ((ToTreeListItem)listItem).op;
                                nextLeft = next.getLeftPrec();
                                if (stopperKind == SqlKind.OTHER || next.getKind() != stopperKind) break;
                                break block0;
                            }
                            ++nextOrdinal;
                        }
                    }
                    if (nextLeft < minPrec) break block0;
                    if (previousRight < left && right >= nextLeft) {
                        i = specOp.reduceExpr(i, list);
                        if (!LOGGER.isLoggable(Level.FINE)) break;
                        LOGGER.fine("Reduced special op: " + list.get(i));
                        break;
                    }
                    i = nextOrdinal;
                    continue;
                }
                throw Util.newInternal("Unexpected operator type: " + current);
            }
            assert (list.size() < count);
        }
        return (SqlNode)list.get(start);
    }

    public static char checkUnicodeEscapeChar(String string) {
        throw new Error("Unresolved compilation problems: \n\tThe method unicodeEscapeCharLength(String) from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method unicodeEscapeCharIllegal(String) from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    public static class ParsedCollation {
        private final Charset charset;
        private final Locale locale;
        private final String strength;

        public ParsedCollation(Charset charset, Locale locale, String strength) {
            this.charset = charset;
            this.locale = locale;
            this.strength = strength;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getStrength() {
            return this.strength;
        }
    }

    public static class StringAndPos {
        public final String sql;
        public final int cursor;
        public final SqlParserPos pos;

        StringAndPos(String sql, int cursor, SqlParserPos pos) {
            this.sql = sql;
            this.cursor = cursor;
            this.pos = pos;
        }
    }

    public static class ToTreeListItem {
        private final SqlOperator op;
        private final SqlParserPos pos;

        public ToTreeListItem(SqlOperator op, SqlParserPos pos) {
            this.op = op;
            this.pos = pos;
        }

        public SqlOperator getOperator() {
            return this.op;
        }

        public SqlParserPos getPos() {
            return this.pos;
        }
    }
}

