/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.hydromatic.avatica.Casing;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlFunction;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlSyntax;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParseException;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.parser.SqlParserUtil;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SqlAbstractParserImpl {
    private static final ImmutableSet<String> SQL_92_RESERVED_WORD_SET = ImmutableSet.of((Object)"ABSOLUTE", (Object)"ACTION", (Object)"ADD", (Object)"ALL", (Object)"ALLOCATE", (Object)"ALTER", (Object[])new String[]{"AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIT", "BIT_LENGTH", "BOTH", "BY", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR", "CHARACTER", "CHARACTER_LENGTH", "CHAR_LENGTH", "CHECK", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CONVERT", "CORRESPONDING", "COUNT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DESCRIPTOR", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOMAIN", "DOUBLE", "DROP", "ELSE", "END", "END-EXEC", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FROM", "FULL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HAVING", "HOUR", "IDENTITY", "IMMEDIATE", "IN", "INDICATOR", "INITIALLY", "INNER", "INADD", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LANGUAGE", "LAST", "LEADING", "LEFT", "LEVEL", "LIKE", "LOCAL", "LOWER", "MATCH", "MAX", "MIN", "MINUTE", "MODULE", "MONTH", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NOT", "NULL", "NULLIF", "NUMERIC", "OCTET_LENGTH", "OF", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUTER", "OUTADD", "OVERLAPS", "PAD", "PARTIAL", "POSITION", "PRECISION", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RESTRICT", "REVOKE", "RIGHT", "ROLLBACK", "ROWS", "SCHEMA", "SCROLL", "SECOND", "SECTION", "SELECT", "SESSION", "SESSION_USER", "SET", "SIZE", "SMALLINT", "SOME", "SPACE", "SQL", "SQLCODE", "SQLERROR", "SQLSTATE", "SUBSTRING", "SUM", "SYSTEM_USER", "TABLE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRIM", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "UPPER", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WITH", "WORK", "WRITE", "YEAR", "ZONE"});
    protected final SqlStdOperatorTable opTab = SqlStdOperatorTable.instance();
    protected int nDynamicParams;

    public static Set<String> getSql92ReservedWords() {
        return SQL_92_RESERVED_WORD_SET;
    }

    protected SqlCall createCall(SqlIdentifier funName, SqlParserPos pos, SqlFunctionCategory funcType, SqlLiteral functionQualifier, SqlNode[] operands) {
        List<SqlOperator> list;
        SqlOperator fun = null;
        if (funName.isSimple() && (list = this.opTab.lookupOperatorOverloads(funName, null, SqlSyntax.FUNCTION)).size() == 1) {
            fun = list.get(0);
        }
        if (fun == null) {
            fun = new SqlFunction(funName, null, null, null, null, funcType);
        }
        return fun.createCall(functionQualifier, pos, operands);
    }

    public abstract Metadata getMetadata();

    public abstract SqlParseException normalizeException(Throwable var1);

    public abstract void ReInit(Reader var1);

    public abstract SqlNode parseSqlExpressionEof() throws Exception;

    public abstract SqlNode parseSqlStmtEof() throws Exception;

    public abstract void setTabSize(int var1);

    public abstract void setQuotedCasing(Casing var1);

    public abstract void setUnquotedCasing(Casing var1);

    public abstract void switchTo(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ExprContext {
        ACCEPT_ALL,
        ACCEPT_NONCURSOR,
        ACCEPT_QUERY,
        ACCEPT_NONQUERY,
        ACCEPT_SUBQUERY,
        ACCEPT_CURSOR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Metadata {
        public boolean isNonReservedKeyword(String var1);

        public boolean isContextVariableName(String var1);

        public boolean isReservedFunctionName(String var1);

        public boolean isKeyword(String var1);

        public boolean isReservedWord(String var1);

        public boolean isSql92ReservedWord(String var1);

        public String getJdbcKeywords();

        public List<String> getTokens();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MetadataImpl
    implements Metadata {
        private final Set<String> reservedFunctionNames = new HashSet<String>();
        private final Set<String> contextVariableNames = new HashSet<String>();
        private final Set<String> nonReservedKeyWordSet = new HashSet<String>();
        private final SortedSet<String> tokenSet = new TreeSet<String>();
        private final List<String> tokenList;
        private final Set<String> reservedWords = new HashSet<String>();
        private final String sql92ReservedWords;

        public MetadataImpl(SqlAbstractParserImpl sqlParser) {
            this.initList(sqlParser, this.reservedFunctionNames, "ReservedFunctionName");
            this.initList(sqlParser, this.contextVariableNames, "ContextVariable");
            this.initList(sqlParser, this.nonReservedKeyWordSet, "NonReservedKeyWord");
            this.tokenList = ImmutableList.copyOf(this.tokenSet);
            this.sql92ReservedWords = this.constructSql92ReservedWordList();
            TreeSet<String> reservedWordSet = new TreeSet<String>();
            reservedWordSet.addAll(this.tokenSet);
            reservedWordSet.removeAll(this.nonReservedKeyWordSet);
            this.reservedWords.addAll(reservedWordSet);
        }

        /*
         * Unable to fully structure code
         */
        private void initList(SqlAbstractParserImpl parserImpl, Set<String> keywords, String name) {
            block9: {
                block8: {
                    parserImpl.ReInit(new StringReader("1"));
                    try {
                        o = this.virtualCall(parserImpl, name);
                        Util.discard(o);
                        throw Util.newInternal("expected call to fail");
                    }
                    catch (SqlParseException parseException) {
                        tokenImages = parseException.getTokenImages();
                        if (!this.tokenSet.isEmpty()) break block8;
                        var9_8 = tokenImages;
                        var8_10 = tokenImages.length;
                        var7_11 = 0;
                        ** while (var7_11 < var8_10)
                    }
lbl-1000:
                    // 1 sources

                    {
                        token = var9_8[var7_11];
                        tokenVal = SqlParserUtil.getTokenVal(token);
                        if (tokenVal != null) {
                            this.tokenSet.add(tokenVal);
                        }
                        ++var7_11;
                        continue;
                    }
                }
                var10_14 = expectedTokenSequences = parseException.getExpectedTokenSequences();
                var9_9 = expectedTokenSequences.length;
                var8_10 = 0;
                while (var8_10 < var9_9) {
                    tokens = var10_14[var8_10];
                    if (!MetadataImpl.$assertionsDisabled && tokens.length != 1) {
                        throw new AssertionError();
                    }
                    tokenId = tokens[0];
                    token = tokenImages[tokenId];
                    tokenVal = SqlParserUtil.getTokenVal(token);
                    if (tokenVal != null) {
                        keywords.add(tokenVal);
                    }
                    ++var8_10;
                }
                break block9;
                catch (Throwable e) {
                    throw Util.newInternal(e, "Unexpected error while building token lists");
                }
            }
        }

        private Object virtualCall(SqlAbstractParserImpl parserImpl, String name) throws Throwable {
            Class<?> clazz = parserImpl.getClass();
            try {
                Method method = clazz.getMethod(name, null);
                return method.invoke((Object)parserImpl, null);
            }
            catch (NoSuchMethodException e) {
                throw Util.newInternal(e);
            }
            catch (IllegalAccessException e) {
                throw Util.newInternal(e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw parserImpl.normalizeException(cause);
            }
        }

        private String constructSql92ReservedWordList() {
            StringBuilder sb = new StringBuilder();
            TreeSet<String> jdbcReservedSet = new TreeSet<String>();
            jdbcReservedSet.addAll(this.tokenSet);
            jdbcReservedSet.removeAll((Collection<?>)SQL_92_RESERVED_WORD_SET);
            jdbcReservedSet.removeAll(this.nonReservedKeyWordSet);
            int j = 0;
            for (String jdbcReserved : jdbcReservedSet) {
                if (j++ > 0) {
                    sb.append(",");
                }
                sb.append(jdbcReserved);
            }
            return sb.toString();
        }

        @Override
        public List<String> getTokens() {
            return this.tokenList;
        }

        @Override
        public boolean isSql92ReservedWord(String token) {
            return SQL_92_RESERVED_WORD_SET.contains((Object)token);
        }

        @Override
        public String getJdbcKeywords() {
            return this.sql92ReservedWords;
        }

        @Override
        public boolean isKeyword(String token) {
            return this.isNonReservedKeyword(token) || this.isReservedFunctionName(token) || this.isContextVariableName(token) || this.isReservedWord(token);
        }

        @Override
        public boolean isNonReservedKeyword(String token) {
            return this.nonReservedKeyWordSet.contains(token);
        }

        @Override
        public boolean isReservedFunctionName(String token) {
            return this.reservedFunctionNames.contains(token);
        }

        @Override
        public boolean isContextVariableName(String token) {
            return this.contextVariableNames.contains(token);
        }

        @Override
        public boolean isReservedWord(String token) {
            return this.reservedWords.contains(token);
        }
    }
}

