/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.fun;

import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlAggFunction;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.ReturnTypes;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlMinMaxAggFunction
extends SqlAggFunction {
    public static final int MINMAX_INVALID = -1;
    public static final int MINMAX_PRIMITIVE = 0;
    public static final int MINMAX_COMPARABLE = 1;
    public static final int MINMAX_COMPARATOR = 2;
    public final List<RelDataType> argTypes;
    private final boolean isMin;
    private final int kind;

    public SqlMinMaxAggFunction(List<RelDataType> argTypes, boolean isMin, int kind) {
        super(isMin ? "MIN" : "MAX", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0, null, OperandTypes.COMPARABLE_ORDERED, SqlFunctionCategory.SYSTEM);
        this.argTypes = argTypes;
        this.isMin = isMin;
        this.kind = kind;
    }

    public boolean isMin() {
        return this.isMin;
    }

    public int getMinMaxKind() {
        return this.kind;
    }

    @Override
    public List<RelDataType> getParameterTypes(RelDataTypeFactory typeFactory) {
        switch (this.kind) {
            case 0: 
            case 1: {
                return this.argTypes;
            }
            case 2: {
                return this.argTypes.subList(1, 2);
            }
        }
        throw Util.newInternal("bad kind: " + this.kind);
    }

    @Override
    public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
        switch (this.kind) {
            case 0: 
            case 1: {
                return this.argTypes.get(0);
            }
            case 2: {
                return this.argTypes.get(1);
            }
        }
        throw Util.newInternal("bad kind: " + this.kind);
    }
}

