/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.hydromatic.linq4j.Ord;
import org.eigenbase.sql.SqlAggFunction;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlIntervalLiteral;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlPostfixOperator;
import org.eigenbase.sql.SqlSyntax;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.parser.SqlParserUtil;
import org.eigenbase.sql.type.SqlTypeFamily;
import org.eigenbase.sql.util.SqlBasicVisitor;
import org.eigenbase.sql.util.SqlVisitor;
import org.eigenbase.sql.validate.SqlMoniker;
import org.eigenbase.sql.validate.SqlMonotonicity;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlWindow
extends SqlCall {
    static final SqlPostfixOperator FOLLOWING_OPERATOR = new SqlPostfixOperator("FOLLOWING", SqlKind.FOLLOWING, 20, null, null, null);
    static final SqlPostfixOperator PRECEDING_OPERATOR = new SqlPostfixOperator("PRECEDING", SqlKind.PRECEDING, 20, null, null, null);
    SqlIdentifier declName;
    SqlIdentifier refName;
    SqlNodeList partitionList;
    SqlNodeList orderList;
    SqlLiteral isRows;
    SqlNode lowerBound;
    SqlNode upperBound;
    SqlLiteral allowPartial;
    private SqlCall windowCall = null;

    public SqlWindow(SqlParserPos pos, SqlIdentifier declName, SqlIdentifier refName, SqlNodeList partitionList, SqlNodeList orderList, SqlLiteral isRows, SqlNode lowerBound, SqlNode upperBound, SqlLiteral allowPartial) {
        super(pos);
        this.declName = declName;
        this.refName = refName;
        this.partitionList = partitionList;
        this.orderList = orderList;
        this.isRows = isRows;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.allowPartial = allowPartial;
        assert (declName == null || declName.isSimple());
        assert (partitionList != null);
        assert (orderList != null);
    }

    public static SqlWindow create(SqlIdentifier declName, SqlIdentifier refName, SqlNodeList partitionList, SqlNodeList orderList, SqlLiteral isRows, SqlNode lowerBound, SqlNode upperBound, SqlLiteral allowPartial, SqlParserPos pos) {
        if (upperBound == null && lowerBound != null && lowerBound.getKind() == SqlKind.FOLLOWING) {
            upperBound = lowerBound;
            lowerBound = null;
        }
        return new SqlWindow(pos, declName, refName, partitionList, orderList, isRows, lowerBound, upperBound, allowPartial);
    }

    @Override
    public SqlOperator getOperator() {
        return SqlWindowOperator.INSTANCE;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.WINDOW;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return Arrays.asList(this.declName, this.refName, this.partitionList, this.orderList, this.isRows, this.lowerBound, this.upperBound, this.allowPartial);
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        switch (i) {
            case 0: {
                this.declName = (SqlIdentifier)operand;
                break;
            }
            case 1: {
                this.refName = (SqlIdentifier)operand;
                break;
            }
            case 2: {
                this.partitionList = (SqlNodeList)operand;
                break;
            }
            case 3: {
                this.orderList = (SqlNodeList)operand;
                break;
            }
            case 4: {
                this.isRows = (SqlLiteral)operand;
                break;
            }
            case 5: {
                this.lowerBound = operand;
                break;
            }
            case 6: {
                this.upperBound = operand;
                break;
            }
            case 7: {
                this.allowPartial = (SqlLiteral)operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.declName != null) {
            this.declName.unparse(writer, 0, 0);
            writer.keyword("AS");
        }
        this.getOperator().unparse(writer, this, 0, 0);
    }

    public SqlIdentifier getDeclName() {
        return this.declName;
    }

    public void setDeclName(SqlIdentifier declName) {
        assert (declName.isSimple());
        this.declName = declName;
    }

    public SqlNode getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(SqlNode lowerBound) {
        this.lowerBound = lowerBound;
    }

    public SqlNode getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(SqlNode upperBound) {
        this.upperBound = upperBound;
    }

    public boolean isRows() {
        return this.isRows.booleanValue();
    }

    public SqlNodeList getOrderList() {
        return this.orderList;
    }

    public SqlNodeList getPartitionList() {
        return this.partitionList;
    }

    public SqlIdentifier getRefName() {
        return this.refName;
    }

    public void setWindowCall(SqlCall windowCall) {
        this.windowCall = windowCall;
        assert (windowCall == null || windowCall.getOperator() instanceof SqlAggFunction);
    }

    public SqlCall getWindowCall() {
        return this.windowCall;
    }

    static void checkSpecialLiterals(SqlWindow sqlWindow, SqlValidator sqlValidator) {
        throw new Error("Unresolved compilation problems: \n\tThe method badLowerBoundary() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method badUpperBoundary() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method currentRowPrecedingError() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method followingBeforePrecedingError() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method currentRowFollowingError() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method unboundedFollowingWindowNotSupported() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method windowHasNegativeSize() from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    static boolean isTableSorted(SqlValidatorScope scope) {
        ArrayList<SqlMoniker> columnNames = new ArrayList<SqlMoniker>();
        scope.findAllColumnNames(columnNames);
        for (SqlMoniker columnName : columnNames) {
            SqlIdentifier columnId = columnName.toIdentifier();
            SqlMonotonicity monotonicity = scope.getMonotonicity(columnId);
            if (monotonicity == SqlMonotonicity.NOT_MONOTONIC) continue;
            return true;
        }
        return false;
    }

    public static SqlNode createCurrentRow(SqlParserPos pos) {
        return Bound.CURRENT_ROW.symbol(pos);
    }

    public static SqlNode createUnboundedFollowing(SqlParserPos pos) {
        return Bound.UNBOUNDED_FOLLOWING.symbol(pos);
    }

    public static SqlNode createUnboundedPreceding(SqlParserPos pos) {
        return Bound.UNBOUNDED_PRECEDING.symbol(pos);
    }

    public static SqlNode createFollowing(SqlLiteral literal, SqlParserPos pos) {
        return FOLLOWING_OPERATOR.createCall(pos, literal);
    }

    public static SqlNode createPreceding(SqlLiteral literal, SqlParserPos pos) {
        return PRECEDING_OPERATOR.createCall(pos, literal);
    }

    public static SqlNode createBound(SqlLiteral range) {
        return range;
    }

    public static boolean isCurrentRow(SqlNode node) {
        return node instanceof SqlLiteral && ((SqlLiteral)node).symbolValue() == Bound.CURRENT_ROW;
    }

    public static boolean isUnboundedPreceding(SqlNode node) {
        return node instanceof SqlLiteral && ((SqlLiteral)node).symbolValue() == Bound.UNBOUNDED_PRECEDING;
    }

    public static boolean isUnboundedFollowing(SqlNode node) {
        return node instanceof SqlLiteral && ((SqlLiteral)node).symbolValue() == Bound.UNBOUNDED_FOLLOWING;
    }

    public static OffsetRange getOffsetAndRange(SqlNode lowerBound, SqlNode upperBound, boolean physical) {
        long range;
        long offset;
        ValSign upper = SqlWindow.getRangeOffset(upperBound, PRECEDING_OPERATOR);
        ValSign lower = SqlWindow.getRangeOffset(lowerBound, FOLLOWING_OPERATOR);
        if (upper == null) {
            return null;
        }
        if (lower == null) {
            offset = upper.signedVal();
            range = Long.MAX_VALUE;
        } else {
            offset = upper.signedVal();
            range = lower.signedVal() + upper.signedVal();
        }
        return new OffsetRange(offset, range);
    }

    private static ValSign getRangeOffset(SqlNode node, SqlPostfixOperator op) {
        assert (op == PRECEDING_OPERATOR || op == FOLLOWING_OPERATOR);
        if (node == null) {
            return new ValSign(0L, 1L);
        }
        if (node instanceof SqlLiteral) {
            SqlLiteral literal = (SqlLiteral)node;
            if (literal.getValue() == Bound.CURRENT_ROW) {
                return new ValSign(0L, 1L);
            }
            if (literal.getValue() == Bound.UNBOUNDED_FOLLOWING && op == PRECEDING_OPERATOR) {
                return null;
            }
            if (literal.getValue() == Bound.UNBOUNDED_PRECEDING && op == FOLLOWING_OPERATOR) {
                return null;
            }
            throw Util.newInternal("unexpected literal " + literal);
        }
        if (node instanceof SqlCall) {
            SqlCall call = (SqlCall)node;
            long sign = call.getOperator() == op ? -1 : 1;
            assert (call.operandCount() == 1);
            SqlLiteral operand = (SqlLiteral)call.operand(0);
            Object obj = operand.getValue();
            long val = obj instanceof BigDecimal ? (long)((BigDecimal)obj).intValue() : (obj instanceof SqlIntervalLiteral.IntervalValue ? SqlParserUtil.intervalToMillis((SqlIntervalLiteral.IntervalValue)obj) : 0L);
            return new ValSign(val, sign);
        }
        return new ValSign(0L, 1L);
    }

    public SqlWindow overlay(SqlWindow sqlWindow, SqlValidator sqlValidator) {
        throw new Error("Unresolved compilation problems: \n\tThe method partitionNotAllowed() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method orderByOverlap() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method refWindowWithFrame() from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    private static boolean setOperand(SqlNode sqlNode, SqlNode sqlNode2, SqlValidator sqlValidator) {
        throw new Error("Unresolved compilation problem: \n\tThe method cannotOverrideWindowAttribute() from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    @Override
    public boolean equalsDeep(SqlNode node, boolean fail) {
        return node == this || node instanceof SqlWindow && SqlNode.equalDeep(Util.skip(this.getOperandList()), Util.skip(((SqlWindow)node).getOperandList()), fail);
    }

    public OffsetRange getOffsetAndRange() {
        return SqlWindow.getOffsetAndRange(this.getLowerBound(), this.getUpperBound(), this.isRows());
    }

    public boolean isAllowPartial() {
        return this.allowPartial == null || this.allowPartial.booleanValue();
    }

    @Override
    public void validate(SqlValidator sqlValidator, SqlValidatorScope sqlValidatorScope) {
        throw new Error("Unresolved compilation problems: \n\tThe method funcNeedsOrderBy() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method rankWithFrame() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method compoundOrderByProhibitsRange() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method overMissingOrderBy() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method overMissingOrderBy() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method cannotUseDisallowPartialWithRange() from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    private void validateFrameBoundary(SqlNode sqlNode, boolean bl, SqlTypeFamily sqlTypeFamily, SqlValidator sqlValidator, SqlValidatorScope sqlValidatorScope) {
        throw new Error("Unresolved compilation problems: \n\tThe method rangeOrRowMustBeConstant() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method rowMustBeNonNegativeIntegral() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method rowMustBeNonNegativeIntegral() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method orderByRangeMismatch() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method orderByRangeMismatch() from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method orderByDataTypeProhibitsRange() from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    public SqlWindow createCurrentRowWindow(String columnName) {
        return SqlWindow.create(null, null, new SqlNodeList(SqlParserPos.ZERO), new SqlNodeList((Collection<? extends SqlNode>)ImmutableList.of((Object)new SqlIdentifier(columnName, SqlParserPos.ZERO)), SqlParserPos.ZERO), SqlLiteral.createBoolean(true, SqlParserPos.ZERO), SqlWindow.createCurrentRow(SqlParserPos.ZERO), SqlWindow.createCurrentRow(SqlParserPos.ZERO), SqlLiteral.createBoolean(true, SqlParserPos.ZERO), SqlParserPos.ZERO);
    }

    public SqlWindow createUnboundedPrecedingWindow(String columnName) {
        return SqlWindow.create(null, null, new SqlNodeList(SqlParserPos.ZERO), new SqlNodeList((Collection<? extends SqlNode>)ImmutableList.of((Object)new SqlIdentifier(columnName, SqlParserPos.ZERO)), SqlParserPos.ZERO), SqlLiteral.createBoolean(false, SqlParserPos.ZERO), SqlWindow.createUnboundedPreceding(SqlParserPos.ZERO), SqlWindow.createCurrentRow(SqlParserPos.ZERO), SqlLiteral.createBoolean(false, SqlParserPos.ZERO), SqlParserPos.ZERO);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Bound implements SqlLiteral.SqlSymbol
    {
        CURRENT_ROW("CURRENT ROW"),
        UNBOUNDED_PRECEDING("UNBOUNDED PRECEDING"),
        UNBOUNDED_FOLLOWING("UNBOUNDED FOLLOWING");

        private final String sql;

        private Bound(String sql) {
            this.sql = sql;
        }

        public String toString() {
            return this.sql;
        }

        public SqlNode symbol(SqlParserPos pos) {
            return SqlLiteral.createSymbol(this, pos);
        }
    }

    public static class OffsetRange {
        public final long offset;
        public final long range;

        OffsetRange(long offset, long range) {
            this.offset = offset;
            this.range = range;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SqlWindowOperator
    extends SqlOperator {
        private static final SqlWindowOperator INSTANCE = new SqlWindowOperator();

        private SqlWindowOperator() {
            super("WINDOW", SqlKind.WINDOW, 2, true, null, null, null);
        }

        @Override
        public SqlSyntax getSyntax() {
            return SqlSyntax.SPECIAL;
        }

        @Override
        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            assert (functionQualifier == null);
            assert (operands.length == 8);
            return SqlWindow.create((SqlIdentifier)operands[0], (SqlIdentifier)operands[1], (SqlNodeList)operands[2], (SqlNodeList)operands[3], (SqlLiteral)operands[4], operands[5], operands[6], (SqlLiteral)operands[7], pos);
        }

        @Override
        public <R> void acceptCall(SqlVisitor<R> visitor, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
            if (onlyExpressions) {
                List<SqlNode> operandList = call.getOperandList();
                for (Ord operand : Ord.zip(operandList)) {
                    if (operand.e == null || operand.i == 1 && operand.e instanceof SqlIdentifier) continue;
                    argHandler.visitChild(visitor, call, operand.i, (SqlNode)operand.e);
                }
            } else {
                super.acceptCall(visitor, call, onlyExpressions, argHandler);
            }
        }

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            SqlWindow window = (SqlWindow)call;
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.WINDOW, "(", ")");
            if (window.refName != null) {
                window.refName.unparse(writer, 0, 0);
            }
            if (window.partitionList.size() > 0) {
                writer.sep("PARTITION BY");
                SqlWriter.Frame partitionFrame = writer.startList("", "");
                window.partitionList.unparse(writer, 0, 0);
                writer.endList(partitionFrame);
            }
            if (window.orderList.size() > 0) {
                writer.sep("ORDER BY");
                SqlWriter.Frame orderFrame = writer.startList("", "");
                window.orderList.unparse(writer, 0, 0);
                writer.endList(orderFrame);
            }
            if (window.lowerBound != null) {
                if (window.upperBound == null) {
                    if (window.isRows()) {
                        writer.sep("ROWS");
                    } else {
                        writer.sep("RANGE");
                    }
                    window.lowerBound.unparse(writer, 0, 0);
                } else {
                    if (window.isRows()) {
                        writer.sep("ROWS BETWEEN");
                    } else {
                        writer.sep("RANGE BETWEEN");
                    }
                    window.lowerBound.unparse(writer, 0, 0);
                    writer.keyword("AND");
                    window.upperBound.unparse(writer, 0, 0);
                }
            }
            if (window.allowPartial != null && !window.isAllowPartial()) {
                writer.keyword("DISALLOW PARTIAL");
            }
            writer.endList(frame);
        }
    }

    private static class ValSign {
        long val;
        long sign;

        ValSign(long val, long sign) {
            this.val = val;
            this.sign = sign;
            assert (sign == 1L || sign == -1L);
        }

        long signedVal() {
            return this.val * this.sign;
        }
    }
}

