/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import java.util.Calendar;
import org.eigenbase.sql.SqlAbstractDateTimeLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.SqlTypeName;

public class SqlTimeLiteral
extends SqlAbstractDateTimeLiteral {
    SqlTimeLiteral(Calendar t, int precision, boolean hasTZ, SqlParserPos pos) {
        super(t, hasTZ, SqlTypeName.TIME, precision, "HH:mm:ss", pos);
    }

    SqlTimeLiteral(Calendar t, int precision, boolean hasTZ, String format, SqlParserPos pos) {
        super(t, hasTZ, SqlTypeName.TIME, precision, format, pos);
    }

    public SqlNode clone(SqlParserPos pos) {
        return new SqlTimeLiteral((Calendar)this.value, this.precision, this.hasTimeZone, this.formatString, pos);
    }

    public String toString() {
        return "TIME '" + this.toFormattedString() + "'";
    }

    public String toFormattedString() {
        String result = this.getTime().toString(this.formatString);
        Calendar cal = this.getCal();
        if (this.precision > 0) {
            assert (this.precision <= 3);
            String digits = Long.toString(cal.getTimeInMillis());
            result = String.valueOf(result) + "." + digits.substring(digits.length() - 3, digits.length() - 3 + this.precision);
        } else assert (cal.get(14) == 0);
        return result;
    }
}

