/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eigenbase.sql.SqlBinaryOperator;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.util.SqlVisitor;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlNodeList
extends SqlNode
implements Iterable<SqlNode> {
    public static final SqlNodeList EMPTY = new SqlNodeList(SqlParserPos.ZERO){

        public void add(SqlNode node) {
            throw new UnsupportedOperationException();
        }
    };
    private final List<SqlNode> list;

    public SqlNodeList(SqlParserPos pos) {
        super(pos);
        this.list = new ArrayList<SqlNode>();
    }

    public SqlNodeList(Collection<? extends SqlNode> collection, SqlParserPos pos) {
        super(pos);
        this.list = new ArrayList<SqlNode>(collection);
    }

    @Override
    public Iterator<SqlNode> iterator() {
        return this.list.iterator();
    }

    public List<SqlNode> getList() {
        return this.list;
    }

    public void add(SqlNode node) {
        this.list.add(node);
    }

    @Override
    public SqlNodeList clone(SqlParserPos pos) {
        return new SqlNodeList(this.list, pos);
    }

    public SqlNode get(int n) {
        return this.list.get(n);
    }

    public SqlNode set(int n, SqlNode node) {
        return this.list.set(n, node);
    }

    public int size() {
        return this.list.size();
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = leftPrec > 0 || rightPrec > 0 ? writer.startList("(", ")") : writer.startList("", "");
        this.commaList(writer);
        writer.endList(frame);
    }

    void commaList(SqlWriter writer) {
        for (SqlNode node : this.list) {
            writer.sep(",");
            node.unparse(writer, 2, 3);
        }
    }

    void andOrList(SqlWriter writer, SqlKind sepKind) {
        SqlBinaryOperator sepOp = sepKind == SqlKind.AND ? SqlStdOperatorTable.AND : SqlStdOperatorTable.OR;
        int i = 0;
        while (i < this.list.size()) {
            SqlNode node = this.list.get(i);
            writer.sep(sepKind.name(), false);
            int lprec = i == 0 ? 0 : sepOp.getRightPrec();
            int rprec = i == this.list.size() - 1 ? 0 : sepOp.getLeftPrec();
            node.unparse(writer, lprec, rprec);
            ++i;
        }
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        for (SqlNode child : this.list) {
            child.validate(validator, scope);
        }
    }

    @Override
    public <R> R accept(SqlVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equalsDeep(SqlNode node, boolean fail) {
        if (!(node instanceof SqlNodeList)) {
            assert (!fail) : this + "!=" + node;
            return false;
        }
        SqlNodeList that = (SqlNodeList)node;
        if (this.size() != that.size()) {
            assert (!fail) : this + "!=" + node;
            return false;
        }
        int i = 0;
        while (i < this.list.size()) {
            SqlNode thatChild;
            SqlNode thisChild = this.list.get(i);
            if (!thisChild.equalsDeep(thatChild = that.list.get(i), fail)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public SqlNode[] toArray() {
        return this.list.toArray(new SqlNode[this.list.size()]);
    }

    public static boolean isEmptyList(SqlNode node) {
        return node instanceof SqlNodeList && ((SqlNodeList)node).size() == 0;
    }

    @Override
    public void validateExpr(SqlValidator validator, SqlValidatorScope scope) {
        for (SqlNode node : this.list) {
            node.validateExpr(validator, scope);
        }
    }
}

