/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlCollation;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.util.SqlVisitor;
import org.eigenbase.sql.validate.SqlMonotonicity;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorNamespace;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.sql.validate.SqlValidatorUtil;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlIdentifier
extends SqlNode {
    public ImmutableList<String> names;
    final SqlCollation collation;
    private ImmutableList<SqlParserPos> componentPositions;

    public SqlIdentifier(List<String> names, SqlCollation collation, SqlParserPos pos, List<SqlParserPos> componentPositions) {
        super(pos);
        this.names = ImmutableList.copyOf(names);
        this.collation = collation;
        this.componentPositions = componentPositions == null ? null : ImmutableList.copyOf(componentPositions);
        for (String name : names) {
            assert (name != null);
        }
    }

    public SqlIdentifier(List<String> names, SqlParserPos pos) {
        this(names, null, pos, null);
    }

    public SqlIdentifier(String name, SqlCollation collation, SqlParserPos pos) {
        this((List<String>)ImmutableList.of((Object)name), collation, pos, null);
    }

    public SqlIdentifier(String name, SqlParserPos pos) {
        this((List<String>)ImmutableList.of((Object)name), null, pos, null);
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.IDENTIFIER;
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return new SqlIdentifier((List<String>)this.names, this.collation, pos, (List<SqlParserPos>)this.componentPositions);
    }

    @Override
    public String toString() {
        return Util.sepList(this.names, ".");
    }

    public void setNames(List<String> names, List<SqlParserPos> poses) {
        this.names = ImmutableList.copyOf(names);
        this.componentPositions = poses == null ? null : ImmutableList.copyOf(poses);
    }

    public SqlParserPos getComponentParserPosition(int i) {
        assert (i >= 0 && i < this.names.size());
        return this.componentPositions == null ? this.getParserPosition() : (SqlParserPos)this.componentPositions.get(i);
    }

    public void assignNamesFrom(SqlIdentifier other) {
        this.setNames((List<String>)other.names, (List<SqlParserPos>)other.componentPositions);
    }

    public SqlIdentifier getComponent(int ordinal) {
        return new SqlIdentifier((String)this.names.get(ordinal), this.getComponentParserPosition(ordinal));
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.IDENTIFIER);
        for (String name : this.names) {
            writer.sep(".");
            if (name.equals("*")) {
                writer.print(name);
                continue;
            }
            writer.identifier(name);
        }
        if (this.collation != null) {
            this.collation.unparse(writer, leftPrec, rightPrec);
        }
        writer.endList(frame);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateIdentifier(this, scope);
    }

    @Override
    public void validateExpr(SqlValidator validator, SqlValidatorScope scope) {
        SqlCall call = SqlUtil.makeCall(validator.getOperatorTable(), this);
        if (call != null) {
            validator.validateCall(call, scope);
            return;
        }
        validator.validateIdentifier(this, scope);
    }

    @Override
    public boolean equalsDeep(SqlNode node, boolean fail) {
        if (!(node instanceof SqlIdentifier)) {
            assert (!fail) : this + "!=" + node;
            return false;
        }
        SqlIdentifier that = (SqlIdentifier)node;
        if (this.names.size() != that.names.size()) {
            assert (!fail) : this + "!=" + node;
            return false;
        }
        int i = 0;
        while (i < this.names.size()) {
            if (!((String)this.names.get(i)).equals(that.names.get(i))) {
                assert (!fail) : this + "!=" + node;
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public <R> R accept(SqlVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public SqlCollation getCollation() {
        return this.collation;
    }

    public String getSimple() {
        assert (this.names.size() == 1);
        return (String)this.names.get(0);
    }

    public boolean isStar() {
        return Util.last(this.names).equals("*");
    }

    public boolean isSimple() {
        return this.names.size() == 1 && !((String)this.names.get(0)).equals("*");
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlValidatorScope scope) {
        SqlValidator validator = scope.getValidator();
        SqlCall call = SqlUtil.makeCall(validator.getOperatorTable(), this);
        if (call != null) {
            return call.getMonotonicity(scope);
        }
        SqlIdentifier fqId = scope.fullyQualify(this);
        SqlValidatorNamespace ns = SqlValidatorUtil.lookup(scope, Util.skipLast(fqId.names));
        return ns.resolve().getMonotonicity(Util.last(fqId.names));
    }
}

