/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import java.nio.charset.Charset;
import java.util.TimeZone;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlCollation;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.sql.util.SqlVisitor;
import org.eigenbase.sql.validate.SqlMonotonicity;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlDataTypeSpec
extends SqlNode {
    private final SqlIdentifier collectionsTypeName;
    private final SqlIdentifier typeName;
    private final int scale;
    private final int precision;
    private final String charSetName;
    private final TimeZone timeZone;

    public SqlDataTypeSpec(SqlIdentifier typeName, int precision, int scale, String charSetName, TimeZone timeZone, SqlParserPos pos) {
        super(pos);
        this.collectionsTypeName = null;
        this.typeName = typeName;
        this.scale = scale;
        this.precision = precision;
        this.charSetName = charSetName;
        this.timeZone = timeZone;
    }

    public SqlDataTypeSpec(SqlIdentifier collectionsTypeName, SqlIdentifier typeName, int precision, int scale, String charSetName, SqlParserPos pos) {
        super(pos);
        this.collectionsTypeName = collectionsTypeName;
        this.typeName = typeName;
        this.scale = scale;
        this.precision = precision;
        this.charSetName = charSetName;
        this.timeZone = null;
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return this.collectionsTypeName != null ? new SqlDataTypeSpec(this.collectionsTypeName, this.typeName, this.precision, this.scale, this.charSetName, pos) : new SqlDataTypeSpec(this.typeName, this.precision, this.scale, this.charSetName, this.timeZone, pos);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlValidatorScope scope) {
        return SqlMonotonicity.CONSTANT;
    }

    public SqlIdentifier getCollectionsTypeName() {
        return this.collectionsTypeName;
    }

    public SqlIdentifier getTypeName() {
        return this.typeName;
    }

    public int getScale() {
        return this.scale;
    }

    public int getPrecision() {
        return this.precision;
    }

    public String getCharSetName() {
        return this.charSetName;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public SqlDataTypeSpec getComponentTypeSpec() {
        assert (this.getCollectionsTypeName() != null);
        return new SqlDataTypeSpec(this.typeName, this.precision, this.scale, this.charSetName, this.timeZone, this.getParserPosition());
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        String name = this.typeName.getSimple();
        if (SqlTypeName.get(name) != null) {
            SqlTypeName sqlTypeName = SqlTypeName.get(name);
            writer.keyword(name);
            if (sqlTypeName.allowsPrec() && this.precision >= 0) {
                SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")");
                writer.print(this.precision);
                if (sqlTypeName.allowsScale() && this.scale >= 0) {
                    writer.sep(",", true);
                    writer.print(this.scale);
                }
                writer.endList(frame);
            }
            if (this.charSetName != null) {
                writer.keyword("CHARACTER SET");
                writer.identifier(this.charSetName);
            }
            if (this.collectionsTypeName != null) {
                writer.keyword(this.collectionsTypeName.getSimple());
            }
        } else if (name.startsWith("_")) {
            writer.keyword(name.substring(1));
        } else {
            this.typeName.unparse(writer, leftPrec, rightPrec);
        }
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateDataType(this);
    }

    @Override
    public <R> R accept(SqlVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equalsDeep(SqlNode node, boolean fail) {
        if (!(node instanceof SqlDataTypeSpec)) {
            assert (!fail) : this + "!=" + node;
            return false;
        }
        SqlDataTypeSpec that = (SqlDataTypeSpec)node;
        if (!SqlNode.equalDeep(this.collectionsTypeName, that.collectionsTypeName, fail)) {
            return false;
        }
        if (!this.typeName.equalsDeep(that.typeName, fail)) {
            return false;
        }
        if (this.precision != that.precision) {
            assert (!fail) : this + "!=" + node;
            return false;
        }
        if (this.scale != that.scale) {
            assert (!fail) : this + "!=" + node;
            return false;
        }
        if (!Util.equal(this.timeZone, that.timeZone)) {
            assert (!fail) : this + "!=" + node;
            return false;
        }
        if (!Util.equal(this.charSetName, that.charSetName)) {
            assert (!fail) : this + "!=" + node;
            return false;
        }
        return true;
    }

    public RelDataType deriveType(SqlValidator sqlValidator) {
        throw new Error("Unresolved compilation problems: \n\tThe method unknownDatatypeName(String) from the type EigenbaseNewResource refers to the missing type ExInst\n\tThe method unknownDatatypeName(String) from the type EigenbaseNewResource refers to the missing type ExInst\n");
    }

    public RelDataType deriveType(RelDataTypeFactory typeFactory) {
        RelDataType type;
        String name = this.typeName.getSimple();
        SqlTypeName sqlTypeName = SqlTypeName.get(name);
        if (this.precision >= 0 && this.scale >= 0) {
            assert (sqlTypeName.allowsPrecScale(true, true));
            type = typeFactory.createSqlType(sqlTypeName, this.precision, this.scale);
        } else if (this.precision >= 0) {
            assert (sqlTypeName.allowsPrecNoScale());
            type = typeFactory.createSqlType(sqlTypeName, this.precision);
        } else {
            assert (sqlTypeName.allowsNoPrecNoScale());
            type = typeFactory.createSqlType(sqlTypeName);
        }
        if (SqlTypeUtil.inCharFamily(type)) {
            Charset charset;
            SqlCollation collation = SqlCollation.COERCIBLE;
            if (this.charSetName == null) {
                charset = typeFactory.getDefaultCharset();
            } else {
                String javaCharSetName = SqlUtil.translateCharacterSetName(this.charSetName);
                charset = Charset.forName(javaCharSetName);
            }
            type = typeFactory.createTypeWithCharsetAndCollation(type, charset, collation);
        }
        if (this.collectionsTypeName != null) {
            String collectionName = this.collectionsTypeName.getSimple();
            SqlTypeName collectionsSqlTypeName = SqlTypeName.get(collectionName);
            switch (collectionsSqlTypeName) {
                case MULTISET: {
                    type = typeFactory.createMultisetType(type, -1L);
                    break;
                }
                default: {
                    throw Util.unexpected(collectionsSqlTypeName);
                }
            }
        }
        return type;
    }
}

