/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rex;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.linq4j.function.Functions;
import net.hydromatic.linq4j.function.Predicate1;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelCollationImpl;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexCorrelVariable;
import org.eigenbase.rex.RexDynamicParam;
import org.eigenbase.rex.RexFieldAccess;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexRangeRef;
import org.eigenbase.rex.RexShuttle;
import org.eigenbase.rex.RexVariable;
import org.eigenbase.rex.RexVisitor;
import org.eigenbase.rex.RexVisitorImpl;
import org.eigenbase.sql.SqlAggFunction;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;
import org.eigenbase.util.mapping.Mappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RexUtil {
    private static final Predicate1<RexNode> NOT_ALWAYS_TRUE_PREDICATE = new Predicate1<RexNode>(){

        public boolean apply(RexNode e) {
            return !e.isAlwaysTrue();
        }
    };
    private static final Predicate1<RexNode> NOT_ALWAYS_FALSE_PREDICATE = new Predicate1<RexNode>(){

        public boolean apply(RexNode e) {
            return !e.isAlwaysFalse();
        }
    };
    private static final Predicate1<RexNode> IS_FLAT_PREDICATE = new Predicate1<RexNode>(){

        public boolean apply(RexNode v1) {
            return RexUtil.isFlat(v1);
        }
    };

    private RexUtil() {
    }

    public static double getSelectivity(RexNode exp) {
        if (exp == null || exp.isAlwaysTrue()) {
            return 1.0;
        }
        return 0.1;
    }

    public static List<RexNode> generateCastExpressions(RexBuilder rexBuilder, RelDataType lhsRowType, RelDataType rhsRowType) {
        List<RelDataTypeField> fieldList = rhsRowType.getFieldList();
        int n = fieldList.size();
        assert (n == lhsRowType.getFieldCount()) : "field count: lhs [" + lhsRowType + "] rhs [" + rhsRowType + "]";
        ArrayList<RexNode> rhsExps = new ArrayList<RexNode>();
        for (RelDataTypeField field : fieldList) {
            rhsExps.add(rexBuilder.makeInputRef(field.getType(), field.getIndex()));
        }
        return RexUtil.generateCastExpressions(rexBuilder, lhsRowType, rhsExps);
    }

    public static List<RexNode> generateCastExpressions(RexBuilder rexBuilder, RelDataType lhsRowType, List<RexNode> rhsExps) {
        List<RelDataTypeField> lhsFields = lhsRowType.getFieldList();
        ArrayList<RexNode> castExps = new ArrayList<RexNode>();
        for (Pair<RelDataTypeField, RexNode> pair : Pair.zip(lhsFields, rhsExps, true)) {
            RexNode rhsExp;
            RelDataType rhsType;
            RelDataTypeField lhsField = (RelDataTypeField)pair.left;
            RelDataType lhsType = lhsField.getType();
            if (lhsType.equals(rhsType = (rhsExp = (RexNode)pair.right).getType())) {
                castExps.add(rhsExp);
                continue;
            }
            castExps.add(rexBuilder.makeCast(lhsType, rhsExp));
        }
        return castExps;
    }

    public static boolean isNullLiteral(RexNode node, boolean allowCast) {
        if (node instanceof RexLiteral) {
            RexLiteral literal = (RexLiteral)node;
            if (literal.getTypeName() == SqlTypeName.NULL) {
                assert (literal.getValue() == null);
                return true;
            }
            return false;
        }
        if (allowCast && node.isA(SqlKind.CAST)) {
            RexCall call = (RexCall)node;
            if (RexUtil.isNullLiteral((RexNode)call.operands.get(0), false)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isNull(RexNode expr) {
        switch (expr.getKind()) {
            case LITERAL: {
                return ((RexLiteral)expr).getValue2() == null;
            }
            case CAST: {
                return RexUtil.isNull((RexNode)((RexCall)expr).operands.get(0));
            }
        }
        return false;
    }

    public static RexCall findOperatorCall(final SqlOperator operator, RexNode node) {
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                @Override
                public Void visitCall(RexCall call) {
                    if (call.getOperator().equals(operator)) {
                        throw new Util.FoundOne(call);
                    }
                    return (Void)super.visitCall(call);
                }
            };
            node.accept(visitor);
            return null;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return (RexCall)e.getNode();
        }
    }

    public static boolean containsInputRef(RexNode node) {
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                @Override
                public Void visitInputRef(RexInputRef inputRef) {
                    throw new Util.FoundOne(inputRef);
                }
            };
            node.accept(visitor);
            return false;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return true;
        }
    }

    public static boolean containsFieldAccess(RexNode node) {
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                @Override
                public Void visitFieldAccess(RexFieldAccess fieldAccess) {
                    throw new Util.FoundOne(fieldAccess);
                }
            };
            node.accept(visitor);
            return false;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return true;
        }
    }

    public static boolean requiresDecimalExpansion(RexNode expr, boolean recurse) {
        if (!(expr instanceof RexCall)) {
            return false;
        }
        RexCall call = (RexCall)expr;
        boolean localCheck = true;
        switch (call.getKind()) {
            case IS_NULL: 
            case REINTERPRET: {
                localCheck = false;
                break;
            }
            case CAST: {
                RelDataType lhsType = call.getType();
                RelDataType rhsType = ((RexNode)call.operands.get(0)).getType();
                if (rhsType.getSqlTypeName() == SqlTypeName.NULL) {
                    return false;
                }
                if (SqlTypeUtil.inCharFamily(lhsType) || SqlTypeUtil.inCharFamily(rhsType)) {
                    localCheck = false;
                    break;
                }
                if (!SqlTypeUtil.isDecimal(lhsType) || lhsType == rhsType) break;
                return true;
            }
            default: {
                localCheck = call.getOperator().requiresDecimalExpansion();
            }
        }
        if (localCheck) {
            if (SqlTypeUtil.isDecimal(call.getType())) {
                return true;
            }
            int i = 0;
            while (i < call.operands.size()) {
                if (SqlTypeUtil.isDecimal(((RexNode)call.operands.get(i)).getType())) {
                    return true;
                }
                ++i;
            }
        }
        return recurse && RexUtil.requiresDecimalExpansion(call.operands, recurse);
    }

    public static boolean requiresDecimalExpansion(List<RexNode> operands, boolean recurse) {
        for (RexNode operand : operands) {
            RexCall call;
            if (!(operand instanceof RexCall) || !RexUtil.requiresDecimalExpansion(call = (RexCall)operand, recurse)) continue;
            return true;
        }
        return false;
    }

    public static boolean requiresDecimalExpansion(RexProgram program, boolean recurse) {
        List<RexNode> exprList = program.getExprList();
        for (RexNode expr : exprList) {
            if (!RexUtil.requiresDecimalExpansion(expr, recurse)) continue;
            return true;
        }
        return false;
    }

    public static boolean canReinterpretOverflow(RexCall call) {
        assert (call.isA(SqlKind.REINTERPRET)) : "call is not a reinterpret";
        return call.operands.size() > 1;
    }

    public static boolean containCommonExprs(List<RexNode> exprs, boolean fail) {
        ExpressionNormalizer visitor = new ExpressionNormalizer(false);
        for (RexNode expr : exprs) {
            try {
                expr.accept(visitor);
            }
            catch (ExpressionNormalizer.SubExprExistsException e) {
                Util.swallow(e, null);
                assert (!fail);
            }
        }
        return false;
    }

    public static boolean containForwardRefs(List<RexNode> exprs, RelDataType inputRowType, boolean fail) {
        ForwardRefFinder visitor = new ForwardRefFinder(inputRowType);
        int i = 0;
        while (i < exprs.size()) {
            RexNode expr = exprs.get(i);
            visitor.setLimit(i);
            try {
                expr.accept(visitor);
            }
            catch (ForwardRefFinder.IllegalForwardRefException e) {
                Util.swallow(e, null);
                assert (!fail) : "illegal forward reference in " + expr;
                return true;
            }
            ++i;
        }
        return false;
    }

    static boolean containNonTrivialAggs(List<RexNode> exprs, boolean fail) {
        for (RexNode expr : exprs) {
            RexCall rexCall;
            if (!(expr instanceof RexCall) || !((rexCall = (RexCall)expr).getOperator() instanceof SqlAggFunction)) continue;
            for (RexNode operand : rexCall.operands) {
                if (operand instanceof RexLocalRef) continue;
                assert (!fail) : "contains non trivial agg";
                return true;
            }
        }
        return false;
    }

    public static boolean containComplexExprs(List<RexNode> exprs) {
        for (RexNode expr : exprs) {
            if (!(expr instanceof RexCall)) continue;
            for (RexNode operand : ((RexCall)expr).operands) {
                if (RexUtil.isAtomic(operand)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAtomic(RexNode expr) {
        return expr instanceof RexLiteral || expr instanceof RexVariable;
    }

    public static boolean isCallTo(RexNode expr, SqlOperator op) {
        return expr instanceof RexCall && ((RexCall)expr).getOperator() == op;
    }

    public static RelDataType createStructType(RelDataTypeFactory typeFactory, List<RexNode> exprs) {
        return RexUtil.createStructType(typeFactory, exprs, null);
    }

    public static RelDataType createStructType(RelDataTypeFactory typeFactory, List<? extends RexNode> exprs, List<String> names) {
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        int i = 0;
        while (i < exprs.size()) {
            String name;
            if (names == null || (name = names.get(i)) == null) {
                name = "$f" + i;
            }
            builder.add(name, exprs.get(i).getType());
            ++i;
        }
        return builder.build();
    }

    public static boolean compatibleTypes(List<RexNode> exprs, RelDataType type, boolean fail) {
        List<RelDataTypeField> fields = type.getFieldList();
        if (exprs.size() != fields.size()) {
            assert (!fail) : "rowtype mismatches expressions";
            return false;
        }
        int i = 0;
        while (i < fields.size()) {
            RelDataType fieldType;
            RelDataType exprType = exprs.get(i).getType();
            if (!RelOptUtil.eq("type1", exprType, "type2", fieldType = fields.get(i).getType(), fail)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Pair<String, String> makeKey(RexNode expr) {
        return Pair.of(expr.toString(), expr.getType().getFullTypeString());
    }

    public static boolean containIdentity(List<RexNode> exprs, RelDataType rowType, boolean fail) {
        List<RelDataTypeField> fields = rowType.getFieldList();
        if (exprs.size() < fields.size()) {
            assert (!fail) : "exprs/rowType length mismatch";
            return false;
        }
        int i = 0;
        while (i < fields.size()) {
            if (!(exprs.get(i) instanceof RexInputRef)) {
                assert (!fail) : "expr[" + i + "] is not a RexInputRef";
                return false;
            }
            RexInputRef inputRef = (RexInputRef)exprs.get(i);
            if (inputRef.getIndex() != i) {
                assert (!fail) : "expr[" + i + "] has ordinal " + inputRef.getIndex();
                return false;
            }
            if (!RelOptUtil.eq("type1", exprs.get(i).getType(), "type2", fields.get(i).getType(), fail)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static RexNode composeConjunction(RexBuilder rexBuilder, List<RexNode> nodes, boolean nullOnEmpty) {
        List nodes2 = Functions.filter(nodes, NOT_ALWAYS_TRUE_PREDICATE);
        switch (nodes2.size()) {
            case 0: {
                return nullOnEmpty ? null : rexBuilder.makeLiteral(true);
            }
            case 1: {
                return (RexNode)nodes2.get(0);
            }
        }
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, nodes2);
    }

    public static RexNode composeDisjunction(RexBuilder rexBuilder, List<RexNode> nodes, boolean nullOnEmpty) {
        List nodes2 = Functions.filter(nodes, NOT_ALWAYS_FALSE_PREDICATE);
        switch (nodes2.size()) {
            case 0: {
                return nullOnEmpty ? null : rexBuilder.makeLiteral(false);
            }
            case 1: {
                return (RexNode)nodes2.get(0);
            }
        }
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, nodes2);
    }

    public static List<RelCollation> apply(Mappings.TargetMapping mapping, List<RelCollation> collationList) {
        ArrayList<RelCollation> newCollationList = new ArrayList<RelCollation>();
        for (RelCollation collation : collationList) {
            RelCollation newCollation;
            if (collation == RelCollationImpl.PRESERVE) {
                newCollationList.add(collation);
                continue;
            }
            ArrayList<RelFieldCollation> newFieldCollationList = new ArrayList<RelFieldCollation>();
            for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
                RelFieldCollation newFieldCollation = RexUtil.apply(mapping, fieldCollation);
                if (newFieldCollation == null) break;
                newFieldCollationList.add(newFieldCollation);
            }
            if (newFieldCollationList.isEmpty() || newCollationList.contains(newCollation = RelCollationImpl.of(newFieldCollationList))) continue;
            newCollationList.add(newCollation);
        }
        return newCollationList;
    }

    public static RelCollation apply(Mappings.TargetMapping mapping, RelCollation collation) {
        List<RelFieldCollation> fieldCollations = RexUtil.applyFields(mapping, collation.getFieldCollations());
        return fieldCollations.equals(collation.getFieldCollations()) ? collation : RelCollationImpl.of(fieldCollations);
    }

    public static RelFieldCollation apply(Mappings.TargetMapping mapping, RelFieldCollation fieldCollation) {
        int target = mapping.getTargetOpt(fieldCollation.getFieldIndex());
        if (target < 0) {
            return null;
        }
        return fieldCollation.copy(target);
    }

    public static List<RelFieldCollation> applyFields(Mappings.TargetMapping mapping, List<RelFieldCollation> fieldCollations) {
        ArrayList<RelFieldCollation> newFieldCollations = new ArrayList<RelFieldCollation>(fieldCollations.size());
        for (RelFieldCollation fieldCollation : fieldCollations) {
            newFieldCollations.add(RexUtil.apply(mapping, fieldCollation));
        }
        return newFieldCollations;
    }

    public static <T extends RexNode> T[] apply(RexVisitor<T> shuttle, T[] exprs) {
        RexNode[] newExprs = (RexNode[])exprs.clone();
        int i = 0;
        while (i < newExprs.length) {
            RexNode expr = newExprs[i];
            if (expr != null) {
                newExprs[i] = (RexNode)expr.accept(shuttle);
            }
            ++i;
        }
        return newExprs;
    }

    public static void apply(RexVisitor<Void> visitor, RexNode[] exprs, RexNode expr) {
        RexNode[] rexNodeArray = exprs;
        int n = exprs.length;
        int n2 = 0;
        while (n2 < n) {
            RexNode e = rexNodeArray[n2];
            e.accept(visitor);
            ++n2;
        }
        if (expr != null) {
            expr.accept(visitor);
        }
    }

    public static void apply(RexVisitor<Void> visitor, List<? extends RexNode> exprs, RexNode expr) {
        for (RexNode rexNode : exprs) {
            rexNode.accept(visitor);
        }
        if (expr != null) {
            expr.accept(visitor);
        }
    }

    static List<? extends RexNode> flatten(List<? extends RexNode> exprs, SqlOperator op) {
        if (RexUtil.isFlat(exprs, op)) {
            return exprs;
        }
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        RexUtil.flattenRecurse(list, exprs, op);
        return list;
    }

    private static boolean isFlat(List<? extends RexNode> exprs, final SqlOperator op) {
        return !RexUtil.isAssociative(op) || !RexUtil.exists(exprs, new Predicate1<RexNode>(){

            public boolean apply(RexNode expr) {
                return RexUtil.isCallTo(expr, op);
            }
        });
    }

    public static boolean isFlat(RexNode expr) {
        if (!(expr instanceof RexCall)) {
            return true;
        }
        RexCall call = (RexCall)expr;
        return RexUtil.isFlat(call.getOperands(), call.getOperator()) && RexUtil.all(call.getOperands(), IS_FLAT_PREDICATE);
    }

    private static void flattenRecurse(List<RexNode> list, List<? extends RexNode> exprs, SqlOperator op) {
        for (RexNode rexNode : exprs) {
            if (rexNode instanceof RexCall && ((RexCall)rexNode).getOperator() == op) {
                RexUtil.flattenRecurse(list, ((RexCall)rexNode).getOperands(), op);
                continue;
            }
            list.add(rexNode);
        }
    }

    private static boolean isAssociative(SqlOperator op) {
        return op.getKind() == SqlKind.AND || op.getKind() == SqlKind.OR;
    }

    public static <E> boolean exists(List<? extends E> list, Predicate1<E> predicate) {
        for (E e : list) {
            if (!predicate.apply(e)) continue;
            return true;
        }
        return false;
    }

    public static <E> boolean all(List<? extends E> list, Predicate1<E> predicate) {
        for (E e : list) {
            if (predicate.apply(e)) continue;
            return false;
        }
        return true;
    }

    public static <E> List<E> generate(final int size, final Function1<Integer, E> fn) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        return new AbstractList<E>(){

            @Override
            public int size() {
                return size;
            }

            @Override
            public E get(int index) {
                return fn.apply((Object)index);
            }
        };
    }

    public static RexNode shift(RexNode node, final int offset) {
        return node.accept(new RexShuttle(){

            public RexNode visitInputRef(RexInputRef input) {
                return new RexInputRef(input.getIndex() + offset, input.getType());
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExpressionNormalizer
    extends RexVisitorImpl<RexNode> {
        final Map<String, RexNode> mapDigestToExpr = new HashMap<String, RexNode>();
        final boolean allowDups;

        protected ExpressionNormalizer(boolean allowDups) {
            super(true);
            this.allowDups = allowDups;
        }

        protected RexNode register(RexNode expr) {
            String key = expr.toString();
            RexNode previous = this.mapDigestToExpr.put(key, expr);
            if (!this.allowDups && previous != null) {
                throw new SubExprExistsException(expr);
            }
            return expr;
        }

        protected RexNode lookup(RexNode expr) {
            return this.mapDigestToExpr.get(expr.toString());
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            return this.register(inputRef);
        }

        @Override
        public RexNode visitLiteral(RexLiteral literal) {
            return this.register(literal);
        }

        @Override
        public RexNode visitCorrelVariable(RexCorrelVariable correlVariable) {
            return this.register(correlVariable);
        }

        @Override
        public RexNode visitCall(RexCall call) {
            ArrayList<RexNode> normalizedOperands = new ArrayList<RexNode>();
            int diffCount = 0;
            for (RexNode operand : call.getOperands()) {
                operand.accept(this);
                RexNode normalizedOperand = this.lookup(operand);
                normalizedOperands.add(normalizedOperand);
                if (normalizedOperand == operand) continue;
                ++diffCount;
            }
            if (diffCount > 0) {
                call = call.clone(call.getType(), normalizedOperands);
            }
            return this.register(call);
        }

        @Override
        public RexNode visitDynamicParam(RexDynamicParam dynamicParam) {
            return this.register(dynamicParam);
        }

        @Override
        public RexNode visitRangeRef(RexRangeRef rangeRef) {
            return this.register(rangeRef);
        }

        @Override
        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            RexNode expr = fieldAccess.getReferenceExpr();
            expr.accept(this);
            RexNode normalizedExpr = this.lookup(expr);
            if (normalizedExpr != expr) {
                fieldAccess = new RexFieldAccess(normalizedExpr, fieldAccess.getField());
            }
            return this.register(fieldAccess);
        }

        private static class SubExprExistsException
        extends RuntimeException {
            SubExprExistsException(RexNode expr) {
                Util.discard(expr);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldAccessFinder
    extends RexVisitorImpl<Void> {
        private final List<RexFieldAccess> fieldAccessList = new ArrayList<RexFieldAccess>();

        public FieldAccessFinder() {
            super(true);
        }

        @Override
        public Void visitFieldAccess(RexFieldAccess fieldAccess) {
            this.fieldAccessList.add(fieldAccess);
            return null;
        }

        @Override
        public Void visitCall(RexCall call) {
            for (RexNode operand : call.operands) {
                operand.accept(this);
            }
            return null;
        }

        public List<RexFieldAccess> getFieldAccessList() {
            return this.fieldAccessList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForwardRefFinder
    extends RexVisitorImpl<Void> {
        private int limit = -1;
        private final RelDataType inputRowType;

        public ForwardRefFinder(RelDataType inputRowType) {
            super(true);
            this.inputRowType = inputRowType;
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            super.visitInputRef(inputRef);
            if (inputRef.getIndex() >= this.inputRowType.getFieldCount()) {
                throw new IllegalForwardRefException();
            }
            return null;
        }

        @Override
        public Void visitLocalRef(RexLocalRef inputRef) {
            super.visitLocalRef(inputRef);
            if (inputRef.getIndex() >= this.limit) {
                throw new IllegalForwardRefException();
            }
            return null;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        static class IllegalForwardRefException
        extends RuntimeException {
            IllegalForwardRefException() {
            }
        }
    }
}

