/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rex;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexVisitor;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlSyntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RexCall
extends RexNode {
    private final SqlOperator op;
    public final ImmutableList<RexNode> operands;
    private final RelDataType type;

    protected RexCall(RelDataType type, SqlOperator op, List<? extends RexNode> operands) {
        assert (type != null) : "precondition: type != null";
        assert (op != null) : "precondition: op != null";
        assert (operands != null) : "precondition: operands != null";
        this.type = type;
        this.op = op;
        this.operands = ImmutableList.copyOf(operands);
        assert (op.getKind() != null) : op;
        this.digest = this.computeDigest(true);
        assert (op.validRexOperands(operands.size(), true)) : this;
    }

    protected String computeDigest(boolean withType) {
        StringBuilder sb = new StringBuilder(this.op.getName());
        if (this.operands.size() != 0 || this.op.getSyntax() != SqlSyntax.FUNCTION_ID) {
            sb.append("(");
            int i = 0;
            while (i < this.operands.size()) {
                if (i > 0) {
                    sb.append(", ");
                }
                RexNode operand = (RexNode)this.operands.get(i);
                sb.append(operand.toString());
                ++i;
            }
            sb.append(")");
        }
        if (withType) {
            sb.append(":");
            sb.append(this.type.getFullTypeString());
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.computeDigest(this.isA(SqlKind.CAST) || this.isA(SqlKind.NEW_SPECIFICATION));
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitCall(this);
    }

    @Override
    public RelDataType getType() {
        return this.type;
    }

    @Override
    public SqlKind getKind() {
        return this.op.kind;
    }

    public List<RexNode> getOperands() {
        return this.operands;
    }

    public SqlOperator getOperator() {
        return this.op;
    }

    public RexCall clone(RelDataType type, List<RexNode> operands) {
        return new RexCall(type, this.op, operands);
    }
}

