/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoerceInputsRule
extends RelOptRule {
    private final Class consumerRelClass;
    private final boolean coerceNames;

    public CoerceInputsRule(Class<? extends RelNode> consumerRelClass, boolean coerceNames) {
        super(CoerceInputsRule.operand(consumerRelClass, CoerceInputsRule.any()), "CoerceInputsRule:" + consumerRelClass.getName());
        this.consumerRelClass = consumerRelClass;
        this.coerceNames = coerceNames;
    }

    @Override
    public Convention getOutConvention() {
        return Convention.NONE;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Object consumerRel = call.rel(0);
        if (consumerRel.getClass() != this.consumerRelClass) {
            return;
        }
        List<RelNode> inputs = consumerRel.getInputs();
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>(inputs);
        boolean coerce = false;
        int i = 0;
        while (i < inputs.size()) {
            RelDataType expectedType = consumerRel.getExpectedInputRowType(i);
            RelNode input = inputs.get(i);
            RelNode newInput = RelOptUtil.createCastRel(input, expectedType, this.coerceNames);
            if (newInput != input) {
                newInputs.set(i, newInput);
                coerce = true;
            }
            assert (RelOptUtil.areRowTypesEqual(((RelNode)newInputs.get(i)).getRowType(), expectedType, this.coerceNames));
            ++i;
        }
        if (!coerce) {
            return;
        }
        RelNode newConsumerRel = consumerRel.copy(consumerRel.getTraitSet(), newInputs);
        call.transformTo(newConsumerRel);
    }
}

