/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.hydromatic.optiq.util.graph.DefaultDirectedGraph;
import net.hydromatic.optiq.util.graph.DefaultEdge;
import net.hydromatic.optiq.util.graph.TopologicalOrderIterator;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.CalcRelBase;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexDynamicParam;
import org.eigenbase.rex.RexFieldAccess;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexProgramBuilder;
import org.eigenbase.rex.RexShuttle;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.rex.RexVisitorImpl;
import org.eigenbase.util.IntList;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CalcRelSplitter {
    private static final Logger RULE_LOGGER = RelOptPlanner.LOGGER;
    protected final RexProgram program;
    private final RelDataTypeFactory typeFactory;
    private final RelType[] relTypes;
    private final RelOptCluster cluster;
    private final RelTraitSet traits;
    private final RelNode child;

    CalcRelSplitter(CalcRelBase calc, RelType[] relTypes) {
        int i = 0;
        while (i < relTypes.length) {
            assert (relTypes[i] != null);
            int j = 0;
            while (j < i) {
                assert (relTypes[i] != relTypes[j]) : "Rel types must be distinct";
                ++j;
            }
            ++i;
        }
        this.program = calc.getProgram();
        this.cluster = calc.getCluster();
        this.traits = calc.getTraitSet();
        this.typeFactory = calc.getCluster().getTypeFactory();
        this.child = calc.getChild();
        this.relTypes = relTypes;
    }

    RelNode execute() {
        assert (this.program.isValid(true));
        List<RexNode> exprList = this.program.getExprList();
        RexNode[] exprs = exprList.toArray(new RexNode[exprList.size()]);
        assert (!RexUtil.containComplexExprs(exprList));
        int[] exprLevels = new int[exprs.length];
        int[] levelTypeOrdinals = new int[exprs.length];
        int levelCount = this.chooseLevels(exprs, -1, exprLevels, levelTypeOrdinals);
        int[] exprMaxUsingLevelOrdinals = new HighestUsageFinder(exprs, exprLevels).getMaxUsingLevelOrdinals();
        List<RexLocalRef> projectRefList = this.program.getProjectList();
        RexLocalRef conditionRef = this.program.getCondition();
        for (RexLocalRef projectRef : projectRefList) {
            exprMaxUsingLevelOrdinals[projectRef.getIndex()] = levelCount;
        }
        if (conditionRef != null) {
            exprMaxUsingLevelOrdinals[conditionRef.getIndex()] = levelCount;
        }
        if (RULE_LOGGER.isLoggable(Level.FINER)) {
            this.traceLevelExpressions(exprs, exprLevels, levelTypeOrdinals, levelCount);
        }
        RelNode rel = this.child;
        int inputFieldCount = this.program.getInputRowType().getFieldCount();
        int[] inputExprOrdinals = this.identityArray(inputFieldCount);
        boolean doneCondition = false;
        int level = 0;
        while (level < levelCount) {
            RexProgram program1;
            int[] projectExprOrdinals;
            RelDataType outputRowType;
            if (level == levelCount - 1) {
                outputRowType = this.program.getOutputRowType();
                projectExprOrdinals = new int[projectRefList.size()];
                int i = 0;
                while (i < projectExprOrdinals.length) {
                    projectExprOrdinals[i] = projectRefList.get(i).getIndex();
                    ++i;
                }
            } else {
                outputRowType = null;
                IntList projectExprOrdinalList = new IntList();
                int i = 0;
                while (i < exprs.length) {
                    RexNode expr = exprs[i];
                    if (expr instanceof RexLiteral) {
                        exprLevels[i] = -1;
                    } else if (exprLevels[i] <= level && exprMaxUsingLevelOrdinals[i] > level) {
                        projectExprOrdinalList.add(i);
                    }
                    ++i;
                }
                projectExprOrdinals = projectExprOrdinalList.toIntArray();
            }
            RelType relType = this.relTypes[levelTypeOrdinals[level]];
            int conditionExprOrdinal = -1;
            if (conditionRef != null && !doneCondition) {
                conditionExprOrdinal = conditionRef.getIndex();
                if (exprLevels[conditionExprOrdinal] > level || !relType.supportsCondition()) {
                    conditionExprOrdinal = -1;
                } else {
                    doneCondition = true;
                }
            }
            if ((rel = relType.makeRel(this.cluster, this.traits, (program1 = this.createProgramForLevel(level, levelCount, rel.getRowType(), exprs, exprLevels, inputExprOrdinals, projectExprOrdinals, conditionExprOrdinal, outputRowType)).getOutputRowType(), rel, program1)) instanceof CalcRel && ((CalcRel)rel).getProgram().isTrivial()) {
                rel = rel.getInput(0);
            }
            rel = this.handle(rel);
            inputExprOrdinals = projectExprOrdinals;
            ++level;
        }
        Util.permAssert(doneCondition || conditionRef == null, "unhandled condition");
        return rel;
    }

    protected RelNode handle(RelNode rel) {
        return rel;
    }

    private int chooseLevels(RexNode[] exprs, int conditionOrdinal, int[] exprLevels, int[] levelTypeOrdinals) {
        int inputFieldCount = this.program.getInputRowType().getFieldCount();
        int levelCount = 0;
        MaxInputFinder maxInputFinder = new MaxInputFinder(exprLevels);
        boolean[] relTypesPossibleForTopLevel = new boolean[this.relTypes.length];
        Arrays.fill(relTypesPossibleForTopLevel, true);
        List<Set<Integer>> cohorts = this.getCohorts();
        List<Integer> permutation = this.computeTopologicalOrdering(exprs, cohorts);
        block0: for (int i : permutation) {
            boolean condition;
            RexNode expr = exprs[i];
            boolean bl = condition = i == conditionOrdinal;
            if (i < inputFieldCount) {
                assert (expr instanceof RexInputRef);
                exprLevels[i] = -1;
                continue;
            }
            int level = maxInputFinder.maxInputFor(expr);
            Set<Integer> cohort = CalcRelSplitter.findCohort(cohorts, i);
            if (cohort != null) {
                for (Integer exprOrdinal : cohort) {
                    RexNode cohortExpr;
                    int cohortLevel;
                    if (exprOrdinal == i || (cohortLevel = maxInputFinder.maxInputFor(cohortExpr = exprs[exprOrdinal])) <= level) continue;
                    level = cohortLevel;
                }
            }
            while (true) {
                if (level >= levelCount) {
                    int relTypeOrdinal = 0;
                    while (relTypeOrdinal < this.relTypes.length) {
                        if (relTypesPossibleForTopLevel[relTypeOrdinal] && this.relTypes[relTypeOrdinal].canImplement(expr, condition)) {
                            exprLevels[i] = level;
                            levelTypeOrdinals[level] = relTypeOrdinal;
                            assert (level == 0 || levelTypeOrdinals[level - 1] != levelTypeOrdinals[level]) : "successive levels of same type";
                            int j = 0;
                            while (j < relTypeOrdinal) {
                                relTypesPossibleForTopLevel[j] = false;
                                ++j;
                            }
                            j = relTypeOrdinal + 1;
                            while (j < this.relTypes.length) {
                                if (relTypesPossibleForTopLevel[j]) {
                                    relTypesPossibleForTopLevel[j] = this.relTypes[j].canImplement(expr, condition);
                                }
                                ++j;
                            }
                            levelTypeOrdinals[levelCount] = CalcRelSplitter.firstSet(relTypesPossibleForTopLevel);
                            ++levelCount;
                            Arrays.fill(relTypesPossibleForTopLevel, true);
                            continue block0;
                        }
                        ++relTypeOrdinal;
                    }
                    if (CalcRelSplitter.count(relTypesPossibleForTopLevel) >= this.relTypes.length) {
                        throw Util.newInternal("cannot implement " + expr);
                    }
                    levelTypeOrdinals[levelCount] = CalcRelSplitter.firstSet(relTypesPossibleForTopLevel);
                    ++levelCount;
                    Arrays.fill(relTypesPossibleForTopLevel, true);
                } else {
                    int levelTypeOrdinal = levelTypeOrdinals[level];
                    if (this.relTypes[levelTypeOrdinal].canImplement(expr, condition)) {
                        exprLevels[i] = level;
                        continue block0;
                    }
                }
                ++level;
            }
        }
        return levelCount;
    }

    private List<Integer> computeTopologicalOrdering(RexNode[] exprs, List<Set<Integer>> cohorts) {
        final DefaultDirectedGraph<Integer, DefaultEdge> graph = DefaultDirectedGraph.create();
        int i = 0;
        while (i < exprs.length) {
            graph.addVertex(i);
            ++i;
        }
        i = 0;
        while (i < exprs.length) {
            RexNode expr = exprs[i];
            Set<Integer> cohort = CalcRelSplitter.findCohort(cohorts, i);
            final Set<Integer> targets = cohort == null ? Collections.singleton(i) : cohort;
            expr.accept(new RexVisitorImpl<Void>(true){

                @Override
                public Void visitLocalRef(RexLocalRef localRef) {
                    for (Integer target : targets) {
                        graph.addEdge(localRef.getIndex(), target);
                    }
                    return null;
                }
            });
            ++i;
        }
        TopologicalOrderIterator iter = new TopologicalOrderIterator(graph);
        ArrayList<Integer> permutation = new ArrayList<Integer>();
        while (iter.hasNext()) {
            permutation.add((Integer)iter.next());
        }
        return permutation;
    }

    private static Set<Integer> findCohort(List<Set<Integer>> cohorts, int ordinal) {
        for (Set<Integer> cohort : cohorts) {
            if (!cohort.contains(ordinal)) continue;
            return cohort;
        }
        return null;
    }

    private int[] identityArray(int length) {
        int[] ints = new int[length];
        int i = 0;
        while (i < ints.length) {
            ints[i] = i;
            ++i;
        }
        return ints;
    }

    private RexProgram createProgramForLevel(int level, int levelCount, RelDataType inputRowType, RexNode[] allExprs, int[] exprLevels, int[] inputExprOrdinals, int[] projectExprOrdinals, int conditionExprOrdinal, RelDataType outputRowType) {
        RexLocalRef conditionRef;
        ArrayList<RexNode> exprs = new ArrayList<RexNode>();
        int[] exprInverseOrdinals = new int[allExprs.length];
        Arrays.fill(exprInverseOrdinals, -1);
        int j = 0;
        int i = 0;
        while (i < inputExprOrdinals.length) {
            int inputExprOrdinal = inputExprOrdinals[i];
            exprs.add(new RexInputRef(i, allExprs[inputExprOrdinal].getType()));
            exprInverseOrdinals[inputExprOrdinal] = j++;
            ++i;
        }
        InputToCommonExprConverter shuttle = new InputToCommonExprConverter(exprInverseOrdinals, exprLevels, level, inputExprOrdinals, allExprs);
        int i2 = 0;
        while (i2 < allExprs.length) {
            if (exprLevels[i2] == level || exprLevels[i2] == -1 && level == levelCount - 1 && allExprs[i2] instanceof RexLiteral) {
                RexNode expr = allExprs[i2];
                RexNode translatedExpr = expr.accept(shuttle);
                exprs.add(translatedExpr);
                assert (exprInverseOrdinals[i2] == -1);
                exprInverseOrdinals[i2] = j++;
            }
            ++i2;
        }
        ArrayList<RexLocalRef> projectRefs = new ArrayList<RexLocalRef>(projectExprOrdinals.length);
        ArrayList<String> fieldNames = new ArrayList<String>(projectExprOrdinals.length);
        int i3 = 0;
        while (i3 < projectExprOrdinals.length) {
            int projectExprOrdinal = projectExprOrdinals[i3];
            int index = exprInverseOrdinals[projectExprOrdinal];
            assert (index >= 0);
            RexNode expr = allExprs[projectExprOrdinal];
            projectRefs.add(new RexLocalRef(index, expr.getType()));
            fieldNames.add(this.deriveFieldName(expr, i3));
            ++i3;
        }
        if (conditionExprOrdinal >= 0) {
            int index = exprInverseOrdinals[conditionExprOrdinal];
            conditionRef = new RexLocalRef(index, allExprs[conditionExprOrdinal].getType());
        } else {
            conditionRef = null;
        }
        if (outputRowType == null) {
            outputRowType = RexUtil.createStructType(this.typeFactory, projectRefs, fieldNames);
        }
        RexProgram program = new RexProgram(inputRowType, exprs, projectRefs, conditionRef, outputRowType);
        return RexProgramBuilder.normalize(this.cluster.getRexBuilder(), program);
    }

    private String deriveFieldName(RexNode expr, int ordinal) {
        if (expr instanceof RexInputRef) {
            int inputIndex = ((RexInputRef)expr).getIndex();
            String fieldName = this.child.getRowType().getFieldList().get(inputIndex).getName();
            if (!fieldName.startsWith("$") || fieldName.startsWith("$EXPR")) {
                return fieldName;
            }
        }
        return "$" + ordinal;
    }

    private void traceLevelExpressions(RexNode[] exprs, int[] exprLevels, int[] levelTypeOrdinals, int levelCount) {
        StringWriter traceMsg = new StringWriter();
        PrintWriter traceWriter = new PrintWriter(traceMsg);
        traceWriter.println("FarragoAutoCalcRule result expressions for: ");
        traceWriter.println(this.program.toString());
        int level = 0;
        while (level < levelCount) {
            traceWriter.println("Rel Level " + level + ", type " + this.relTypes[levelTypeOrdinals[level]]);
            int i = 0;
            while (i < exprs.length) {
                RexNode expr = exprs[i];
                assert (exprLevels[i] >= -1 && exprLevels[i] < levelCount) : "expression's level is out of range";
                if (exprLevels[i] == level) {
                    traceWriter.println("\t" + i + ": " + expr);
                }
                ++i;
            }
            traceWriter.println();
            ++level;
        }
        String msg = traceMsg.toString();
        RULE_LOGGER.finer(msg);
    }

    private static int count(boolean[] booleans) {
        int count = 0;
        boolean[] blArray = booleans;
        int n = booleans.length;
        int n2 = 0;
        while (n2 < n) {
            boolean b = blArray[n2];
            if (b) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    private static int firstSet(boolean[] booleans) {
        int i = 0;
        while (i < booleans.length) {
            if (booleans[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int indexOf(int value, int[] map) {
        int i = 0;
        while (i < map.length) {
            if (value == map[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected boolean canImplement(CalcRel rel, String relTypeName) {
        RelType[] relTypeArray = this.relTypes;
        int n = this.relTypes.length;
        int n2 = 0;
        while (n2 < n) {
            RelType relType = relTypeArray[n2];
            if (relType.name.equals(relTypeName)) {
                return relType.canImplement(rel.getProgram());
            }
            ++n2;
        }
        throw Util.newInternal("unknown reltype " + relTypeName);
    }

    protected List<Set<Integer>> getCohorts() {
        return Collections.emptyList();
    }

    private static class CannotImplement
    extends RuntimeException {
        static final CannotImplement INSTANCE = new CannotImplement();

        private CannotImplement() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HighestUsageFinder
    extends RexVisitorImpl<Void> {
        private final int[] maxUsingLevelOrdinals;
        private int currentLevel;

        public HighestUsageFinder(RexNode[] exprs, int[] exprLevels) {
            super(true);
            this.maxUsingLevelOrdinals = new int[exprs.length];
            Arrays.fill(this.maxUsingLevelOrdinals, -1);
            int i = 0;
            while (i < exprs.length) {
                if (exprs[i] instanceof RexLiteral) {
                    this.maxUsingLevelOrdinals[i] = -1;
                } else {
                    this.currentLevel = exprLevels[i];
                    exprs[i].accept(this);
                }
                ++i;
            }
        }

        public int[] getMaxUsingLevelOrdinals() {
            return this.maxUsingLevelOrdinals;
        }

        @Override
        public Void visitLocalRef(RexLocalRef ref) {
            int index = ref.getIndex();
            this.maxUsingLevelOrdinals[index] = Math.max(this.maxUsingLevelOrdinals[index], this.currentLevel);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImplementTester
    extends RexVisitorImpl<Void> {
        private final RelType relType;

        public ImplementTester(RelType relType) {
            super(false);
            this.relType = relType;
        }

        @Override
        public Void visitCall(RexCall call) {
            if (!this.relType.canImplement(call)) {
                throw CannotImplement.INSTANCE;
            }
            return null;
        }

        @Override
        public Void visitDynamicParam(RexDynamicParam dynamicParam) {
            if (!this.relType.canImplement(dynamicParam)) {
                throw CannotImplement.INSTANCE;
            }
            return null;
        }

        @Override
        public Void visitFieldAccess(RexFieldAccess fieldAccess) {
            if (!this.relType.canImplement(fieldAccess)) {
                throw CannotImplement.INSTANCE;
            }
            return null;
        }

        @Override
        public Void visitLiteral(RexLiteral literal) {
            if (!this.relType.canImplement(literal)) {
                throw CannotImplement.INSTANCE;
            }
            return null;
        }
    }

    private static class InputToCommonExprConverter
    extends RexShuttle {
        private final int[] exprInverseOrdinals;
        private final int[] exprLevels;
        private final int level;
        private final int[] inputExprOrdinals;
        private final RexNode[] allExprs;

        public InputToCommonExprConverter(int[] exprInverseOrdinals, int[] exprLevels, int level, int[] inputExprOrdinals, RexNode[] allExprs) {
            this.exprInverseOrdinals = exprInverseOrdinals;
            this.exprLevels = exprLevels;
            this.level = level;
            this.inputExprOrdinals = inputExprOrdinals;
            this.allExprs = allExprs;
        }

        public RexNode visitInputRef(RexInputRef input) {
            int index = this.exprInverseOrdinals[input.getIndex()];
            assert (index >= 0);
            return new RexLocalRef(index, input.getType());
        }

        public RexNode visitLocalRef(RexLocalRef local) {
            int localIndex = local.getIndex();
            int exprLevel = this.exprLevels[localIndex];
            if (exprLevel < this.level) {
                if (this.allExprs[localIndex] instanceof RexLiteral) {
                    return this.allExprs[localIndex];
                }
                int inputIndex = CalcRelSplitter.indexOf(localIndex, this.inputExprOrdinals);
                assert (inputIndex >= 0);
                return new RexLocalRef(inputIndex, local.getType());
            }
            int exprIndex = this.exprInverseOrdinals[localIndex];
            return new RexLocalRef(exprIndex, local.getType());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MaxInputFinder
    extends RexVisitorImpl<Void> {
        int level;
        private final int[] exprLevels;

        MaxInputFinder(int[] exprLevels) {
            super(true);
            this.exprLevels = exprLevels;
        }

        @Override
        public Void visitLocalRef(RexLocalRef localRef) {
            int inputLevel = this.exprLevels[localRef.getIndex()];
            this.level = Math.max(this.level, inputLevel);
            return null;
        }

        public int maxInputFor(RexNode expr) {
            this.level = 0;
            expr.accept(this);
            return this.level;
        }
    }

    public static abstract class RelType {
        private final String name;

        public RelType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        protected abstract boolean canImplement(RexFieldAccess var1);

        protected abstract boolean canImplement(RexDynamicParam var1);

        protected abstract boolean canImplement(RexLiteral var1);

        protected abstract boolean canImplement(RexCall var1);

        protected boolean supportsCondition() {
            return true;
        }

        protected RelNode makeRel(RelOptCluster cluster, RelTraitSet traits, RelDataType rowType, RelNode child, RexProgram program) {
            return new CalcRel(cluster, traits, child, rowType, program, Collections.<RelCollation>emptyList());
        }

        public boolean canImplement(RexNode expr, boolean condition) {
            if (condition && !this.supportsCondition()) {
                return false;
            }
            try {
                expr.accept(new ImplementTester(this));
                return true;
            }
            catch (CannotImplement e) {
                Util.swallow(e, null);
                return false;
            }
        }

        public boolean canImplement(RexProgram program) {
            if (program.getCondition() != null && !this.canImplement(program.getCondition(), true)) {
                return false;
            }
            for (RexNode expr : program.getExprList()) {
                if (this.canImplement(expr, false)) continue;
                return false;
            }
            return true;
        }
    }
}

