/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.runtime;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import net.hydromatic.optiq.runtime.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlatLists {
    public static final ComparableEmptyList COMPARABLE_EMPTY_LIST = new ComparableEmptyList();

    private FlatLists() {
    }

    public static <T> List<T> of(T t0, T t1) {
        return new Flat2List<T>(t0, t1);
    }

    public static <T> List<T> of(T t0, T t1, T t2) {
        return new Flat3List<T>(t0, t1, t2);
    }

    public static <T> List<T> of(T ... t) {
        return FlatLists.flatList_(t, false);
    }

    public static <T> List<T> copy(T ... t) {
        return FlatLists.flatList_(t, true);
    }

    private static <T> List<T> flatList_(T[] t, boolean copy) {
        switch (t.length) {
            case 0: {
                return COMPARABLE_EMPTY_LIST;
            }
            case 1: {
                return Collections.singletonList(t[0]);
            }
            case 2: {
                return new Flat2List<T>(t[0], t[1]);
            }
            case 3: {
                return new Flat3List<T>(t[0], t[1], t[2]);
            }
        }
        if (copy) {
            return new ComparableListImpl<Object>(Arrays.asList((Object[])t.clone()));
        }
        return new ComparableListImpl<T>(Arrays.asList(t));
    }

    public static <T> List<T> of(List<T> t) {
        switch (t.size()) {
            case 0: {
                return COMPARABLE_EMPTY_LIST;
            }
            case 1: {
                return Collections.singletonList(t.get(0));
            }
            case 2: {
                return new Flat2List<T>(t.get(0), t.get(1));
            }
            case 3: {
                return new Flat3List<T>(t.get(0), t.get(1), t.get(2));
            }
        }
        return new ComparableListImpl<Object>(Arrays.asList(t.toArray()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractFlatList<T>
    implements List<T>,
    RandomAccess {
        protected final List<T> asArrayList() {
            return Arrays.asList(this.toArray());
        }

        @Override
        public Iterator<T> iterator() {
            return this.asArrayList().iterator();
        }

        @Override
        public ListIterator<T> listIterator() {
            return this.asArrayList().listIterator();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean add(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T set(int index, T element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, T element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            return this.asArrayList().listIterator(index);
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            return this.asArrayList().subList(fromIndex, toIndex);
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) >= 0;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComparableEmptyList
    extends AbstractList
    implements Comparable<List> {
        private ComparableEmptyList() {
        }

        @Override
        public Object get(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object o) {
            return o == this || o instanceof List && ((List)o).isEmpty();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public int compareTo(List o) {
            if (o == this) {
                return 0;
            }
            return o.size() == 0 ? 0 : -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ComparableList<T>
    extends List<T>,
    Comparable<List> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ComparableListImpl<T extends Comparable<T>>
    extends AbstractList<T>
    implements ComparableList<T> {
        private final List<T> list;

        protected ComparableListImpl(List<T> list) {
            this.list = list;
        }

        @Override
        public T get(int index) {
            return (T)((Comparable)this.list.get(index));
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public int compareTo(List o) {
            return ComparableListImpl.compare(this.list, o);
        }

        static <T extends Comparable<T>> int compare(List<T> list0, List<T> list1) {
            int size0 = list0.size();
            int size1 = list1.size();
            if (size1 == size0) {
                return ComparableListImpl.compare(list0, list1, size0);
            }
            int c = ComparableListImpl.compare(list0, list1, Math.min(size0, size1));
            if (c != 0) {
                return c;
            }
            return size0 - size1;
        }

        static <T extends Comparable> int compare(List<T> list0, List<T> list1, int size) {
            int i = 0;
            while (i < size) {
                Comparable o1;
                Comparable o0 = (Comparable)list0.get(i);
                int c = o0.compareTo(o1 = (Comparable)list1.get(i));
                if (c != 0) {
                    return c;
                }
                ++i;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Flat2List<T>
    extends AbstractFlatList<T>
    implements ComparableList<T> {
        private final T t0;
        private final T t1;

        Flat2List(T t0, T t1) {
            this.t0 = t0;
            this.t1 = t1;
        }

        public String toString() {
            return "[" + this.t0 + ", " + this.t1 + "]";
        }

        @Override
        public T get(int index) {
            switch (index) {
                case 0: {
                    return this.t0;
                }
                case 1: {
                    return this.t1;
                }
            }
            throw new IndexOutOfBoundsException("index " + index);
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public Iterator<T> iterator() {
            return Arrays.asList(this.t0, this.t1).iterator();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Flat2List) {
                Flat2List that = (Flat2List)o;
                return Utilities.equal(this.t0, that.t0) && Utilities.equal(this.t1, that.t1);
            }
            return Arrays.asList(this.t0, this.t1).equals(o);
        }

        @Override
        public int hashCode() {
            int h = 1;
            h = h * 31 + Utilities.hash(this.t0);
            h = h * 31 + Utilities.hash(this.t1);
            return h;
        }

        @Override
        public int indexOf(Object o) {
            if (o == null) {
                if (this.t0 == null) {
                    return 0;
                }
                if (this.t1 == null) {
                    return 1;
                }
            } else {
                if (this.t0.equals(o)) {
                    return 0;
                }
                if (this.t1.equals(o)) {
                    return 1;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (o == null) {
                if (this.t1 == null) {
                    return 1;
                }
                if (this.t0 == null) {
                    return 0;
                }
            } else {
                if (this.t1.equals(o)) {
                    return 1;
                }
                if (this.t0.equals(o)) {
                    return 0;
                }
            }
            return -1;
        }

        @Override
        public <T2> T2[] toArray(T2[] a) {
            a[0] = this.t0;
            a[1] = this.t1;
            return a;
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.t0, this.t1};
        }

        @Override
        public int compareTo(List o) {
            Flat2List that = (Flat2List)o;
            int c = Utilities.compare((Comparable)this.t0, (Comparable)that.t0);
            if (c != 0) {
                return c;
            }
            return Utilities.compare((Comparable)this.t1, (Comparable)that.t1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Flat3List<T>
    extends AbstractFlatList<T>
    implements ComparableList<T> {
        private final T t0;
        private final T t1;
        private final T t2;

        Flat3List(T t0, T t1, T t2) {
            this.t0 = t0;
            this.t1 = t1;
            this.t2 = t2;
        }

        public String toString() {
            return "[" + this.t0 + ", " + this.t1 + ", " + this.t2 + "]";
        }

        @Override
        public T get(int index) {
            switch (index) {
                case 0: {
                    return this.t0;
                }
                case 1: {
                    return this.t1;
                }
                case 2: {
                    return this.t2;
                }
            }
            throw new IndexOutOfBoundsException("index " + index);
        }

        @Override
        public int size() {
            return 3;
        }

        @Override
        public Iterator<T> iterator() {
            return Arrays.asList(this.t0, this.t1, this.t2).iterator();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Flat3List) {
                Flat3List that = (Flat3List)o;
                return Utilities.equal(this.t0, that.t0) && Utilities.equal(this.t1, that.t1) && Utilities.equal(this.t2, that.t2);
            }
            return o.equals(this);
        }

        @Override
        public int hashCode() {
            int h = 1;
            h = h * 31 + Utilities.hash(this.t0);
            h = h * 31 + Utilities.hash(this.t1);
            h = h * 31 + Utilities.hash(this.t2);
            return h;
        }

        @Override
        public int indexOf(Object o) {
            if (o == null) {
                if (this.t0 == null) {
                    return 0;
                }
                if (this.t1 == null) {
                    return 1;
                }
                if (this.t2 == null) {
                    return 2;
                }
            } else {
                if (this.t0.equals(o)) {
                    return 0;
                }
                if (this.t1.equals(o)) {
                    return 1;
                }
                if (this.t2.equals(o)) {
                    return 2;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (o == null) {
                if (this.t2 == null) {
                    return 2;
                }
                if (this.t1 == null) {
                    return 1;
                }
                if (this.t0 == null) {
                    return 0;
                }
            } else {
                if (this.t2.equals(o)) {
                    return 2;
                }
                if (this.t1.equals(o)) {
                    return 1;
                }
                if (this.t0.equals(o)) {
                    return 0;
                }
            }
            return -1;
        }

        @Override
        public <T2> T2[] toArray(T2[] a) {
            a[0] = this.t0;
            a[1] = this.t1;
            a[2] = this.t2;
            return a;
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.t0, this.t1, this.t2};
        }

        @Override
        public int compareTo(List o) {
            Flat3List that = (Flat3List)o;
            int c = Utilities.compare((Comparable)this.t0, (Comparable)that.t0);
            if (c != 0) {
                return c;
            }
            c = Utilities.compare((Comparable)this.t1, (Comparable)that.t1);
            if (c != 0) {
                return c;
            }
            return Utilities.compare((Comparable)this.t2, (Comparable)that.t2);
        }
    }
}

