/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.rules.java;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.linq4j.expressions.BinaryExpression;
import net.hydromatic.linq4j.expressions.ConstantExpression;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.MemberExpression;
import net.hydromatic.linq4j.expressions.NewExpression;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.expressions.TernaryExpression;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.linq4j.expressions.Visitor;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.Function;
import net.hydromatic.optiq.impl.ScalarFunctionImpl;
import net.hydromatic.optiq.rules.java.RexToLixTranslator;
import net.hydromatic.optiq.runtime.SqlFunctions;
import org.eigenbase.rel.Aggregation;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeFactoryImpl;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlBinaryOperator;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.fun.SqlTrimFunction;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.validate.SqlUserDefinedFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RexImpTable {
    public static final ConstantExpression NULL_EXPR = Expressions.constant(null);
    public static final ConstantExpression FALSE_EXPR = Expressions.constant((Object)false);
    public static final ConstantExpression TRUE_EXPR = Expressions.constant((Object)true);
    public static final MemberExpression BOXED_FALSE_EXPR = Expressions.field(null, Boolean.class, (String)"FALSE");
    public static final MemberExpression BOXED_TRUE_EXPR = Expressions.field(null, Boolean.class, (String)"TRUE");
    private static final CallImplementor UDF_IMPLEMENTOR = RexImpTable.createImplementor(new NotNullImplementor(){

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            Function x = ((SqlUserDefinedFunction)call.getOperator()).function;
            Method method = ((ScalarFunctionImpl)x).method;
            if ((method.getModifiers() & 8) != 0) {
                return Expressions.call((Method)method, translatedOperands);
            }
            NewExpression target = Expressions.new_(method.getDeclaringClass());
            return Expressions.call((Expression)target, (Method)method, translatedOperands);
        }
    }, NullPolicy.ANY, false);
    private final Map<SqlOperator, CallImplementor> map = new HashMap<SqlOperator, CallImplementor>();
    final Map<Aggregation, AggregateImplementor> aggMap = new HashMap<Aggregation, AggregateImplementor>();
    private final Map<Aggregation, AggImplementor2> agg2Map = new HashMap<Aggregation, AggImplementor2>();
    public static final RexImpTable INSTANCE = new RexImpTable();

    RexImpTable() {
        this.defineMethod((SqlOperator)SqlStdOperatorTable.UPPER, BuiltinMethod.UPPER.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.LOWER, BuiltinMethod.LOWER.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.INITCAP, BuiltinMethod.INITCAP.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.SUBSTRING, BuiltinMethod.SUBSTRING.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CHARACTER_LENGTH, BuiltinMethod.CHAR_LENGTH.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CHAR_LENGTH, BuiltinMethod.CHAR_LENGTH.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CONCAT, BuiltinMethod.STRING_CONCAT.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.OVERLAY, BuiltinMethod.OVERLAY.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.POSITION, BuiltinMethod.POSITION.method, NullPolicy.STRICT);
        TrimImplementor trimImplementor = new TrimImplementor();
        this.defineImplementor(SqlStdOperatorTable.TRIM, NullPolicy.STRICT, trimImplementor, false);
        this.defineBinary(SqlStdOperatorTable.AND, ExpressionType.AndAlso, NullPolicy.AND, null);
        this.defineBinary(SqlStdOperatorTable.OR, ExpressionType.OrElse, NullPolicy.OR, null);
        this.defineUnary(SqlStdOperatorTable.NOT, ExpressionType.Not, NullPolicy.NOT);
        this.defineBinary(SqlStdOperatorTable.LESS_THAN, ExpressionType.LessThan, NullPolicy.STRICT, "lt");
        this.defineBinary(SqlStdOperatorTable.LESS_THAN_OR_EQUAL, ExpressionType.LessThanOrEqual, NullPolicy.STRICT, "le");
        this.defineBinary(SqlStdOperatorTable.GREATER_THAN, ExpressionType.GreaterThan, NullPolicy.STRICT, "gt");
        this.defineBinary(SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, ExpressionType.GreaterThanOrEqual, NullPolicy.STRICT, "ge");
        this.defineBinary(SqlStdOperatorTable.EQUALS, ExpressionType.Equal, NullPolicy.STRICT, "eq");
        this.defineBinary(SqlStdOperatorTable.NOT_EQUALS, ExpressionType.NotEqual, NullPolicy.STRICT, "ne");
        this.defineBinary(SqlStdOperatorTable.PLUS, ExpressionType.Add, NullPolicy.STRICT, "plus");
        this.defineBinary(SqlStdOperatorTable.MINUS, ExpressionType.Subtract, NullPolicy.STRICT, "minus");
        this.defineBinary(SqlStdOperatorTable.MULTIPLY, ExpressionType.Multiply, NullPolicy.STRICT, "multiply");
        this.defineBinary(SqlStdOperatorTable.DIVIDE, ExpressionType.Divide, NullPolicy.STRICT, "divide");
        this.defineBinary(SqlStdOperatorTable.DIVIDE_INTEGER, ExpressionType.Divide, NullPolicy.STRICT, "divide");
        this.defineUnary(SqlStdOperatorTable.UNARY_MINUS, ExpressionType.Negate, NullPolicy.STRICT);
        this.defineUnary(SqlStdOperatorTable.UNARY_PLUS, ExpressionType.UnaryPlus, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.MOD, "mod", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.EXP, "exp", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.POWER, "power", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.LN, "ln", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.LOG10, "log10", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ABS, "abs", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CEIL, "ceil", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.FLOOR, "floor", NullPolicy.STRICT);
        this.map.put(SqlStdOperatorTable.IS_NULL, new IsXxxImplementor(null, false));
        this.map.put(SqlStdOperatorTable.IS_NOT_NULL, new IsXxxImplementor(null, true));
        this.map.put(SqlStdOperatorTable.IS_TRUE, new IsXxxImplementor(true, false));
        this.map.put(SqlStdOperatorTable.IS_NOT_TRUE, new IsXxxImplementor(true, true));
        this.map.put(SqlStdOperatorTable.IS_FALSE, new IsXxxImplementor(false, false));
        this.map.put(SqlStdOperatorTable.IS_NOT_FALSE, new IsXxxImplementor(false, true));
        MethodImplementor likeImplementor = new MethodImplementor(BuiltinMethod.LIKE.method);
        this.defineImplementor(SqlStdOperatorTable.LIKE, NullPolicy.STRICT, likeImplementor, false);
        this.defineImplementor(SqlStdOperatorTable.NOT_LIKE, NullPolicy.STRICT, NotImplementor.of(likeImplementor), false);
        MethodImplementor similarImplementor = new MethodImplementor(BuiltinMethod.SIMILAR.method);
        this.defineImplementor(SqlStdOperatorTable.SIMILAR_TO, NullPolicy.STRICT, similarImplementor, false);
        this.defineImplementor(SqlStdOperatorTable.NOT_SIMILAR_TO, NullPolicy.STRICT, NotImplementor.of(similarImplementor), false);
        this.map.put(SqlStdOperatorTable.CASE, new CaseImplementor());
        this.defineImplementor(SqlStdOperatorTable.CAST, NullPolicy.STRICT, new CastImplementor(), false);
        this.defineImplementor(SqlStdOperatorTable.REINTERPRET, NullPolicy.STRICT, new ReinterpretImplementor(), false);
        ValueConstructorImplementor value = new ValueConstructorImplementor();
        this.map.put(SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR, value);
        this.map.put(SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, value);
        this.map.put(SqlStdOperatorTable.ITEM, new ItemImplementor());
        SystemFunctionImplementor systemFunctionImplementor = new SystemFunctionImplementor();
        this.map.put(SqlStdOperatorTable.USER, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_USER, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.SESSION_USER, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.SYSTEM_USER, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_PATH, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_ROLE, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_TIME, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_TIMESTAMP, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_DATE, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.LOCALTIME, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.LOCALTIMESTAMP, systemFunctionImplementor);
        this.aggMap.put(SqlStdOperatorTable.COUNT, new BuiltinAggregateImplementor("longCount"));
        this.aggMap.put(SqlStdOperatorTable.SUM, new BuiltinAggregateImplementor("sum"));
        this.aggMap.put(SqlStdOperatorTable.MIN, new BuiltinAggregateImplementor("min"));
        this.aggMap.put(SqlStdOperatorTable.MAX, new BuiltinAggregateImplementor("max"));
        this.agg2Map.put(SqlStdOperatorTable.COUNT, new CountImplementor2());
        this.agg2Map.put(SqlStdOperatorTable.SUM, new SumImplementor2());
        this.agg2Map.put(SqlStdOperatorTable.SUM0, new SumImplementor2());
        MinMaxImplementor2 minMax = new MinMaxImplementor2();
        this.agg2Map.put(SqlStdOperatorTable.MIN, minMax);
        this.agg2Map.put(SqlStdOperatorTable.MAX, minMax);
        this.agg2Map.put(SqlStdOperatorTable.RANK, new RankImplementor2());
    }

    private void defineImplementor(SqlOperator operator, NullPolicy nullPolicy, NotNullImplementor implementor, boolean harmonize) {
        CallImplementor callImplementor = RexImpTable.createImplementor(implementor, nullPolicy, harmonize);
        this.map.put(operator, callImplementor);
    }

    private static RexCall call2(boolean harmonize, RexToLixTranslator translator, RexCall call) {
        if (!harmonize) {
            return call;
        }
        List<RexNode> operands2 = RexImpTable.harmonize(translator, call.getOperands());
        if (operands2.equals(call.getOperands())) {
            return call;
        }
        return call.clone(call.getType(), operands2);
    }

    private static CallImplementor createImplementor(final NotNullImplementor implementor, final NullPolicy nullPolicy, final boolean harmonize) {
        switch (nullPolicy) {
            case STRICT: 
            case ANY: {
                return new CallImplementor(){

                    public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
                        return RexImpTable.implementNullSemantics0(translator, call, nullAs, nullPolicy, harmonize, implementor);
                    }
                };
            }
            case AND: {
                return new CallImplementor(){

                    public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
                        RexCall call2 = RexImpTable.call2(false, translator, call);
                        final NullAs nullAs2 = nullAs == NullAs.TRUE ? NullAs.NULL : nullAs;
                        List<Expression> expressions = translator.translateList(call2.getOperands(), nullAs2);
                        switch (nullAs) {
                            case TRUE: 
                            case NOT_POSSIBLE: {
                                return Expressions.foldAnd(expressions);
                            }
                        }
                        return Expressions.foldAnd((List)Lists.transform(expressions, (com.google.common.base.Function)new com.google.common.base.Function<Expression, Expression>(){

                            public Expression apply(Expression e) {
                                return nullAs2.handle(e);
                            }
                        }));
                    }
                };
            }
            case OR: {
                return new CallImplementor(){

                    public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
                        RexCall call2 = RexImpTable.call2(harmonize, translator, call);
                        NullAs nullAs2 = nullAs == NullAs.TRUE ? NullAs.NULL : nullAs;
                        List<Expression> expressions = translator.translateList(call2.getOperands(), nullAs2);
                        switch (nullAs) {
                            case FALSE: 
                            case NOT_POSSIBLE: {
                                return Expressions.foldOr(expressions);
                            }
                        }
                        Expression t0 = expressions.get(0);
                        Expression t1 = expressions.get(1);
                        if (!RexImpTable.nullable(call2, 0) && !RexImpTable.nullable(call2, 1)) {
                            return Expressions.orElse((Expression)t0, (Expression)t1);
                        }
                        return RexImpTable.optimize(Expressions.condition((Expression)Expressions.equal((Expression)t0, (Expression)NULL_EXPR), (Expression)Expressions.condition((Expression)Expressions.orElse((Expression)Expressions.equal((Expression)t1, (Expression)NULL_EXPR), (Expression)Expressions.not((Expression)t1)), (Expression)NULL_EXPR, (Expression)BOXED_TRUE_EXPR), (Expression)Expressions.condition((Expression)Expressions.not((Expression)t0), (Expression)t1, (Expression)BOXED_TRUE_EXPR)));
                    }
                };
            }
            case NOT: {
                return new CallImplementor(){

                    public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
                        NullAs nullAs2;
                        switch (nullAs) {
                            case FALSE: {
                                nullAs2 = NullAs.TRUE;
                                break;
                            }
                            case TRUE: {
                                nullAs2 = NullAs.FALSE;
                                break;
                            }
                            default: {
                                nullAs2 = nullAs;
                            }
                        }
                        return RexImpTable.implementNullSemantics0(translator, call, nullAs2, nullPolicy, harmonize, implementor);
                    }
                };
            }
            case NONE: {
                return new CallImplementor(){

                    public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
                        RexCall call2 = RexImpTable.call2(false, translator, call);
                        return RexImpTable.implementCall(translator, call2, implementor, nullAs);
                    }
                };
            }
        }
        throw new AssertionError((Object)nullPolicy);
    }

    private void defineMethod(SqlOperator operator, String functionName, NullPolicy nullPolicy) {
        this.defineImplementor(operator, nullPolicy, new MethodNameImplementor(functionName), false);
    }

    private void defineMethod(SqlOperator operator, Method method, NullPolicy nullPolicy) {
        this.defineImplementor(operator, nullPolicy, new MethodImplementor(method), false);
    }

    private void defineUnary(SqlOperator operator, ExpressionType expressionType, NullPolicy nullPolicy) {
        this.defineImplementor(operator, nullPolicy, new UnaryImplementor(expressionType), false);
    }

    private void defineBinary(SqlOperator operator, ExpressionType expressionType, NullPolicy nullPolicy, String backupMethodName) {
        this.defineImplementor(operator, nullPolicy, new BinaryImplementor(expressionType, backupMethodName), true);
    }

    public CallImplementor get(SqlOperator operator) {
        if (operator instanceof SqlUserDefinedFunction) {
            return UDF_IMPLEMENTOR;
        }
        return this.map.get(operator);
    }

    public AggregateImplementor get(Aggregation aggregation) {
        return this.aggMap.get(aggregation);
    }

    public AggImplementor2 get2(Aggregation aggregation) {
        return this.agg2Map.get(aggregation);
    }

    static Expression maybeNegate(boolean negate, Expression expression) {
        if (!negate) {
            return expression;
        }
        return Expressions.not((Expression)expression);
    }

    static Expression optimize(Expression expression) {
        return expression.accept((Visitor)new OptimizeVisitor());
    }

    static Expression optimize2(Expression operand, Expression expression) {
        if (Primitive.is((Type)operand.getType())) {
            return RexImpTable.optimize(expression);
        }
        return RexImpTable.optimize(Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)NULL_EXPR), (Expression)NULL_EXPR, (Expression)expression));
    }

    private static boolean nullable(RexCall call, int i) {
        return call.getOperands().get(i).getType().isNullable();
    }

    private static List<RexNode> harmonize(RexToLixTranslator translator, List<RexNode> operands) {
        int nullCount = 0;
        ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        RelDataTypeFactory typeFactory = translator.builder.getTypeFactory();
        for (RexNode operand : operands) {
            RelDataType type = operand.getType();
            type = RexImpTable.toSql(typeFactory, type);
            if (translator.isNullable(operand)) {
                ++nullCount;
            } else {
                type = typeFactory.createTypeWithNullability(type, false);
            }
            types.add(type);
        }
        if (RexImpTable.allSame(types)) {
            return operands;
        }
        RelDataType type = typeFactory.leastRestrictive(types);
        if (type == null) {
            return operands;
        }
        assert (nullCount > 0 == type.isNullable());
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        for (RexNode operand : operands) {
            list.add(translator.builder.ensureType(type, operand, false));
        }
        return list;
    }

    private static RelDataType toSql(RelDataTypeFactory typeFactory, RelDataType type) {
        SqlTypeName typeName;
        if (type instanceof RelDataTypeFactoryImpl.JavaType && (typeName = type.getSqlTypeName()) != null && typeName != SqlTypeName.OTHER) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(typeName), type.isNullable());
        }
        return type;
    }

    private static <E> boolean allSame(List<E> list) {
        Object prev = null;
        for (E e : list) {
            if (prev != null && !prev.equals(e)) {
                return false;
            }
            prev = e;
        }
        return true;
    }

    private static Expression implementNullSemantics0(RexToLixTranslator translator, RexCall call, NullAs nullAs, NullPolicy nullPolicy, boolean harmonize, NotNullImplementor implementor) {
        switch (nullAs) {
            case IS_NOT_NULL: {
                if (nullPolicy != NullPolicy.STRICT) break;
                return Expressions.foldAnd(translator.translateList(call.getOperands(), nullAs));
            }
            case IS_NULL: {
                if (nullPolicy != NullPolicy.STRICT) break;
                return Expressions.foldOr(translator.translateList(call.getOperands(), nullAs));
            }
        }
        RexCall call2 = RexImpTable.call2(harmonize, translator, call);
        try {
            return RexImpTable.implementNullSemantics(translator, call2, nullAs, implementor);
        }
        catch (RexToLixTranslator.AlwaysNull e) {
            switch (nullAs) {
                case NOT_POSSIBLE: {
                    throw e;
                }
                case FALSE: {
                    return FALSE_EXPR;
                }
                case TRUE: {
                    return TRUE_EXPR;
                }
            }
            return NULL_EXPR;
        }
    }

    private static Expression implementNullSemantics(RexToLixTranslator translator, RexCall call, NullAs nullAs, NotNullImplementor implementor) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        switch (nullAs) {
            case NULL: {
                for (Ord operand : Ord.zip(call.getOperands())) {
                    if (!translator.isNullable((RexNode)operand.e)) continue;
                    list.add(translator.translate((RexNode)operand.e, NullAs.IS_NULL));
                    translator = translator.setNullable((RexNode)operand.e, false);
                }
                Expression box = Expressions.box((Expression)RexImpTable.implementCall(translator, call, implementor, nullAs));
                return RexImpTable.optimize(Expressions.condition((Expression)Expressions.foldOr(list), (Expression)Types.castIfNecessary((Type)box.getType(), (Expression)NULL_EXPR), (Expression)box));
            }
            case FALSE: {
                for (Ord operand : Ord.zip(call.getOperands())) {
                    if (!translator.isNullable((RexNode)operand.e)) continue;
                    list.add(translator.translate((RexNode)operand.e, NullAs.IS_NOT_NULL));
                    translator = translator.setNullable((RexNode)operand.e, false);
                }
                list.add(RexImpTable.implementCall(translator, call, implementor, nullAs));
                return Expressions.foldAnd(list);
            }
            case NOT_POSSIBLE: {
                translator = translator.setNullable(call, false);
            }
        }
        return RexImpTable.implementCall(translator, call, implementor, nullAs);
    }

    private static Expression implementCall(RexToLixTranslator translator, RexCall call, NotNullImplementor implementor, NullAs nullAs) {
        List<Expression> translatedOperands = translator.translateList(call.getOperands());
        switch (nullAs) {
            case NULL: 
            case NOT_POSSIBLE: {
                for (Expression translatedOperand : translatedOperands) {
                    if (!Expressions.isConstantNull((Expression)translatedOperand)) continue;
                    return NULL_EXPR;
                }
                break;
            }
        }
        return implementor.implement(translator, call, translatedOperands);
    }

    static abstract class AbstractCallImplementor
    implements CallImplementor {
        AbstractCallImplementor() {
        }

        abstract Expression implement(RexToLixTranslator var1, RexCall var2);

        public final Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            return nullAs.handle(this.implement(translator, call));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface AggImplementor2 {
        public boolean callOnNull();

        public Expression implementInit(Aggregation var1, Type var2, List<Type> var3);

        public Expression implementAdd(Aggregation var1, Expression var2, List<Expression> var3);

        public Expression implementResult(Aggregation var1, Expression var2);
    }

    static interface AggregateImplementor {
        public Expression implementAggregate(Expression var1, Expression var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BinaryImplementor
    implements NotNullImplementor {
        private static final List<Primitive> COMP_OP_TYPES = Arrays.asList(Primitive.BYTE, Primitive.CHAR, Primitive.SHORT, Primitive.INT, Primitive.LONG, Primitive.FLOAT, Primitive.DOUBLE);
        private static final List<SqlBinaryOperator> COMPARISON_OPERATORS = Arrays.asList(SqlStdOperatorTable.LESS_THAN, SqlStdOperatorTable.LESS_THAN_OR_EQUAL, SqlStdOperatorTable.GREATER_THAN, SqlStdOperatorTable.GREATER_THAN_OR_EQUAL);
        private final ExpressionType expressionType;
        private final String backupMethodName;

        BinaryImplementor(ExpressionType expressionType, String backupMethodName) {
            this.expressionType = expressionType;
            this.backupMethodName = backupMethodName;
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> expressions) {
            if (this.backupMethodName != null) {
                Primitive primitive = Primitive.ofBoxOr((Type)expressions.get(0).getType());
                SqlBinaryOperator op = (SqlBinaryOperator)call.getOperator();
                if (primitive == null || COMPARISON_OPERATORS.contains(op) && !COMP_OP_TYPES.contains(primitive)) {
                    return Expressions.call(SqlFunctions.class, (String)this.backupMethodName, expressions);
                }
            }
            return Expressions.makeBinary((ExpressionType)this.expressionType, (Expression)expressions.get(0), (Expression)expressions.get(1));
        }
    }

    static class BuiltinAggregateImplementor
    implements AggregateImplementor {
        private final String methodName;

        public BuiltinAggregateImplementor(String methodName) {
            this.methodName = methodName;
        }

        public Expression implementAggregate(Expression grouping, Expression accessor) {
            return accessor == null ? Expressions.call((Expression)grouping, (String)this.methodName, (Expression[])new Expression[0]) : Expressions.call((Expression)grouping, (String)this.methodName, (Expression[])new Expression[]{accessor});
        }
    }

    static interface CallImplementor {
        public Expression implement(RexToLixTranslator var1, RexCall var2, NullAs var3);
    }

    private static class CaseImplementor
    extends AbstractCallImplementor {
        private CaseImplementor() {
        }

        public Expression implement(RexToLixTranslator translator, RexCall call) {
            return this.implementRecurse(translator, call, 0);
        }

        private Expression implementRecurse(RexToLixTranslator translator, RexCall call, int i) {
            List<RexNode> operands = call.getOperands();
            if (i == operands.size() - 1) {
                return translator.translate(translator.builder.ensureType(call.getType(), operands.get(i), false));
            }
            return Expressions.condition((Expression)translator.translate(operands.get(i), NullAs.FALSE), (Expression)translator.translate(translator.builder.ensureType(call.getType(), operands.get(i + 1), false)), (Expression)this.implementRecurse(translator, call, i + 2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CastImplementor
    implements NotNullImplementor {
        private CastImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            assert (call.getOperands().size() == 1);
            RelDataType sourceType = call.getOperands().get(0).getType();
            boolean nullable = translator.isNullable(call) && sourceType.isNullable() && !Primitive.is((Type)translatedOperands.get(0).getType());
            RelDataType targetType = translator.nullifyType(call.getType(), nullable);
            return translator.translateCast(sourceType, targetType, translatedOperands.get(0));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CountImplementor2
    implements AggImplementor2 {
        CountImplementor2() {
        }

        @Override
        public boolean callOnNull() {
            return false;
        }

        @Override
        public Expression implementInit(Aggregation aggregation, Type returnType, List<Type> parameterTypes) {
            return Expressions.constant((Object)0, (Type)returnType);
        }

        @Override
        public Expression implementAdd(Aggregation aggregation, Expression accumulator, List<Expression> arguments) {
            return Expressions.add((Expression)accumulator, (Expression)Expressions.constant((Object)1, (Type)accumulator.type));
        }

        @Override
        public Expression implementResult(Aggregation aggregation, Expression accumulator) {
            return accumulator;
        }
    }

    private static class IsXxxImplementor
    implements CallImplementor {
        private final Boolean seek;
        private final boolean negate;

        public IsXxxImplementor(Boolean seek, boolean negate) {
            this.seek = seek;
            this.negate = negate;
        }

        public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            List<RexNode> operands = call.getOperands();
            assert (operands.size() == 1);
            if (this.seek == null) {
                return translator.translate(operands.get(0), this.negate ? NullAs.IS_NOT_NULL : NullAs.IS_NULL);
            }
            return RexImpTable.maybeNegate(this.negate == this.seek, translator.translate(operands.get(0), this.seek != false ? NullAs.FALSE : NullAs.TRUE));
        }
    }

    private static class ItemImplementor
    implements CallImplementor {
        private ItemImplementor() {
        }

        public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            MethodImplementor implementor = this.getImplementor(call.getOperands().get(0).getType().getSqlTypeName());
            return RexImpTable.implementNullSemantics0(translator, call, nullAs, NullPolicy.STRICT, false, implementor);
        }

        private MethodImplementor getImplementor(SqlTypeName sqlTypeName) {
            switch (sqlTypeName) {
                case ARRAY: {
                    return new MethodImplementor(BuiltinMethod.ARRAY_ITEM.method);
                }
                case MAP: {
                    return new MethodImplementor(BuiltinMethod.MAP_ITEM.method);
                }
            }
            return new MethodImplementor(BuiltinMethod.ANY_ITEM.method);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodImplementor
    implements NotNullImplementor {
        private final Method method;

        MethodImplementor(Method method) {
            this.method = method;
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            return Expressions.call((Method)this.method, translatedOperands);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodNameImplementor
    implements NotNullImplementor {
        private final String methodName;

        MethodNameImplementor(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            return Expressions.call(SqlFunctions.class, (String)this.methodName, translatedOperands);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MinMaxImplementor2
    implements AggImplementor2 {
        MinMaxImplementor2() {
        }

        @Override
        public boolean callOnNull() {
            return false;
        }

        @Override
        public Expression implementInit(Aggregation aggregation, Type returnType, List<Type> parameterTypes) {
            Primitive primitive = Primitive.of((Type)returnType);
            if (primitive != null) {
                returnType = primitive.boxClass;
            }
            return Types.castIfNecessary((Type)returnType, (Expression)NULL_EXPR);
        }

        @Override
        public Expression implementAdd(Aggregation aggregation, Expression accumulator, List<Expression> arguments) {
            assert (arguments.size() == 1);
            Expression arg = arguments.get(0);
            return RexImpTable.optimize(Expressions.condition((Expression)Expressions.foldOr((List)Expressions.list((Object[])new Expression[]{Expressions.equal((Expression)accumulator, (Expression)NULL_EXPR)}).appendIf(!Primitive.is((Type)arg.type), (Object)Expressions.equal((Expression)arg, (Expression)NULL_EXPR))), (Expression)arg, (Expression)Expressions.convert_((Expression)Expressions.call(SqlFunctions.class, (String)(aggregation == SqlStdOperatorTable.MIN ? "lesser" : "greater"), (Expression[])new Expression[]{Expressions.unbox((Expression)accumulator), Expressions.unbox((Expression)arg)}), (Type)arg.getType())));
        }

        @Override
        public Expression implementResult(Aggregation aggregation, Expression accumulator) {
            return accumulator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotImplementor
    implements NotNullImplementor {
        private final NotNullImplementor implementor;

        public NotImplementor(NotNullImplementor implementor) {
            this.implementor = implementor;
        }

        private static NotNullImplementor of(NotNullImplementor implementor) {
            return new NotImplementor(implementor);
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            Expression expression = this.implementor.implement(translator, call, translatedOperands);
            return Expressions.not((Expression)expression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface NotNullImplementor {
        public Expression implement(RexToLixTranslator var1, RexCall var2, List<Expression> var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NullAs {
        NULL,
        FALSE,
        TRUE,
        NOT_POSSIBLE,
        IS_NULL,
        IS_NOT_NULL;


        public static NullAs of(boolean nullable) {
            return nullable ? NULL : NOT_POSSIBLE;
        }

        public Expression handle(Expression x) {
            switch (Primitive.flavor((Type)x.getType())) {
                case PRIMITIVE: {
                    switch (this) {
                        case NULL: 
                        case FALSE: 
                        case TRUE: 
                        case NOT_POSSIBLE: {
                            return x;
                        }
                        case IS_NULL: {
                            return FALSE_EXPR;
                        }
                        case IS_NOT_NULL: {
                            return TRUE_EXPR;
                        }
                    }
                    throw new AssertionError();
                }
                case BOX: {
                    switch (this) {
                        case NOT_POSSIBLE: {
                            return RexToLixTranslator.convert(x, Primitive.ofBox((Type)x.getType()).primitiveClass);
                        }
                    }
                }
            }
            switch (this) {
                case NULL: 
                case NOT_POSSIBLE: {
                    return x;
                }
                case FALSE: {
                    return Expressions.call((Method)BuiltinMethod.IS_TRUE.method, (Expression[])new Expression[]{x});
                }
                case TRUE: {
                    return Expressions.call((Method)BuiltinMethod.IS_NOT_FALSE.method, (Expression[])new Expression[]{x});
                }
                case IS_NULL: {
                    return Expressions.equal((Expression)x, (Expression)NULL_EXPR);
                }
                case IS_NOT_NULL: {
                    return Expressions.notEqual((Expression)x, (Expression)NULL_EXPR);
                }
            }
            throw new AssertionError();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NullPolicy {
        STRICT,
        ANY,
        AND,
        OR,
        NOT,
        NONE;

    }

    static class OptimizeVisitor
    extends Visitor {
        OptimizeVisitor() {
        }

        public Expression visit(TernaryExpression ternaryExpression, Expression expression0, Expression expression1, Expression expression2) {
            TernaryExpression ternary = (TernaryExpression)super.visit(ternaryExpression, expression0, expression1, expression2);
            switch (ternary.getNodeType()) {
                case Conditional: {
                    Boolean always = OptimizeVisitor.always(ternary.expression0);
                    if (always != null) {
                        return always != false ? ternary.expression1 : ternary.expression2;
                    }
                    if (!ternary.expression1.equals(ternary.expression2)) break;
                    return ternary.expression1;
                }
            }
            return ternary;
        }

        public Expression visit(BinaryExpression binaryExpression, Expression expression0, Expression expression1) {
            BinaryExpression binary = (BinaryExpression)super.visit(binaryExpression, expression0, expression1);
            switch (binary.getNodeType()) {
                case AndAlso: {
                    Boolean always = OptimizeVisitor.always(binary.expression0);
                    if (always != null) {
                        return always != false ? binary.expression1 : FALSE_EXPR;
                    }
                    always = OptimizeVisitor.always(binary.expression1);
                    if (always == null) break;
                    return always != false ? binary.expression0 : FALSE_EXPR;
                }
                case OrElse: {
                    Boolean always = OptimizeVisitor.always(binary.expression0);
                    if (always != null) {
                        return always == false ? binary.expression1 : TRUE_EXPR;
                    }
                    always = OptimizeVisitor.always(binary.expression1);
                    if (always == null) break;
                    return always == false ? binary.expression0 : TRUE_EXPR;
                }
                case Equal: {
                    if (binary.expression0 instanceof ConstantExpression && binary.expression1 instanceof ConstantExpression) {
                        return binary.expression0.equals(binary.expression1) ? TRUE_EXPR : FALSE_EXPR;
                    }
                    if (this.isConstantNull(binary.expression1) && Primitive.is((Type)binary.expression0.getType())) {
                        return FALSE_EXPR;
                    }
                    if (!this.isConstantNull(binary.expression0) || !Primitive.is((Type)binary.expression1.getType())) break;
                    return FALSE_EXPR;
                }
                case NotEqual: {
                    if (binary.expression0 instanceof ConstantExpression && binary.expression1 instanceof ConstantExpression) {
                        return !binary.expression0.equals(binary.expression1) ? TRUE_EXPR : FALSE_EXPR;
                    }
                    if (this.isConstantNull(binary.expression1) && Primitive.is((Type)binary.expression0.getType())) {
                        return TRUE_EXPR;
                    }
                    if (!this.isConstantNull(binary.expression0) || !Primitive.is((Type)binary.expression1.getType())) break;
                    return TRUE_EXPR;
                }
            }
            return binary;
        }

        private boolean isConstantNull(Expression expression) {
            return expression instanceof ConstantExpression && ((ConstantExpression)expression).value == null;
        }

        private static Boolean always(Expression x) {
            if (x.equals(FALSE_EXPR) || x.equals(BOXED_FALSE_EXPR)) {
                return Boolean.FALSE;
            }
            if (x.equals(TRUE_EXPR) || x.equals(BOXED_TRUE_EXPR)) {
                return Boolean.TRUE;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RankImplementor2
    implements WinAggImplementor {
        RankImplementor2() {
        }

        @Override
        public boolean callOnNull() {
            return false;
        }

        @Override
        public Expression implementInit(Aggregation aggregation, Type returnType, List<Type> parameterTypes) {
            return Expressions.constant((Object)0, (Type)returnType);
        }

        @Override
        public Expression implementAdd(Aggregation aggregation, Expression accumulator, List<Expression> arguments) {
            return accumulator;
        }

        @Override
        public Expression implementResult(Aggregation aggregation, Expression accumulator) {
            return accumulator;
        }

        @Override
        public Expression implementResultPlus(Aggregation aggregation, Expression accumulator, Expression start, Expression end, Expression rows, Expression current) {
            return Expressions.add((Expression)current, (Expression)Expressions.constant((Object)1));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReinterpretImplementor
    implements NotNullImplementor {
        private ReinterpretImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            assert (call.getOperands().size() == 1);
            return translatedOperands.get(0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SumImplementor2
    implements AggImplementor2 {
        SumImplementor2() {
        }

        @Override
        public boolean callOnNull() {
            return false;
        }

        @Override
        public Expression implementInit(Aggregation aggregation, Type returnType, List<Type> parameterTypes) {
            Primitive primitive = this.choosePrimitive(returnType);
            assert (primitive != null);
            return Expressions.constant((Object)primitive.number((Number)0), (Type)returnType);
        }

        private Primitive choosePrimitive(Type returnType) {
            switch (Primitive.flavor((Type)returnType)) {
                case PRIMITIVE: {
                    return Primitive.of((Type)returnType);
                }
                case BOX: {
                    return Primitive.ofBox((Type)returnType);
                }
            }
            assert (returnType == BigDecimal.class) : "expected primitive or boxed primitive, got " + returnType;
            return Primitive.INT;
        }

        @Override
        public Expression implementAdd(Aggregation aggregation, Expression accumulator, List<Expression> arguments) {
            assert (arguments.size() == 1);
            if (accumulator.type == BigDecimal.class || accumulator.type == BigInteger.class) {
                return Expressions.call((Expression)accumulator, (String)"add", (Expression[])new Expression[]{arguments.get(0)});
            }
            return Types.castIfNecessary((Type)accumulator.type, (Expression)Expressions.add((Expression)accumulator, (Expression)Types.castIfNecessary((Type)accumulator.type, (Expression)arguments.get(0))));
        }

        @Override
        public Expression implementResult(Aggregation aggregation, Expression accumulator) {
            return accumulator;
        }
    }

    private static class SystemFunctionImplementor
    implements CallImplementor {
        private SystemFunctionImplementor() {
        }

        public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            switch (nullAs) {
                case IS_NULL: {
                    return Expressions.constant((Object)false);
                }
                case IS_NOT_NULL: {
                    return Expressions.constant((Object)true);
                }
            }
            SqlOperator op = call.getOperator();
            if (op == SqlStdOperatorTable.CURRENT_USER || op == SqlStdOperatorTable.SESSION_USER || op == SqlStdOperatorTable.USER) {
                return Expressions.constant((Object)"sa");
            }
            if (op == SqlStdOperatorTable.SYSTEM_USER) {
                return Expressions.constant((Object)System.getProperty("user.name"));
            }
            if (op == SqlStdOperatorTable.CURRENT_PATH || op == SqlStdOperatorTable.CURRENT_ROLE) {
                return Expressions.constant((Object)"");
            }
            if (op == SqlStdOperatorTable.CURRENT_TIMESTAMP) {
                return Expressions.call((Method)BuiltinMethod.CURRENT_TIMESTAMP.method, (Expression[])new Expression[]{DataContext.ROOT});
            }
            if (op == SqlStdOperatorTable.CURRENT_TIME) {
                return Expressions.call((Method)BuiltinMethod.CURRENT_TIME.method, (Expression[])new Expression[]{DataContext.ROOT});
            }
            if (op == SqlStdOperatorTable.CURRENT_DATE) {
                return Expressions.call((Method)BuiltinMethod.CURRENT_DATE.method, (Expression[])new Expression[]{DataContext.ROOT});
            }
            if (op == SqlStdOperatorTable.LOCALTIMESTAMP) {
                return Expressions.call((Method)BuiltinMethod.LOCAL_TIMESTAMP.method, (Expression[])new Expression[]{DataContext.ROOT});
            }
            if (op == SqlStdOperatorTable.LOCALTIME) {
                return Expressions.call((Method)BuiltinMethod.LOCAL_TIME.method, (Expression[])new Expression[]{DataContext.ROOT});
            }
            throw new AssertionError((Object)("unknown function " + op));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TrimImplementor
    implements NotNullImplementor {
        private TrimImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            Object value = ((ConstantExpression)translatedOperands.get((int)0)).value;
            SqlTrimFunction.Flag flag = (SqlTrimFunction.Flag)value;
            return Expressions.call((Method)BuiltinMethod.TRIM.method, (Expression[])new Expression[]{Expressions.constant((Object)(flag == SqlTrimFunction.Flag.BOTH || flag == SqlTrimFunction.Flag.LEADING ? 1 : 0)), Expressions.constant((Object)(flag == SqlTrimFunction.Flag.BOTH || flag == SqlTrimFunction.Flag.TRAILING ? 1 : 0)), translatedOperands.get(1), translatedOperands.get(2)});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnaryImplementor
    implements NotNullImplementor {
        private final ExpressionType expressionType;

        UnaryImplementor(ExpressionType expressionType) {
            this.expressionType = expressionType;
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            return Expressions.makeUnary((ExpressionType)this.expressionType, (Expression)translatedOperands.get(0));
        }
    }

    private static class ValueConstructorImplementor
    implements CallImplementor {
        private ValueConstructorImplementor() {
        }

        public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            return translator.translateConstructor(call.getOperands(), call.getOperator().getKind());
        }
    }

    static interface WinAggImplementor
    extends AggImplementor2 {
        public Expression implementResultPlus(Aggregation var1, Expression var2, Expression var3, Expression var4, Expression var5, Expression var6);
    }
}

