/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.prepare;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.linq4j.expressions.BlockStatement;
import net.hydromatic.linq4j.expressions.Blocks;
import net.hydromatic.linq4j.expressions.ConstantExpression;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.FunctionExpression;
import net.hydromatic.linq4j.expressions.MethodCallExpression;
import net.hydromatic.linq4j.expressions.NewExpression;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import net.hydromatic.optiq.prepare.Prepare;
import net.hydromatic.optiq.prepare.QueryableRelBuilder;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.TableAccessRel;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LixToRelTranslator
implements RelOptTable.ToRelContext {
    final RelOptCluster cluster;
    private final Prepare preparingStmt;
    final JavaTypeFactory typeFactory;

    public LixToRelTranslator(RelOptCluster cluster, Prepare preparingStmt) {
        this.cluster = cluster;
        this.preparingStmt = preparingStmt;
        this.typeFactory = (JavaTypeFactory)cluster.getTypeFactory();
    }

    @Override
    public RelOptCluster getCluster() {
        return this.cluster;
    }

    @Override
    public RelNode expandView(RelDataType rowType, String queryString, List<String> schemaPath) {
        return this.preparingStmt.expandView(rowType, queryString, schemaPath);
    }

    public <T> RelNode translate(Queryable<T> queryable) {
        QueryableRelBuilder<T> translatorQueryable = new QueryableRelBuilder<T>(this);
        return translatorQueryable.toRel(queryable);
    }

    public RelNode translate(Expression expression) {
        if (expression instanceof MethodCallExpression) {
            MethodCallExpression call = (MethodCallExpression)expression;
            BuiltinMethod method = (BuiltinMethod)((Object)BuiltinMethod.MAP.get((Object)call.method));
            if (method == null) {
                throw new UnsupportedOperationException("unknown method " + call.method);
            }
            switch (method) {
                case SELECT: {
                    RelNode child = this.translate(call.targetExpression);
                    return new ProjectRel(this.cluster, child, this.toRex(child, (FunctionExpression)call.expressions.get(0)), null, 1);
                }
                case WHERE: {
                    RelNode child = this.translate(call.targetExpression);
                    return new FilterRel(this.cluster, child, this.toRex((FunctionExpression)call.expressions.get(0), child));
                }
                case AS_QUERYABLE: {
                    return new TableAccessRel(this.cluster, new OptiqPrepareImpl.RelOptTableImpl(null, this.typeFactory.createJavaType(Types.toClass((Type)Types.getElementType((Type)call.targetExpression.getType()))), (List<String>)ImmutableList.of(), call.targetExpression));
                }
                case SCHEMA_GET_TABLE: {
                    return new TableAccessRel(this.cluster, new OptiqPrepareImpl.RelOptTableImpl(null, this.typeFactory.createJavaType((Class)((ConstantExpression)call.expressions.get((int)1)).value), (List<String>)ImmutableList.of(), call.targetExpression));
                }
            }
            throw new UnsupportedOperationException("unknown method " + call.method);
        }
        throw new UnsupportedOperationException("unknown expression type " + expression.getNodeType());
    }

    private List<RexNode> toRex(RelNode child, FunctionExpression expression) {
        RexBuilder rexBuilder = this.cluster.getRexBuilder();
        List<RexNode> list = Collections.singletonList(rexBuilder.makeRangeReference(child));
        OptiqPrepareImpl.ScalarTranslator translator = OptiqPrepareImpl.EmptyScalarTranslator.empty(rexBuilder).bind(expression.parameterList, list);
        ArrayList<RexNode> rexList = new ArrayList<RexNode>();
        Expression simple = Blocks.simple((BlockStatement)expression.body);
        for (Expression expression1 : this.fieldExpressions(simple)) {
            rexList.add(translator.toRex(expression1));
        }
        return rexList;
    }

    List<Expression> fieldExpressions(Expression expression) {
        if (expression instanceof NewExpression) {
            return ((NewExpression)expression).arguments;
        }
        throw new RuntimeException("unsupported expression type " + expression);
    }

    List<RexNode> toRexList(FunctionExpression expression, RelNode ... inputs) {
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        RexBuilder rexBuilder = this.cluster.getRexBuilder();
        RelNode[] relNodeArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            RelNode input = relNodeArray[n2];
            list.add(rexBuilder.makeRangeReference(input));
            ++n2;
        }
        return OptiqPrepareImpl.EmptyScalarTranslator.empty(rexBuilder).bind(expression.parameterList, list).toRexList(expression.body);
    }

    RexNode toRex(FunctionExpression expression, RelNode ... inputs) {
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        RexBuilder rexBuilder = this.cluster.getRexBuilder();
        RelNode[] relNodeArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            RelNode input = relNodeArray[n2];
            list.add(rexBuilder.makeRangeReference(input));
            ++n2;
        }
        return OptiqPrepareImpl.EmptyScalarTranslator.empty(rexBuilder).bind(expression.parameterList, list).toRex(expression.body);
    }
}

