/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.jdbc;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.optiq.Function;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.TableMacro;
import net.hydromatic.optiq.impl.MaterializedViewTable;
import net.hydromatic.optiq.jdbc.OptiqRootSchema;
import net.hydromatic.optiq.util.Compatible;
import net.hydromatic.optiq.util.CompositeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptiqSchema {
    private final OptiqSchema parent;
    public final Schema schema;
    public final String name;
    public final Map<String, TableEntry> tableMap = new HashMap<String, TableEntry>();
    public final Map<String, TableEntry> tableMapInsensitive = new TreeMap<String, TableEntry>(String.CASE_INSENSITIVE_ORDER);
    private final Multimap<String, FunctionEntry> functionMap = LinkedListMultimap.create();
    private final Map<String, FunctionEntry> nullaryFunctionMapInsensitive = new TreeMap<String, FunctionEntry>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, OptiqSchema> subSchemaMap = new HashMap<String, OptiqSchema>();
    private final Map<String, OptiqSchema> subSchemaMapInsensitive = new TreeMap<String, OptiqSchema>(String.CASE_INSENSITIVE_ORDER);
    public final Map<String, Table> compositeTableMap;
    public final Multimap<String, Function> compositeFunctionMap;
    public final Map<String, OptiqSchema> compositeSubSchemaMap;

    public OptiqSchema(OptiqSchema parent, final Schema schema, String name) {
        this.parent = parent;
        this.schema = schema;
        this.name = name;
        assert (parent == null == this instanceof OptiqRootSchema);
        this.compositeTableMap = CompositeMap.of(Maps.transformValues(this.tableMap, (com.google.common.base.Function)new com.google.common.base.Function<TableEntry, Table>(){

            public Table apply(TableEntry input) {
                return input.getTable();
            }
        }), Maps.transformValues((Map)Multimaps.filterEntries(this.functionMap, (Predicate)new Predicate<Map.Entry<String, FunctionEntry>>(){

            public boolean apply(Map.Entry<String, FunctionEntry> entry) {
                Function function = entry.getValue().getFunction();
                return function instanceof TableMacro && function.getParameters().isEmpty();
            }
        }).asMap(), (com.google.common.base.Function)new com.google.common.base.Function<Collection<FunctionEntry>, Table>(){

            public Table apply(Collection<FunctionEntry> input) {
                TableMacro tableMacro = (TableMacro)input.iterator().next().getFunction();
                return tableMacro.apply((List<Object>)ImmutableList.of());
            }
        }), Compatible.INSTANCE.asMap(schema.getTableNames(), new com.google.common.base.Function<String, Table>(){

            public Table apply(String input) {
                return schema.getTable(input);
            }
        }));
        this.compositeFunctionMap = Multimaps.transformValues(this.functionMap, (com.google.common.base.Function)new com.google.common.base.Function<FunctionEntry, Function>(){

            public Function apply(FunctionEntry input) {
                return input.getFunction();
            }
        });
        this.compositeSubSchemaMap = CompositeMap.of(this.subSchemaMap, Compatible.INSTANCE.asMap(schema.getSubSchemaNames(), new com.google.common.base.Function<String, OptiqSchema>(){

            public OptiqSchema apply(String name) {
                return OptiqSchema.this.add(name, schema.getSubSchema(name));
            }
        }));
    }

    public TableEntry add(String tableName, Table table) {
        TableEntryImpl entry = new TableEntryImpl(this, tableName, table);
        this.tableMap.put(tableName, entry);
        this.tableMapInsensitive.put(tableName, entry);
        return entry;
    }

    private FunctionEntry add(String name, Function function) {
        FunctionEntryImpl entry = new FunctionEntryImpl(this, name, function);
        this.functionMap.put((Object)name, (Object)entry);
        if (function.getParameters().isEmpty()) {
            this.nullaryFunctionMapInsensitive.put(name, entry);
        }
        return entry;
    }

    public OptiqRootSchema root() {
        OptiqSchema schema = this;
        while (schema.parent != null) {
            schema = schema.parent;
        }
        return (OptiqRootSchema)schema;
    }

    public List<String> path(String name) {
        ArrayList<String> list = new ArrayList<String>();
        if (name != null) {
            list.add(name);
        }
        OptiqSchema s = this;
        while (s != null) {
            if (s.parent != null || !s.name.equals("")) {
                list.add(s.name);
            }
            s = s.parent;
        }
        return ImmutableList.copyOf((Collection)Lists.reverse(list));
    }

    public final OptiqSchema getSubSchema(String schemaName, boolean caseSensitive) {
        return (caseSensitive ? this.subSchemaMap : this.subSchemaMapInsensitive).get(schemaName);
    }

    public OptiqSchema add(String name, Schema schema) {
        OptiqSchema optiqSchema = new OptiqSchema(this, schema, name);
        this.subSchemaMap.put(name, optiqSchema);
        this.subSchemaMapInsensitive.put(name, optiqSchema);
        return optiqSchema;
    }

    public final Table getTable(String tableName, boolean caseSensitive) {
        if (caseSensitive) {
            return this.compositeTableMap.get(tableName);
        }
        TableEntry tableEntry = this.tableMapInsensitive.get(tableName);
        if (tableEntry != null) {
            return tableEntry.getTable();
        }
        FunctionEntry entry = this.nullaryFunctionMapInsensitive.get(tableName);
        if (entry != null) {
            return ((TableMacro)entry.getFunction()).apply((List<Object>)ImmutableList.of());
        }
        for (String name : this.schema.getTableNames()) {
            if (!name.equalsIgnoreCase(tableName)) continue;
            return this.schema.getTable(name);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public SchemaPlus plus() {
        return new SchemaPlusImpl();
    }

    public static OptiqSchema from(SchemaPlus plus) {
        return ((SchemaPlusImpl)plus).optiqSchema();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Entry {
        public final OptiqSchema schema;
        public final String name;

        public Entry(OptiqSchema schema, String name) {
            Linq4j.requireNonNull((Object)schema);
            Linq4j.requireNonNull((Object)name);
            this.schema = schema;
            this.name = name;
        }

        public final List<String> path() {
            return this.schema.path(this.name);
        }
    }

    public static abstract class FunctionEntry
    extends Entry {
        public FunctionEntry(OptiqSchema schema, String name) {
            super(schema, name);
        }

        public abstract Function getFunction();

        public abstract boolean isMaterialization();
    }

    public static class FunctionEntryImpl
    extends FunctionEntry {
        private final Function function;

        public FunctionEntryImpl(OptiqSchema schema, String name, Function function) {
            super(schema, name);
            this.function = function;
        }

        public Function getFunction() {
            return this.function;
        }

        public boolean isMaterialization() {
            return this.function instanceof MaterializedViewTable.MaterializedViewTableMacro;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SchemaPlusImpl
    implements SchemaPlus {
        private SchemaPlusImpl() {
        }

        public OptiqSchema optiqSchema() {
            return OptiqSchema.this;
        }

        @Override
        public SchemaPlus getParentSchema() {
            return OptiqSchema.this.parent == null ? null : OptiqSchema.this.parent.plus();
        }

        @Override
        public String getName() {
            return OptiqSchema.this.getName();
        }

        @Override
        public boolean isMutable() {
            return OptiqSchema.this.schema.isMutable();
        }

        @Override
        public Expression getExpression(SchemaPlus parentSchema, String name) {
            return OptiqSchema.this.schema.getExpression(parentSchema, name);
        }

        @Override
        public Table getTable(String name) {
            return OptiqSchema.this.compositeTableMap.get(name);
        }

        @Override
        public Set<String> getTableNames() {
            return OptiqSchema.this.compositeTableMap.keySet();
        }

        @Override
        public Collection<Function> getFunctions(String name) {
            return OptiqSchema.this.compositeFunctionMap.get((Object)name);
        }

        @Override
        public Set<String> getFunctionNames() {
            return OptiqSchema.this.compositeFunctionMap.keySet();
        }

        @Override
        public SchemaPlus getSubSchema(String name) {
            OptiqSchema subSchema = OptiqSchema.this.getSubSchema(name, true);
            return subSchema == null ? null : subSchema.plus();
        }

        @Override
        public Set<String> getSubSchemaNames() {
            return OptiqSchema.this.subSchemaMap.keySet();
        }

        @Override
        public SchemaPlus add(String name, Schema schema) {
            OptiqSchema optiqSchema = OptiqSchema.this.add(name, schema);
            return optiqSchema.plus();
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            if (clazz.isInstance(this)) {
                return clazz.cast(this);
            }
            if (clazz.isInstance(OptiqSchema.this)) {
                return clazz.cast(OptiqSchema.this);
            }
            if (clazz.isInstance(OptiqSchema.this.schema)) {
                return clazz.cast(OptiqSchema.this.schema);
            }
            throw new ClassCastException("not a " + clazz);
        }

        @Override
        public void add(String name, Table table) {
            OptiqSchema.this.add(name, table);
        }

        @Override
        public void add(String name, Function function) {
            OptiqSchema.this.add(name, function);
        }
    }

    public static abstract class TableEntry
    extends Entry {
        public TableEntry(OptiqSchema schema, String name) {
            super(schema, name);
        }

        public abstract Table getTable();
    }

    public static class TableEntryImpl
    extends TableEntry {
        private final Table table;

        public TableEntryImpl(OptiqSchema schema, String name, Table table) {
            super(schema, name);
            assert (table != null);
            this.table = table;
        }

        public Table getTable() {
            return this.table;
        }
    }
}

