/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util;

import java.util.regex.Pattern;
import org.eigenbase.util.Util;
import org.junit.ComparisonFailure;

public abstract class TestUtil {
    private static final Pattern LINE_BREAK_PATTERN = Pattern.compile("\r\n|\r|\n");
    private static final Pattern TAB_PATTERN = Pattern.compile("\t");
    private static final String LINE_BREAK = "\\\\n\"" + Util.LINE_SEPARATOR + " + \"";

    public static void assertEqualsVerbose(String expected, String actual) {
        if (actual == null) {
            if (expected == null) {
                return;
            }
            String message = "Expected:\n" + expected + "\nActual: null";
            throw new ComparisonFailure(message, expected, null);
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        String s = TestUtil.toJavaString(actual);
        String message = "Expected:\n" + expected + "\nActual:\n " + actual + "\nActual java:\n" + s + '\n';
        throw new ComparisonFailure(message, expected, actual);
    }

    public static String quoteForJava(String s) {
        s = Util.replace((String)s, (String)"\\", (String)"\\\\");
        s = Util.replace((String)s, (String)"\"", (String)"\\\"");
        s = LINE_BREAK_PATTERN.matcher(s).replaceAll(LINE_BREAK);
        s = TAB_PATTERN.matcher(s).replaceAll("\\\\t");
        s = "\"" + s + "\"";
        String spurious = " + \n\"\"";
        if (s.endsWith(" + \n\"\"")) {
            s = s.substring(0, s.length() - " + \n\"\"".length());
        }
        return s;
    }

    public static String toJavaString(String s) {
        String spurious;
        s = Util.replace((String)s, (String)"\"", (String)"\\\"");
        s = LINE_BREAK_PATTERN.matcher(s).replaceAll(LINE_BREAK);
        s = TAB_PATTERN.matcher(s).replaceAll("\\\\t");
        if ((s = "\"" + s + "\"").endsWith(spurious = "\n \\+ \"\"")) {
            s = s.substring(0, s.length() - spurious.length());
        }
        return s;
    }

    public static String fold(String ... strings) {
        StringBuilder buf = new StringBuilder();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            buf.append(string);
            buf.append('\n');
            ++n2;
        }
        return buf.toString();
    }

    public static String quotePattern(String s) {
        return s.replaceAll("\\\\", "\\\\").replaceAll("\\.", "\\\\.").replaceAll("\\+", "\\\\+").replaceAll("\\{", "\\\\{").replaceAll("\\}", "\\\\}").replaceAll("\\|", "\\\\||").replaceAll("[$]", "\\\\\\$").replaceAll("\\?", "\\\\?").replaceAll("\\*", "\\\\*").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]");
    }
}

