/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.test;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.jdbc.JavaTypeFactoryImpl;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexProgramBuilder;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.util.TestUtil;
import org.eigenbase.util.Util;
import org.junit.Before;
import org.junit.Test;

public class RexProgramTest {
    private JavaTypeFactory typeFactory;
    private RexBuilder rexBuilder;

    @Before
    public void setUp() {
        this.typeFactory = new JavaTypeFactoryImpl();
        this.rexBuilder = new RexBuilder((RelDataTypeFactory)this.typeFactory);
    }

    @Test
    public void testBuildProgram() {
        RexProgramBuilder builder = this.createProg(0);
        RexProgram program = builder.getProgram(false);
        String programString = program.toString();
        TestUtil.assertEqualsVerbose("(expr#0..1=[{inputs}], expr#2=[+($0, 1)], expr#3=[77], expr#4=[+($0, $1)], expr#5=[+($0, $0)], expr#6=[+($t4, $t2)], a=[$t6], b=[$t5])", programString);
        RexProgram normalizedProgram = RexProgramBuilder.normalize((RexBuilder)this.rexBuilder, (RexProgram)program);
        String normalizedProgramString = normalizedProgram.toString();
        TestUtil.assertEqualsVerbose("(expr#0..1=[{inputs}], expr#2=[+($t0, $t1)], expr#3=[1], expr#4=[+($t0, $t3)], expr#5=[+($t2, $t4)], expr#6=[+($t0, $t0)], a=[$t5], b=[$t6])", normalizedProgramString);
    }

    @Test
    public void testNormalize() {
        RexProgramBuilder builder = this.createProg(0);
        String program = builder.getProgram(true).toString();
        TestUtil.assertEqualsVerbose("(expr#0..1=[{inputs}], expr#2=[+($t0, $t1)], expr#3=[1], expr#4=[+($t0, $t3)], expr#5=[+($t2, $t4)], expr#6=[+($t0, $t0)], a=[$t5], b=[$t6])", program);
    }

    @Test
    public void testElimDups() {
        RexProgramBuilder builder = this.createProg(1);
        String unnormalizedProgram = builder.getProgram(false).toString();
        TestUtil.assertEqualsVerbose("(expr#0..1=[{inputs}], expr#2=[+($0, 1)], expr#3=[77], expr#4=[+($0, $1)], expr#5=[+($0, 1)], expr#6=[+($0, $t5)], expr#7=[+($t4, $t2)], a=[$t7], b=[$t6])", unnormalizedProgram);
        RexProgramBuilder builder2 = this.createProg(1);
        String program2 = builder2.getProgram(true).toString();
        TestUtil.assertEqualsVerbose("(expr#0..1=[{inputs}], expr#2=[+($t0, $t1)], expr#3=[1], expr#4=[+($t0, $t3)], expr#5=[+($t2, $t4)], expr#6=[+($t0, $t4)], a=[$t5], b=[$t6])", program2);
    }

    @Test
    public void testDuplicateAnd() {
        RexProgramBuilder builder = this.createProg(2);
        String program = builder.getProgram(true).toString();
        TestUtil.assertEqualsVerbose("(expr#0..1=[{inputs}], expr#2=[+($t0, $t1)], expr#3=[1], expr#4=[+($t0, $t3)], expr#5=[+($t2, $t4)], expr#6=[+($t0, $t0)], expr#7=[>($t2, $t0)], a=[$t5], b=[$t6], $condition=[$t7])", program);
    }

    private RexProgramBuilder createProg(int variant) {
        RexLocalRef t5;
        assert (variant == 0 || variant == 1 || variant == 2);
        List<RelDataType> types = Arrays.asList(this.typeFactory.createSqlType(SqlTypeName.INTEGER), this.typeFactory.createSqlType(SqlTypeName.INTEGER));
        List<String> names = Arrays.asList("x", "y");
        RelDataType inputRowType = this.typeFactory.createStructType(types, names);
        RexProgramBuilder builder = new RexProgramBuilder(inputRowType, this.rexBuilder);
        RexInputRef i0 = this.rexBuilder.makeInputRef(types.get(0), 0);
        RexLiteral c1 = this.rexBuilder.makeExactLiteral(BigDecimal.ONE);
        RexLocalRef t2 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{i0, c1}));
        RexLiteral c77 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(77L));
        RexLocalRef t3 = builder.addExpr((RexNode)c77);
        Util.discard((Object)t3);
        RexInputRef i1 = this.rexBuilder.makeInputRef(types.get(1), 1);
        RexLocalRef t4 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{i0, i1}));
        switch (variant) {
            case 0: 
            case 2: {
                t5 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{i0, i0}));
                break;
            }
            case 1: {
                RexLocalRef tx = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{i0, c1}));
                t5 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{i0, tx}));
                break;
            }
            default: {
                throw Util.newInternal((String)("unexpected variant " + variant));
            }
        }
        RexLocalRef t6 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{t4, t2}));
        builder.addProject(t6.getIndex(), "a");
        builder.addProject(t5.getIndex(), "b");
        if (variant == 2) {
            RexLocalRef t7 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{t4, i0}));
            RexLocalRef t8 = builder.addExpr(this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{t7, t7}));
            builder.addCondition((RexNode)t8);
            builder.addCondition((RexNode)t7);
        }
        return builder;
    }
}

