/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.hydromatic.optiq.Schemas;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.AbstractRelOptPlanner;
import org.eigenbase.relopt.RelOptCostImpl;
import org.eigenbase.relopt.RelOptMaterialization;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.rex.RexExecutorImpl;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockRelOptPlanner
extends AbstractRelOptPlanner {
    private RelNode root;
    private RelOptRule rule;
    private RelNode transformationResult;
    private long metadataTimestamp = 0L;

    public MockRelOptPlanner() {
        super(RelOptCostImpl.FACTORY);
        this.setExecutor((RelOptPlanner.Executor)new RexExecutorImpl(Schemas.createDataContext(null)));
    }

    public void setRoot(RelNode rel) {
        this.root = rel;
    }

    public RelNode getRoot() {
        return this.root;
    }

    public void addMaterialization(RelOptMaterialization materialization) {
    }

    public void clear() {
        super.clear();
        this.rule = null;
    }

    public boolean addRule(RelOptRule rule) {
        assert (this.rule == null) : "MockRelOptPlanner only supports a single rule";
        this.rule = rule;
        return false;
    }

    public boolean removeRule(RelOptRule rule) {
        return false;
    }

    public RelNode changeTraits(RelNode rel, RelTraitSet toTraits) {
        return rel;
    }

    public RelNode findBestExp() {
        if (this.rule != null) {
            this.matchRecursive(this.root, null, -1);
        }
        return this.root;
    }

    private boolean matchRecursive(RelNode rel, RelNode parent, int ordinalInParent) {
        MockRuleCall call;
        ArrayList<RelNode> bindings = new ArrayList<RelNode>();
        if (this.match(this.rule.getOperand(), rel, bindings) && this.rule.matches((RelOptRuleCall)(call = new MockRuleCall((RelOptPlanner)this, this.rule.getOperand(), bindings.toArray(new RelNode[bindings.size()]))))) {
            this.rule.onMatch((RelOptRuleCall)call);
        }
        if (this.transformationResult != null) {
            if (parent == null) {
                this.root = this.transformationResult;
            } else {
                parent.replaceInput(ordinalInParent, this.transformationResult);
            }
            return true;
        }
        List children = rel.getInputs();
        int i = 0;
        while (i < children.size()) {
            if (this.matchRecursive((RelNode)children.get(i), rel, i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean match(RelOptRuleOperand operand, RelNode rel, List<RelNode> bindings) {
        if (!operand.matches(rel)) {
            return false;
        }
        bindings.add(rel);
        switch (operand.childPolicy) {
            case ANY: {
                return true;
            }
        }
        List childOperands = operand.getChildOperands();
        List childRels = rel.getInputs();
        if (childOperands.size() != childRels.size()) {
            return false;
        }
        for (Pair pair : Pair.zip((List)childOperands, (List)childRels)) {
            if (this.match((RelOptRuleOperand)pair.left, (RelNode)pair.right, bindings)) continue;
            return false;
        }
        return true;
    }

    public RelNode register(RelNode rel, RelNode equivRel) {
        return rel;
    }

    public RelNode ensureRegistered(RelNode rel, RelNode equivRel) {
        return rel;
    }

    public boolean isRegistered(RelNode rel) {
        return true;
    }

    public long getRelMetadataTimestamp(RelNode rel) {
        return this.metadataTimestamp;
    }

    public void setRelMetadataTimestamp(long metadataTimestamp) {
        this.metadataTimestamp = metadataTimestamp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MockRuleCall
    extends RelOptRuleCall {
        MockRuleCall(RelOptPlanner planner, RelOptRuleOperand operand, RelNode[] rels) {
            super(planner, operand, rels, Collections.emptyMap());
        }

        public void transformTo(RelNode rel, Map<RelNode, RelNode> equiv) {
            MockRelOptPlanner.this.transformationResult = rel;
        }
    }
}

