/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.test;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.test.SqlTester;
import org.eigenbase.sql.type.SqlTypeName;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SqlTests {
    public static final SqlTester.TypeChecker INTEGER_TYPE_CHECKER = new SqlTypeChecker(SqlTypeName.INTEGER);
    public static final SqlTester.TypeChecker BOOLEAN_TYPE_CHECKER = new SqlTypeChecker(SqlTypeName.BOOLEAN);
    public static final SqlTester.TypeChecker ANY_TYPE_CHECKER = new SqlTester.TypeChecker(){

        public void checkType(RelDataType type) {
        }
    };

    public static String getTypeString(RelDataType sqlType) {
        switch (sqlType.getSqlTypeName()) {
            case VARCHAR: {
                String actual = "VARCHAR(" + sqlType.getPrecision() + ")";
                return sqlType.isNullable() ? actual : String.valueOf(actual) + " NOT NULL";
            }
            case CHAR: {
                String actual = "CHAR(" + sqlType.getPrecision() + ")";
                return sqlType.isNullable() ? actual : String.valueOf(actual) + " NOT NULL";
            }
        }
        String s = sqlType.getFullTypeString();
        return s.replace(" CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\"", "");
    }

    public static String generateAggQuery(String expr, String[] inputValues) {
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT ").append(expr).append(" FROM ");
        if (inputValues.length == 0) {
            buf.append("(VALUES 1) AS t(x) WHERE false");
        } else {
            buf.append("(");
            int i = 0;
            while (i < inputValues.length) {
                if (i > 0) {
                    buf.append(" UNION ALL ");
                }
                buf.append("SELECT ");
                String inputValue = inputValues[i];
                buf.append(inputValue).append(" AS x FROM (VALUES (1))");
                ++i;
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public static String generateWinAggQuery(String expr, String windowSpec, String[] inputValues) {
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT ").append(expr).append(" OVER (").append(windowSpec).append(") FROM (");
        int i = 0;
        while (i < inputValues.length) {
            if (i > 0) {
                buf.append(" UNION ALL ");
            }
            buf.append("SELECT ");
            String inputValue = inputValues[i];
            buf.append(inputValue).append(" AS x FROM (VALUES (1))");
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }

    public static void compareResultSet(ResultSet resultSet, Set<String> refSet) throws Exception {
        HashSet<String> actualSet = new HashSet<String>();
        while (resultSet.next()) {
            String s = resultSet.getString(1);
            actualSet.add(s);
        }
        resultSet.close();
        Assert.assertEquals(refSet, actualSet);
    }

    public static void compareResultSetWithPattern(ResultSet resultSet, Pattern pattern) throws Exception {
        if (!resultSet.next()) {
            Assert.fail((String)"Query returned 0 rows, expected 1");
        }
        String actual = resultSet.getString(1);
        if (resultSet.next()) {
            Assert.fail((String)"Query returned 2 or more rows, expected 1");
        }
        if (!pattern.matcher(actual).matches()) {
            Assert.fail((String)("Query returned '" + actual + "', expected '" + pattern.pattern() + "'"));
        }
    }

    public static void compareResultSetWithDelta(ResultSet resultSet, double expected, double delta) throws Exception {
        if (!resultSet.next()) {
            Assert.fail((String)"Query returned 0 rows, expected 1");
        }
        double actual = resultSet.getDouble(1);
        if (resultSet.next()) {
            Assert.fail((String)"Query returned 2 or more rows, expected 1");
        }
        if (actual < expected - delta || actual > expected + delta) {
            Assert.fail((String)("Query returned " + actual + ", expected " + expected + (delta == 0.0 ? "" : "+/-" + delta)));
        }
    }

    public static void compareResultList(ResultSet resultSet, List<String> refList) throws Exception {
        ArrayList<String> actualSet = new ArrayList<String>();
        while (resultSet.next()) {
            String s = resultSet.getString(1);
            actualSet.add(s);
        }
        resultSet.close();
        Assert.assertEquals(refList, actualSet);
    }

    public static void compareResultLists(ResultSet resultSet, List<String> ... refLists) throws Exception {
        int numExpectedColumns = refLists.length;
        Assert.assertTrue((numExpectedColumns > 0 ? 1 : 0) != 0);
        Assert.assertTrue((resultSet.getMetaData().getColumnCount() >= numExpectedColumns ? 1 : 0) != 0);
        int numExpectedRows = -1;
        ArrayList actualLists = new ArrayList();
        int i = 0;
        while (i < numExpectedColumns) {
            actualLists.add(new ArrayList());
            if (i == 0) {
                numExpectedRows = refLists[i].size();
            } else {
                Assert.assertEquals((String)"num rows differ across ref lists", (long)numExpectedRows, (long)refLists[i].size());
            }
            ++i;
        }
        while (resultSet.next()) {
            i = 0;
            while (i < numExpectedColumns) {
                String s = resultSet.getString(i + 1);
                ((List)actualLists.get(i)).add(s);
                ++i;
            }
        }
        resultSet.close();
        i = 0;
        while (i < numExpectedColumns) {
            Assert.assertEquals((String)("column mismatch in column " + (i + 1)), refLists[i], actualLists.get(i));
            ++i;
        }
    }

    public static SqlTester.ResultChecker createChecker(Object result, double delta) {
        if (result instanceof Pattern) {
            return new PatternResultChecker((Pattern)result);
        }
        if (delta != 0.0) {
            Assert.assertTrue((boolean)(result instanceof Number));
            return new ApproximateResultChecker((Number)result, delta);
        }
        HashSet<String> refSet = new HashSet<String>();
        if (result == null) {
            refSet.add(null);
        } else if (result instanceof Collection) {
            refSet.addAll((Collection)result);
        } else {
            refSet.add(result.toString());
        }
        return new RefSetResultChecker(refSet);
    }

    public static class ApproximateResultChecker
    implements SqlTester.ResultChecker {
        private final Number expected;
        private final double delta;

        public ApproximateResultChecker(Number expected, double delta) {
            this.expected = expected;
            this.delta = delta;
        }

        public void checkResult(ResultSet resultSet) throws Exception {
            SqlTests.compareResultSetWithDelta(resultSet, this.expected.doubleValue(), this.delta);
        }
    }

    public static class PatternResultChecker
    implements SqlTester.ResultChecker {
        private final Pattern pattern;

        public PatternResultChecker(Pattern pattern) {
            this.pattern = pattern;
        }

        public void checkResult(ResultSet resultSet) throws Exception {
            SqlTests.compareResultSetWithPattern(resultSet, this.pattern);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RefSetResultChecker
    implements SqlTester.ResultChecker {
        private final Set<String> expected;

        private RefSetResultChecker(Set<String> expected) {
            this.expected = expected;
        }

        @Override
        public void checkResult(ResultSet resultSet) throws Exception {
            SqlTests.compareResultSet(resultSet, this.expected);
        }
    }

    private static class SqlTypeChecker
    implements SqlTester.TypeChecker {
        private final SqlTypeName typeName;

        SqlTypeChecker(SqlTypeName typeName) {
            this.typeName = typeName;
        }

        public void checkType(RelDataType type) {
            Assert.assertEquals((Object)this.typeName.toString(), (Object)type.toString());
        }
    }

    public static class StringTypeChecker
    implements SqlTester.TypeChecker {
        private final String expected;

        public StringTypeChecker(String expected) {
            this.expected = expected;
        }

        public void checkType(RelDataType type) {
            String actual = SqlTests.getTypeString(type);
            Assert.assertEquals((Object)this.expected, (Object)actual);
        }
    }
}

