/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rex;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Schemas;
import net.hydromatic.optiq.server.OptiqServerStatement;
import net.hydromatic.optiq.tools.Frameworks;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptSchema;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexExecutorImpl;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.util.NlsString;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class RexExecutorTest {
    protected void check(final Action action) throws Exception {
        Frameworks.withPrepare((Frameworks.PrepareAction)new Frameworks.PrepareAction<Void>(){

            public Void apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema, OptiqServerStatement statement) {
                RexBuilder rexBuilder = cluster.getRexBuilder();
                DataContext dataContext = Schemas.createDataContext((Connection)statement.getConnection());
                RexExecutorImpl executor = new RexExecutorImpl(dataContext);
                action.check(rexBuilder, executor);
                return null;
            }
        });
    }

    @Test
    public void testConstant() throws Exception {
        this.check(new Action(){

            public void check(RexBuilder rexBuilder, RexExecutorImpl executor) {
                ArrayList reducedValues = new ArrayList();
                RexLiteral ten = rexBuilder.makeExactLiteral(BigDecimal.TEN);
                executor.execute(rexBuilder, (List)ImmutableList.of((Object)ten), reducedValues);
                Assert.assertThat((Object)reducedValues.size(), (Matcher)CoreMatchers.equalTo((Object)1));
                Assert.assertThat((Object)((RexNode)reducedValues.get(0)), (Matcher)CoreMatchers.instanceOf(RexLiteral.class));
                Assert.assertThat((Object)((RexLiteral)reducedValues.get(0)).getValue2(), (Matcher)CoreMatchers.equalTo((Object)10L));
            }
        });
    }

    @Test
    public void testSubstring() throws Exception {
        this.check(new Action(){

            public void check(RexBuilder rexBuilder, RexExecutorImpl executor) {
                ArrayList reducedValues = new ArrayList();
                RexLiteral hello = rexBuilder.makeCharLiteral(new NlsString("Hello world!", null, null));
                RexNode plus = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, new RexNode[]{rexBuilder.makeExactLiteral(BigDecimal.ONE), rexBuilder.makeExactLiteral(BigDecimal.ONE)});
                RexLiteral four = rexBuilder.makeExactLiteral(BigDecimal.valueOf(4L));
                RexNode substring = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.SUBSTRING, new RexNode[]{hello, plus, four});
                executor.execute(rexBuilder, (List)ImmutableList.of((Object)substring, (Object)plus), reducedValues);
                Assert.assertThat((Object)reducedValues.size(), (Matcher)CoreMatchers.equalTo((Object)2));
                Assert.assertThat((Object)((RexNode)reducedValues.get(0)), (Matcher)CoreMatchers.instanceOf(RexLiteral.class));
                Assert.assertThat((Object)((RexLiteral)reducedValues.get(0)).getValue2(), (Matcher)CoreMatchers.equalTo((Object)"ello"));
                Assert.assertThat((Object)((RexNode)reducedValues.get(1)), (Matcher)CoreMatchers.instanceOf(RexLiteral.class));
                Assert.assertThat((Object)((RexLiteral)reducedValues.get(1)).getValue2(), (Matcher)CoreMatchers.equalTo((Object)2L));
            }
        });
    }

    static interface Action {
        public void check(RexBuilder var1, RexExecutorImpl var2);
    }
}

