/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.impl.java.ReflectiveSchema;
import net.hydromatic.optiq.test.JdbcTest;
import net.hydromatic.optiq.tools.Frameworks;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRel;
import org.eigenbase.rel.Aggregation;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.RelJsonReader;
import org.eigenbase.rel.RelJsonWriter;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.TableAccessRel;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptSchema;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlExplainLevel;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class RelWriterTest {
    public static final String XX = "{\n  rels: [\n    {\n      id: \"0\",\n      relOp: \"TableAccessRel\",\n      table: [\n        \"hr\",\n        \"emps\"\n      ],\n      inputs: []\n    },\n    {\n      id: \"1\",\n      relOp: \"FilterRel\",\n      condition: {\n        op: \"=\",\n        operands: [\n          {\n            input: 1\n          },\n          10\n        ]\n      }\n    },\n    {\n      id: \"2\",\n      relOp: \"AggregateRel\",\n      group: [\n        0\n      ],\n      aggs: [\n        {\n          agg: \"COUNT\",\n          type: {\n            type: \"INTEGER\",\n            nullable: false\n          },\n          distinct: true,\n          operands: [\n            1\n          ]\n        },\n        {\n          agg: \"COUNT\",\n          type: {\n            type: \"INTEGER\",\n            nullable: false\n          },\n          distinct: false,\n          operands: []\n        }\n      ]\n    }\n  ]\n}";

    @Test
    public void testWriter() {
        String s = (String)Frameworks.withPlanner((Frameworks.PlannerAction)new Frameworks.PlannerAction<String>(){

            public String apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema) {
                rootSchema.add("hr", (Schema)new ReflectiveSchema("hr", (Object)new JdbcTest.HrSchema()));
                TableAccessRel table = new TableAccessRel(cluster, relOptSchema.getTableForMember(Arrays.asList("hr", "emps")));
                RexBuilder rexBuilder = cluster.getRexBuilder();
                FilterRel filter = new FilterRel(cluster, (RelNode)table, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{rexBuilder.makeFieldAccess(rexBuilder.makeRangeReference((RelNode)table), "deptno", true), rexBuilder.makeExactLiteral(BigDecimal.TEN)}));
                RelJsonWriter writer = new RelJsonWriter();
                RelDataType intType = cluster.getTypeFactory().createSqlType(SqlTypeName.INTEGER);
                AggregateRel aggregate = new AggregateRel(cluster, (RelNode)filter, BitSets.of((int[])new int[]{0}), (List)ImmutableList.of((Object)new AggregateCall((Aggregation)SqlStdOperatorTable.COUNT, true, (List)ImmutableList.of((Object)1), intType, "c"), (Object)new AggregateCall((Aggregation)SqlStdOperatorTable.COUNT, false, (List)ImmutableList.of(), intType, "d")));
                aggregate.explain((RelWriter)writer);
                return writer.asString();
            }
        });
        Assert.assertThat((Object)s, (Matcher)CoreMatchers.is((Object)XX));
    }

    @Test
    public void testReader() {
        String s = (String)Frameworks.withPlanner((Frameworks.PlannerAction)new Frameworks.PlannerAction<String>(){

            public String apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema) {
                RelNode node;
                SchemaPlus schema = rootSchema.add("hr", (Schema)new ReflectiveSchema("hr", (Object)new JdbcTest.HrSchema()));
                RelJsonReader reader = new RelJsonReader(cluster, relOptSchema, (Schema)schema);
                try {
                    node = reader.read(RelWriterTest.XX);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return RelOptUtil.dumpPlan((String)"", (RelNode)node, (boolean)false, (SqlExplainLevel)SqlExplainLevel.EXPPLAN_ATTRIBUTES);
            }
        });
        Assert.assertThat((Object)Util.toLinux((String)s), (Matcher)CoreMatchers.is((Object)"AggregateRel(group=[{0}], agg#0=[COUNT(DISTINCT $1)], agg#1=[COUNT()])\n  FilterRel(condition=[=($1, 10)])\n    TableAccessRel(table=[[hr, emps]])\n"));
    }
}

