/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.generate;

import java.util.Map;
import java.util.NoSuchElementException;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.optiq.QueryableTable;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.TableFactory;
import net.hydromatic.optiq.impl.AbstractTableQueryable;
import net.hydromatic.optiq.impl.java.AbstractQueryableTable;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.type.SqlTypeName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeTable
extends AbstractQueryableTable {
    private final String columnName;
    private final int start;
    private final int end;

    protected RangeTable(String columnName, String tableName, int start, int end) {
        super(Object[].class);
        this.columnName = columnName;
        this.start = start;
        this.end = end;
    }

    public static RangeTable create(String tableName, String columnName, int start, int end) {
        return new RangeTable(columnName, tableName, start, end);
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return typeFactory.builder().add(this.columnName, SqlTypeName.INTEGER).build();
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new AbstractTableQueryable<T>(queryProvider, schema, (QueryableTable)this, tableName){

            public Enumerator<T> enumerator() {
                return RangeTable.this.enumerator();
            }
        };
    }

    public Enumerator<Integer> enumerator() {
        return new Enumerator<Integer>(){
            int current;
            {
                this.current = RangeTable.this.start - 1;
            }

            public Integer current() {
                if (this.current >= RangeTable.this.end) {
                    throw new NoSuchElementException();
                }
                return this.current;
            }

            public boolean moveNext() {
                ++this.current;
                return this.current < RangeTable.this.end;
            }

            public void reset() {
                this.current = RangeTable.this.start - 1;
            }

            public void close() {
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements TableFactory<RangeTable> {
        public RangeTable create(SchemaPlus schema, String name, Map<String, Object> operand, RelDataType rowType) {
            String columnName = (String)operand.get("column");
            int start = (Integer)operand.get("start");
            int end = (Integer)operand.get("end");
            return RangeTable.create(name, columnName, start, end);
        }
    }
}

