/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.optiq.prepare.Prepare;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelCollationImpl;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.TableAccessRel;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptSchema;
import org.eigenbase.relopt.RelOptSchemaWithSampling;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperatorTable;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParser;
import org.eigenbase.sql.type.SqlTypeFactoryImpl;
import org.eigenbase.sql.validate.SqlConformance;
import org.eigenbase.sql.validate.SqlMonotonicity;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorCatalogReader;
import org.eigenbase.sql.validate.SqlValidatorImpl;
import org.eigenbase.sql.validate.SqlValidatorTable;
import org.eigenbase.sql2rel.RelFieldTrimmer;
import org.eigenbase.sql2rel.SqlToRelConverter;
import org.eigenbase.test.DiffRepository;
import org.eigenbase.test.MockCatalogReader;
import org.eigenbase.test.MockRelOptPlanner;
import org.eigenbase.test.MockSqlOperatorTable;
import org.eigenbase.test.SqlToRelConverterTest;
import org.eigenbase.util.Util;
import org.junit.Assert;

public abstract class SqlToRelTestBase {
    protected static final String NL = System.getProperty("line.separator");
    protected final Tester tester = this.createTester();

    protected Tester createTester() {
        return new TesterImpl(this.getDiffRepos());
    }

    protected DiffRepository getDiffRepos() {
        return null;
    }

    private static class FarragoTestValidator
    extends SqlValidatorImpl {
        public FarragoTestValidator(SqlOperatorTable opTab, SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory, SqlConformance conformance) {
            super(opTab, catalogReader, typeFactory, conformance);
        }

        public boolean shouldExpandIdentifiers() {
            return true;
        }
    }

    public static class TesterImpl
    implements Tester {
        private RelOptPlanner planner;
        private SqlOperatorTable opTab;
        private final DiffRepository diffRepos;
        private RelDataTypeFactory typeFactory;

        protected TesterImpl(DiffRepository diffRepos) {
            this.diffRepos = diffRepos;
        }

        public RelNode convertSqlToRel(String sql) {
            SqlNode sqlQuery;
            Util.pre((sql != null ? 1 : 0) != 0, (String)"sql != null");
            try {
                sqlQuery = this.parseQuery(sql);
            }
            catch (Exception e) {
                throw Util.newInternal((Throwable)e);
            }
            RelDataTypeFactory typeFactory = this.getTypeFactory();
            Prepare.CatalogReader catalogReader = this.createCatalogReader(typeFactory);
            SqlValidator validator = this.createValidator((SqlValidatorCatalogReader)catalogReader, typeFactory);
            SqlToRelConverter converter = this.createSqlToRelConverter(validator, catalogReader, typeFactory);
            converter.setTrimUnusedFields(true);
            SqlNode validatedQuery = validator.validate(sqlQuery);
            RelNode rel = converter.convertQuery(validatedQuery, false, true);
            Util.post((rel != null ? 1 : 0) != 0, (String)"return != null");
            return rel;
        }

        protected SqlToRelConverter createSqlToRelConverter(SqlValidator validator, Prepare.CatalogReader catalogReader, RelDataTypeFactory typeFactory) {
            return new SqlToRelConverter(null, validator, catalogReader, this.getPlanner(), new RexBuilder(typeFactory));
        }

        protected final RelDataTypeFactory getTypeFactory() {
            if (this.typeFactory == null) {
                this.typeFactory = this.createTypeFactory();
            }
            return this.typeFactory;
        }

        protected RelDataTypeFactory createTypeFactory() {
            return new SqlTypeFactoryImpl();
        }

        protected final RelOptPlanner getPlanner() {
            if (this.planner == null) {
                this.planner = this.createPlanner();
            }
            return this.planner;
        }

        public SqlNode parseQuery(String sql) throws Exception {
            SqlParser parser = SqlParser.create((String)sql);
            SqlNode sqlNode = parser.parseQuery();
            return sqlNode;
        }

        public SqlConformance getConformance() {
            return SqlConformance.DEFAULT;
        }

        public SqlValidator createValidator(SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory) {
            boolean caseSensitive = true;
            return new FarragoTestValidator(this.getOperatorTable(), (SqlValidatorCatalogReader)new MockCatalogReader(typeFactory, caseSensitive), typeFactory, this.getConformance());
        }

        public final SqlOperatorTable getOperatorTable() {
            if (this.opTab == null) {
                this.opTab = this.createOperatorTable();
            }
            return this.opTab;
        }

        protected SqlOperatorTable createOperatorTable() {
            MockSqlOperatorTable opTab = new MockSqlOperatorTable((SqlOperatorTable)SqlStdOperatorTable.instance());
            MockSqlOperatorTable.addRamp(opTab);
            return opTab;
        }

        public Prepare.CatalogReader createCatalogReader(RelDataTypeFactory typeFactory) {
            boolean caseSensitive = true;
            return new MockCatalogReader(typeFactory, caseSensitive);
        }

        public RelOptPlanner createPlanner() {
            return new MockRelOptPlanner();
        }

        public void assertConvertsTo(String sql, String plan) {
            this.assertConvertsTo(sql, plan, false);
        }

        public void assertConvertsTo(String sql, String plan, boolean trim) {
            String sql2 = this.getDiffRepos().expand("sql", sql);
            RelNode rel = this.convertSqlToRel(sql2);
            Assert.assertTrue((rel != null ? 1 : 0) != 0);
            this.assertValid(rel);
            if (trim) {
                RelFieldTrimmer trimmer = this.createFieldTrimmer();
                rel = trimmer.trim(rel);
                Assert.assertTrue((rel != null ? 1 : 0) != 0);
                this.assertValid(rel);
            }
            String actual = NL + RelOptUtil.toString((RelNode)rel);
            this.diffRepos.assertEquals("plan", plan, actual);
        }

        public RelFieldTrimmer createFieldTrimmer() {
            return new RelFieldTrimmer(this.getValidator());
        }

        protected void assertValid(RelNode rel) {
            SqlToRelConverterTest.RelValidityChecker checker = new SqlToRelConverterTest.RelValidityChecker();
            checker.go(rel);
            Assert.assertEquals((long)0L, (long)checker.invalidCount);
        }

        public DiffRepository getDiffRepos() {
            return this.diffRepos;
        }

        public SqlValidator getValidator() {
            RelDataTypeFactory typeFactory = this.getTypeFactory();
            Prepare.CatalogReader catalogReader = this.createCatalogReader(typeFactory);
            return this.createValidator((SqlValidatorCatalogReader)catalogReader, typeFactory);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelegatingRelOptTable
    implements RelOptTable {
        private final RelOptTable parent;

        public DelegatingRelOptTable(RelOptTable parent) {
            this.parent = parent;
        }

        public <T> T unwrap(Class<T> clazz) {
            if (clazz.isInstance(this)) {
                return clazz.cast(this);
            }
            return (T)this.parent.unwrap(clazz);
        }

        public Expression getExpression(Class clazz) {
            return this.parent.getExpression(clazz);
        }

        public List<String> getQualifiedName() {
            return this.parent.getQualifiedName();
        }

        public double getRowCount() {
            return this.parent.getRowCount();
        }

        public RelDataType getRowType() {
            return this.parent.getRowType();
        }

        public RelOptSchema getRelOptSchema() {
            return this.parent.getRelOptSchema();
        }

        public RelNode toRel(RelOptTable.ToRelContext context) {
            return new TableAccessRel(context.getCluster(), (RelOptTable)this);
        }

        public List<RelCollation> getCollationList() {
            return this.parent.getCollationList();
        }

        public boolean isKey(BitSet columns) {
            return this.parent.isKey(columns);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MockRelOptSchema
    implements RelOptSchemaWithSampling {
        private final SqlValidatorCatalogReader catalogReader;
        private final RelDataTypeFactory typeFactory;

        public MockRelOptSchema(SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory) {
            this.catalogReader = catalogReader;
            this.typeFactory = typeFactory;
        }

        public RelOptTable getTableForMember(List<String> names) {
            SqlValidatorTable table = this.catalogReader.getTable(names);
            RelDataType rowType = table.getRowType();
            List<RelCollation> collationList = this.deduceMonotonicity(table);
            if (names.size() < 3) {
                String[] newNames2 = new String[]{"CATALOG", "SALES", ""};
                ArrayList<String> newNames = new ArrayList<String>();
                int i = 0;
                while (newNames.size() < newNames2.length) {
                    newNames.add(i, newNames2[i]);
                    ++i;
                }
                names = newNames;
            }
            return this.createColumnSet(table, names, rowType, collationList);
        }

        private List<RelCollation> deduceMonotonicity(SqlValidatorTable table) {
            RelDataType rowType = table.getRowType();
            ArrayList<RelCollation> collationList = new ArrayList<RelCollation>();
            int i = -1;
            for (RelDataTypeField field : rowType.getFieldList()) {
                ++i;
                SqlMonotonicity monotonicity = table.getMonotonicity(field.getName());
                if (monotonicity == SqlMonotonicity.NOT_MONOTONIC) continue;
                RelFieldCollation.Direction direction = monotonicity.isDecreasing() ? RelFieldCollation.Direction.DESCENDING : RelFieldCollation.Direction.ASCENDING;
                collationList.add(RelCollationImpl.of((RelFieldCollation[])new RelFieldCollation[]{new RelFieldCollation(i, direction, RelFieldCollation.NullDirection.UNSPECIFIED)}));
            }
            return collationList;
        }

        public RelOptTable getTableForMember(List<String> names, final String datasetName, boolean[] usedDataset) {
            RelOptTable table = this.getTableForMember(names);
            DelegatingRelOptTable datasetTable = new DelegatingRelOptTable(table){

                @Override
                public List<String> getQualifiedName() {
                    ArrayList<String> list = new ArrayList<String>(super.getQualifiedName());
                    list.set(list.size() - 1, (String)list.get(list.size() - 1) + ":" + datasetName);
                    return ImmutableList.copyOf(list);
                }
            };
            if (usedDataset != null) {
                assert (usedDataset.length == 1);
                usedDataset[0] = true;
            }
            return datasetTable;
        }

        protected MockColumnSet createColumnSet(SqlValidatorTable table, List<String> names, RelDataType rowType, List<RelCollation> collationList) {
            return new MockColumnSet(names, rowType, collationList);
        }

        public RelDataTypeFactory getTypeFactory() {
            return this.typeFactory;
        }

        public void registerRules(RelOptPlanner planner) throws Exception {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class MockColumnSet
        implements RelOptTable {
            private final List<String> names;
            private final RelDataType rowType;
            private final List<RelCollation> collationList;

            protected MockColumnSet(List<String> names, RelDataType rowType, List<RelCollation> collationList) {
                this.names = ImmutableList.copyOf(names);
                this.rowType = rowType;
                this.collationList = collationList;
            }

            public <T> T unwrap(Class<T> clazz) {
                if (clazz.isInstance(this)) {
                    return clazz.cast(this);
                }
                return null;
            }

            public List<String> getQualifiedName() {
                return this.names;
            }

            public double getRowCount() {
                if (((String)Iterables.getLast(this.names)).equals("EMP")) {
                    return 1000.0;
                }
                return 100.0;
            }

            public RelDataType getRowType() {
                return this.rowType;
            }

            public RelOptSchema getRelOptSchema() {
                return MockRelOptSchema.this;
            }

            public RelNode toRel(RelOptTable.ToRelContext context) {
                return new TableAccessRel(context.getCluster(), (RelOptTable)this);
            }

            public List<RelCollation> getCollationList() {
                return this.collationList;
            }

            public boolean isKey(BitSet columns) {
                return false;
            }

            public Expression getExpression(Class clazz) {
                return null;
            }
        }
    }

    public static interface Tester {
        public RelNode convertSqlToRel(String var1);

        public SqlNode parseQuery(String var1) throws Exception;

        public SqlValidator createValidator(SqlValidatorCatalogReader var1, RelDataTypeFactory var2);

        public Prepare.CatalogReader createCatalogReader(RelDataTypeFactory var1);

        public RelOptPlanner createPlanner();

        public SqlOperatorTable getOperatorTable();

        public SqlConformance getConformance();

        public void assertConvertsTo(String var1, String var2);

        public void assertConvertsTo(String var1, String var2, boolean var3);

        public DiffRepository getDiffRepos();

        public SqlValidator getValidator();
    }
}

