/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.test;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.metadata.ChainedRelMetadataProvider;
import org.eigenbase.rel.metadata.DefaultRelMetadataProvider;
import org.eigenbase.rel.metadata.RelMetadataProvider;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.hep.HepPlanner;
import org.eigenbase.relopt.hep.HepProgram;
import org.eigenbase.relopt.hep.HepProgramBuilder;
import org.eigenbase.test.DiffRepository;
import org.eigenbase.test.SqlToRelTestBase;
import org.junit.Assert;

abstract class RelOptTestBase
extends SqlToRelTestBase {
    RelOptTestBase() {
    }

    protected void checkPlanning(RelOptRule rule, String sql) {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addRuleInstance(rule);
        this.checkPlanning(programBuilder.build(), sql);
    }

    protected void checkPlanning(HepProgram program, String sql) {
        this.checkPlanning((RelOptPlanner)new HepPlanner(program), sql);
    }

    protected void checkPlanning(RelOptPlanner planner, String sql) {
        this.checkPlanning(null, planner, sql);
    }

    protected void checkPlanning(HepProgram preProgram, RelOptRule rule, String sql) {
        HepProgramBuilder programBuilder = HepProgram.builder();
        programBuilder.addRuleInstance(rule);
        HepPlanner planner = new HepPlanner(programBuilder.build());
        this.checkPlanning(preProgram, (RelOptPlanner)planner, sql);
    }

    protected void checkPlanning(HepProgram preProgram, RelOptPlanner planner, String sql) {
        RelNode relBefore;
        DiffRepository diffRepos = this.getDiffRepos();
        String sql2 = diffRepos.expand("sql", sql);
        RelNode relInitial = this.tester.convertSqlToRel(sql2);
        Assert.assertTrue((relInitial != null ? 1 : 0) != 0);
        ArrayList list = Lists.newArrayList();
        DefaultRelMetadataProvider defaultProvider = new DefaultRelMetadataProvider();
        list.add(defaultProvider);
        planner.registerMetadataProviders((List)list);
        RelMetadataProvider plannerChain = ChainedRelMetadataProvider.of((List)list);
        relInitial.getCluster().setMetadataProvider(plannerChain);
        if (preProgram == null) {
            relBefore = relInitial;
        } else {
            HepPlanner prePlanner = new HepPlanner(preProgram);
            prePlanner.setRoot(relInitial);
            relBefore = prePlanner.findBestExp();
        }
        Assert.assertTrue((relBefore != null ? 1 : 0) != 0);
        String planBefore = NL + RelOptUtil.toString((RelNode)relBefore);
        diffRepos.assertEquals("planBefore", "${planBefore}", planBefore);
        planner.setRoot(relBefore);
        RelNode relAfter = planner.findBestExp();
        String planAfter = NL + RelOptUtil.toString((RelNode)relAfter);
        diffRepos.assertEquals("planAfter", "${planAfter}", planAfter);
    }

    protected static HepProgram createProgram(RelOptRule ... rules) {
        HepProgramBuilder builder = HepProgram.builder();
        for (RelOptRule rule : rules) {
            builder.addRuleInstance(rule);
        }
        return builder.build();
    }
}

