/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.tools;

import java.math.BigDecimal;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.impl.AbstractTable;
import net.hydromatic.optiq.rules.java.EnumerableConvention;
import net.hydromatic.optiq.rules.java.JavaRules;
import net.hydromatic.optiq.tools.Frameworks;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptAbstractTable;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptSchema;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlExplainLevel;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class FrameworksTest {
    @Test
    public void testOptimize() {
        RelNode x = (RelNode)Frameworks.withPlanner((Frameworks.PlannerAction)new Frameworks.PlannerAction<RelNode>(){

            public RelNode apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema) {
                FilterRel filterRel;
                RelDataTypeFactory typeFactory = cluster.getTypeFactory();
                AbstractTable table = new AbstractTable(){

                    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                        RelDataType stringType = typeFactory.createJavaType(String.class);
                        RelDataType integerType = typeFactory.createJavaType(Integer.class);
                        return typeFactory.builder().add("s", stringType).add("i", integerType).build();
                    }
                };
                RelOptAbstractTable relOptTable = new RelOptAbstractTable(relOptSchema, "myTable", table.getRowType(typeFactory)){};
                JavaRules.EnumerableTableAccessRel tableRel = new JavaRules.EnumerableTableAccessRel(cluster, cluster.traitSetOf(new RelTrait[]{EnumerableConvention.INSTANCE}), (RelOptTable)relOptTable, Object[].class);
                RexBuilder rexBuilder = cluster.getRexBuilder();
                RexNode condition = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{rexBuilder.makeFieldAccess(rexBuilder.makeRangeReference((RelNode)tableRel), "i", true), rexBuilder.makeExactLiteral(BigDecimal.ONE)});
                FilterRel rootRel = filterRel = new FilterRel(cluster, (RelNode)tableRel, condition);
                RelOptPlanner planner = cluster.getPlanner();
                RelTraitSet desiredTraits = rootRel.getTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
                RelNode rootRel2 = planner.changeTraits((RelNode)rootRel, desiredTraits);
                planner.setRoot(rootRel2);
                return planner.findBestExp();
            }
        });
        String s = RelOptUtil.dumpPlan((String)"", (RelNode)x, (boolean)false, (SqlExplainLevel)SqlExplainLevel.DIGEST_ATTRIBUTES);
        Assert.assertThat((Object)Util.toLinux((String)s), (Matcher)CoreMatchers.equalTo((Object)"EnumerableFilterRel(condition=[>($1, 1)])\n  EnumerableTableAccessRel(table=[[myTable]])\n"));
    }
}

