/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.test;

import com.google.common.collect.ImmutableMultiset;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.sql.DataSource;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.impl.clone.CloneSchema;
import net.hydromatic.optiq.impl.java.ReflectiveSchema;
import net.hydromatic.optiq.impl.jdbc.JdbcSchema;
import net.hydromatic.optiq.jdbc.MetaImpl;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.runtime.Hook;
import net.hydromatic.optiq.test.JdbcTest;
import org.eigenbase.util.JsonBuilder;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptiqAssert {
    public static final ConnectionSpec CONNECTION_SPEC = ((String)Util.first((Object)System.getProperty("optiq.test.db"), (Object)"hsqldb")).equals("mysql") ? ConnectionSpec.MYSQL : ConnectionSpec.HSQLDB;
    private static final DateFormat UTC_DATE_FORMAT;
    private static final DateFormat UTC_TIME_FORMAT;
    private static final DateFormat UTC_TIMESTAMP_FORMAT;
    private static final AssertThat DISABLED;

    private OptiqAssert() {
    }

    public static AssertThat that() {
        return new AssertThat(Config.REGULAR);
    }

    static Function1<Throwable, Void> checkException(final String expected) {
        return new Function1<Throwable, Void>(){

            public Void apply(Throwable p0) {
                Assert.assertNotNull((String)"expected exception but none was thrown", (Object)p0);
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                p0.printStackTrace(printWriter);
                printWriter.flush();
                String stack = stringWriter.toString();
                Assert.assertTrue((String)stack, (boolean)stack.contains(expected));
                return null;
            }
        };
    }

    static Function1<ResultSet, Void> checkResult(final String expected) {
        return new Function1<ResultSet, Void>(){

            public Void apply(ResultSet resultSet) {
                try {
                    String resultString = OptiqAssert.toString(resultSet);
                    Assert.assertEquals((Object)expected, (Object)Util.toLinux((String)resultString));
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    static Function1<ResultSet, Void> checkResultCount(final int expected) {
        return new Function1<ResultSet, Void>(){

            public Void apply(ResultSet resultSet) {
                try {
                    int count = OptiqAssert.countRows(resultSet);
                    Assert.assertEquals((long)expected, (long)count);
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    static Function1<ResultSet, Void> consistentResult(final boolean ordered) {
        return new Function1<ResultSet, Void>(){
            int executeCount = 0;
            Collection expected;

            public Void apply(ResultSet resultSet) {
                ++this.executeCount;
                try {
                    Collection<String> result = OptiqAssert.toStringList(resultSet, ordered ? new ArrayList() : new TreeSet());
                    if (this.executeCount == 1) {
                        this.expected = result;
                    } else if (!this.expected.equals(result)) {
                        Assert.assertThat((Object)OptiqAssert.newlineList(result), (Matcher)CoreMatchers.equalTo((Object)OptiqAssert.newlineList(this.expected)));
                        Assert.fail((String)"oops");
                    }
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    static String newlineList(Collection collection) {
        StringBuilder buf = new StringBuilder();
        for (Object o : collection) {
            buf.append(o).append('\n');
        }
        return buf.toString();
    }

    static Function1<ResultSet, Void> checkResultUnordered(final String ... lines) {
        return new Function1<ResultSet, Void>(){

            public Void apply(ResultSet resultSet) {
                try {
                    ArrayList expectedList = new ArrayList();
                    Collections.addAll(expectedList, lines);
                    Collections.sort(expectedList);
                    ArrayList<String> actualList = new ArrayList<String>();
                    OptiqAssert.toStringList(resultSet, actualList);
                    Collections.sort(actualList);
                    Assert.assertThat(actualList, (Matcher)CoreMatchers.equalTo(expectedList));
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static Function1<ResultSet, Void> checkResultContains(final String expected) {
        return new Function1<ResultSet, Void>(){

            public Void apply(ResultSet s) {
                try {
                    String actual = Util.toLinux((String)OptiqAssert.toString(s));
                    if (!actual.contains(expected)) {
                        Assert.assertEquals((String)"contains", (Object)expected, (Object)actual);
                    }
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static Function1<ResultSet, Void> checkResultType(final String expected) {
        return new Function1<ResultSet, Void>(){

            public Void apply(ResultSet s) {
                try {
                    String actual = OptiqAssert.typeString(s.getMetaData());
                    Assert.assertEquals((Object)expected, (Object)actual);
                    return null;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private static String typeString(ResultSetMetaData metaData) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < metaData.getColumnCount(); ++i) {
            list.add(metaData.getColumnName(i + 1) + " " + metaData.getColumnTypeName(i + 1) + (metaData.isNullable(i + 1) == 0 ? " NOT NULL" : ""));
        }
        return ((Object)list).toString();
    }

    static void assertQuery(Connection connection, String sql, int limit, boolean materializationsEnabled, Function1<ResultSet, Void> resultChecker, Function1<Throwable, Void> exceptionChecker) throws Exception {
        String message = "With materializationsEnabled=" + materializationsEnabled + ", limit=" + limit;
        try {
            ResultSet resultSet;
            ((OptiqConnection)connection).getProperties().setProperty("materializationsEnabled", Boolean.toString(materializationsEnabled));
            Statement statement = connection.createStatement();
            statement.setMaxRows(limit <= 0 ? limit : Math.max(limit, 1));
            try {
                resultSet = statement.executeQuery(sql);
                if (exceptionChecker != null) {
                    exceptionChecker.apply(null);
                    return;
                }
            }
            catch (Exception e) {
                if (exceptionChecker != null) {
                    exceptionChecker.apply((Object)e);
                    return;
                }
                throw e;
            }
            catch (Error e) {
                if (exceptionChecker != null) {
                    exceptionChecker.apply((Object)e);
                    return;
                }
                throw e;
            }
            if (resultChecker != null) {
                resultChecker.apply((Object)resultSet);
            }
            resultSet.close();
            statement.close();
            connection.close();
        }
        catch (Throwable e) {
            throw new RuntimeException(message, e);
        }
    }

    static String toString(ResultSet resultSet) throws SQLException {
        StringBuilder buf = new StringBuilder();
        ResultSetMetaData metaData = resultSet.getMetaData();
        while (resultSet.next()) {
            int n = metaData.getColumnCount();
            if (n > 0) {
                int i = 1;
                while (true) {
                    buf.append(metaData.getColumnLabel(i)).append("=").append(resultSet.getString(i));
                    if (i == n) break;
                    buf.append("; ");
                    ++i;
                }
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    static int countRows(ResultSet resultSet) throws SQLException {
        int n = 0;
        while (resultSet.next()) {
            ++n;
        }
        return n;
    }

    static Collection<String> toStringList(ResultSet resultSet, Collection<String> list) throws SQLException {
        StringBuilder buf = new StringBuilder();
        while (resultSet.next()) {
            int n = resultSet.getMetaData().getColumnCount();
            if (n > 0) {
                int i = 1;
                while (true) {
                    buf.append(resultSet.getMetaData().getColumnLabel(i)).append("=").append(resultSet.getString(i));
                    if (i == n) break;
                    buf.append("; ");
                    ++i;
                }
            }
            list.add(buf.toString());
            buf.setLength(0);
        }
        return list;
    }

    static ImmutableMultiset<String> toSet(ResultSet resultSet) throws SQLException {
        return ImmutableMultiset.copyOf(OptiqAssert.toStringList(resultSet, new ArrayList<String>()));
    }

    static Object call(Object o, String methodName, Object ... args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return OptiqAssert.method(o, methodName, args).invoke(o, args);
    }

    /*
     * Unable to fully structure code
     */
    static Method method(Object o, String methodName, Object[] args) {
        aClass = o.getClass();
        while (true) lbl-1000:
        // 5 sources

        {
            block1: for (Method method1 : aClass.getMethods()) {
                if (!method1.getName().equals(methodName) || method1.getParameterTypes().length != args.length || !Modifier.isPublic(method1.getDeclaringClass().getModifiers())) continue;
                for (Pair pair : Pair.zip((Object[])args, (Object[])method1.getParameterTypes())) {
                    if (((Class)pair.right).isInstance(pair.left)) continue;
                    continue block1;
                }
                return method1;
            }
            if (aClass.getSuperclass() != null && aClass.getSuperclass() != Object.class) {
                aClass = aClass.getSuperclass();
                ** continue;
            }
            interfaces = aClass.getInterfaces();
            if (interfaces.length <= 0) break;
            aClass = interfaces[0];
        }
        throw new AssertionError((Object)("method " + methodName + " not found"));
    }

    static OptiqConnection getConnection(String ... schema) throws ClassNotFoundException, SQLException {
        List<String> schemaList = Arrays.asList(schema);
        Class.forName("net.hydromatic.optiq.jdbc.Driver");
        String suffix = schemaList.contains("spark") ? "spark=true" : "";
        Connection connection = DriverManager.getConnection("jdbc:optiq:" + suffix);
        OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
        SchemaPlus rootSchema = optiqConnection.getRootSchema();
        if (schemaList.contains("hr")) {
            rootSchema.add("hr", (Schema)new ReflectiveSchema("hr", (Object)new JdbcTest.HrSchema()));
        }
        if (schemaList.contains("foodmart")) {
            rootSchema.add("foodmart", (Schema)new ReflectiveSchema("foodmart", (Object)new JdbcTest.FoodmartSchema()));
        }
        if (schemaList.contains("lingual")) {
            rootSchema.add("SALES", (Schema)new ReflectiveSchema("SALES", (Object)new JdbcTest.LingualSchema()));
        }
        if (schemaList.contains("metadata")) {
            Util.discard((int)0);
        }
        return optiqConnection;
    }

    static OptiqConnection getConnection(boolean withClone) throws ClassNotFoundException, SQLException {
        Class.forName("net.hydromatic.optiq.jdbc.Driver");
        Connection connection = DriverManager.getConnection("jdbc:optiq:");
        OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
        SchemaPlus rootSchema = optiqConnection.getRootSchema();
        DataSource dataSource = JdbcSchema.dataSource((String)OptiqAssert.CONNECTION_SPEC.url, (String)OptiqAssert.CONNECTION_SPEC.driver, (String)OptiqAssert.CONNECTION_SPEC.username, (String)OptiqAssert.CONNECTION_SPEC.password);
        SchemaPlus foodmart = rootSchema.add("foodmart", (Schema)JdbcSchema.create((SchemaPlus)rootSchema, (String)"foodmart", (DataSource)dataSource, null, (String)"foodmart"));
        if (withClone) {
            rootSchema.add("foodmart2", (Schema)new CloneSchema(foodmart));
        }
        optiqConnection.setSchema("foodmart2");
        return optiqConnection;
    }

    static {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        UTC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
        UTC_DATE_FORMAT.setTimeZone(utc);
        UTC_TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
        UTC_TIME_FORMAT.setTimeZone(utc);
        UTC_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        UTC_TIMESTAMP_FORMAT.setTimeZone(utc);
        DISABLED = new AssertThat(null){

            @Override
            public AssertThat with(Config config) {
                return this;
            }

            @Override
            public AssertThat with(ConnectionFactory connectionFactory) {
                return this;
            }

            @Override
            public AssertThat with(Map<String, String> map) {
                return this;
            }

            @Override
            public AssertThat with(String name, Object schema) {
                return this;
            }

            @Override
            public AssertThat withModel(String model) {
                return this;
            }

            @Override
            public AssertQuery query(String sql) {
                return NopAssertQuery.of(sql);
            }

            @Override
            public void connectThrows(String message) {
            }

            @Override
            public void connectThrows(Function1<Throwable, Void> exceptionChecker) {
            }

            @Override
            public <T> AssertThat doWithConnection(Function1<OptiqConnection, T> fn) throws Exception {
                return this;
            }

            @Override
            public AssertThat withSchema(String schema) {
                return this;
            }

            @Override
            public AssertThat enable(boolean enabled) {
                return this;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConnectionSpec {
        HSQLDB("jdbc:hsqldb:res:foodmart", "FOODMART", "FOODMART", "org.hsqldb.jdbcDriver"),
        MYSQL("jdbc:mysql://localhost/foodmart", "foodmart", "foodmart", "com.mysql.jdbc.Driver");

        public final String url;
        public final String username;
        public final String password;
        public final String driver;

        private ConnectionSpec(String url, String username, String password, String driver) {
            this.url = url;
            this.username = username;
            this.password = password;
            this.driver = driver;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NopAssertQuery
    extends AssertQuery {
        private NopAssertQuery(String sql) {
            super(null, sql);
        }

        static AssertQuery of(String sql) {
            return new NopAssertQuery(sql);
        }

        @Override
        protected Connection createConnection() throws Exception {
            throw new AssertionError((Object)"disabled");
        }

        @Override
        public AssertQuery returns(String expected) {
            return this;
        }

        @Override
        public AssertQuery returns(Function1<ResultSet, Void> checker) {
            return this;
        }

        @Override
        public AssertQuery throws_(String message) {
            return this;
        }

        @Override
        public AssertQuery runs() {
            return this;
        }

        @Override
        public AssertQuery explainMatches(Function1<ResultSet, Void> checker) {
            return this;
        }

        @Override
        public AssertQuery planContains(String expected) {
            return this;
        }

        @Override
        public AssertQuery planHasSql(String expected) {
            return this;
        }

        @Override
        public AssertQuery queryContains(Function1<List, Void> predicate1) {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Config {
        REGULAR,
        LINGUAL,
        JDBC_FOODMART,
        FOODMART_CLONE,
        REGULAR_PLUS_METADATA,
        SPARK;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AssertQuery {
        private final String sql;
        private ConnectionFactory connectionFactory;
        private String plan;
        private int limit;
        private boolean materializationsEnabled = false;

        private AssertQuery(ConnectionFactory connectionFactory, String sql) {
            this.sql = sql;
            this.connectionFactory = connectionFactory;
        }

        protected Connection createConnection() throws Exception {
            return this.connectionFactory.createConnection();
        }

        public AssertQuery enable(boolean enabled) {
            return enabled ? this : NopAssertQuery.of(this.sql);
        }

        public AssertQuery returns(String expected) {
            return this.returns(OptiqAssert.checkResult(expected));
        }

        public AssertQuery returnsCount(int expectedCount) {
            return this.returns(OptiqAssert.checkResultCount(expectedCount));
        }

        public AssertQuery returns(Function1<ResultSet, Void> checker) {
            try {
                OptiqAssert.assertQuery(this.createConnection(), this.sql, this.limit, this.materializationsEnabled, checker, null);
                return this;
            }
            catch (Exception e) {
                throw new RuntimeException("exception while executing [" + this.sql + "]", e);
            }
        }

        public AssertQuery returnsUnordered(String ... lines) {
            return this.returns(OptiqAssert.checkResultUnordered(lines));
        }

        public AssertQuery throws_(String message) {
            try {
                OptiqAssert.assertQuery(this.createConnection(), this.sql, this.limit, this.materializationsEnabled, null, OptiqAssert.checkException(message));
                return this;
            }
            catch (Exception e) {
                throw new RuntimeException("exception while executing [" + this.sql + "]", e);
            }
        }

        public AssertQuery runs() {
            try {
                OptiqAssert.assertQuery(this.createConnection(), this.sql, this.limit, this.materializationsEnabled, null, null);
                return this;
            }
            catch (Exception e) {
                throw new RuntimeException("exception while executing [" + this.sql + "]", e);
            }
        }

        public AssertQuery typeIs(String expected) {
            try {
                OptiqAssert.assertQuery(this.createConnection(), this.sql, this.limit, false, OptiqAssert.checkResultType(expected), null);
                return this;
            }
            catch (Exception e) {
                throw new RuntimeException("exception while executing [" + this.sql + "]", e);
            }
        }

        public AssertQuery explainContains(String expected) {
            return this.explainMatches(OptiqAssert.checkResultContains(expected));
        }

        public AssertQuery explainMatches(Function1<ResultSet, Void> checker) {
            String explainSql = "explain plan for " + this.sql;
            try {
                OptiqAssert.assertQuery(this.createConnection(), explainSql, this.limit, this.materializationsEnabled, checker, null);
                return this;
            }
            catch (Exception e) {
                throw new RuntimeException("exception while executing [" + explainSql + "]", e);
            }
        }

        public AssertQuery planContains(String expected) {
            this.ensurePlan();
            Assert.assertTrue((String)("Plan [" + this.plan + "] contains [" + expected + "]"), (boolean)Util.toLinux((String)this.plan).replaceAll("\\\\r\\\\n", "\\\\n").contains(expected));
            return this;
        }

        public AssertQuery planHasSql(String expected) {
            return this.planContains("getDataSource(), \"" + expected.replace("\\", "\\\\").replace("\"", "\\\"").replaceAll("\n", "\\\\n") + "\"");
        }

        private void ensurePlan() {
            if (this.plan != null) {
                return;
            }
            Hook.Closeable hook = Hook.JAVA_PLAN.addThread((Function1)new Function1<Object, Object>(){

                public Object apply(Object a0) {
                    AssertQuery.this.plan = (String)a0;
                    return null;
                }
            });
            try {
                OptiqAssert.assertQuery(this.createConnection(), this.sql, this.limit, this.materializationsEnabled, null, null);
                Assert.assertNotNull((Object)this.plan);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while executing [" + this.sql + "]", e);
            }
            finally {
                hook.close();
            }
        }

        public AssertQuery queryContains(Function1<List, Void> predicate1) {
            final ArrayList list = new ArrayList();
            Hook.Closeable hook = Hook.QUERY_PLAN.addThread((Function1)new Function1<Object, Object>(){

                public Object apply(Object a0) {
                    list.add(a0);
                    return null;
                }
            });
            try {
                OptiqAssert.assertQuery(this.createConnection(), this.sql, this.limit, this.materializationsEnabled, null, null);
                predicate1.apply(list);
                AssertQuery assertQuery = this;
                return assertQuery;
            }
            catch (Exception e) {
                throw new RuntimeException("exception while executing [" + this.sql + "]", e);
            }
            finally {
                hook.close();
            }
        }

        public AssertQuery limit(int limit) {
            this.limit = limit;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sameResultWithMaterializationsDisabled() {
            boolean save = this.materializationsEnabled;
            try {
                this.materializationsEnabled = false;
                boolean ordered = this.sql.toUpperCase().contains("ORDER BY");
                Function1<ResultSet, Void> checker = OptiqAssert.consistentResult(ordered);
                this.returns(checker);
                this.materializationsEnabled = true;
                this.returns(checker);
            }
            finally {
                this.materializationsEnabled = save;
            }
        }

        public AssertQuery enableMaterializations(boolean enable) {
            this.materializationsEnabled = enable;
            return this;
        }
    }

    private static class SchemaConnectionFactory
    extends DelegatingConnectionFactory {
        private final String schema;

        public SchemaConnectionFactory(ConnectionFactory factory, String schema) {
            super(factory);
            this.schema = schema;
        }

        public OptiqConnection createConnection() throws Exception {
            OptiqConnection connection = super.createConnection();
            connection.setSchema(this.schema);
            return connection;
        }
    }

    private static class DelegatingConnectionFactory
    implements ConnectionFactory {
        private final ConnectionFactory factory;

        public DelegatingConnectionFactory(ConnectionFactory factory) {
            this.factory = factory;
        }

        public OptiqConnection createConnection() throws Exception {
            return this.factory.createConnection();
        }
    }

    private static class ConfigConnectionFactory
    implements ConnectionFactory {
        private final Config config;

        public ConfigConnectionFactory(Config config) {
            this.config = config;
        }

        public OptiqConnection createConnection() throws Exception {
            switch (this.config) {
                case REGULAR: {
                    return OptiqAssert.getConnection("hr", "foodmart");
                }
                case REGULAR_PLUS_METADATA: {
                    return OptiqAssert.getConnection("hr", "foodmart", "metadata");
                }
                case LINGUAL: {
                    return OptiqAssert.getConnection("lingual");
                }
                case JDBC_FOODMART: {
                    return OptiqAssert.getConnection(false);
                }
                case FOODMART_CLONE: {
                    return OptiqAssert.getConnection(true);
                }
                case SPARK: {
                    return OptiqAssert.getConnection("spark");
                }
            }
            throw Util.unexpected((Enum)this.config);
        }
    }

    public static interface ConnectionFactory {
        public OptiqConnection createConnection() throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AssertThat {
        private final ConnectionFactory connectionFactory;

        private AssertThat(Config config) {
            this(new ConfigConnectionFactory(config));
        }

        private AssertThat(ConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
        }

        public AssertThat with(Config config) {
            return new AssertThat(config);
        }

        public AssertThat with(ConnectionFactory connectionFactory) {
            return new AssertThat(connectionFactory);
        }

        public AssertThat with(final Map<String, String> map) {
            return new AssertThat(new ConnectionFactory(){

                public OptiqConnection createConnection() throws Exception {
                    Class.forName("net.hydromatic.optiq.jdbc.Driver");
                    Properties info = new Properties();
                    for (Map.Entry entry : map.entrySet()) {
                        info.setProperty((String)entry.getKey(), (String)entry.getValue());
                    }
                    return (OptiqConnection)DriverManager.getConnection("jdbc:optiq:", info);
                }
            });
        }

        public AssertThat with(final String name, final Object schema) {
            return this.with(new ConnectionFactory(){

                public OptiqConnection createConnection() throws Exception {
                    Class.forName("net.hydromatic.optiq.jdbc.Driver");
                    Connection connection = DriverManager.getConnection("jdbc:optiq:");
                    OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
                    SchemaPlus rootSchema = optiqConnection.getRootSchema();
                    rootSchema.add(name, (Schema)new ReflectiveSchema(name, schema));
                    optiqConnection.setSchema(name);
                    return optiqConnection;
                }
            });
        }

        public AssertThat withModel(final String model) {
            return new AssertThat(new ConnectionFactory(){

                public OptiqConnection createConnection() throws Exception {
                    Class.forName("net.hydromatic.optiq.jdbc.Driver");
                    Properties info = new Properties();
                    info.setProperty("model", "inline:" + model);
                    return (OptiqConnection)DriverManager.getConnection("jdbc:optiq:", info);
                }
            });
        }

        public AssertThat withMaterializations(String model, String ... materializations) {
            String model2;
            assert (materializations.length % 2 == 0);
            JsonBuilder builder = new JsonBuilder();
            List list = builder.list();
            for (int i = 0; i < materializations.length; ++i) {
                String table = materializations[i++];
                Map map = builder.map();
                map.put("table", table);
                map.put("view", table + "v");
                String sql = materializations[i];
                String sql2 = sql.replaceAll("`", "\"");
                map.put("sql", sql2);
                list.add(map);
            }
            String buf = "materializations: " + builder.toJsonString((Object)list);
            if (model.contains("defaultSchema: 'foodmart'")) {
                model2 = model.replace("]", ", { name: 'mat', " + buf + "}\n" + "]");
            } else if (model.contains("type: ")) {
                model2 = model.replace("type: ", buf + ",\n" + "type: ");
            } else {
                throw new AssertionError((Object)"do not know where to splice");
            }
            return this.withModel(model2);
        }

        public AssertQuery query(String sql) {
            return new AssertQuery(this.connectionFactory, sql);
        }

        public void connectThrows(String message) {
            this.connectThrows(OptiqAssert.checkException(message));
        }

        public void connectThrows(Function1<Throwable, Void> exceptionChecker) {
            Throwable throwable;
            try {
                OptiqConnection x = this.connectionFactory.createConnection();
                try {
                    x.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
                throwable = null;
            }
            catch (Throwable e) {
                throwable = e;
            }
            exceptionChecker.apply((Object)throwable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> AssertThat doWithConnection(Function1<OptiqConnection, T> fn) throws Exception {
            OptiqConnection connection = this.connectionFactory.createConnection();
            try {
                Object t = fn.apply((Object)connection);
                Util.discard((Object)t);
                AssertThat assertThat = this;
                return assertThat;
            }
            finally {
                connection.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> AssertThat doWithDataContext(Function1<DataContext, T> fn) throws Exception {
            OptiqConnection connection = this.connectionFactory.createConnection();
            DataContext dataContext = MetaImpl.createDataContext((OptiqConnection)connection);
            try {
                Object t = fn.apply((Object)dataContext);
                Util.discard((Object)t);
                AssertThat assertThat = this;
                return assertThat;
            }
            finally {
                connection.close();
            }
        }

        public AssertThat withSchema(String schema) {
            return new AssertThat(new SchemaConnectionFactory(this.connectionFactory, schema));
        }

        public AssertThat enable(boolean enabled) {
            return enabled ? this : DISABLED;
        }
    }
}

