/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util;

import org.eigenbase.util.OptionsList;

public abstract class MainApp {
    protected final String[] args;
    private OptionsList options = new OptionsList();
    private int exitCode;

    protected MainApp(String[] args) {
        this.args = args;
        this.exitCode = 0;
    }

    public abstract void mainImpl() throws Exception;

    public final void run() {
        try {
            this.initializeOptions();
            this.mainImpl();
        }
        catch (Throwable e) {
            this.handle(e);
        }
        System.exit(this.exitCode);
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public void handle(Throwable throwable) {
        throwable.printStackTrace();
    }

    public void parseOptions(OptionsList.OptionHandler values) {
        this.options.parse(this.args);
    }

    protected void initializeOptions() {
        this.options.add(new OptionsList.BooleanOption("-h", "help", "Prints command-line parameters", false, false, false));
    }
}

