/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import java.util.Arrays;
import java.util.List;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlSelect;
import org.eigenbase.sql.SqlSpecialOperator;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlDelete
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("DELETE", SqlKind.DELETE);
    SqlIdentifier targetTable;
    SqlNode condition;
    SqlSelect sourceSelect;
    SqlIdentifier alias;

    public SqlDelete(SqlParserPos pos, SqlIdentifier targetTable, SqlNode condition, SqlSelect sourceSelect, SqlIdentifier alias) {
        super(pos);
        this.targetTable = targetTable;
        this.condition = condition;
        this.sourceSelect = sourceSelect;
        this.alias = alias;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.DELETE;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return Arrays.asList(this.targetTable, this.condition, this.alias);
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        switch (i) {
            case 0: {
                this.targetTable = (SqlIdentifier)operand;
                break;
            }
            case 1: {
                this.condition = operand;
                break;
            }
            case 2: {
                this.sourceSelect = (SqlSelect)operand;
                break;
            }
            case 3: {
                this.alias = (SqlIdentifier)operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    public SqlIdentifier getTargetTable() {
        return this.targetTable;
    }

    public SqlIdentifier getAlias() {
        return this.alias;
    }

    public SqlNode getCondition() {
        return this.condition;
    }

    public SqlSelect getSourceSelect() {
        return this.sourceSelect;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SELECT, "DELETE FROM", "");
        int opLeft = this.getOperator().getLeftPrec();
        int opRight = this.getOperator().getRightPrec();
        this.targetTable.unparse(writer, opLeft, opRight);
        if (this.alias != null) {
            writer.keyword("AS");
            this.alias.unparse(writer, opLeft, opRight);
        }
        if (this.condition != null) {
            writer.sep("WHERE");
            this.condition.unparse(writer, opLeft, opRight);
        }
        writer.endList(frame);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateDelete(this);
    }

    public void setSourceSelect(SqlSelect sourceSelect) {
        this.sourceSelect = sourceSelect;
    }
}

