/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRel;
import org.eigenbase.rel.Aggregation;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelCollationImpl;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelVisitor;
import org.eigenbase.rel.rules.RemoveTrivialProjectRule;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexShuttle;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.trace.EigenbaseTrace;
import org.eigenbase.util.IntList;
import org.eigenbase.util.Pair;
import org.eigenbase.util.mapping.Mapping;
import org.eigenbase.util.mapping.Mappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstitutionVisitor {
    private static final boolean DEBUG = OptiqPrepareImpl.DEBUG;
    private static final Logger LOGGER = EigenbaseTrace.getPlannerTracer();
    private static final List<UnifyRule> RULES = ImmutableList.of((Object)TrivialRule.access$000(), (Object)ProjectToProjectUnifyRule.INSTANCE, (Object)FilterToProjectUnifyRule.INSTANCE, (Object)FilterToFilterUnifyRule.INSTANCE, (Object)AggregateToAggregateUnifyRule.INSTANCE, (Object)AggregateOnProjectToAggregateUnifyRule.INSTANCE);
    private static final Map<Pair<Class, Class>, List<UnifyRule>> RULE_MAP = new HashMap<Pair<Class, Class>, List<UnifyRule>>();
    private final RelVisitor registrar = new RelVisitor(){

        public void visit(RelNode node, int ordinal, RelNode parent) {
            if (parent != null) {
                SubstitutionVisitor.this.parentMap.put(node, new Parentage(parent, ordinal));
            }
            super.visit(node, ordinal, parent);
        }
    };
    private final RelNode query;
    private final RelNode target;
    final Map<RelNode, Parentage> parentMap = new IdentityHashMap<RelNode, Parentage>();
    final List<RelNode> targetLeaves;
    final List<RelNode> queryLeaves;
    final Map<RelNode, RelNode> replacementMap = new HashMap<RelNode, RelNode>();

    public SubstitutionVisitor(RelNode target, RelNode query) {
        this.query = query;
        this.target = target;
        final HashSet parents = new HashSet();
        final ArrayList allNodes = new ArrayList();
        RelVisitor visitor = new RelVisitor(){

            public void visit(RelNode node, int ordinal, RelNode parent) {
                SubstitutionVisitor.this.parentMap.put(node, new Parentage(parent, ordinal));
                parents.add(parent);
                allNodes.add(node);
                super.visit(node, ordinal, parent);
            }
        };
        visitor.go(target);
        allNodes.removeAll(parents);
        this.targetLeaves = ImmutableList.copyOf(allNodes);
        allNodes.clear();
        visitor.go(query);
        allNodes.removeAll(parents);
        this.queryLeaves = ImmutableList.copyOf(allNodes);
    }

    void register(RelNode result, RelNode query) {
        this.equiv(result, query);
        this.registrar.go(result);
    }

    void equiv(RelNode result, RelNode query) {
        Parentage parentage;
        if (result != query && this.parentMap.get(result) == null && (parentage = this.parentMap.get(query)) != null) {
            this.parentMap.put(result, parentage);
        }
    }

    @VisibleForTesting
    public static RexNode splitFilter(RexBuilder rexBuilder, RexNode condition, RexNode target) {
        RexNode z = SubstitutionVisitor.splitOr(rexBuilder, condition, target);
        if (z != null) {
            return z;
        }
        RexNode x = SubstitutionVisitor.andNot(rexBuilder, target, condition);
        if (SubstitutionVisitor.mayBeSatisfiable(x)) {
            RexNode x2 = SubstitutionVisitor.andNot(rexBuilder, condition, target);
            return SubstitutionVisitor.simplify(rexBuilder, x2);
        }
        return null;
    }

    private static RexNode splitOr(RexBuilder rexBuilder, RexNode condition, RexNode target) {
        List<RexNode> targets = RelOptUtil.disjunctions(target);
        for (RexNode e : RelOptUtil.disjunctions(condition)) {
            boolean found = SubstitutionVisitor.removeAll(targets, e);
            if (found) continue;
            return null;
        }
        return RexUtil.composeConjunction(rexBuilder, Lists.transform(targets, SubstitutionVisitor.not(rexBuilder)), false);
    }

    public static Function<RexNode, RexNode> not(final RexBuilder rexBuilder) {
        return new Function<RexNode, RexNode>(){

            public RexNode apply(RexNode input) {
                return input.isAlwaysTrue() ? rexBuilder.makeLiteral(false) : (input.isAlwaysFalse() ? rexBuilder.makeLiteral(true) : (input.getKind() == SqlKind.NOT ? (RexNode)((RexCall)input).operands.get(0) : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, input)));
            }
        };
    }

    private static boolean removeAll(List<RexNode> targets, RexNode e) {
        int count = 0;
        Iterator<RexNode> iterator = targets.iterator();
        while (iterator.hasNext()) {
            RexNode next = iterator.next();
            if (!SubstitutionVisitor.equivalent(next, e)) continue;
            ++count;
            iterator.remove();
        }
        return count > 0;
    }

    private static boolean equivalent(RexNode e1, RexNode e2) {
        return e1 == e2 || e1.toString().equals(e2.toString());
    }

    public static boolean mayBeSatisfiable(RexNode e) {
        ArrayList<RexNode> disjunctions = new ArrayList<RexNode>();
        ArrayList<RexNode> notDisjunctions = new ArrayList<RexNode>();
        RelOptUtil.decomposeConjunction(e, disjunctions, notDisjunctions);
        for (RexNode disjunction : disjunctions) {
            switch (disjunction.getKind()) {
                case LITERAL: {
                    if (RexLiteral.booleanValue(disjunction)) break;
                    return false;
                }
            }
        }
        for (RexNode disjunction : notDisjunctions) {
            switch (disjunction.getKind()) {
                case LITERAL: {
                    if (!RexLiteral.booleanValue(disjunction)) break;
                    return false;
                }
            }
        }
        for (RexNode notDisjunction : notDisjunctions) {
            List<RexNode> disjunctions2 = RelOptUtil.conjunctions(notDisjunction);
            if (!disjunctions.containsAll(disjunctions2)) continue;
            return false;
        }
        return true;
    }

    public static RexNode simplify(RexBuilder rexBuilder, RexNode e) {
        List<RexNode> disjunctions = RelOptUtil.conjunctions(e);
        ArrayList<RexNode> notDisjunctions = new ArrayList<RexNode>();
        block4: for (int i = 0; i < disjunctions.size(); ++i) {
            RexNode disjunction = disjunctions.get(i);
            SqlKind kind = disjunction.getKind();
            switch (kind) {
                case NOT: {
                    notDisjunctions.add(((RexCall)disjunction).getOperands().get(0));
                    disjunctions.remove(i);
                    --i;
                    continue block4;
                }
                case LITERAL: {
                    if (!RexLiteral.booleanValue(disjunction)) {
                        return disjunction;
                    }
                    disjunctions.remove(i);
                    --i;
                }
            }
        }
        if (disjunctions.isEmpty() && notDisjunctions.isEmpty()) {
            return rexBuilder.makeLiteral(true);
        }
        for (RexNode notDisjunction : notDisjunctions) {
            List<RexNode> disjunctions2 = RelOptUtil.conjunctions(notDisjunction);
            if (!disjunctions.containsAll(disjunctions2)) continue;
            return rexBuilder.makeLiteral(false);
        }
        for (RexNode notDisjunction : notDisjunctions) {
            disjunctions.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, notDisjunction));
        }
        return RexUtil.composeConjunction(rexBuilder, disjunctions, false);
    }

    static RexNode andNot(RexBuilder rexBuilder, RexNode e1, RexNode e2) {
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, e1, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, e2));
    }

    public RelNode go(RelNode replacement) {
        assert (RelOptUtil.equalType("target", this.target, "replacement", replacement, true));
        this.replacementMap.put(this.target, replacement);
        UnifyResult unifyResult = this.matchRecurse(this.target);
        if (unifyResult == null) {
            return null;
        }
        RelNode node0 = unifyResult.result;
        RelNode node = this.replaceAncestors(node0);
        if (DEBUG) {
            System.out.println("Convert: query:\n" + RelOptUtil.toString(this.query) + "\nunify.query:\n" + RelOptUtil.toString(((UnifyResult)unifyResult).call.query) + "\nunify.result:\n" + RelOptUtil.toString(unifyResult.result) + "\nunify.target:\n" + RelOptUtil.toString(((UnifyResult)unifyResult).call.target) + "\nnode0:\n" + RelOptUtil.toString(node0) + "\nnode:\n" + RelOptUtil.toString(node));
        }
        return node;
    }

    private RelNode replaceAncestors(RelNode node) {
        Parentage parentage;
        while ((parentage = this.parentMap.get(node)) != null && parentage.parent != null) {
            node = RelOptUtil.replaceInput(parentage.parent, parentage.ordinal, node);
        }
        return node;
    }

    private UnifyResult matchRecurse(RelNode target) {
        List<RelNode> targetInputs = target.getInputs();
        RelNode queryParent = null;
        for (RelNode targetInput : targetInputs) {
            UnifyResult unifyResult = this.matchRecurse(targetInput);
            if (unifyResult == null) {
                return null;
            }
            Parentage parentage = this.parentMap.get(((UnifyResult)unifyResult).call.query);
            this.parentMap.put(unifyResult.result, parentage);
            queryParent = RelOptUtil.replaceInput(parentage.parent, parentage.ordinal, unifyResult.result);
            this.equiv(queryParent, parentage.parent);
        }
        if (targetInputs.isEmpty()) {
            for (RelNode queryLeaf : this.queryLeaves) {
                for (UnifyRule rule : SubstitutionVisitor.applicableRules(queryLeaf, target)) {
                    UnifyResult x = this.apply(rule, queryLeaf, target);
                    if (x == null) continue;
                    if (DEBUG) {
                        System.out.println("Rule: " + rule + "\nQuery:\n" + RelOptUtil.toString(queryParent) + (((UnifyResult)x).call.query != queryParent ? "\nQuery (original):\n" + RelOptUtil.toString(queryParent) : "") + "\nTarget:\n" + RelOptUtil.toString(target) + "\nResult:\n" + RelOptUtil.toString(x.result) + "\n");
                    }
                    return x;
                }
            }
        } else {
            for (UnifyRule rule : SubstitutionVisitor.applicableRules(queryParent, target)) {
                UnifyResult x = this.apply(rule, queryParent, target);
                if (x == null) continue;
                if (DEBUG) {
                    System.out.println("Rule: " + rule + "\nQuery:\n" + RelOptUtil.toString(queryParent) + (((UnifyResult)x).call.query != queryParent ? "\nQuery (original):\n" + RelOptUtil.toString(queryParent) : "") + "\nTarget:\n" + RelOptUtil.toString(target) + "\nResult:\n" + RelOptUtil.toString(x.result) + "\n");
                }
                return x;
            }
        }
        if (DEBUG) {
            System.out.println("Unify failed:\nQuery:\n" + RelOptUtil.toString(queryParent) + "\nTarget:\n" + RelOptUtil.toString(target) + "\n");
        }
        return null;
    }

    private UnifyResult apply(UnifyRule rule, RelNode query, RelNode target) {
        UnifyRuleCall call = new UnifyRuleCall(rule, query, target);
        return rule.apply(call);
    }

    private static List<UnifyRule> applicableRules(RelNode query, RelNode target) {
        Class<?> targetClass;
        Class<?> queryClass = query.getClass();
        Pair<Class<?>, Class<?>> key = Pair.of(queryClass, targetClass = target.getClass());
        ImmutableList list = RULE_MAP.get(key);
        if (list == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (UnifyRule rule : RULES) {
                if (!rule.mightMatch(queryClass, targetClass)) continue;
                builder.add((Object)rule);
            }
            list = builder.build();
            RULE_MAP.put(key, (List<UnifyRule>)list);
        }
        return list;
    }

    public static AggregateRel permute(AggregateRel aggregate, RelNode input, Mapping mapping) {
        BitSet groupSet = Mappings.apply(mapping, aggregate.getGroupSet());
        List<AggregateCall> aggregateCalls = SubstitutionVisitor.apply(mapping, aggregate.getAggCallList());
        return aggregate.copy(aggregate.getTraitSet(), input, groupSet, (List)aggregateCalls);
    }

    private static List<AggregateCall> apply(final Mapping mapping, List<AggregateCall> aggCallList) {
        return Lists.transform(aggCallList, (Function)new Function<AggregateCall, AggregateCall>(){

            public AggregateCall apply(AggregateCall call) {
                return new AggregateCall(call.getAggregation(), call.isDistinct(), Mappings.apply2(mapping, call.getArgList()), call.getType(), call.name);
            }
        });
    }

    public static RelNode unifyAggregates(AggregateRel query, AggregateRel target) {
        RelNode result;
        if (query.getGroupSet().equals(target.getGroupSet())) {
            ArrayList projects = Lists.newArrayList();
            int groupCount = query.getGroupSet().cardinality();
            for (int i = 0; i < groupCount; ++i) {
                projects.add(i);
            }
            for (AggregateCall aggregateCall : query.getAggCallList()) {
                int i = target.getAggCallList().indexOf(aggregateCall);
                if (i < 0) {
                    return null;
                }
                projects.add(groupCount + i);
            }
            result = CalcRel.createProject(target, projects);
        } else {
            BitSet groupSet = new BitSet();
            IntList targetGroupList = BitSets.toList(target.getGroupSet());
            for (int c : BitSets.toIter(query.getGroupSet())) {
                int c2 = targetGroupList.indexOf(c);
                if (c2 < 0) {
                    return null;
                }
                groupSet.set(c2);
            }
            ArrayList aggregateCalls = Lists.newArrayList();
            for (AggregateCall aggregateCall : query.getAggCallList()) {
                if (aggregateCall.isDistinct()) {
                    return null;
                }
                int i = target.getAggCallList().indexOf(aggregateCall);
                if (i < 0) {
                    return null;
                }
                aggregateCalls.add(new AggregateCall(SubstitutionVisitor.getRollup(aggregateCall.getAggregation()), aggregateCall.isDistinct(), (List<Integer>)ImmutableList.of((Object)(groupSet.cardinality() + i)), aggregateCall.type, aggregateCall.name));
            }
            result = new AggregateRel(target.getCluster(), target, groupSet, aggregateCalls);
        }
        return RelOptUtil.createCastRel(result, query.getRowType(), true);
    }

    public static Aggregation getRollup(Aggregation aggregation) {
        return aggregation;
    }

    private static RexShuttle getRexShuttle(ProjectRel target) {
        final HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (RexNode e : target.getProjects()) {
            map.put(e.toString(), map.size());
        }
        return new RexShuttle(){

            public RexNode visitInputRef(RexInputRef ref) {
                Integer integer = (Integer)map.get(ref.getName());
                if (integer != null) {
                    return new RexInputRef(integer, ref.getType());
                }
                throw MatchFailed.INSTANCE;
            }

            public RexNode visitCall(RexCall call) {
                Integer integer = (Integer)map.get(call.toString());
                if (integer != null) {
                    return new RexInputRef(integer, call.getType());
                }
                return super.visitCall(call);
            }
        };
    }

    private static class Parentage {
        final RelNode parent;
        final int ordinal;

        private Parentage(RelNode parent, int ordinal) {
            this.parent = parent;
            this.ordinal = ordinal;
        }
    }

    private static class AggregateOnProjectToAggregateUnifyRule
    extends AbstractUnifyRule {
        public static final AggregateOnProjectToAggregateUnifyRule INSTANCE = new AggregateOnProjectToAggregateUnifyRule();

        private AggregateOnProjectToAggregateUnifyRule() {
            super(AggregateRel.class, AggregateRel.class);
        }

        public UnifyResult apply(UnifyRuleCall call) {
            AggregateRel query = (AggregateRel)call.query;
            AggregateRel target = (AggregateRel)call.target;
            if (!(query.getChild() instanceof ProjectRel)) {
                return null;
            }
            ProjectRel project = (ProjectRel)query.getChild();
            if (project.getChild() != target.getChild()) {
                return null;
            }
            Mappings.TargetMapping mapping = project.getMapping();
            if (mapping == null) {
                return null;
            }
            AggregateRel aggregate2 = SubstitutionVisitor.permute(query, project.getChild(), mapping.inverse());
            RelNode result = SubstitutionVisitor.unifyAggregates(aggregate2, target);
            return result == null ? null : call.result(result);
        }
    }

    private static class AggregateToAggregateUnifyRule
    extends AbstractUnifyRule {
        public static final AggregateToAggregateUnifyRule INSTANCE = new AggregateToAggregateUnifyRule();

        private AggregateToAggregateUnifyRule() {
            super(AggregateRel.class, AggregateRel.class);
        }

        public UnifyResult apply(UnifyRuleCall call) {
            AggregateRel query = (AggregateRel)call.query;
            AggregateRel target = (AggregateRel)call.target;
            assert (query != target);
            if (query.getChild() != target.getChild()) {
                return null;
            }
            if (!BitSets.contains(target.getGroupSet(), query.getGroupSet())) {
                return null;
            }
            RelNode result = SubstitutionVisitor.unifyAggregates(query, target);
            if (result == null) {
                return null;
            }
            return call.result(result);
        }
    }

    private static class ProjectToFilterUnifyRule
    extends AbstractUnifyRule {
        public static final ProjectToFilterUnifyRule INSTANCE = new ProjectToFilterUnifyRule();

        private ProjectToFilterUnifyRule() {
            super(ProjectRel.class, FilterRel.class);
        }

        public UnifyResult apply(UnifyRuleCall call) {
            Parentage queryParent = call.parent(call.query);
            if (queryParent.parent instanceof FilterRel) {
                UnifyRuleCall in2 = call.create(queryParent.parent);
                FilterRel query = (FilterRel)in2.query;
                FilterRel target = (FilterRel)in2.target;
                FilterRel newFilter = FilterToFilterUnifyRule.INSTANCE.createFilter(query, target);
                if (newFilter == null) {
                    return null;
                }
                return in2.result(call.query.copy(call.query.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)newFilter)));
            }
            return null;
        }
    }

    private static class FilterToFilterUnifyRule
    extends AbstractUnifyRule {
        public static final FilterToFilterUnifyRule INSTANCE = new FilterToFilterUnifyRule();

        private FilterToFilterUnifyRule() {
            super(FilterRel.class, FilterRel.class);
        }

        public UnifyResult apply(UnifyRuleCall call) {
            FilterRel query = (FilterRel)call.query;
            FilterRel target = (FilterRel)call.target;
            FilterRel newFilter = this.createFilter(query, target);
            if (newFilter == null) {
                return null;
            }
            return call.result(newFilter);
        }

        FilterRel createFilter(FilterRel query, FilterRel target) {
            RelOptCluster cluster = query.getCluster();
            RexNode newCondition = SubstitutionVisitor.splitFilter(cluster.getRexBuilder(), query.getCondition(), target.getCondition());
            if (newCondition == null) {
                return null;
            }
            if (newCondition.isAlwaysTrue()) {
                return target;
            }
            return new FilterRel(cluster, target, newCondition);
        }
    }

    private static class FilterToProjectUnifyRule
    extends AbstractUnifyRule {
        public static final FilterToProjectUnifyRule INSTANCE = new FilterToProjectUnifyRule();

        private FilterToProjectUnifyRule() {
            super(FilterRel.class, ProjectRel.class);
        }

        public UnifyResult apply(UnifyRuleCall call) {
            try {
                RexNode newCondition;
                ProjectRel target = (ProjectRel)call.target;
                RexShuttle shuttle = SubstitutionVisitor.getRexShuttle(target);
                FilterRel query = (FilterRel)call.query;
                try {
                    newCondition = query.getCondition().accept(shuttle);
                }
                catch (MatchFailed e) {
                    return null;
                }
                FilterRel newFilter = new FilterRel(query.getCluster(), target, newCondition);
                RelNode inverse = this.invert(query, newFilter, target);
                return call.result(inverse);
            }
            catch (MatchFailed e) {
                return null;
            }
        }

        private RelNode invert(RelNode model, RelNode input, ProjectRel project) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("SubstitutionVisitor: invert:\nmodel: " + model + "\n" + "input: " + input + "\n" + "project: " + project + "\n");
            }
            ArrayList<RexNode> exprList = new ArrayList<RexNode>();
            RexBuilder rexBuilder = model.getCluster().getRexBuilder();
            for (RelDataTypeField field : model.getRowType().getFieldList()) {
                exprList.add(rexBuilder.makeZeroLiteral(field.getType()));
            }
            for (Ord expr : Ord.zip(project.getProjects())) {
                if (!(expr.e instanceof RexInputRef)) continue;
                int target = ((RexInputRef)expr.e).getIndex();
                exprList.set(expr.i, rexBuilder.makeInputRef(input, target));
            }
            return new ProjectRel(model.getCluster(), model.getTraitSet(), input, exprList, model.getRowType(), 1);
        }
    }

    private static class ProjectToProjectUnifyRule
    extends AbstractUnifyRule {
        public static final ProjectToProjectUnifyRule INSTANCE = new ProjectToProjectUnifyRule();

        private ProjectToProjectUnifyRule() {
            super(ProjectRel.class, ProjectRel.class);
        }

        public UnifyResult apply(UnifyRuleCall call) {
            List<RexNode> newProjects;
            ProjectRel target = (ProjectRel)call.target;
            ProjectRel query = (ProjectRel)call.query;
            RexShuttle shuttle = SubstitutionVisitor.getRexShuttle(target);
            try {
                newProjects = shuttle.apply(query.getProjects());
            }
            catch (MatchFailed e) {
                return null;
            }
            ProjectRel newProject = new ProjectRel(target.getCluster(), target.getCluster().traitSetOf(query.getCollationList().isEmpty() ? RelCollationImpl.EMPTY : query.getCollationList().get(0)), target, newProjects, query.getRowType(), query.getFlags());
            RelNode newProject2 = RemoveTrivialProjectRule.strip(newProject);
            return call.result(newProject2);
        }
    }

    private static class TrivialRule
    extends AbstractUnifyRule {
        private static final TrivialRule INSTANCE = new TrivialRule();

        private TrivialRule() {
            super(RelNode.class, RelNode.class);
        }

        public UnifyResult apply(UnifyRuleCall call) {
            if (call.query == call.target) {
                return call.result(call.query);
            }
            return null;
        }

        static /* synthetic */ TrivialRule access$000() {
            return INSTANCE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractUnifyRule
    implements UnifyRule {
        private final Class<? extends RelNode> queryClass;
        private final Class<? extends RelNode> targetClass;

        public AbstractUnifyRule(Class<? extends RelNode> queryClass, Class<? extends RelNode> targetClass) {
            this.queryClass = queryClass;
            this.targetClass = targetClass;
        }

        @Override
        public boolean mightMatch(Class queryClass, Class targetClass) {
            return this.queryClass.isAssignableFrom(queryClass) && this.targetClass.isAssignableFrom(targetClass);
        }
    }

    private static class UnifyResult {
        private final UnifyRuleCall call;
        private final RelNode result;

        UnifyResult(UnifyRuleCall call, RelNode result) {
            this.call = call;
            assert (RelOptUtil.equalType("query", call.query, "result", result, true));
            this.result = result;
        }
    }

    private class UnifyRuleCall {
        final UnifyRule rule;
        final RelNode query;
        final RelNode target;

        public UnifyRuleCall(UnifyRule rule, RelNode query, RelNode target) {
            this.rule = rule;
            this.query = query;
            this.target = target;
        }

        public Parentage parent(RelNode node) {
            return SubstitutionVisitor.this.parentMap.get(node);
        }

        UnifyResult result(RelNode result) {
            assert (RelOptUtil.contains(result, this.target));
            assert (RelOptUtil.equalType("result", result, "query", this.query, true));
            SubstitutionVisitor.this.equiv(result, this.query);
            RelNode replace = SubstitutionVisitor.this.replacementMap.get(this.target);
            if (replace != null) {
                result = RelOptUtil.replace(result, this.target, replace);
            }
            SubstitutionVisitor.this.register(result, this.query);
            return new UnifyResult(this, result);
        }

        public UnifyRuleCall create(RelNode query) {
            return new UnifyRuleCall(this.rule, query, this.target);
        }
    }

    private static interface UnifyRule {
        public UnifyResult apply(UnifyRuleCall var1);

        public boolean mightMatch(Class var1, Class var2);
    }

    private static class MatchFailed
    extends RuntimeException {
        public static final MatchFailed INSTANCE = new MatchFailed();

        private MatchFailed() {
        }
    }
}

