/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.test;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelVisitor;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.RelXmlWriter;
import org.eigenbase.sql.SqlExplainLevel;
import org.eigenbase.test.DiffRepository;
import org.eigenbase.test.SqlToRelTestBase;
import org.eigenbase.util.TestUtil;
import org.eigenbase.util.Util;
import org.junit.Test;

public class SqlToRelConverterTest
extends SqlToRelTestBase {
    protected DiffRepository getDiffRepos() {
        return DiffRepository.lookup(SqlToRelConverterTest.class);
    }

    protected final void check(String sql, String plan) {
        this.tester.assertConvertsTo(sql, plan);
    }

    @Test
    public void testIntegerLiteral() {
        this.check("select 1 from emp", "${plan}");
    }

    @Test
    public void testAliasList() {
        this.check("select a + b from (\n  select deptno, 1 as one, name from dept\n) as d(a, b, c)\nwhere c like 'X%'", "${plan}");
    }

    @Test
    public void testAliasList2() {
        this.check("select * from (\n  select a, b, c from (values (1, 2, 3)) as t (c, b, a)\n) join dept on dept.deptno = c\norder by c + a", "${plan}");
    }

    @Test
    public void testMultiAnd() {
        this.check("select * from emp\nwhere deptno < 10\nand deptno > 5\nand (deptno = 8 or empno < 100)", "${plan}");
    }

    @Test
    public void testJoinOn() {
        this.check("SELECT * FROM emp JOIN dept on emp.deptno = dept.deptno", "${plan}");
    }

    @Test
    public void testJoinOnExpression() {
        this.check("SELECT * FROM emp JOIN dept on emp.deptno + 1 = dept.deptno - 2", "${plan}");
    }

    @Test
    public void testJoinOnIn() {
        this.check("select * from emp join dept\n on emp.deptno = dept.deptno and emp.empno in (1, 3)", "${plan}");
    }

    @Test
    public void testJoinUsing() {
        this.check("SELECT * FROM emp JOIN dept USING (deptno)", "${plan}");
    }

    @Test
    public void testJoinUsingThreeWay() {
        this.check("select *\nfrom emp as e\njoin dept as d using (deptno)\njoin emp as e2 using (empno)", "${plan}");
    }

    @Test
    public void testJoinUsingCompound() {
        this.check("SELECT * FROM emp LEFT JOIN (SELECT *, deptno * 5 as empno FROM dept) USING (deptno,empno)", "${plan}");
    }

    @Test
    public void testJoinNatural() {
        this.check("SELECT * FROM emp NATURAL JOIN dept", "${plan}");
    }

    @Test
    public void testJoinNaturalNoCommonColumn() {
        this.check("SELECT * FROM emp NATURAL JOIN (SELECT deptno AS foo, name FROM dept) AS d", "${plan}");
    }

    @Test
    public void testJoinNaturalMultipleCommonColumn() {
        this.check("SELECT * FROM emp NATURAL JOIN (SELECT deptno, name AS ename FROM dept) AS d", "${plan}");
    }

    @Test
    public void testJoinWithUnion() {
        this.check("select grade from (select empno from emp union select deptno from dept), salgrade", "${plan}");
    }

    @Test
    public void testGroup() {
        this.check("select deptno from emp group by deptno", "${plan}");
    }

    @Test
    public void testGroupJustOneAgg() {
        this.check("select deptno, sum(sal) as sum_sal from emp group by deptno", "${plan}");
    }

    @Test
    public void testGroupExpressionsInsideAndOut() {
        this.check("select deptno + 4, sum(sal), sum(3 + sal), 2 * count(sal) from emp group by deptno", "${plan}");
    }

    @Test
    public void testHaving() {
        this.check("select sum(sal + sal) from emp having sum(sal) > 10", "${plan}");
    }

    @Test
    public void testGroupBug281() {
        this.check("select name from (select name from dept group by name)", "${plan}");
    }

    @Test
    public void testGroupBug281b() {
        this.check("select name, foo from (select deptno, name, count(deptno) as foo from dept group by name, deptno, name)", "${plan}");
    }

    @Test
    public void testAggDistinct() {
        this.check("select deptno, sum(sal), sum(distinct sal), count(*) from emp group by deptno", "${plan}");
    }

    @Test
    public void testSelectDistinct() {
        this.check("select distinct sal + 5 from emp", "${plan}");
    }

    @Test
    public void testSelectDistinctGroup() {
        this.check("select distinct sum(sal) from emp group by deptno", "${plan}");
    }

    @Test
    public void testSelectDistinctDup() {
        this.check("select distinct sal + 5, deptno, sal + 5 from emp where deptno < 10", "${plan}");
    }

    @Test
    public void testDuplicateColumnsInSubQuery() {
        String sql = "select \"e\" from (\nselect empno as \"e\", deptno as d, 1 as \"e\" from EMP)";
        this.tester.assertConvertsTo(sql, "${plan}");
    }

    @Test
    public void testOrder() {
        this.check("select empno from emp order by empno", "${plan}");
    }

    @Test
    public void testOrderDescNullsLast() {
        this.check("select empno from emp order by empno desc nulls last", "${plan}");
    }

    @Test
    public void testOrderByOrdinalDesc() {
        if (!this.tester.getConformance().isSortByOrdinal()) {
            return;
        }
        this.check("select empno + 1, deptno, empno from emp order by 2 desc", "${plan}");
        this.check("select empno + 1, deptno, empno from emp order by 2.5 desc", "${plan}");
    }

    @Test
    public void testOrderDistinct() {
        this.check("select distinct empno, deptno + 1 from emp order by deptno + 1 + empno", "${plan}");
    }

    @Test
    public void testOrderByNegativeOrdinal() {
        this.check("select empno + 1, deptno, empno from emp order by -1 desc", "${plan}");
    }

    @Test
    public void testOrderByOrdinalInExpr() {
        this.check("select empno + 1, deptno, empno from emp order by 1 + 2 desc", "${plan}");
    }

    @Test
    public void testOrderByIdenticalExpr() {
        this.check("select empno + 1 from emp order by deptno asc, empno + 1 desc", "${plan}");
    }

    @Test
    public void testOrderByAlias() {
        this.check("select empno + 1 as x, empno - 2 as y from emp order by y", "${plan}");
    }

    @Test
    public void testOrderByAliasInExpr() {
        this.check("select empno + 1 as x, empno - 2 as y from emp order by y + 3", "${plan}");
    }

    @Test
    public void testOrderByAliasOverrides() {
        if (!this.tester.getConformance().isSortByAlias()) {
            return;
        }
        this.check("select empno + 1 as empno, empno - 2 as y from emp order by empno + 3", "${plan}");
    }

    @Test
    public void testOrderByAliasDoesNotOverride() {
        if (this.tester.getConformance().isSortByAlias()) {
            return;
        }
        this.check("select empno + 1 as empno, empno - 2 as y from emp order by empno + 3", "${plan}");
    }

    @Test
    public void testOrderBySameExpr() {
        this.check("select empno from emp, dept order by sal + empno desc, sal * empno, sal + empno", "${plan}");
    }

    @Test
    public void testOrderUnion() {
        this.check("select empno, sal from emp union all select deptno, deptno from dept order by sal desc, empno asc", "${plan}");
    }

    @Test
    public void testOrderUnionOrdinal() {
        if (!this.tester.getConformance().isSortByOrdinal()) {
            return;
        }
        this.check("select empno, sal from emp union all select deptno, deptno from dept order by 2", "${plan}");
    }

    @Test
    public void testOrderUnionExprs() {
        this.check("select empno, sal from emp union all select deptno, deptno from dept order by empno * sal + 2", "${plan}");
    }

    @Test
    public void testOrderOffsetFetch() {
        this.check("select empno from emp order by empno offset 10 rows fetch next 5 rows only", "${plan}");
    }

    @Test
    public void testOffsetFetch() {
        this.check("select empno from emp offset 10 rows fetch next 5 rows only", "${plan}");
    }

    @Test
    public void testOffset() {
        this.check("select empno from emp offset 10 rows", "${plan}");
    }

    @Test
    public void testFetch() {
        this.check("select empno from emp fetch next 5 rows only", "${plan}");
    }

    @Test
    public void testOrderGroup() {
        this.check("select deptno, count(*) from emp group by deptno order by deptno * sum(sal) desc, min(empno)", "${plan}");
    }

    @Test
    public void testCountNoGroup() {
        this.check("select count(*), sum(sal)\nfrom emp\nwhere empno > 10", "${plan}");
    }

    @Test
    public void testWith() {
        this.check("with emp2 as (select * from emp)\nselect * from emp2", "${plan}");
    }

    @Test
    public void testWithUnion() {
        this.check("with emp2 as (select * from emp where deptno > 10)\nselect empno from emp2 where deptno < 30 union all select deptno from emp", "${plan}");
    }

    @Test
    public void testWithInsideWhereExists() {
        this.check("select * from emp\nwhere exists (\n  with dept2 as (select * from dept where dept.deptno >= emp.deptno)\n  select 1 from dept2 where deptno <= emp.deptno)", "${plan}");
    }

    @Test
    public void testWithInsideScalarSubquery() {
        this.check("select (\n with dept2 as (select * from dept where deptno > 10) select count(*) from dept2) as c\nfrom emp", "${plan}");
    }

    @Test
    public void testExplicitTable() {
        this.check("table emp", "${plan}");
    }

    @Test
    public void testCollectionTable() {
        this.check("select * from table(ramp(3))", "${plan}");
    }

    @Test
    public void testSample() {
        this.check("select * from emp tablesample substitute('DATASET1') where empno > 5", "${plan}");
    }

    @Test
    public void testSampleQuery() {
        this.check("select * from (\n select * from emp as e tablesample substitute('DATASET1')\n join dept on e.deptno = dept.deptno\n) tablesample substitute('DATASET2')\nwhere empno > 5", "${plan}");
    }

    @Test
    public void testSampleBernoulli() {
        this.check("select * from emp tablesample bernoulli(50) where empno > 5", "${plan}");
    }

    @Test
    public void testSampleBernoulliQuery() {
        this.check("select * from (\n select * from emp as e tablesample bernoulli(10) repeatable(1)\n join dept on e.deptno = dept.deptno\n) tablesample bernoulli(50) repeatable(99)\nwhere empno > 5", "${plan}");
    }

    @Test
    public void testSampleSystem() {
        this.check("select * from emp tablesample system(50) where empno > 5", "${plan}");
    }

    @Test
    public void testSampleSystemQuery() {
        this.check("select * from (\n select * from emp as e tablesample system(10) repeatable(1)\n join dept on e.deptno = dept.deptno\n) tablesample system(50) repeatable(99)\nwhere empno > 5", "${plan}");
    }

    @Test
    public void testCollectionTableWithCursorParam() {
        this.check("select * from table(dedup(cursor(select ename from emp), cursor(select name from dept), 'NAME'))", "${plan}");
    }

    @Test
    public void testUnnest() {
        this.check("select*from unnest(multiset[1,2])", "${plan}");
    }

    @Test
    public void testUnnestSubquery() {
        this.check("select*from unnest(multiset(select*from dept))", "${plan}");
    }

    @Test
    public void testMultisetSubquery() {
        this.check("select multiset(select deptno from dept) from (values(true))", "${plan}");
    }

    @Test
    public void testMultiset() {
        this.check("select 'a',multiset[10] from dept", "${plan}");
    }

    @Test
    public void testMultisetOfColumns() {
        this.check("select 'abc',multiset[deptno,sal] from emp", "${plan}");
    }

    @Test
    public void testCorrelationJoin() {
        this.check("select *,         multiset(select * from emp where deptno=dept.deptno)                as empset      from dept", "${plan}");
    }

    @Test
    public void testExists() {
        this.check("select*from emp where exists (select 1 from dept where deptno=55)", "${plan}");
    }

    @Test
    public void testExistsCorrelated() {
        this.check("select*from emp where exists (select 1 from dept where emp.deptno=dept.deptno)", "${plan}");
    }

    @Test
    public void testInValueListShort() {
        this.check("select empno from emp where deptno in (10, 20)", "${plan}");
    }

    @Test
    public void testInValueListLong() {
        this.check("select empno from emp where deptno in (10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 110, 120, 130, 140, 150, 160, 170, 180, 190, 200, 210, 220, 230)", "${plan}");
    }

    @Test
    public void testInUncorrelatedSubquery() {
        this.check("select empno from emp where deptno in (select deptno from dept)", "${plan}");
    }

    @Test
    public void testUnnestSelect() {
        this.check("select*from unnest(select multiset[deptno] from dept)", "${plan}");
    }

    @Test
    public void testLateral() {
        this.check("select * from emp, LATERAL (select * from dept where emp.deptno=dept.deptno)", "${plan}");
    }

    @Test
    public void testElement() {
        this.check("select element(multiset[5]) from emp", "${plan}");
    }

    @Test
    public void testElementInValues() {
        this.check("values element(multiset[5])", "${plan}");
    }

    @Test
    public void testUnionAll() {
        this.check("select empno from emp union all select deptno from dept", "${plan}");
    }

    @Test
    public void testUnion() {
        this.check("select empno from emp union select deptno from dept", "${plan}");
    }

    @Test
    public void testUnionValues() {
        this.check("values (10), (20)\nunion all\nselect 34 from emp\nunion all values (30), (45 + 10)", "${plan}");
    }

    @Test
    public void testUnionSubquery() {
        this.check("select deptno from emp as emp0 cross join\n (select empno from emp union all \n  select deptno from dept where deptno > 20 union all\n  values (45), (67))", "${plan}");
    }

    @Test
    public void testIsDistinctFrom() {
        this.check("select 1 is distinct from 2 from (values(true))", "${plan}");
    }

    @Test
    public void testIsNotDistinctFrom() {
        this.check("select 1 is not distinct from 2 from (values(true))", "${plan}");
    }

    @Test
    public void testNotLike() {
        this.check("values ('a' not like 'b' escape 'c')", "${plan}");
    }

    @Test
    public void testOverMultiple() {
        this.check("select sum(sal) over w1,\n  sum(deptno) over w1,\n  sum(deptno) over w2\nfrom emp\nwhere deptno - sal > 999\nwindow w1 as (partition by job order by hiredate rows 2 preceding),\n  w2 as (partition by job order by hiredate rows 3 preceding disallow partial),\n  w3 as (partition by job order by hiredate range interval '1' second preceding)", "${plan}");
    }

    @Test
    public void testCase() {
        this.check("values (case 'a' when 'a' then 1 end)", "${plan}");
    }

    @Test
    public void testCharLength() {
        this.check("values (character_length('foo'))", "${plan}");
    }

    @Test
    public void testOverAvg() {
        this.check("select sum(sal) over w1,\n  avg(sal) over w1\nfrom emp\nwindow w1 as (partition by job order by hiredate rows 2 preceding)", "${plan}");
    }

    @Test
    public void testOverAvg2() {
        this.check("select sum(sal) over w1,\n  avg(CAST(sal as real)) over w1\nfrom emp\nwindow w1 as (partition by job order by hiredate rows 2 preceding)", "${plan}");
    }

    @Test
    public void testOverCountStar() {
        this.check("select count(sal) over w1,\n  count(*) over w1\nfrom emp\nwindow w1 as (partition by job order by hiredate rows 2 preceding)", "${plan}");
    }

    @Test
    public void testOverOrderWindow() {
        this.check("select last_value(deptno) over w\nfrom emp\nwindow w as (order by empno)", "${plan}");
        this.check("select last_value(deptno) over (order by empno)\nfrom emp\n", "${plan}");
    }

    @Test
    public void testOverOrderFollowingWindow() {
        this.check("select last_value(deptno) over w\nfrom emp\nwindow w as (order by empno rows 2 following)", "${plan}");
        this.check("select last_value(deptno) over (order by empno rows 2 following)\nfrom emp\n", "${plan}");
    }

    @Test
    public void testInterval() {
    }

    @Test
    public void testExplainAsXml() {
        String sql = "select 1 + 2, 3 from (values (true))";
        RelNode rel = this.tester.convertSqlToRel(sql);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        RelXmlWriter planWriter = new RelXmlWriter(pw, SqlExplainLevel.EXPPLAN_ATTRIBUTES);
        rel.explain((RelWriter)planWriter);
        pw.flush();
        TestUtil.assertEqualsVerbose("<RelNode type=\"ProjectRel\">\n\t<Property name=\"EXPR$0\">\n\t\t+(1, 2)\t</Property>\n\t<Property name=\"EXPR$1\">\n\t\t3\t</Property>\n\t<Inputs>\n\t\t<RelNode type=\"ValuesRel\">\n\t\t\t<Property name=\"tuples\">\n\t\t\t\t[{ true }]\t\t\t</Property>\n\t\t\t<Inputs/>\n\t\t</RelNode>\n\t</Inputs>\n</RelNode>\n", Util.toLinux((String)sw.toString()));
    }

    public static class RelValidityChecker
    extends RelVisitor {
        int invalidCount;

        public void visit(RelNode node, int ordinal, RelNode parent) {
            if (!node.isValid(true)) {
                ++this.invalidCount;
            }
            super.visit(node, ordinal, parent);
        }
    }
}

