/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.eigenbase.sql.SqlCollation;
import org.eigenbase.sql.test.DefaultSqlTestFactory;
import org.eigenbase.sql.test.DelegatingSqlTestFactory;
import org.eigenbase.sql.test.SqlTestFactory;
import org.eigenbase.sql.test.SqlTester;
import org.eigenbase.sql.test.SqlTesterImpl;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.test.SqlValidatorTest;
import org.eigenbase.util.BarfingInvocationHandler;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlTestGen {
    private SqlTestGen() {
    }

    public static void main(String[] args) {
        new SqlTestGen().genValidatorTest();
    }

    private void genValidatorTest() {
        FileOutputStream fos = null;
        PrintWriter pw = null;
        try {
            try {
                Method[] methods;
                File file = new File("validatorTest.sql");
                fos = new FileOutputStream(file);
                pw = new PrintWriter(fos);
                Method[] methodArray = methods = SqlTestGen.getJunitMethods(SqlValidatorSpooler.class);
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    SqlValidatorSpooler test = new SqlValidatorSpooler(pw);
                    Object result = method.invoke((Object)test, new Object[0]);
                    assert (result == null);
                    ++n2;
                }
            }
            catch (IOException e) {
                throw Util.newInternal((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw Util.newInternal((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw Util.newInternal((Throwable)e);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                throw Util.newInternal((Throwable)e);
            }
        }
        finally {
            if (pw != null) {
                pw.flush();
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw Util.newInternal((Throwable)e);
                }
            }
        }
    }

    private static Method[] getJunitMethods(Class<SqlValidatorSpooler> clazz) {
        ArrayList<Method> list = new ArrayList<Method>();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().startsWith("test") && Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers()) && method.getParameterTypes().length == 0 && method.getReturnType() == Void.TYPE) {
                list.add(method);
            }
            ++n2;
        }
        return list.toArray(new Method[list.size()]);
    }

    private static class SqlValidatorSpooler
    extends SqlValidatorTest {
        private final PrintWriter pw;

        private SqlValidatorSpooler(PrintWriter pw) {
            this.pw = pw;
        }

        public SqlTester getTester() {
            DelegatingSqlTestFactory factory = new DelegatingSqlTestFactory(DefaultSqlTestFactory.INSTANCE){

                public SqlValidator getValidator(SqlTestFactory factory) {
                    return (SqlValidator)Proxy.newProxyInstance(SqlValidatorSpooler.class.getClassLoader(), new Class[]{SqlValidator.class}, (InvocationHandler)((Object)new MyInvocationHandler()));
                }
            };
            return new SqlTesterImpl(factory){

                public void assertExceptionIsThrown(String sql, String expectedMsgPattern) {
                    if (expectedMsgPattern == null) {
                        SqlValidatorSpooler.this.pw.println("-- ");
                        SqlValidatorSpooler.this.pw.println(sql);
                        SqlValidatorSpooler.this.pw.println(";");
                    }
                }

                public void checkColumnType(String sql, String expected) {
                }

                public void checkResultType(String sql, String expected) {
                }

                public void checkType(String sql, String expected) {
                }

                public void checkCollation(String expression, String expectedCollationName, SqlCollation.Coercibility expectedCoercibility) {
                }

                public void checkCharset(String expression, Charset expectedCharset) {
                }

                public void checkIntervalConv(String sql, String expected) {
                }

                public void checkRewrite(SqlValidator validator, String query, String expectedRewrite) {
                }

                public void checkFieldOrigin(String sql, String fieldOriginList) {
                }
            };
        }

        public static class MyInvocationHandler
        extends BarfingInvocationHandler {
            public void setIdentifierExpansion(boolean b) {
            }

            public void setColumnReferenceExpansion(boolean b) {
            }

            public void setCallRewrite(boolean b) {
            }

            public boolean shouldExpandIdentifiers() {
                return true;
            }
        }
    }
}

