/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.test;

import java.math.BigDecimal;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sarg.SargBinding;
import org.eigenbase.sarg.SargBoundType;
import org.eigenbase.sarg.SargEndpoint;
import org.eigenbase.sarg.SargExpr;
import org.eigenbase.sarg.SargFactory;
import org.eigenbase.sarg.SargIntervalExpr;
import org.eigenbase.sarg.SargMutableEndpoint;
import org.eigenbase.sarg.SargRexAnalyzer;
import org.eigenbase.sarg.SargSetExpr;
import org.eigenbase.sarg.SargSetOperator;
import org.eigenbase.sarg.SargStrictness;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.type.SqlTypeFactoryImpl;
import org.eigenbase.sql.type.SqlTypeName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SargTest {
    private SargFactory sargFactory;
    private RexBuilder rexBuilder;
    private RelDataType intType;
    private RelDataType stringType;
    private RexNode intLiteral7;
    private RexNode intLiteral8point5;
    private RexNode intLiteral490;
    private SargIntervalExpr[] exprs;

    @Before
    public void setUp() {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl();
        this.intType = typeFactory.createSqlType(SqlTypeName.INTEGER);
        this.intType = typeFactory.createTypeWithNullability(this.intType, true);
        this.stringType = typeFactory.createSqlType(SqlTypeName.VARCHAR, 20);
        this.stringType = typeFactory.createTypeWithNullability(this.stringType, true);
        this.rexBuilder = new RexBuilder((RelDataTypeFactory)typeFactory);
        this.intLiteral7 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(7L), this.intType);
        this.intLiteral490 = this.rexBuilder.makeExactLiteral(BigDecimal.valueOf(490L), this.intType);
        this.intLiteral8point5 = this.rexBuilder.makeExactLiteral(new BigDecimal("8.5"), this.intType);
        this.sargFactory = new SargFactory(this.rexBuilder);
    }

    @Test
    public void testDefaultEndpoint() {
        SargMutableEndpoint ep = this.sargFactory.newEndpoint(this.intType);
        Assert.assertEquals((Object)"-infinity", (Object)ep.toString());
    }

    @Test
    public void testInfiniteEndpoint() {
        SargMutableEndpoint ep = this.sargFactory.newEndpoint(this.intType);
        ep.setInfinity(1);
        Assert.assertEquals((Object)"+infinity", (Object)ep.toString());
        ep.setInfinity(-1);
        Assert.assertEquals((Object)"-infinity", (Object)ep.toString());
    }

    @Test
    public void testFiniteEndpoint() {
        SargMutableEndpoint ep = this.sargFactory.newEndpoint(this.intType);
        ep.setFinite(SargBoundType.LOWER, SargStrictness.OPEN, this.intLiteral7);
        Assert.assertEquals((Object)"> 7", (Object)ep.toString());
        ep.setFinite(SargBoundType.LOWER, SargStrictness.CLOSED, this.intLiteral7);
        Assert.assertEquals((Object)">= 7", (Object)ep.toString());
        ep.setFinite(SargBoundType.UPPER, SargStrictness.OPEN, this.intLiteral7);
        Assert.assertEquals((Object)"< 7", (Object)ep.toString());
        ep.setFinite(SargBoundType.UPPER, SargStrictness.CLOSED, this.intLiteral7);
        Assert.assertEquals((Object)"<= 7", (Object)ep.toString());
        ep.setFinite(SargBoundType.LOWER, SargStrictness.OPEN, this.intLiteral8point5);
        Assert.assertEquals((Object)">= 9", (Object)ep.toString());
        ep.setFinite(SargBoundType.LOWER, SargStrictness.CLOSED, this.intLiteral8point5);
        Assert.assertEquals((Object)">= 9", (Object)ep.toString());
        ep.setFinite(SargBoundType.UPPER, SargStrictness.OPEN, this.intLiteral8point5);
        Assert.assertEquals((Object)"< 9", (Object)ep.toString());
        ep.setFinite(SargBoundType.UPPER, SargStrictness.CLOSED, this.intLiteral8point5);
        Assert.assertEquals((Object)"< 9", (Object)ep.toString());
    }

    @Test
    public void testNullEndpoint() {
        SargMutableEndpoint ep = this.sargFactory.newEndpoint(this.intType);
        ep.setFinite(SargBoundType.LOWER, SargStrictness.OPEN, this.sargFactory.newNullLiteral());
        Assert.assertEquals((Object)"> null", (Object)ep.toString());
    }

    @Test
    public void testTouchingEndpoint() {
        SargMutableEndpoint ep1 = this.sargFactory.newEndpoint(this.intType);
        SargMutableEndpoint ep2 = this.sargFactory.newEndpoint(this.intType);
        Assert.assertFalse((boolean)ep1.isTouching((SargEndpoint)ep2));
        ep1.setFinite(SargBoundType.UPPER, SargStrictness.OPEN, this.intLiteral7);
        ep2.setFinite(SargBoundType.LOWER, SargStrictness.OPEN, this.intLiteral7);
        Assert.assertFalse((boolean)ep1.isTouching((SargEndpoint)ep2));
        Assert.assertTrue((ep1.compareTo((SargEndpoint)ep2) < 0 ? 1 : 0) != 0);
        ep2.setFinite(SargBoundType.LOWER, SargStrictness.CLOSED, this.intLiteral7);
        Assert.assertTrue((boolean)ep1.isTouching((SargEndpoint)ep2));
        Assert.assertTrue((ep1.compareTo((SargEndpoint)ep2) < 0 ? 1 : 0) != 0);
        ep1.setFinite(SargBoundType.LOWER, SargStrictness.CLOSED, this.intLiteral7);
        Assert.assertTrue((boolean)ep1.isTouching((SargEndpoint)ep2));
        Assert.assertEquals((long)0L, (long)ep1.compareTo((SargEndpoint)ep2));
        ep2.setFinite(SargBoundType.LOWER, SargStrictness.CLOSED, this.intLiteral490);
        Assert.assertFalse((boolean)ep1.isTouching((SargEndpoint)ep2));
        Assert.assertTrue((ep1.compareTo((SargEndpoint)ep2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultIntervalExpr() {
        SargIntervalExpr interval = this.sargFactory.newIntervalExpr(this.intType);
        Assert.assertEquals((Object)"(-infinity, +infinity)", (Object)interval.toString());
    }

    @Test
    public void testPointExpr() {
        SargIntervalExpr interval = this.sargFactory.newIntervalExpr(this.intType);
        interval.setPoint(this.intLiteral7);
        Assert.assertTrue((boolean)interval.isPoint());
        Assert.assertFalse((boolean)interval.isUnconstrained());
        Assert.assertFalse((boolean)interval.isEmpty());
        Assert.assertEquals((Object)"[7]", (Object)interval.toString());
        Assert.assertEquals((Object)"[7]", (Object)interval.evaluate().toString());
    }

    @Test
    public void testRangeIntervalExpr() {
        SargIntervalExpr interval = this.sargFactory.newIntervalExpr(this.intType);
        interval.setLower(this.intLiteral7, SargStrictness.CLOSED);
        interval.setUpper(this.intLiteral490, SargStrictness.CLOSED);
        this.assertRange(interval);
        Assert.assertEquals((Object)"[7, 490]", (Object)interval.toString());
        Assert.assertEquals((Object)"[7, 490]", (Object)interval.evaluate().toString());
        interval.unsetLower();
        this.assertRange(interval);
        Assert.assertEquals((Object)"(-infinity, 490]", (Object)interval.toString());
        Assert.assertEquals((Object)"(null, 490]", (Object)interval.evaluate().toString());
        interval.setLower(this.intLiteral7, SargStrictness.CLOSED);
        interval.unsetUpper();
        this.assertRange(interval);
        Assert.assertEquals((Object)"[7, +infinity)", (Object)interval.toString());
        Assert.assertEquals((Object)"[7, +infinity)", (Object)interval.evaluate().toString());
        interval.setUpper(this.intLiteral490, SargStrictness.OPEN);
        this.assertRange(interval);
        Assert.assertEquals((Object)"[7, 490)", (Object)interval.toString());
        Assert.assertEquals((Object)"[7, 490)", (Object)interval.evaluate().toString());
        interval.setLower(this.intLiteral7, SargStrictness.OPEN);
        this.assertRange(interval);
        Assert.assertEquals((Object)"(7, 490)", (Object)interval.toString());
        Assert.assertEquals((Object)"(7, 490)", (Object)interval.evaluate().toString());
    }

    private void assertRange(SargIntervalExpr interval) {
        Assert.assertFalse((boolean)interval.isPoint());
        Assert.assertFalse((boolean)interval.isUnconstrained());
        Assert.assertFalse((boolean)interval.isEmpty());
    }

    @Test
    public void testNullExpr() {
        SargIntervalExpr interval = this.sargFactory.newIntervalExpr(this.intType);
        interval.setNull();
        Assert.assertTrue((boolean)interval.isPoint());
        Assert.assertFalse((boolean)interval.isUnconstrained());
        Assert.assertFalse((boolean)interval.isEmpty());
        Assert.assertEquals((Object)"[null] NULL_MATCHES_NULL", (Object)interval.toString());
        Assert.assertEquals((Object)"[null]", (Object)interval.evaluate().toString());
    }

    @Test
    public void testEmptyExpr() {
        SargIntervalExpr interval = this.sargFactory.newIntervalExpr(this.intType);
        interval.setEmpty();
        Assert.assertTrue((boolean)interval.isEmpty());
        Assert.assertFalse((boolean)interval.isUnconstrained());
        Assert.assertEquals((Object)"()", (Object)interval.toString());
        Assert.assertEquals((Object)"()", (Object)interval.evaluate().toString());
    }

    @Test
    public void testUnconstrainedExpr() {
        SargIntervalExpr interval = this.sargFactory.newIntervalExpr(this.intType);
        interval.setEmpty();
        Assert.assertFalse((boolean)interval.isUnconstrained());
        interval.setUnconstrained();
        Assert.assertTrue((boolean)interval.isUnconstrained());
        Assert.assertFalse((boolean)interval.isEmpty());
        Assert.assertEquals((Object)"(-infinity, +infinity)", (Object)interval.toString());
        Assert.assertEquals((Object)"(-infinity, +infinity)", (Object)interval.evaluate().toString());
    }

    @Test
    public void testSetExpr() {
        SargIntervalExpr interval1 = this.sargFactory.newIntervalExpr(this.intType);
        SargIntervalExpr interval2 = this.sargFactory.newIntervalExpr(this.intType);
        interval1.setLower(this.intLiteral7, SargStrictness.OPEN);
        interval2.setUpper(this.intLiteral490, SargStrictness.OPEN);
        SargSetExpr intersectExpr = this.sargFactory.newSetExpr(this.intType, SargSetOperator.INTERSECTION);
        intersectExpr.addChild((SargExpr)interval1);
        intersectExpr.addChild((SargExpr)interval2);
        Assert.assertEquals((Object)"INTERSECTION( (7, +infinity) (-infinity, 490) )", (Object)intersectExpr.toString());
        Assert.assertEquals((Object)"(7, 490)", (Object)intersectExpr.evaluate().toString());
        SargSetExpr unionExpr = this.sargFactory.newSetExpr(this.intType, SargSetOperator.UNION);
        unionExpr.addChild((SargExpr)interval1);
        unionExpr.addChild((SargExpr)interval2);
        Assert.assertEquals((Object)"UNION( (7, +infinity) (-infinity, 490) )", (Object)unionExpr.toString());
        Assert.assertEquals((Object)"(null, +infinity)", (Object)unionExpr.evaluate().toString());
        SargSetExpr complementExpr = this.sargFactory.newSetExpr(this.intType, SargSetOperator.COMPLEMENT);
        complementExpr.addChild((SargExpr)interval1);
        Assert.assertEquals((Object)"COMPLEMENT( (7, +infinity) )", (Object)complementExpr.toString());
        Assert.assertEquals((Object)"(null, 7]", (Object)complementExpr.evaluate().toString());
    }

    @Test
    public void testComplement() {
        SargIntervalExpr interval1 = this.sargFactory.newIntervalExpr(this.intType);
        SargIntervalExpr interval2 = this.sargFactory.newIntervalExpr(this.intType);
        SargIntervalExpr interval3 = this.sargFactory.newIntervalExpr(this.intType);
        interval1.setLower(this.intLiteral7, SargStrictness.CLOSED);
        interval1.setUpper(this.intLiteral7, SargStrictness.CLOSED);
        interval2.setLower(this.intLiteral490, SargStrictness.CLOSED);
        interval2.setUpper(this.intLiteral490, SargStrictness.CLOSED);
        interval3.setUpper(this.intLiteral490, SargStrictness.OPEN);
        SargSetExpr complementExpr1 = this.sargFactory.newSetExpr(this.intType, SargSetOperator.COMPLEMENT);
        complementExpr1.addChild((SargExpr)interval1);
        Assert.assertEquals((Object)"UNION( (null, 7) (7, +infinity) )", (Object)complementExpr1.evaluate().toString());
        SargSetExpr complementExpr2 = this.sargFactory.newSetExpr(this.intType, SargSetOperator.COMPLEMENT);
        complementExpr2.addChild((SargExpr)interval2);
        Assert.assertEquals((Object)"UNION( (null, 490) (490, +infinity) )", (Object)complementExpr2.evaluate().toString());
        SargSetExpr intersectExpr1 = this.sargFactory.newSetExpr(this.intType, SargSetOperator.INTERSECTION);
        intersectExpr1.addChild((SargExpr)complementExpr1);
        intersectExpr1.addChild((SargExpr)complementExpr2);
        Assert.assertEquals((Object)"UNION( (null, 7) (7, 490) (490, +infinity) )", (Object)intersectExpr1.evaluate().toString());
        SargSetExpr intersectExpr2 = this.sargFactory.newSetExpr(this.intType, SargSetOperator.INTERSECTION);
        intersectExpr2.addChild((SargExpr)complementExpr2);
        intersectExpr2.addChild((SargExpr)complementExpr1);
        Assert.assertEquals((Object)"UNION( (null, 7) (7, 490) (490, +infinity) )", (Object)intersectExpr2.evaluate().toString());
        SargSetExpr intersectExpr3 = this.sargFactory.newSetExpr(this.intType, SargSetOperator.INTERSECTION);
        intersectExpr3.addChild((SargExpr)complementExpr1);
        intersectExpr3.addChild((SargExpr)interval3);
        Assert.assertEquals((Object)"UNION( (null, 7) (7, 490) )", (Object)intersectExpr3.evaluate().toString());
        SargSetExpr unionExpr1 = this.sargFactory.newSetExpr(this.intType, SargSetOperator.UNION);
        unionExpr1.addChild((SargExpr)interval1);
        unionExpr1.addChild((SargExpr)interval2);
        SargSetExpr complementExpr3 = this.sargFactory.newSetExpr(this.intType, SargSetOperator.COMPLEMENT);
        complementExpr3.addChild((SargExpr)unionExpr1);
        Assert.assertEquals((Object)"UNION( (null, 7) (7, 490) (490, +infinity) )", (Object)complementExpr3.evaluate().toString());
        SargSetExpr unionExpr2 = this.sargFactory.newSetExpr(this.intType, SargSetOperator.UNION);
        unionExpr2.addChild((SargExpr)interval2);
        unionExpr2.addChild((SargExpr)interval1);
        SargSetExpr complementExpr4 = this.sargFactory.newSetExpr(this.intType, SargSetOperator.COMPLEMENT);
        complementExpr4.addChild((SargExpr)unionExpr2);
        Assert.assertEquals((Object)"UNION( (null, 7) (7, 490) (490, +infinity) )", (Object)complementExpr4.evaluate().toString());
    }

    @Test
    public void testUnion() {
        this.exprs = new SargIntervalExpr[11];
        int i = 0;
        while (i < 11) {
            this.exprs[i] = this.sargFactory.newIntervalExpr(this.stringType);
            ++i;
        }
        this.exprs[0].setPoint(this.createCoordinate(Zodiac.AQUARIUS));
        this.exprs[1].setPoint(this.createCoordinate(Zodiac.LEO));
        this.exprs[2].setUpper(this.createCoordinate(Zodiac.CAPRICORN), SargStrictness.CLOSED);
        this.exprs[3].setLower(this.createCoordinate(Zodiac.GEMINI), SargStrictness.OPEN);
        this.exprs[4].setLower(this.createCoordinate(Zodiac.GEMINI), SargStrictness.CLOSED);
        this.exprs[5].setNull();
        this.exprs[6].setLower(this.createCoordinate(Zodiac.GEMINI), SargStrictness.CLOSED);
        this.exprs[6].setUpper(this.createCoordinate(Zodiac.PISCES), SargStrictness.CLOSED);
        this.exprs[7].setLower(this.createCoordinate(Zodiac.GEMINI), SargStrictness.CLOSED);
        this.exprs[7].setUpper(this.createCoordinate(Zodiac.SCORPIO), SargStrictness.CLOSED);
        this.exprs[8].setLower(this.createCoordinate(Zodiac.ARIES), SargStrictness.CLOSED);
        this.exprs[8].setUpper(this.createCoordinate(Zodiac.GEMINI), SargStrictness.CLOSED);
        this.exprs[9].setLower(this.createCoordinate(Zodiac.ARIES), SargStrictness.CLOSED);
        this.exprs[9].setUpper(this.createCoordinate(Zodiac.GEMINI), SargStrictness.OPEN);
        this.exprs[10].setEmpty();
        this.checkUnion(0, 2, 5, "[null, 'CAPRICORN']");
        this.checkUnion(2, 5, 0, "[null, 'CAPRICORN']");
        this.checkUnion(5, 6, 7, "UNION( [null] ['GEMINI', 'SCORPIO'] )");
        this.checkUnion(8, 4, 5, "UNION( [null] ['ARIES', +infinity) )");
        this.checkUnion(9, 4, 5, "UNION( [null] ['ARIES', +infinity) )");
        this.checkUnion(7, 8, 9, "['ARIES', 'SCORPIO']");
        this.checkUnion(6, 7, 10, "['GEMINI', 'SCORPIO']");
        this.checkUnion(5, 6, 0, "UNION( [null] ['AQUARIUS'] ['GEMINI', 'PISCES'] )");
        this.checkUnion(10, 9, 5, "UNION( [null] ['ARIES', 'GEMINI') )");
        this.checkUnion(9, 8, 7, "['ARIES', 'SCORPIO']");
        this.checkUnion(3, 9, 1, "UNION( ['ARIES', 'GEMINI') ('GEMINI', +infinity) )");
    }

    @Test
    public void testIntersection() {
        this.exprs = new SargIntervalExpr[11];
        int i = 0;
        while (i < 11) {
            this.exprs[i] = this.sargFactory.newIntervalExpr(this.stringType);
            ++i;
        }
        this.exprs[0].setUnconstrained();
        this.exprs[1].setPoint(this.createCoordinate(Zodiac.LEO));
        this.exprs[2].setUpper(this.createCoordinate(Zodiac.CAPRICORN), SargStrictness.CLOSED);
        this.exprs[3].setLower(this.createCoordinate(Zodiac.CANCER), SargStrictness.OPEN);
        this.exprs[4].setLower(this.createCoordinate(Zodiac.GEMINI), SargStrictness.CLOSED);
        this.exprs[5].setNull();
        this.exprs[6].setLower(this.createCoordinate(Zodiac.GEMINI), SargStrictness.CLOSED);
        this.exprs[6].setUpper(this.createCoordinate(Zodiac.PISCES), SargStrictness.CLOSED);
        this.exprs[7].setLower(this.createCoordinate(Zodiac.GEMINI), SargStrictness.CLOSED);
        this.exprs[7].setUpper(this.createCoordinate(Zodiac.SCORPIO), SargStrictness.CLOSED);
        this.exprs[8].setLower(this.createCoordinate(Zodiac.ARIES), SargStrictness.CLOSED);
        this.exprs[8].setUpper(this.createCoordinate(Zodiac.GEMINI), SargStrictness.CLOSED);
        this.exprs[9].setLower(this.createCoordinate(Zodiac.ARIES), SargStrictness.CLOSED);
        this.exprs[9].setUpper(this.createCoordinate(Zodiac.GEMINI), SargStrictness.OPEN);
        this.exprs[10].setEmpty();
        this.checkIntersection(2, 3, 0, "('CANCER', 'CAPRICORN']");
        this.checkIntersection(0, 3, 2, "('CANCER', 'CAPRICORN']");
        this.checkIntersection(6, 7, 0, "['GEMINI', 'PISCES']");
        this.checkIntersection(6, 7, 8, "['GEMINI']");
        this.checkIntersection(8, 7, 6, "['GEMINI']");
        this.checkIntersection(9, 7, 6, "()");
    }

    private void checkUnion(int i1, int i2, int i3, String expected) {
        this.checkSetOp(SargSetOperator.UNION, i1, i2, i3, expected);
    }

    private void checkIntersection(int i1, int i2, int i3, String expected) {
        this.checkSetOp(SargSetOperator.INTERSECTION, i1, i2, i3, expected);
    }

    private void checkSetOp(SargSetOperator setOp, int i1, int i2, int i3, String expected) {
        SargSetExpr setExpr = this.sargFactory.newSetExpr(this.stringType, setOp);
        setExpr.addChild((SargExpr)this.exprs[i1]);
        setExpr.addChild((SargExpr)this.exprs[i2]);
        setExpr.addChild((SargExpr)this.exprs[i3]);
        Assert.assertEquals((Object)expected, (Object)setExpr.evaluate().toString());
    }

    private RexNode createCoordinate(Zodiac z) {
        return this.sargFactory.getRexBuilder().makeLiteral(z.toString());
    }

    @Test
    public void testRexAnalyzer() {
        SargRexAnalyzer rexAnalyzer = this.sargFactory.newRexAnalyzer();
        RexInputRef inputRef8 = this.rexBuilder.makeInputRef(this.intType, 8);
        RexInputRef inputRef9 = this.rexBuilder.makeInputRef(this.intType, 8);
        RexNode pred1 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{inputRef8, this.intLiteral7});
        SargBinding binding = rexAnalyzer.analyze(pred1);
        Assert.assertNotNull((Object)binding);
        Assert.assertEquals((Object)"(-infinity, 7)", (Object)binding.getExpr().toString());
        RexNode pred2 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{this.intLiteral490, inputRef9});
        binding = rexAnalyzer.analyze(pred2);
        Assert.assertNotNull((Object)binding);
        Assert.assertEquals((Object)"(-infinity, 490]", (Object)binding.getExpr().toString());
        RexNode pred3 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{pred1, pred2});
        binding = rexAnalyzer.analyze(pred3);
        Assert.assertNotNull((Object)binding);
        Assert.assertEquals((Object)"INTERSECTION( (-infinity, 7) (-infinity, 490] )", (Object)binding.getExpr().toString());
        pred3 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{pred1, pred2});
        binding = rexAnalyzer.analyze(pred3);
        Assert.assertNotNull((Object)binding);
        Assert.assertEquals((Object)"UNION( (-infinity, 7) (-infinity, 490] )", (Object)binding.getExpr().toString());
        pred3 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{pred1});
        binding = rexAnalyzer.analyze(pred3);
        Assert.assertNotNull((Object)binding);
        Assert.assertEquals((Object)"COMPLEMENT( (-infinity, 7) )", (Object)binding.getExpr().toString());
        pred1 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{inputRef8, inputRef9});
        binding = rexAnalyzer.analyze(pred1);
        Assert.assertNull((Object)binding);
        pred1 = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{this.intLiteral7, this.intLiteral490});
        binding = rexAnalyzer.analyze(pred1);
        Assert.assertNull((Object)binding);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Zodiac {
        AQUARIUS,
        ARIES,
        CANCER,
        CAPRICORN,
        GEMINI,
        LEO,
        LIBRA,
        PISCES,
        SAGITTARIUS,
        SCORPIO,
        TAURUS,
        VIRGO;

    }
}

