/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.optiq.prepare.Prepare;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelCollationImpl;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.TableAccessRel;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptSchema;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeComparability;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.reltype.RelDataTypeFieldImpl;
import org.eigenbase.sql.SqlAccessType;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.ObjectSqlType;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.validate.SqlMoniker;
import org.eigenbase.sql.validate.SqlMonikerImpl;
import org.eigenbase.sql.validate.SqlMonikerType;
import org.eigenbase.sql.validate.SqlMonotonicity;
import org.eigenbase.sql.validate.SqlValidatorUtil;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockCatalogReader
implements Prepare.CatalogReader {
    protected static final String DEFAULT_CATALOG = "CATALOG";
    protected static final String DEFAULT_SCHEMA = "SALES";
    public static final Ordering<Iterable<String>> CASE_INSENSITIVE_LIST_COMPARATOR = Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).lexicographical();
    protected final RelDataTypeFactory typeFactory;
    private final boolean caseSensitive;
    private final Map<List<String>, MockTable> tables;
    protected final Map<String, MockSchema> schemas;
    private RelDataType addressType;

    public MockCatalogReader(RelDataTypeFactory typeFactory, boolean caseSensitive) {
        this(typeFactory, caseSensitive, false);
        this.init();
    }

    protected MockCatalogReader(RelDataTypeFactory typeFactory, boolean caseSensitive, boolean dummy) {
        this.typeFactory = typeFactory;
        this.caseSensitive = caseSensitive;
        assert (!dummy);
        if (caseSensitive) {
            this.tables = new HashMap<List<String>, MockTable>();
            this.schemas = new HashMap<String, MockSchema>();
        } else {
            this.tables = new TreeMap<Iterable<String>, MockTable>((Comparator<Iterable<String>>)CASE_INSENSITIVE_LIST_COMPARATOR);
            this.schemas = new TreeMap<String, MockSchema>(String.CASE_INSENSITIVE_ORDER);
        }
    }

    protected void init() {
        RelDataType intType = this.typeFactory.createSqlType(SqlTypeName.INTEGER);
        RelDataType varchar10Type = this.typeFactory.createSqlType(SqlTypeName.VARCHAR, 10);
        RelDataType varchar20Type = this.typeFactory.createSqlType(SqlTypeName.VARCHAR, 20);
        RelDataType timestampType = this.typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
        RelDataType booleanType = this.typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        RelDataType rectilinearCoordType = this.typeFactory.builder().add("X", intType).add("Y", intType).build();
        this.addressType = new ObjectSqlType(SqlTypeName.STRUCTURED, new SqlIdentifier("ADDRESS", SqlParserPos.ZERO), false, Arrays.asList(new RelDataTypeFieldImpl("STREET", 0, varchar20Type), new RelDataTypeFieldImpl("CITY", 1, varchar20Type), new RelDataTypeFieldImpl("ZIP", 1, intType), new RelDataTypeFieldImpl("STATE", 1, varchar20Type)), RelDataTypeComparability.NONE);
        MockSchema salesSchema = new MockSchema(DEFAULT_SCHEMA);
        this.registerSchema(salesSchema);
        MockTable empTable = new MockTable(this, salesSchema, "EMP");
        empTable.addColumn("EMPNO", intType);
        empTable.addColumn("ENAME", varchar20Type);
        empTable.addColumn("JOB", varchar10Type);
        empTable.addColumn("MGR", intType);
        empTable.addColumn("HIREDATE", timestampType);
        empTable.addColumn("SAL", intType);
        empTable.addColumn("COMM", intType);
        empTable.addColumn("DEPTNO", intType);
        empTable.addColumn("SLACKER", booleanType);
        this.registerTable(empTable);
        MockTable deptTable = new MockTable(this, salesSchema, "DEPT");
        deptTable.addColumn("DEPTNO", intType);
        deptTable.addColumn("NAME", varchar10Type);
        this.registerTable(deptTable);
        MockTable bonusTable = new MockTable(this, salesSchema, "BONUS");
        bonusTable.addColumn("ENAME", varchar20Type);
        bonusTable.addColumn("JOB", varchar10Type);
        bonusTable.addColumn("SAL", intType);
        bonusTable.addColumn("COMM", intType);
        this.registerTable(bonusTable);
        MockTable salgradeTable = new MockTable(this, salesSchema, "SALGRADE");
        salgradeTable.addColumn("GRADE", intType);
        salgradeTable.addColumn("LOSAL", intType);
        salgradeTable.addColumn("HISAL", intType);
        this.registerTable(salgradeTable);
        MockTable contactAddressTable = new MockTable(this, salesSchema, "EMP_ADDRESS");
        contactAddressTable.addColumn("EMPNO", intType);
        contactAddressTable.addColumn("HOME_ADDRESS", this.addressType);
        contactAddressTable.addColumn("MAILING_ADDRESS", this.addressType);
        this.registerTable(contactAddressTable);
        MockSchema customerSchema = new MockSchema("CUSTOMER");
        this.registerSchema(customerSchema);
        MockTable contactTable = new MockTable(this, customerSchema, "CONTACT");
        contactTable.addColumn("CONTACTNO", intType);
        contactTable.addColumn("FNAME", varchar10Type);
        contactTable.addColumn("LNAME", varchar10Type);
        contactTable.addColumn("EMAIL", varchar20Type);
        contactTable.addColumn("COORD", rectilinearCoordType);
        this.registerTable(contactTable);
        MockTable accountTable = new MockTable(this, customerSchema, "ACCOUNT");
        accountTable.addColumn("ACCTNO", intType);
        accountTable.addColumn("TYPE", varchar20Type);
        accountTable.addColumn("BALANCE", intType);
        this.registerTable(accountTable);
    }

    public Prepare.CatalogReader withSchemaPath(List<String> schemaPath) {
        return this;
    }

    public Prepare.PreparingTable getTableForMember(List<String> names) {
        return this.getTable(names);
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public void registerRules(RelOptPlanner planner) {
    }

    protected void registerTable(MockTable table) {
        table.onRegister(this.typeFactory);
        this.tables.put(table.getQualifiedName(), table);
    }

    protected void registerSchema(MockSchema schema) {
        this.schemas.put(schema.name, schema);
    }

    public Prepare.PreparingTable getTable(List<String> names) {
        switch (names.size()) {
            case 1: {
                return this.tables.get(ImmutableList.of((Object)DEFAULT_CATALOG, (Object)DEFAULT_SCHEMA, (Object)names.get(0)));
            }
            case 2: {
                return this.tables.get(ImmutableList.of((Object)DEFAULT_CATALOG, (Object)names.get(0), (Object)names.get(1)));
            }
            case 3: {
                return this.tables.get(names);
            }
        }
        return null;
    }

    public RelDataType getNamedType(SqlIdentifier typeName) {
        if (typeName.equalsDeep((SqlNode)this.addressType.getSqlIdentifier(), false)) {
            return this.addressType;
        }
        return null;
    }

    public List<SqlMoniker> getAllSchemaObjectNames(List<String> names) {
        switch (names.size()) {
            case 0: {
                ArrayList<SqlMoniker> result = new ArrayList<SqlMoniker>();
                for (MockSchema schema : this.schemas.values()) {
                    result.add((SqlMoniker)new SqlMonikerImpl(schema.name, SqlMonikerType.SCHEMA));
                }
                return result;
            }
            case 1: {
                MockSchema schema = this.schemas.get(names.get(0));
                if (schema == null) {
                    return Collections.emptyList();
                }
                ArrayList<SqlMoniker> result = new ArrayList<SqlMoniker>();
                for (String tableName : schema.tableNames) {
                    result.add((SqlMoniker)new SqlMonikerImpl(tableName, SqlMonikerType.TABLE));
                }
                return result;
            }
        }
        return Collections.emptyList();
    }

    public String getSchemaName() {
        return DEFAULT_SCHEMA;
    }

    public RelDataTypeField field(RelDataType rowType, String alias) {
        return SqlValidatorUtil.lookupField((boolean)this.caseSensitive, (RelDataType)rowType, (String)alias);
    }

    public int fieldOrdinal(RelDataType rowType, String alias) {
        RelDataTypeField field = this.field(rowType, alias);
        return field != null ? field.getIndex() : -1;
    }

    public int match(List<String> strings, String name) {
        return Util.match2(strings, (String)name, (boolean)this.caseSensitive);
    }

    public RelDataType createTypeFromProjection(RelDataType type, List<String> columnNameList) {
        return SqlValidatorUtil.createTypeFromProjection((RelDataType)type, columnNameList, (RelDataTypeFactory)this.typeFactory, (boolean)this.caseSensitive);
    }

    private static List<RelCollation> deduceMonotonicity(Prepare.PreparingTable table) {
        ArrayList<RelCollation> collationList = new ArrayList<RelCollation>();
        int i = -1;
        for (RelDataTypeField field : table.getRowType().getFieldList()) {
            ++i;
            SqlMonotonicity monotonicity = table.getMonotonicity(field.getName());
            if (monotonicity == SqlMonotonicity.NOT_MONOTONIC) continue;
            RelFieldCollation.Direction direction = monotonicity.isDecreasing() ? RelFieldCollation.Direction.DESCENDING : RelFieldCollation.Direction.ASCENDING;
            collationList.add(RelCollationImpl.of((RelFieldCollation[])new RelFieldCollation[]{new RelFieldCollation(i, direction, RelFieldCollation.NullDirection.UNSPECIFIED)}));
        }
        return collationList;
    }

    public static class MockSchema {
        private final List<String> tableNames = new ArrayList<String>();
        private String name;

        public MockSchema(String name) {
            this.name = name;
        }

        public void addTable(String name) {
            this.tableNames.add(name);
        }

        public String getCatalogName() {
            return MockCatalogReader.DEFAULT_CATALOG;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MockTable
    implements Prepare.PreparingTable {
        private final MockCatalogReader catalogReader;
        private final List<Pair<String, RelDataType>> columnList = new ArrayList<Pair<String, RelDataType>>();
        private RelDataType rowType;
        private List<RelCollation> collationList;
        private final List<String> names;

        public MockTable(MockCatalogReader catalogReader, MockSchema schema, String name) {
            this.catalogReader = catalogReader;
            this.names = ImmutableList.of((Object)schema.getCatalogName(), (Object)schema.name, (Object)name);
            schema.addTable(name);
        }

        public <T> T unwrap(Class<T> clazz) {
            if (clazz.isInstance(this)) {
                return clazz.cast(this);
            }
            return null;
        }

        public double getRowCount() {
            return 0.0;
        }

        public RelOptSchema getRelOptSchema() {
            return this.catalogReader;
        }

        public RelNode toRel(RelOptTable.ToRelContext context) {
            return new TableAccessRel(context.getCluster(), (RelOptTable)this);
        }

        public List<RelCollation> getCollationList() {
            return this.collationList;
        }

        public boolean isKey(BitSet columns) {
            return false;
        }

        public RelDataType getRowType() {
            return this.rowType;
        }

        public void onRegister(RelDataTypeFactory typeFactory) {
            this.rowType = typeFactory.createStructType(this.columnList);
            this.collationList = MockCatalogReader.deduceMonotonicity(this);
        }

        public List<String> getQualifiedName() {
            return this.names;
        }

        public SqlMonotonicity getMonotonicity(String columnName) {
            return SqlMonotonicity.NOT_MONOTONIC;
        }

        public SqlAccessType getAllowedAccess() {
            return SqlAccessType.ALL;
        }

        public Expression getExpression(Class clazz) {
            throw new UnsupportedOperationException();
        }

        public void addColumn(int index, String name, RelDataType type) {
            this.columnList.add(index, (Pair<String, RelDataType>)Pair.of((Object)name, (Object)type));
        }

        public void addColumn(String name, RelDataType type) {
            this.columnList.add((Pair<String, RelDataType>)Pair.of((Object)name, (Object)type));
        }
    }
}

