/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eigenbase.util.ReflectUtil;
import org.incava.util.diff.Diff;
import org.incava.util.diff.Difference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DiffTestCase {
    private final String testCaseName;
    protected File logFile;
    protected File refFile;
    protected OutputStream logOutputStream;
    private String diffMasks;
    Matcher compiledDiffMatcher;
    private String ignorePatterns;
    Matcher compiledIgnoreMatcher;
    int gcInterval;
    private boolean verbose;

    protected DiffTestCase(String testCaseName) throws Exception {
        this.testCaseName = testCaseName;
        this.diffMasks = "";
        this.ignorePatterns = "";
        this.compiledIgnoreMatcher = null;
        this.compiledDiffMatcher = null;
        this.gcInterval = 0;
        String verboseVal = System.getProperty(String.valueOf(DiffTestCase.class.getName()) + ".verbose");
        if (verboseVal != null) {
            this.verbose = true;
        }
    }

    @Before
    protected void setUp() {
        this.diffMasks = "";
        this.ignorePatterns = "";
        this.compiledIgnoreMatcher = null;
        this.compiledDiffMatcher = null;
        this.gcInterval = 0;
    }

    @After
    protected void tearDown() throws IOException {
        if (this.logOutputStream != null) {
            this.logOutputStream.close();
            this.logOutputStream = null;
        }
    }

    protected Writer openTestLog() throws Exception {
        File testClassDir = new File(this.getTestlogRoot(), ReflectUtil.getUnqualifiedClassName(this.getClass()));
        testClassDir.mkdirs();
        File testLogFile = new File(testClassDir, this.testCaseName);
        return new OutputStreamWriter(this.openTestLogOutputStream(testLogFile));
    }

    protected abstract File getTestlogRoot() throws Exception;

    protected OutputStream openTestLogOutputStream(File testFileSansExt) throws IOException {
        assert (this.logOutputStream == null);
        this.logFile = new File(String.valueOf(testFileSansExt.toString()) + ".log");
        this.logFile.delete();
        this.refFile = new File(String.valueOf(testFileSansExt.toString()) + ".ref");
        this.logOutputStream = new FileOutputStream(this.logFile);
        return this.logOutputStream;
    }

    protected void diffTestLog() throws IOException {
        assert (this.logOutputStream != null);
        this.logOutputStream.close();
        this.logOutputStream = null;
        if (!this.refFile.exists()) {
            Assert.fail((String)("Reference file " + this.refFile + " does not exist"));
        }
        this.diffFile(this.logFile, this.refFile);
    }

    protected void diffFile(File logFile, File refFile) throws IOException {
        int n = 0;
        InputStreamReader logReader = null;
        InputStreamReader refReader = null;
        try {
            String diffMask;
            if (this.compiledIgnoreMatcher != null && this.gcInterval != 0 && ++n == this.gcInterval) {
                n = 0;
                System.gc();
            }
            if ((diffMask = System.getProperty("diff.mask", null)) != null) {
                this.addDiffMask(diffMask);
            }
            if ((diffMask = System.getProperty("diff_mask", null)) != null) {
                this.addDiffMask(diffMask);
            }
            logReader = new FileReader(logFile);
            refReader = new FileReader(refFile);
            LineNumberReader logLineReader = new LineNumberReader(logReader);
            LineNumberReader refLineReader = new LineNumberReader(refReader);
            while (true) {
                String logLine = logLineReader.readLine();
                String refLine = refLineReader.readLine();
                while (logLine != null && this.matchIgnorePatterns(logLine)) {
                    logLine = logLineReader.readLine();
                }
                while (refLine != null && this.matchIgnorePatterns(refLine)) {
                    refLine = refLineReader.readLine();
                }
                if (logLine == null || refLine == null) {
                    if (logLine != null) {
                        this.diffFail(logFile, logLineReader.getLineNumber());
                    }
                    if (refLine != null) {
                        this.diffFail(logFile, refLineReader.getLineNumber());
                    }
                    break;
                }
                if ((logLine = this.applyDiffMask(logLine)).equals(refLine = this.applyDiffMask(refLine))) continue;
                this.diffFail(logFile, logLineReader.getLineNumber());
            }
        }
        finally {
            if (logReader != null) {
                logReader.close();
            }
            if (refReader != null) {
                refReader.close();
            }
        }
        logFile.delete();
    }

    protected void setGC(int n) {
        this.gcInterval = n;
    }

    protected void addDiffMask(String mask) {
        this.diffMasks = this.diffMasks.length() == 0 ? mask : String.valueOf(this.diffMasks) + "|" + mask;
        Pattern compiledDiffPattern = Pattern.compile(this.diffMasks);
        this.compiledDiffMatcher = compiledDiffPattern.matcher("");
    }

    protected void addIgnorePattern(String javaPattern) {
        this.ignorePatterns = this.ignorePatterns.length() == 0 ? javaPattern : String.valueOf(this.ignorePatterns) + "|" + javaPattern;
        Pattern compiledIgnorePattern = Pattern.compile(this.ignorePatterns);
        this.compiledIgnoreMatcher = compiledIgnorePattern.matcher("");
    }

    private String applyDiffMask(String s) {
        if (this.compiledDiffMatcher != null) {
            this.compiledDiffMatcher.reset(s);
            if (this.compiledDiffMatcher.find()) {
                return s.replaceAll(this.diffMasks, "XYZZY");
            }
        }
        return s;
    }

    private boolean matchIgnorePatterns(String s) {
        if (this.compiledIgnoreMatcher != null) {
            this.compiledIgnoreMatcher.reset(s);
            return this.compiledIgnoreMatcher.matches();
        }
        return false;
    }

    private void diffFail(File logFile, int lineNumber) {
        String message = "diff detected at line " + lineNumber + " in " + logFile;
        if (this.verbose) {
            if (DiffTestCase.inIde()) {
                Assert.assertEquals((String)message, (Object)DiffTestCase.fileContents(this.refFile), (Object)DiffTestCase.fileContents(logFile));
            } else {
                String s = DiffTestCase.diff(this.refFile, logFile);
                Assert.fail((String)(String.valueOf(message) + '\n' + s + '\n'));
            }
        }
        Assert.fail((String)message);
    }

    private static boolean inIde() {
        Throwable runtimeException = new Throwable();
        runtimeException.fillInStackTrace();
        StackTraceElement[] stackTrace = runtimeException.getStackTrace();
        StackTraceElement lastStackTraceElement = stackTrace[stackTrace.length - 1];
        if (lastStackTraceElement.getClassName().equals("com.intellij.rt.execution.junit.JUnitStarter") && lastStackTraceElement.getMethodName().equals("main")) {
            return true;
        }
        return lastStackTraceElement.getClassName().equals("com.intellij.rt.execution.application.AppMain") && lastStackTraceElement.getMethodName().equals("main");
    }

    private static String diff(File file1, File file2) {
        List<String> lines1 = DiffTestCase.fileLines(file1);
        List<String> lines2 = DiffTestCase.fileLines(file2);
        return DiffTestCase.diffLines(lines1, lines2);
    }

    public static String diffLines(List<String> lines1, List<String> lines2) {
        Diff differencer = new Diff(lines1, lines2);
        List differences = differencer.diff();
        StringWriter sw = new StringWriter();
        int offset = 0;
        for (Difference d : differences) {
            int i;
            int as = d.getAddedStart() + 1;
            int ae = d.getAddedEnd() + 1;
            int ds = d.getDeletedStart() + 1;
            int de = d.getDeletedEnd() + 1;
            if (ae == 0) {
                if (de == 0) continue;
                sw.append(String.valueOf(ds));
                if (de > ds) {
                    sw.append(",").append(String.valueOf(de));
                }
                sw.append("d").append(String.valueOf(as - 1)).append('\n');
                i = ds - 1;
                while (i < de) {
                    sw.append("< ").append(lines1.get(i)).append('\n');
                    ++i;
                }
                continue;
            }
            if (de == 0) {
                sw.append(String.valueOf(ds - 1)).append("a").append(String.valueOf(as));
                if (ae > as) {
                    sw.append(",").append(String.valueOf(ae));
                }
                sw.append('\n');
                i = as - 1;
                while (i < ae) {
                    sw.append("> ").append(lines2.get(i)).append('\n');
                    ++i;
                }
                continue;
            }
            sw.append(String.valueOf(ds));
            if (de > ds) {
                sw.append(",").append(String.valueOf(de));
            }
            sw.append("c").append(String.valueOf(as));
            if (ae > as) {
                sw.append(",").append(String.valueOf(ae));
            }
            sw.append('\n');
            i = ds - 1;
            while (i < de) {
                sw.append("< ").append(lines1.get(i)).append('\n');
                ++i;
            }
            sw.append("---\n");
            i = as - 1;
            while (i < ae) {
                sw.append("> ").append(lines2.get(i)).append('\n');
                ++i;
            }
            offset = offset + (ae - as) - (de - ds);
        }
        return sw.toString();
    }

    private static List<String> fileLines(File file) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            LineNumberReader r = new LineNumberReader(new FileReader(file));
            while ((line = r.readLine()) != null) {
                lines.add(line);
            }
            return lines;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected static String fileContents(File file) {
        try {
            int readCount;
            char[] buf = new char[2048];
            FileReader reader = new FileReader(file);
            StringWriter writer = new StringWriter();
            while ((readCount = reader.read(buf)) >= 0) {
                writer.write(buf, 0, readCount);
            }
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected void setRefFileDiffMasks() {
        this.addDiffMask("\\$Id.*\\$");
        this.addDiffMask("0: \\bjdbc(:[^:>]+)+:>");
        this.addDiffMask("^(\\.\\s?)+>");
    }
}

