/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eigenbase.util.Util;
import org.eigenbase.util.XmlOutput;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DiffRepository {
    private static final String ROOT_TAG = "Root";
    private static final String TEST_CASE_TAG = "TestCase";
    private static final String TEST_CASE_NAME_ATTR = "name";
    private static final String TEST_CASE_OVERRIDES_ATTR = "overrides";
    private static final String RESOURCE_TAG = "Resource";
    private static final String RESOURCE_NAME_ATTR = "name";
    private static final Map<Class, DiffRepository> MAP_CLASS_TO_REPOS = new HashMap<Class, DiffRepository>();
    private final DiffRepository baseRepos;
    private Document doc;
    private final Element root;
    private final File logFile;
    private final Filter filter;

    private DiffRepository(URL refFile, File logFile, DiffRepository baseRepos, Filter filter) {
        this.baseRepos = baseRepos;
        this.filter = filter;
        if (refFile == null) {
            throw new IllegalArgumentException("url must not be null");
        }
        this.logFile = logFile;
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = fac.newDocumentBuilder();
            try {
                this.doc = docBuilder.parse(refFile.openStream());
            }
            catch (IOException e) {
                this.doc = docBuilder.newDocument();
                this.doc.appendChild(this.doc.createElement(ROOT_TAG));
                this.flushDoc();
            }
            this.root = this.doc.getDocumentElement();
            if (!this.root.getNodeName().equals(ROOT_TAG)) {
                throw new RuntimeException("expected root element of type 'Root', but found '" + this.root.getNodeName() + "'");
            }
        }
        catch (ParserConfigurationException e) {
            throw Util.newInternal((Throwable)e, (String)"error while creating xml parser");
        }
        catch (SAXException e) {
            throw Util.newInternal((Throwable)e, (String)"error while creating xml parser");
        }
    }

    private static URL findFile(Class clazz, String suffix) {
        String rest = "/" + clazz.getName().replace('.', File.separatorChar) + suffix;
        return clazz.getResource(rest);
    }

    public synchronized String expand(String tag, String text) {
        if (text == null) {
            return null;
        }
        if (text.startsWith("${") && text.endsWith("}")) {
            String testCaseName = this.getCurrentTestCaseName(true);
            String token = text.substring(2, text.length() - 1);
            if (tag == null) {
                tag = token;
            }
            assert (token.startsWith(tag)) : "token '" + token + "' does not match tag '" + tag + "'";
            String expanded = this.get(testCaseName, token);
            if (expanded == null) {
                return text;
            }
            if (this.filter != null) {
                expanded = this.filter.filter(this, testCaseName, tag, text, expanded);
            }
            return expanded;
        }
        String testCaseName = this.getCurrentTestCaseName(true);
        if (this.baseRepos == null || this.baseRepos.get(testCaseName, tag) == null) {
            this.set(tag, text);
        }
        return text;
    }

    public synchronized void set(String resourceName, String value) {
        assert (resourceName != null);
        String testCaseName = this.getCurrentTestCaseName(true);
        this.update(testCaseName, resourceName, value);
    }

    public void amend(String expected, String actual) {
        if (expected.startsWith("${") && expected.endsWith("}")) {
            String token = expected.substring(2, expected.length() - 1);
            this.set(token, actual);
        }
    }

    private synchronized String get(String testCaseName, String resourceName) {
        Element testCaseElement = this.getTestCaseElement(testCaseName, true);
        if (testCaseElement == null) {
            if (this.baseRepos != null) {
                return this.baseRepos.get(testCaseName, resourceName);
            }
            return null;
        }
        Element resourceElement = DiffRepository.getResourceElement(testCaseElement, resourceName);
        if (resourceElement != null) {
            return DiffRepository.getText(resourceElement);
        }
        return null;
    }

    private static String getText(Element element) {
        NodeList childNodes = element.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node instanceof CDATASection) {
                return node.getNodeValue();
            }
            ++i;
        }
        StringBuilder buf = new StringBuilder();
        int i2 = 0;
        while (i2 < childNodes.getLength()) {
            Node node = childNodes.item(i2);
            if (node instanceof Text) {
                buf.append(((Text)node).getWholeText());
            }
            ++i2;
        }
        return buf.toString();
    }

    private synchronized Element getTestCaseElement(String testCaseName, boolean checkOverride) {
        NodeList childNodes = this.root.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element testCase;
            Node child = childNodes.item(i);
            if (child.getNodeName().equals(TEST_CASE_TAG) && testCaseName.equals((testCase = (Element)child).getAttribute("name"))) {
                if (checkOverride && this.baseRepos != null && this.baseRepos.getTestCaseElement(testCaseName, false) != null && !"true".equals(testCase.getAttribute(TEST_CASE_OVERRIDES_ATTR))) {
                    throw new RuntimeException("TestCase  '" + testCaseName + "' overrides a " + "testcase in the base repository, but does " + "not specify 'overrides=true'");
                }
                return testCase;
            }
            ++i;
        }
        return null;
    }

    private String getCurrentTestCaseName(boolean fail) {
        StackTraceElement[] stackTrace;
        Throwable runtimeException = new Throwable();
        runtimeException.fillInStackTrace();
        StackTraceElement[] stackTraceElementArray = stackTrace = runtimeException.getStackTrace();
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            String methodName = stackTraceElement.getMethodName();
            if (methodName.startsWith("test")) {
                return methodName;
            }
            ++n2;
        }
        if (fail) {
            throw new RuntimeException("no testcase on current callstack");
        }
        return null;
    }

    public void assertEquals(String tag, String expected, String actual) {
        String testCaseName = this.getCurrentTestCaseName(true);
        String expected2 = this.expand(tag, expected);
        if (expected2 == null) {
            this.update(testCaseName, expected, actual);
            throw new AssertionError((Object)("reference file does not contain resource '" + expected + "' for testcase '" + testCaseName + "'"));
        }
        try {
            String expected2Canonical = expected2.replace(Util.LINE_SEPARATOR, "\n");
            String actualCanonical = actual.replace(Util.LINE_SEPARATOR, "\n");
            Assert.assertEquals((Object)expected2Canonical, (Object)actualCanonical);
        }
        catch (ComparisonFailure e) {
            this.amend(expected, actual);
            throw e;
        }
    }

    private synchronized void update(String testCaseName, String resourceName, String value) {
        Element resourceElement;
        Element testCaseElement = this.getTestCaseElement(testCaseName, true);
        if (testCaseElement == null) {
            testCaseElement = this.doc.createElement(TEST_CASE_TAG);
            testCaseElement.setAttribute("name", testCaseName);
            this.root.appendChild(testCaseElement);
        }
        if ((resourceElement = DiffRepository.getResourceElement(testCaseElement, resourceName)) == null) {
            resourceElement = this.doc.createElement(RESOURCE_TAG);
            resourceElement.setAttribute("name", resourceName);
            testCaseElement.appendChild(resourceElement);
        } else {
            DiffRepository.removeAllChildren(resourceElement);
        }
        if (!value.equals("")) {
            resourceElement.appendChild(this.doc.createCDATASection(value));
        }
        this.flushDoc();
    }

    private void flushDoc() {
        OutputStreamWriter w = null;
        try {
            try {
                boolean b = this.logFile.getParentFile().mkdirs();
                Util.discard((boolean)b);
                w = new FileWriter(this.logFile);
                DiffRepository.write(this.doc, w);
            }
            catch (IOException e) {
                throw Util.newInternal((Throwable)e, (String)("error while writing test reference log '" + this.logFile + "'"));
            }
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static Element getResourceElement(Element testCaseElement, String resourceName) {
        NodeList childNodes = testCaseElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node child = childNodes.item(i);
            if (child.getNodeName().equals(RESOURCE_TAG) && resourceName.equals(((Element)child).getAttribute("name"))) {
                return (Element)child;
            }
            ++i;
        }
        return null;
    }

    private static void removeAllChildren(Element element) {
        NodeList childNodes = element.getChildNodes();
        while (childNodes.getLength() > 0) {
            element.removeChild(childNodes.item(0));
        }
    }

    private static void write(Document doc, Writer w) {
        XmlOutput out = new XmlOutput(w);
        out.setGlob(true);
        out.setIndentString("    ");
        DiffRepository.writeNode(doc, out);
    }

    private static void writeNode(Node node, XmlOutput out) {
        switch (node.getNodeType()) {
            case 9: {
                out.print("<?xml version=\"1.0\" ?>\n");
                NodeList childNodes = node.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node child = childNodes.item(i);
                    DiffRepository.writeNode(child, out);
                    ++i;
                }
                break;
            }
            case 1: {
                Element element = (Element)node;
                String tagName = element.getTagName();
                out.beginBeginTag(tagName);
                NamedNodeMap attributeMap = element.getAttributes();
                int i = 0;
                while (i < attributeMap.getLength()) {
                    Node att = attributeMap.item(i);
                    out.attribute(att.getNodeName(), att.getNodeValue());
                    ++i;
                }
                out.endBeginTag(tagName);
                NodeList childNodes = node.getChildNodes();
                i = 0;
                while (i < childNodes.getLength()) {
                    Node child = childNodes.item(i);
                    if (child.getNodeType() != 2) {
                        DiffRepository.writeNode(child, out);
                    }
                    ++i;
                }
                out.endTag(tagName);
                break;
            }
            case 2: {
                out.attribute(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 4: {
                CDATASection cdata = (CDATASection)node;
                out.cdata(cdata.getNodeValue(), true);
                break;
            }
            case 3: {
                Text text = (Text)node;
                String wholeText = text.getNodeValue();
                if (DiffRepository.isWhitespace(wholeText)) break;
                out.cdata(wholeText, false);
                break;
            }
            case 8: {
                Comment comment = (Comment)node;
                out.print("<!--" + comment.getNodeValue() + "-->\n");
                break;
            }
            default: {
                throw new RuntimeException("unexpected node type: " + node.getNodeType() + " (" + node + ")");
            }
        }
    }

    private static boolean isWhitespace(String text) {
        int i = 0;
        int count = text.length();
        while (i < count) {
            char c = text.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case ' ': {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static DiffRepository lookup(Class clazz) {
        return DiffRepository.lookup(clazz, null);
    }

    public static DiffRepository lookup(Class clazz, DiffRepository baseRepos) {
        return DiffRepository.lookup(clazz, baseRepos, null);
    }

    public static synchronized DiffRepository lookup(Class clazz, DiffRepository baseRepos, Filter filter) {
        DiffRepository diffRepos = MAP_CLASS_TO_REPOS.get(clazz);
        if (diffRepos == null) {
            URL refFile = DiffRepository.findFile(clazz, ".xml");
            File logFile = new File(refFile.getFile().replace("test-classes", "surefire"));
            diffRepos = new DiffRepository(refFile, logFile, baseRepos, filter);
            MAP_CLASS_TO_REPOS.put(clazz, diffRepos);
        }
        return diffRepos;
    }

    public static interface Filter {
        public String filter(DiffRepository var1, String var2, String var3, String var4, String var5);
    }
}

