/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.parser;

import java.util.Locale;
import net.hydromatic.avatica.Casing;
import net.hydromatic.avatica.Quoting;
import org.eigenbase.sql.SqlDialect;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.parser.SqlAbstractParserImpl;
import org.eigenbase.sql.parser.SqlParseException;
import org.eigenbase.sql.parser.SqlParser;
import org.eigenbase.sql.parser.SqlParserImplFactory;
import org.eigenbase.sql.parser.SqlParserUtil;
import org.eigenbase.sql.parser.impl.SqlParserImpl;
import org.eigenbase.test.SqlValidatorTestCase;
import org.eigenbase.util.TestUtil;
import org.eigenbase.util.Util;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class SqlParserTest {
    private static final String ANY = "(?s).*";
    private static final ThreadLocal<boolean[]> LINUXIFY = new ThreadLocal<boolean[]>(){

        @Override
        protected boolean[] initialValue() {
            return new boolean[]{true};
        }
    };
    Quoting quoting = Quoting.DOUBLE_QUOTE;
    Casing unquotedCasing = Casing.TO_UPPER;
    Casing quotedCasing = Casing.UNCHANGED;

    protected Tester getTester() {
        return new TesterImpl();
    }

    protected void check(String sql, String expected) {
        this.getTester().check(sql, expected);
    }

    private SqlParser getSqlParser(String sql) {
        return SqlParser.create((SqlParserImplFactory)SqlParserImpl.FACTORY, (String)sql, (Quoting)this.quoting, (Casing)this.unquotedCasing, (Casing)this.quotedCasing);
    }

    protected SqlNode parseStmt(String sql) throws SqlParseException {
        return this.getSqlParser(sql).parseStmt();
    }

    protected void checkExp(String sql, String expected) {
        this.getTester().checkExp(sql, expected);
    }

    protected SqlNode parseExpression(String sql) throws SqlParseException {
        return this.getSqlParser(sql).parseExpression();
    }

    protected SqlAbstractParserImpl.Metadata getParserMetadata() {
        return this.getSqlParser("").getMetadata();
    }

    protected void checkExpSame(String sql) {
        this.checkExp(sql, sql);
    }

    protected void checkFails(String sql, String expectedMsgPattern) {
        this.getTester().checkFails(sql, expectedMsgPattern);
    }

    protected void checkExpFails(String sql, String expectedMsgPattern) {
        this.getTester().checkExpFails(sql, expectedMsgPattern);
    }

    @Test
    public void testExceptionCleanup() {
        this.checkFails("select 0.5e1^.1^ from sales.emps", "(?s).*Encountered \".1\" at line 1, column 13.\nWas expecting one of:\n    \"FROM\" ...\n    \",\" ...\n    \"AS\" ...\n    <IDENTIFIER> ...\n    <QUOTED_IDENTIFIER> ...\n.*");
    }

    @Test
    public void testInvalidToken() {
        this.checkFails("values (a^#^b)", "Lexical error at line 1, column 10\\.  Encountered: \"#\" \\(35\\), after : \"\"");
    }

    @Test
    public void testDerivedColumnList() {
        this.check("select * from emp as e (empno, gender) where true", "SELECT *\nFROM `EMP` AS `E` (`EMPNO`, `GENDER`)\nWHERE TRUE");
    }

    @Test
    public void testDerivedColumnListInJoin() {
        this.check("select * from emp as e (empno, gender) join dept as d (deptno, dname) on emp.deptno = dept.deptno", "SELECT *\nFROM `EMP` AS `E` (`EMPNO`, `GENDER`)\nINNER JOIN `DEPT` AS `D` (`DEPTNO`, `DNAME`) ON (`EMP`.`DEPTNO` = `DEPT`.`DEPTNO`)");
    }

    @Ignore
    @Test
    public void testDerivedColumnListNoAs() {
        this.check("select * from emp e (empno, gender) where true", "foo");
    }

    @Ignore
    @Test
    public void testEmbeddedCall() {
        this.checkExp("{call foo(?, ?)}", "foo");
    }

    @Ignore
    @Test
    public void testEmbeddedFunction() {
        this.checkExp("{? = call bar (?, ?)}", "foo");
    }

    @Test
    public void testColumnAliasWithAs() {
        this.check("select 1 as foo from emp", "SELECT 1 AS `FOO`\nFROM `EMP`");
    }

    @Test
    public void testColumnAliasWithoutAs() {
        this.check("select 1 foo from emp", "SELECT 1 AS `FOO`\nFROM `EMP`");
    }

    @Test
    public void testEmbeddedDate() {
        this.checkExp("{d '1998-10-22'}", "DATE '1998-10-22'");
    }

    @Test
    public void testEmbeddedTime() {
        this.checkExp("{t '16:22:34'}", "TIME '16:22:34'");
    }

    @Test
    public void testEmbeddedTimestamp() {
        this.checkExp("{ts '1998-10-22 16:22:34'}", "TIMESTAMP '1998-10-22 16:22:34'");
    }

    @Test
    public void testNot() {
        this.check("select not true, not false, not null, not unknown from t", "SELECT (NOT TRUE), (NOT FALSE), (NOT NULL), (NOT UNKNOWN)\nFROM `T`");
    }

    @Test
    public void testBooleanPrecedenceAndAssociativity() {
        this.check("select * from t where true and false", "SELECT *\nFROM `T`\nWHERE (TRUE AND FALSE)");
        this.check("select * from t where null or unknown and unknown", "SELECT *\nFROM `T`\nWHERE (NULL OR (UNKNOWN AND UNKNOWN))");
        this.check("select * from t where true and (true or true) or false", "SELECT *\nFROM `T`\nWHERE ((TRUE AND (TRUE OR TRUE)) OR FALSE)");
        this.check("select * from t where 1 and true", "SELECT *\nFROM `T`\nWHERE (1 AND TRUE)");
    }

    @Test
    public void testIsBooleans() {
        String[] inOuts;
        String[] stringArray = inOuts = new String[]{"NULL", "TRUE", "FALSE", "UNKNOWN"};
        int n = inOuts.length;
        int n2 = 0;
        while (n2 < n) {
            String inOut = stringArray[n2];
            this.check("select * from t where nOt fAlSe Is " + inOut, "SELECT *\nFROM `T`\nWHERE ((NOT FALSE) IS " + inOut + ")");
            this.check("select * from t where c1=1.1 IS NOT " + inOut, "SELECT *\nFROM `T`\nWHERE ((`C1` = 1.1) IS NOT " + inOut + ")");
            ++n2;
        }
    }

    @Test
    public void testIsBooleanPrecedenceAndAssociativity() {
        this.check("select * from t where x is unknown is not unknown", "SELECT *\nFROM `T`\nWHERE ((`X` IS UNKNOWN) IS NOT UNKNOWN)");
        this.check("select 1 from t where not true is unknown", "SELECT 1\nFROM `T`\nWHERE ((NOT TRUE) IS UNKNOWN)");
        this.check("select * from t where x is unknown is not unknown is false is not false is true is not true is null is not null", "SELECT *\nFROM `T`\nWHERE ((((((((`X` IS UNKNOWN) IS NOT UNKNOWN) IS FALSE) IS NOT FALSE) IS TRUE) IS NOT TRUE) IS NULL) IS NOT NULL)");
        this.check("select * from t where x is unknown is false and x is unknown is true or not y is unknown is not null", "SELECT *\nFROM `T`\nWHERE ((((`X` IS UNKNOWN) IS FALSE) AND ((`X` IS UNKNOWN) IS TRUE)) OR (((NOT `Y`) IS UNKNOWN) IS NOT NULL))");
    }

    @Test
    public void testEqualNotEqual() {
        this.checkExp("'abc'=123", "('abc' = 123)");
        this.checkExp("'abc'<>123", "('abc' <> 123)");
        this.checkExp("'abc'<>123='def'<>456", "((('abc' <> 123) = 'def') <> 456)");
        this.checkExp("'abc'<>123=('def'<>456)", "(('abc' <> 123) = ('def' <> 456))");
    }

    @Test
    public void testBangEqualIsBad() {
        this.checkFails("'abc'^!^=123", "Lexical error at line 1, column 6\\.  Encountered: \"!\" \\(33\\), after : \"\"");
    }

    @Test
    public void testBetween() {
        this.check("select * from t where price between 1 and 2", "SELECT *\nFROM `T`\nWHERE (`PRICE` BETWEEN ASYMMETRIC 1 AND 2)");
        this.check("select * from t where price between symmetric 1 and 2", "SELECT *\nFROM `T`\nWHERE (`PRICE` BETWEEN SYMMETRIC 1 AND 2)");
        this.check("select * from t where price not between symmetric 1 and 2", "SELECT *\nFROM `T`\nWHERE (`PRICE` NOT BETWEEN SYMMETRIC 1 AND 2)");
        this.check("select * from t where price between ASYMMETRIC 1 and 2+2*2", "SELECT *\nFROM `T`\nWHERE (`PRICE` BETWEEN ASYMMETRIC 1 AND (2 + (2 * 2)))");
        this.check("select * from t where price > 5 and price not between 1 + 2 and 3 * 4 AnD price is null", "SELECT *\nFROM `T`\nWHERE (((`PRICE` > 5) AND (`PRICE` NOT BETWEEN ASYMMETRIC (1 + 2) AND (3 * 4))) AND (`PRICE` IS NULL))");
        this.check("select * from t where price > 5 and price between 1 + 2 and 3 * 4 + price is null", "SELECT *\nFROM `T`\nWHERE ((`PRICE` > 5) AND ((`PRICE` BETWEEN ASYMMETRIC (1 + 2) AND ((3 * 4) + `PRICE`)) IS NULL))");
        this.check("select * from t where price > 5 and price between 1 + 2 and 3 * 4 or price is null", "SELECT *\nFROM `T`\nWHERE (((`PRICE` > 5) AND (`PRICE` BETWEEN ASYMMETRIC (1 + 2) AND (3 * 4))) OR (`PRICE` IS NULL))");
        this.check("values a between c and d and e and f between g and h", "(VALUES (ROW((((`A` BETWEEN ASYMMETRIC `C` AND `D`) AND `E`) AND (`F` BETWEEN ASYMMETRIC `G` AND `H`)))))");
        this.checkFails("values a between b or c^", ".*BETWEEN operator has no terminating AND");
        this.checkFails("values a ^between^", "(?s).*Encountered \"between <EOF>\" at line 1, column 10.*");
        this.checkFails("values a between symmetric 1^", ".*BETWEEN operator has no terminating AND");
        this.check("values a between b and c + 2 or d and e", "(VALUES (ROW(((`A` BETWEEN ASYMMETRIC `B` AND (`C` + 2)) OR (`D` AND `E`)))))");
        this.check("values x = a between b and c = d = e", "(VALUES (ROW(((((`X` = `A`) BETWEEN ASYMMETRIC `B` AND `C`) = `D`) = `E`))))");
        this.check("values a between b or (c and d) or e and f", "(VALUES (ROW((`A` BETWEEN ASYMMETRIC ((`B` OR (`C` AND `D`)) OR `E`) AND `F`))))");
    }

    @Test
    public void testOperateOnColumn() {
        this.check("select c1*1,c2  + 2,c3/3,c4-4,c5*c4  from t", "SELECT (`C1` * 1), (`C2` + 2), (`C3` / 3), (`C4` - 4), (`C5` * `C4`)\nFROM `T`");
    }

    @Test
    public void testRow() {
        this.check("select t.r.\"EXPR$1\", t.r.\"EXPR$0\" from (select (1,2) r from sales.depts) t", "SELECT `T`.`R`.`EXPR$1`, `T`.`R`.`EXPR$0`\nFROM (SELECT (ROW(1, 2)) AS `R`\nFROM `SALES`.`DEPTS`) AS `T`");
        this.check("select t.r.\"EXPR$1\".\"EXPR$2\" from (select ((1,2),(3,4,5)) r from sales.depts) t", "SELECT `T`.`R`.`EXPR$1`.`EXPR$2`\nFROM (SELECT (ROW((ROW(1, 2)), (ROW(3, 4, 5)))) AS `R`\nFROM `SALES`.`DEPTS`) AS `T`");
        this.check("select t.r.\"EXPR$1\".\"EXPR$2\" from (select ((1,2),(3,4,5,6)) r from sales.depts) t", "SELECT `T`.`R`.`EXPR$1`.`EXPR$2`\nFROM (SELECT (ROW((ROW(1, 2)), (ROW(3, 4, 5, 6)))) AS `R`\nFROM `SALES`.`DEPTS`) AS `T`");
    }

    @Test
    public void testOverlaps() {
        this.checkExp("(x,xx) overlaps (y,yy)", "((`X`, `XX`) OVERLAPS (`Y`, `YY`))");
        this.checkExp("(x,xx) overlaps (y,yy) or false", "(((`X`, `XX`) OVERLAPS (`Y`, `YY`)) OR FALSE)");
        this.checkExp("true and not (x,xx) overlaps (y,yy) or false", "((TRUE AND (NOT ((`X`, `XX`) OVERLAPS (`Y`, `YY`)))) OR FALSE)");
        this.checkExpFails("^(x,xx,xxx) overlaps (y,yy)^ or false", "(?s).*Illegal overlaps expression.*");
        this.checkExpFails("true or ^(x,xx,xxx) overlaps (y,yy,yyy)^ or false", "(?s).*Illegal overlaps expression.*");
        this.checkExpFails("^(x,xx) overlaps (y,yy,yyy)^ or false", "(?s).*Illegal overlaps expression.*");
    }

    @Test
    public void testIsDistinctFrom() {
        this.check("select x is distinct from y from t", "SELECT (`X` IS DISTINCT FROM `Y`)\nFROM `T`");
        this.check("select * from t where x is distinct from y", "SELECT *\nFROM `T`\nWHERE (`X` IS DISTINCT FROM `Y`)");
        this.check("select * from t where x is distinct from (4,5,6)", "SELECT *\nFROM `T`\nWHERE (`X` IS DISTINCT FROM (ROW(4, 5, 6)))");
        this.check("select * from t where true is distinct from true", "SELECT *\nFROM `T`\nWHERE (TRUE IS DISTINCT FROM TRUE)");
        this.check("select * from t where true is distinct from true is true", "SELECT *\nFROM `T`\nWHERE ((TRUE IS DISTINCT FROM TRUE) IS TRUE)");
    }

    @Test
    public void testIsNotDistinct() {
        this.check("select x is not distinct from y from t", "SELECT (`X` IS NOT DISTINCT FROM `Y`)\nFROM `T`");
        this.check("select * from t where true is not distinct from true", "SELECT *\nFROM `T`\nWHERE (TRUE IS NOT DISTINCT FROM TRUE)");
    }

    @Test
    public void testCast() {
        this.checkExp("cast(x as boolean)", "CAST(`X` AS BOOLEAN)");
        this.checkExp("cast(x as integer)", "CAST(`X` AS INTEGER)");
        this.checkExp("cast(x as varchar(1))", "CAST(`X` AS VARCHAR(1))");
        this.checkExp("cast(x as date)", "CAST(`X` AS DATE)");
        this.checkExp("cast(x as time)", "CAST(`X` AS TIME)");
        this.checkExp("cast(x as timestamp)", "CAST(`X` AS TIMESTAMP)");
        this.checkExp("cast(x as time(0))", "CAST(`X` AS TIME(0))");
        this.checkExp("cast(x as timestamp(0))", "CAST(`X` AS TIMESTAMP(0))");
        this.checkExp("cast(x as decimal(1,1))", "CAST(`X` AS DECIMAL(1, 1))");
        this.checkExp("cast(x as char(1))", "CAST(`X` AS CHAR(1))");
        this.checkExp("cast(x as binary(1))", "CAST(`X` AS BINARY(1))");
        this.checkExp("cast(x as varbinary(1))", "CAST(`X` AS VARBINARY(1))");
        this.checkExp("cast(x as tinyint)", "CAST(`X` AS TINYINT)");
        this.checkExp("cast(x as smallint)", "CAST(`X` AS SMALLINT)");
        this.checkExp("cast(x as bigint)", "CAST(`X` AS BIGINT)");
        this.checkExp("cast(x as real)", "CAST(`X` AS REAL)");
        this.checkExp("cast(x as double)", "CAST(`X` AS DOUBLE)");
        this.checkExp("cast(x as decimal)", "CAST(`X` AS DECIMAL)");
        this.checkExp("cast(x as decimal(0))", "CAST(`X` AS DECIMAL(0))");
        this.checkExp("cast(x as decimal(1,2))", "CAST(`X` AS DECIMAL(1, 2))");
        this.checkExp("cast('foo' as bar)", "CAST('foo' AS `BAR`)");
    }

    @Test
    public void testCastFails() {
    }

    @Test
    public void testLikeAndSimilar() {
        this.check("select * from t where x like '%abc%'", "SELECT *\nFROM `T`\nWHERE (`X` LIKE '%abc%')");
        this.check("select * from t where x+1 not siMilaR to '%abc%' ESCAPE 'e'", "SELECT *\nFROM `T`\nWHERE ((`X` + 1) NOT SIMILAR TO '%abc%' ESCAPE 'e')");
        this.check("select * from t where price > 5 and x+2*2 like y*3+2 escape (select*from t)", "SELECT *\nFROM `T`\nWHERE ((`PRICE` > 5) AND ((`X` + (2 * 2)) LIKE ((`Y` * 3) + 2) ESCAPE (SELECT *\nFROM `T`)))");
        this.check("values a and b like c", "(VALUES (ROW((`A` AND (`B` LIKE `C`)))))");
        this.check("values a and b like c escape d and e", "(VALUES (ROW(((`A` AND (`B` LIKE `C` ESCAPE `D`)) AND `E`))))");
        this.check("values a = b like c = d", "(VALUES (ROW(((`A` = `B`) LIKE (`C` = `D`)))))");
        this.check("values a like b like c escape d", "(VALUES (ROW((`A` LIKE (`B` LIKE `C` ESCAPE `D`)))))");
        this.check("values a like b like c escape d and false", "(VALUES (ROW(((`A` LIKE (`B` LIKE `C` ESCAPE `D`)) AND FALSE))))");
        this.check("values a like b like c like d escape e escape f", "(VALUES (ROW((`A` LIKE (`B` LIKE (`C` LIKE `D` ESCAPE `E`) ESCAPE `F`)))))");
        this.check("values a similar to b like c similar to d escape e escape f", "(VALUES (ROW((`A` SIMILAR TO (`B` LIKE (`C` SIMILAR TO `D` ESCAPE `E`) ESCAPE `F`)))))");
        this.checkFails("select * from t ^where^ escape 'e'", "(?s).*Encountered \"where escape\" at .*");
        this.check("values a like b + c escape d", "(VALUES (ROW((`A` LIKE (`B` + `C`) ESCAPE `D`))))");
        this.check("values a like b || c escape d", "(VALUES (ROW((`A` LIKE (`B` || `C`) ESCAPE `D`))))");
        this.checkFails("values a ^like^ escape d", "(?s).*Encountered \"like escape\" at .*");
        this.checkFails("values a like b || c ^escape^ and false", "(?s).*Encountered \"escape and\" at line 1, column 22.*");
        this.check("select * from t where x similar to '%abc%'", "SELECT *\nFROM `T`\nWHERE (`X` SIMILAR TO '%abc%')");
        this.check("select * from t where x+1 not siMilaR to '%abc%' ESCAPE 'e'", "SELECT *\nFROM `T`\nWHERE ((`X` + 1) NOT SIMILAR TO '%abc%' ESCAPE 'e')");
        this.check("select * from t where price > 5 and x+2*2 SIMILAR TO y*3+2 escape (select*from t)", "SELECT *\nFROM `T`\nWHERE ((`PRICE` > 5) AND ((`X` + (2 * 2)) SIMILAR TO ((`Y` * 3) + 2) ESCAPE (SELECT *\nFROM `T`)))");
        this.check("values a similar to b like c similar to d escape e escape f", "(VALUES (ROW((`A` SIMILAR TO (`B` LIKE (`C` SIMILAR TO `D` ESCAPE `E`) ESCAPE `F`)))))");
        this.check("values a similar to (select * from t where a like b escape c) escape d", "(VALUES (ROW((`A` SIMILAR TO (SELECT *\nFROM `T`\nWHERE (`A` LIKE `B` ESCAPE `C`)) ESCAPE `D`))))");
    }

    @Test
    public void testFoo() {
    }

    @Test
    public void testArthimeticOperators() {
        this.checkExp("1-2+3*4/5/6-7", "(((1 - 2) + (((3 * 4) / 5) / 6)) - 7)");
        this.checkExp("power(2,3)", "POWER(2, 3)");
        this.checkExp("aBs(-2.3e-2)", "ABS(-2.3E-2)");
        this.checkExp("MOD(5             ,\t\f\r\n2)", "MOD(5, 2)");
        this.checkExp("ln(5.43  )", "LN(5.43)");
        this.checkExp("log10(- -.2  )", "LOG10((- -0.2))");
    }

    @Test
    public void testExists() {
        this.check("select * from dept where exists (select 1 from emp where emp.deptno = dept.deptno)", "SELECT *\nFROM `DEPT`\nWHERE (EXISTS (SELECT 1\nFROM `EMP`\nWHERE (`EMP`.`DEPTNO` = `DEPT`.`DEPTNO`)))");
    }

    @Test
    public void testExistsInWhere() {
        this.check("select * from emp where 1 = 2 and exists (select 1 from dept) and 3 = 4", "SELECT *\nFROM `EMP`\nWHERE (((1 = 2) AND (EXISTS (SELECT 1\nFROM `DEPT`))) AND (3 = 4))");
    }

    @Test
    public void testFromWithAs() {
        this.check("select 1 from emp as e where 1", "SELECT 1\nFROM `EMP` AS `E`\nWHERE 1");
    }

    @Test
    public void testConcat() {
        this.checkExp("'a' || 'b'", "('a' || 'b')");
    }

    @Test
    public void testReverseSolidus() {
        this.checkExp("'\\'", "'\\'");
    }

    @Test
    public void testSubstring() {
        this.checkExp("substring('a' \n  FROM \t  1)", "SUBSTRING('a' FROM 1)");
        this.checkExp("substring('a' FROM 1 FOR 3)", "SUBSTRING('a' FROM 1 FOR 3)");
        this.checkExp("substring('a' FROM 'reg' FOR '\\')", "SUBSTRING('a' FROM 'reg' FOR '\\')");
        this.checkExp("substring('a', 'reg', '\\')", "SUBSTRING('a' FROM 'reg' FOR '\\')");
        this.checkExp("substring('a', 1, 2)", "SUBSTRING('a' FROM 1 FOR 2)");
        this.checkExp("substring('a' , 1)", "SUBSTRING('a' FROM 1)");
    }

    @Test
    public void testFunction() {
        this.check("select substring('Eggs and ham', 1, 3 + 2) || ' benedict' from emp", "SELECT (SUBSTRING('Eggs and ham' FROM 1 FOR (3 + 2)) || ' benedict')\nFROM `EMP`");
        this.checkExp("log10(1)\r\n+power(2, mod(\r\n3\n\t\t\f\n,ln(4))*log10(5)-6*log10(7/abs(8)+9))*power(10,11)", "(LOG10(1) + (POWER(2, ((MOD(3, LN(4)) * LOG10(5)) - (6 * LOG10(((7 / ABS(8)) + 9))))) * POWER(10, 11)))");
    }

    @Test
    public void testFunctionWithDistinct() {
        this.checkExp("count(DISTINCT 1)", "COUNT(DISTINCT 1)");
        this.checkExp("count(ALL 1)", "COUNT(ALL 1)");
        this.checkExp("count(1)", "COUNT(1)");
        this.check("select count(1), count(distinct 2) from emp", "SELECT COUNT(1), COUNT(DISTINCT 2)\nFROM `EMP`");
    }

    @Test
    public void testFunctionInFunction() {
        this.checkExp("ln(power(2,2))", "LN(POWER(2, 2))");
    }

    @Test
    public void testGroup() {
        this.check("select deptno, min(foo) as x from emp group by deptno, gender", "SELECT `DEPTNO`, MIN(`FOO`) AS `X`\nFROM `EMP`\nGROUP BY `DEPTNO`, `GENDER`");
    }

    @Test
    public void testGroupEmpty() {
        this.check("select count(*) from emp group by ()", "SELECT COUNT(*)\nFROM `EMP`\nGROUP BY ()");
        this.check("select count(*) from emp group by () having 1 = 2 order by 3", "SELECT COUNT(*)\nFROM `EMP`\nGROUP BY ()\nHAVING (1 = 2)\nORDER BY 3");
        this.checkFails("select 1 from emp group by ()^,^ x", "(?s)Encountered \\\",\\\" at .*");
        this.checkFails("select 1 from emp group by x, ^(^)", "(?s)Encountered \"\\( \\)\" at .*");
        this.check("select 1 from emp group by (empno + deptno)", "SELECT 1\nFROM `EMP`\nGROUP BY (`EMPNO` + `DEPTNO`)");
    }

    @Test
    public void testHavingAfterGroup() {
        this.check("select deptno from emp group by deptno, emp having count(*) > 5 and 1 = 2 order by 5, 2", "SELECT `DEPTNO`\nFROM `EMP`\nGROUP BY `DEPTNO`, `EMP`\nHAVING ((COUNT(*) > 5) AND (1 = 2))\nORDER BY 5, 2");
    }

    @Test
    public void testHavingBeforeGroupFails() {
        this.checkFails("select deptno from emp having count(*) > 5 and deptno < 4 ^group^ by deptno, emp", "(?s).*Encountered \"group\" at .*");
    }

    @Test
    public void testHavingNoGroup() {
        this.check("select deptno from emp having count(*) > 5", "SELECT `DEPTNO`\nFROM `EMP`\nHAVING (COUNT(*) > 5)");
    }

    @Test
    public void testWith() {
        this.check("with femaleEmps as (select * from emps where gender = 'F')select deptno from femaleEmps", "WITH `FEMALEEMPS` AS (SELECT *\nFROM `EMPS`\nWHERE (`GENDER` = 'F')) SELECT `DEPTNO`\nFROM `FEMALEEMPS`");
    }

    @Test
    public void testWith2() {
        this.check("with femaleEmps as (select * from emps where gender = 'F'),\nmarriedFemaleEmps(x, y) as (select * from femaleEmps where maritaStatus = 'M')\nselect deptno from femaleEmps", "WITH `FEMALEEMPS` AS (SELECT *\nFROM `EMPS`\nWHERE (`GENDER` = 'F')), `MARRIEDFEMALEEMPS` (`X`, `Y`) AS (SELECT *\nFROM `FEMALEEMPS`\nWHERE (`MARITASTATUS` = 'M')) SELECT `DEPTNO`\nFROM `FEMALEEMPS`");
    }

    @Test
    public void testWithFails() {
        this.checkFails("with femaleEmps as ^select^ * from emps where gender = 'F'\nselect deptno from femaleEmps", "(?s)Encountered \"select\" at .*");
    }

    @Test
    public void testWithValues() {
        this.check("with v(i,c) as (values (1, 'a'), (2, 'bb'))\nselect c, i from v", "WITH `V` (`I`, `C`) AS (VALUES (ROW(1, 'a')), (ROW(2, 'bb'))) SELECT `C`, `I`\nFROM `V`");
    }

    @Test
    public void testWithNestedFails() {
        this.checkFails("with emp2 as (select * from emp)\n^with^ dept2 as (select * from dept)\nselect 1 as one from emp, dept", "(?s)Encountered \"with\" at .*");
    }

    @Test
    public void testWithNestedInSubquery() {
        this.check("with emp2 as (select * from emp)\n(\n  with dept2 as (select * from dept)\n  select 1 as one from empDept)", "WITH `EMP2` AS (SELECT *\nFROM `EMP`) WITH `DEPT2` AS (SELECT *\nFROM `DEPT`) SELECT 1 AS `ONE`\nFROM `EMPDEPT`");
    }

    @Test
    public void testWithUnion() {
        this.check("with emp2 as (select * from emp)\nselect * from emp2\nunion\nselect * from emp2\n", "WITH `EMP2` AS (SELECT *\nFROM `EMP`) (SELECT *\nFROM `EMP2`\nUNION\nSELECT *\nFROM `EMP2`)");
    }

    @Test
    public void testIdentifier() {
        this.checkExp("ab", "`AB`");
        this.checkExp("     \"a  \"\" b!c\"", "`a  \" b!c`");
        this.checkExpFails("     ^`^a  \" b!c`", "(?s).*Encountered.*");
        this.checkExp("\"x`y`z\"", "`x``y``z`");
        this.checkExpFails("^`^x`y`z`", "(?s).*Encountered.*");
        this.checkExp("myMap[field] + myArray[1 + 2]", "(`MYMAP`[`FIELD`] + `MYARRAY`[(1 + 2)])");
    }

    @Test
    public void testBackTickIdentifier() {
        this.quoting = Quoting.BACK_TICK;
        this.checkExp("ab", "`AB`");
        this.checkExp("     `a  \" b!c`", "`a  \" b!c`");
        this.checkExpFails("     ^\"^a  \"\" b!c\"", "(?s).*Encountered.*");
        this.checkExpFails("^\"^x`y`z\"", "(?s).*Encountered.*");
        this.checkExp("`x``y``z`", "`x``y``z`");
        this.checkExp("myMap[field] + myArray[1 + 2]", "(`MYMAP`[`FIELD`] + `MYARRAY`[(1 + 2)])");
    }

    @Test
    public void testBracketIdentifier() {
        this.quoting = Quoting.BRACKET;
        this.checkExp("ab", "`AB`");
        this.checkExp("     [a  \" b!c]", "`a  \" b!c`");
        this.checkExpFails("     ^`^a  \" b!c`", "(?s).*Encountered.*");
        this.checkExpFails("     ^\"^a  \"\" b!c\"", "(?s).*Encountered.*");
        this.checkExp("[x`y`z]", "`x``y``z`");
        this.checkExpFails("^\"^x`y`z\"", "(?s).*Encountered.*");
        this.checkExpFails("^`^x``y``z`", "(?s).*Encountered.*");
        this.checkExp("[anything [even brackets]] is].[ok]", "`anything [even brackets] is`.`ok`");
        this.check("select * from myMap[field], myArray[1 + 2]", "SELECT *\nFROM `MYMAP` AS `field`,\n`MYARRAY` AS `1 + 2`");
        this.check("select * from myMap [field], myArray [1 + 2]", "SELECT *\nFROM `MYMAP` AS `field`,\n`MYARRAY` AS `1 + 2`");
    }

    @Test
    public void testBackTickQuery() {
        this.quoting = Quoting.BACK_TICK;
        this.check("select `x`.`b baz` from `emp` as `x` where `x`.deptno in (10, 20)", "SELECT `x`.`b baz`\nFROM `emp` AS `x`\nWHERE (`x`.`DEPTNO` IN (10, 20))");
    }

    @Test
    public void testInList() {
        this.check("select * from emp where deptno in (10, 20) and gender = 'F'", "SELECT *\nFROM `EMP`\nWHERE ((`DEPTNO` IN (10, 20)) AND (`GENDER` = 'F'))");
    }

    @Test
    public void testInListEmptyFails() {
        this.checkFails("select * from emp where deptno in (^)^ and gender = 'F'", "(?s).*Encountered \"\\)\" at line 1, column 36\\..*");
    }

    @Test
    public void testInQuery() {
        this.check("select * from emp where deptno in (select deptno from dept)", "SELECT *\nFROM `EMP`\nWHERE (`DEPTNO` IN (SELECT `DEPTNO`\nFROM `DEPT`))");
    }

    @Test
    public void testInQueryWithComma() {
        this.check("select * from emp where deptno in (select deptno from dept group by 1, 2)", "SELECT *\nFROM `EMP`\nWHERE (`DEPTNO` IN (SELECT `DEPTNO`\nFROM `DEPT`\nGROUP BY 1, 2))");
    }

    @Test
    public void testInSetop() {
        this.check("select * from emp where deptno in ((select deptno from dept union select * from dept)except select * from dept) and false", "SELECT *\nFROM `EMP`\nWHERE ((`DEPTNO` IN ((SELECT `DEPTNO`\nFROM `DEPT`\nUNION\nSELECT *\nFROM `DEPT`)\nEXCEPT\nSELECT *\nFROM `DEPT`)) AND FALSE)");
    }

    @Test
    public void testUnion() {
        this.check("select * from a union select * from a", "(SELECT *\nFROM `A`\nUNION\nSELECT *\nFROM `A`)");
        this.check("select * from a union all select * from a", "(SELECT *\nFROM `A`\nUNION ALL\nSELECT *\nFROM `A`)");
        this.check("select * from a union distinct select * from a", "(SELECT *\nFROM `A`\nUNION\nSELECT *\nFROM `A`)");
    }

    @Test
    public void testUnionOrder() {
        this.check("select a, b from t union all select x, y from u order by 1 asc, 2 desc", "(SELECT `A`, `B`\nFROM `T`\nUNION ALL\nSELECT `X`, `Y`\nFROM `U`)\nORDER BY 1, 2 DESC");
    }

    @Test
    public void testUnionOfNonQueryFails() {
        this.checkFails("select 1 from emp union ^2^ + 5", "Non-query expression encountered in illegal context");
    }

    @Test
    public void testQueryInIllegalContext() {
        this.checkFails("select 0, multiset[^(^select * from emp), 2] from dept", "Query expression encountered in illegal context");
        this.checkFails("select 0, multiset[1, ^(^select * from emp), 2, 3] from dept", "Query expression encountered in illegal context");
    }

    @Test
    public void testExcept() {
        this.check("select * from a except select * from a", "(SELECT *\nFROM `A`\nEXCEPT\nSELECT *\nFROM `A`)");
        this.check("select * from a except all select * from a", "(SELECT *\nFROM `A`\nEXCEPT ALL\nSELECT *\nFROM `A`)");
        this.check("select * from a except distinct select * from a", "(SELECT *\nFROM `A`\nEXCEPT\nSELECT *\nFROM `A`)");
    }

    @Test
    public void testIntersect() {
        this.check("select * from a intersect select * from a", "(SELECT *\nFROM `A`\nINTERSECT\nSELECT *\nFROM `A`)");
        this.check("select * from a intersect all select * from a", "(SELECT *\nFROM `A`\nINTERSECT ALL\nSELECT *\nFROM `A`)");
        this.check("select * from a intersect distinct select * from a", "(SELECT *\nFROM `A`\nINTERSECT\nSELECT *\nFROM `A`)");
    }

    @Test
    public void testJoinCross() {
        this.check("select * from a as a2 cross join b", "SELECT *\nFROM `A` AS `A2`\nCROSS JOIN `B`");
    }

    @Test
    public void testJoinOn() {
        this.check("select * from a left join b on 1 = 1 and 2 = 2 where 3 = 3", "SELECT *\nFROM `A`\nLEFT JOIN `B` ON ((1 = 1) AND (2 = 2))\nWHERE (3 = 3)");
    }

    @Test
    public void testJoinOnParentheses() {
    }

    @Test
    public void testJoinOnParenthesesPlus() {
    }

    @Test
    public void testExplicitTableInJoin() {
        this.check("select * from a left join (table b) on 2 = 2 where 3 = 3", "SELECT *\nFROM `A`\nLEFT JOIN (TABLE `B`) ON (2 = 2)\nWHERE (3 = 3)");
    }

    @Test
    public void testSubqueryInJoin() {
    }

    @Test
    public void testOuterJoinNoiseWord() {
        this.check("select * from a left outer join b on 1 = 1 and 2 = 2 where 3 = 3", "SELECT *\nFROM `A`\nLEFT JOIN `B` ON ((1 = 1) AND (2 = 2))\nWHERE (3 = 3)");
    }

    @Test
    public void testJoinQuery() {
        this.check("select * from a join (select * from b) as b2 on true", "SELECT *\nFROM `A`\nINNER JOIN (SELECT *\nFROM `B`) AS `B2` ON TRUE");
    }

    @Test
    public void testFullInnerJoinFails() {
        this.checkFails("select * from a ^full^ inner join b", "(?s).*Encountered \"full inner\" at line 1, column 17.*");
    }

    @Test
    public void testFullOuterJoin() {
        this.check("select * from a full outer join b", "SELECT *\nFROM `A`\nFULL JOIN `B`");
    }

    @Test
    public void testInnerOuterJoinFails() {
        this.checkFails("select * from a ^inner^ outer join b", "(?s).*Encountered \"inner outer\" at line 1, column 17.*");
    }

    @Ignore
    @Test
    public void testJoinAssociativity() {
        this.check("select * from (a natural left join b) left join c on b.c1 = c.c1", "SELECT *\nFROM (`A` NATURAL LEFT JOIN `B`) LEFT JOIN `C` ON (`B`.`C1` = `C`.`C1`)\n");
        this.check("select * from a natural left join (b left join c on b.c1 = c.c1)", "SELECT *\nFROM (`A` NATURAL LEFT JOIN `B`) LEFT JOIN `C` ON (`B`.`C1` = `C`.`C1`)\n");
        this.check("select * from a natural left join b left join c on b.c1 = c.c1", "SELECT *\nFROM (`A` NATURAL LEFT JOIN `B`) LEFT JOIN `C` ON (`B`.`C1` = `C`.`C1`)\n");
    }

    @Test
    public void testNaturalCrossJoin() {
        this.check("select * from a natural cross join b", "SELECT *\nFROM `A`\nNATURAL CROSS JOIN `B`");
    }

    @Test
    public void testJoinUsing() {
        this.check("select * from a join b using (x)", "SELECT *\nFROM `A`\nINNER JOIN `B` USING (`X`)");
        this.checkFails("select * from a join b using (^)^ where c = d", "(?s).*Encountered \"[)]\" at line 1, column 31.*");
    }

    @Test
    public void testTableSample() {
        this.check("select * from (  select *   from emp   join dept on emp.deptno = dept.deptno  where gender = 'F'  order by sal) tablesample substitute('medium')", "SELECT *\nFROM (SELECT *\nFROM `EMP`\nINNER JOIN `DEPT` ON (`EMP`.`DEPTNO` = `DEPT`.`DEPTNO`)\nWHERE (`GENDER` = 'F')\nORDER BY `SAL`) TABLESAMPLE SUBSTITUTE('MEDIUM')");
        this.check("select * from emp as x tablesample substitute('medium') join dept tablesample substitute('lar' /* split */ 'ge') on x.deptno = dept.deptno", "SELECT *\nFROM `EMP` AS `X` TABLESAMPLE SUBSTITUTE('MEDIUM')\nINNER JOIN `DEPT` TABLESAMPLE SUBSTITUTE('LARGE') ON (`X`.`DEPTNO` = `DEPT`.`DEPTNO`)");
        this.check("select * from emp as x tablesample bernoulli(50)", "SELECT *\nFROM `EMP` AS `X` TABLESAMPLE BERNOULLI(50.0)");
    }

    @Test
    public void testLiteral() {
        this.checkExpSame("'foo'");
        this.checkExpSame("100");
        this.check("select 1 as one, 'x' as x, null as n from emp", "SELECT 1 AS `ONE`, 'x' AS `X`, NULL AS `N`\nFROM `EMP`");
        this.checkExp("'2004-06-01'", "'2004-06-01'");
        this.checkExp("-.25", "-0.25");
        this.checkExpSame("TIMESTAMP '2004-06-01 15:55:55'");
        this.checkExpSame("TIMESTAMP '2004-06-01 15:55:55.900'");
        this.checkExp("TIMESTAMP '2004-06-01 15:55:55.1234'", "TIMESTAMP '2004-06-01 15:55:55.123'");
        this.checkExp("TIMESTAMP '2004-06-01 15:55:55.1236'", "TIMESTAMP '2004-06-01 15:55:55.124'");
        this.checkExp("TIMESTAMP '2004-06-01 15:55:55.9999'", "TIMESTAMP '2004-06-01 15:55:56.000'");
        this.checkExpSame("NULL");
    }

    @Test
    public void testContinuedLiteral() {
        this.checkExp("'abba'\n'abba'", "'abba'\n'abba'");
        this.checkExp("'abba'\n'0001'", "'abba'\n'0001'");
        this.checkExp("N'yabba'\n'dabba'\n'doo'", "_ISO-8859-1'yabba'\n'dabba'\n'doo'");
        this.checkExp("_iso-8859-1'yabba'\n'dabba'\n'don''t'", "_ISO-8859-1'yabba'\n'dabba'\n'don''t'");
        this.checkExp("x'01aa'\n'03ff'", "X'01AA'\n'03FF'");
        this.checkFails("x'01aa'\n^'vvvv'^", "Binary literal string must contain only characters '0' - '9', 'A' - 'F'");
    }

    @Test
    public void testMixedFrom() {
        this.check("select * from a join b using (x), c join d using (y)", "SELECT *\nFROM `A`\nINNER JOIN `B` USING (`X`),\n`C`\nINNER JOIN `D` USING (`Y`)");
    }

    @Test
    public void testMixedStar() {
        this.check("select emp.*, 1 as foo from emp, dept", "SELECT `EMP`.*, 1 AS `FOO`\nFROM `EMP`,\n`DEPT`");
    }

    @Test
    public void testNotExists() {
        this.check("select * from dept where not not exists (select * from emp) and true", "SELECT *\nFROM `DEPT`\nWHERE ((NOT (NOT (EXISTS (SELECT *\nFROM `EMP`)))) AND TRUE)");
    }

    @Test
    public void testOrder() {
        this.check("select * from emp order by empno, gender desc, deptno asc, empno asc, name desc", "SELECT *\nFROM `EMP`\nORDER BY `EMPNO`, `GENDER` DESC, `DEPTNO`, `EMPNO`, `NAME` DESC");
    }

    @Test
    public void testOrderNullsFirst() {
        this.check("select * from emp order by gender desc nulls last, deptno asc nulls first, empno nulls last", "SELECT *\nFROM `EMP`\nORDER BY `GENDER` DESC NULLS LAST, `DEPTNO` NULLS FIRST, `EMPNO` NULLS LAST");
    }

    @Test
    public void testOrderInternal() {
        this.check("(select * from emp order by empno) union select * from emp", "((SELECT *\nFROM `EMP`\nORDER BY `EMPNO`)\nUNION\nSELECT *\nFROM `EMP`)");
        this.check("select * from (select * from t order by x, y) where a = b", "SELECT *\nFROM (SELECT *\nFROM `T`\nORDER BY `X`, `Y`)\nWHERE (`A` = `B`)");
    }

    @Test
    public void testOrderIllegalInExpression() {
        this.check("select (select 1 from foo order by x,y) from t where a = b", "SELECT (SELECT 1\nFROM `FOO`\nORDER BY `X`, `Y`)\nFROM `T`\nWHERE (`A` = `B`)");
        this.checkFails("select (1 ^order^ by x, y) from t where a = b", "ORDER BY unexpected");
    }

    @Test
    public void testOrderOffsetFetch() {
        this.check("select a from foo order by b, c offset 1 row fetch first 2 row only", "SELECT `A`\nFROM `FOO`\nORDER BY `B`, `C`\nOFFSET 1 ROWS\nFETCH NEXT 2 ROWS ONLY");
        this.check("select a from foo order by b, c offset 1 rows fetch first 2 rows only", "SELECT `A`\nFROM `FOO`\nORDER BY `B`, `C`\nOFFSET 1 ROWS\nFETCH NEXT 2 ROWS ONLY");
        this.check("select a from foo order by b, c offset 1 rows fetch next 3 rows only", "SELECT `A`\nFROM `FOO`\nORDER BY `B`, `C`\nOFFSET 1 ROWS\nFETCH NEXT 3 ROWS ONLY");
        this.check("select a from foo order by b, c offset 1 fetch next 3 rows only", "SELECT `A`\nFROM `FOO`\nORDER BY `B`, `C`\nOFFSET 1 ROWS\nFETCH NEXT 3 ROWS ONLY");
        this.check("select a from foo order by b, c fetch next 3 rows only", "SELECT `A`\nFROM `FOO`\nORDER BY `B`, `C`\nFETCH NEXT 3 ROWS ONLY");
        this.check("select a from foo fetch next 4 rows only", "SELECT `A`\nFROM `FOO`\nFETCH NEXT 4 ROWS ONLY");
        this.check("select a from foo offset 1 row", "SELECT `A`\nFROM `FOO`\nOFFSET 1 ROWS");
        this.check("select a from foo offset 1 row fetch next 3 rows only", "SELECT `A`\nFROM `FOO`\nOFFSET 1 ROWS\nFETCH NEXT 3 ROWS ONLY");
        this.checkFails("select a from foo offset 1 fetch next 3 ^only^", "(?s).*Encountered \"only\" at .*");
        this.checkFails("select a from foo fetch next 3 rows only ^offset^ 1", "(?s).*Encountered \"offset\" at .*");
    }

    @Test
    public void testLimit() {
        this.check("select a from foo order by b, c limit 2 offset 1", "SELECT `A`\nFROM `FOO`\nORDER BY `B`, `C`\nOFFSET 1 ROWS\nFETCH NEXT 2 ROWS ONLY");
        this.check("select a from foo order by b, c limit 2", "SELECT `A`\nFROM `FOO`\nORDER BY `B`, `C`\nFETCH NEXT 2 ROWS ONLY");
        this.check("select a from foo order by b, c offset 1", "SELECT `A`\nFROM `FOO`\nORDER BY `B`, `C`\nOFFSET 1 ROWS");
    }

    @Test
    public void testSqlInlineComment() {
        this.check("select 1 from t --this is a comment\n", "SELECT 1\nFROM `T`");
        this.check("select 1 from t--\n", "SELECT 1\nFROM `T`");
        this.check("select 1 from t--this is a comment\nwhere a>b-- this is comment\n", "SELECT 1\nFROM `T`\nWHERE (`A` > `B`)");
    }

    @Test
    public void testMultilineComment() {
        this.check("select 1 /* , 2 */, 3 from t", "SELECT 1, 3\nFROM `T`");
        this.check("select /* 1,\n 2, \n */ 3 from t", "SELECT 3\nFROM `T`");
        this.check("values ( /** 1, 2 + ** */ 3)", "(VALUES (ROW(3)))");
        this.check("values ('a string with /* a comment */ in it')", "(VALUES (ROW('a string with /* a comment */ in it')))");
        this.check("values (- -1\n)", "(VALUES (ROW((- -1))))");
        this.check("values (--1+\n2)", "(VALUES (ROW(2)))");
        this.check("values (1 + /* comment -- rest of line\n rest of comment */ 2)", "(VALUES (ROW((1 + 2))))");
        this.check("values -- rest of line /* a comment */ \n(1)", "(VALUES (ROW(1)))");
        this.check("values -- rest of line /* a comment  \n(1)", "(VALUES (ROW(1)))");
        this.check("values ('abc'/* a comment*/'def')", "(VALUES (ROW('abc'\n'def')))");
        this.check("values /**/ (1)", "(VALUES (ROW(1)))");
    }

    @Test
    public void testParseNumber() {
        this.checkExp("1", "1");
        this.checkExp("+1.", "1");
        this.checkExp("-1", "-1");
        this.checkExp("- -1", "(- -1)");
        this.checkExp("1.0", "1.0");
        this.checkExp("-3.2", "-3.2");
        this.checkExp("1.", "1");
        this.checkExp(".1", "0.1");
        this.checkExp("2500000000", "2500000000");
        this.checkExp("5000000000", "5000000000");
        this.checkExp("1e1", "1E1");
        this.checkExp("+1e1", "1E1");
        this.checkExp("1.1e1", "1.1E1");
        this.checkExp("1.1e+1", "1.1E1");
        this.checkExp("1.1e-1", "1.1E-1");
        this.checkExp("+1.1e-1", "1.1E-1");
        this.checkExp("1.E3", "1E3");
        this.checkExp("1.e-3", "1E-3");
        this.checkExp("1.e+3", "1E3");
        this.checkExp(".5E3", "5E2");
        this.checkExp("+.5e3", "5E2");
        this.checkExp("-.5E3", "-5E2");
        this.checkExp(".5e-32", "5E-33");
        this.checkExp("3. + 2", "(3 + 2)");
        this.checkExp("1++2+3", "((1 + 2) + 3)");
        this.checkExp("1- -2", "(1 - -2)");
        this.checkExp("1++2.3e-4++.5e-6++.7++8", "((((1 + 2.3E-4) + 5E-7) + 0.7) + 8)");
        this.checkExp("1- -2.3e-4 - -.5e-6  -\n-.7++8", "((((1 - -2.3E-4) - -5E-7) - -0.7) + 8)");
        this.checkExp("1+-2.*-3.e-1/-4", "(1 + ((-2 * -3E-1) / -4))");
    }

    @Test
    public void testParseNumberFails() {
        this.checkFails("SELECT 0.5e1^.1^ from t", "(?s).*Encountered .*\\.1.* at line 1.*");
    }

    @Test
    public void testMinusPrefixInExpression() {
        this.checkExp("-(1+2)", "(- (1 + 2))");
    }

    @Test
    public void testPrecedence0() {
        this.checkExp("1 + 2 * 3 * 4 + 5", "((1 + ((2 * 3) * 4)) + 5)");
    }

    @Test
    public void testPrecedence1() {
        this.checkExp("1 + 2 * (3 * (4 + 5))", "(1 + (2 * (3 * (4 + 5))))");
    }

    @Test
    public void testPrecedence2() {
        this.checkExp("- - 1", "(- -1)");
    }

    @Test
    public void testPrecedence3() {
        this.checkExp("- 1 is null", "(-1 IS NULL)");
    }

    @Test
    public void testPrecedence4() {
        this.checkExp("1 - -2", "(1 - -2)");
    }

    @Test
    public void testPrecedence5() {
        this.checkExp("1++2", "(1 + 2)");
        this.checkExp("1+ +2", "(1 + 2)");
    }

    @Test
    public void testPrecedenceSetOps() {
        this.check("select * from a union select * from b intersect select * from c intersect select * from d except select * from e except select * from f union select * from g", "((((SELECT *\nFROM `A`\nUNION\n((SELECT *\nFROM `B`\nINTERSECT\nSELECT *\nFROM `C`)\nINTERSECT\nSELECT *\nFROM `D`))\nEXCEPT\nSELECT *\nFROM `E`)\nEXCEPT\nSELECT *\nFROM `F`)\nUNION\nSELECT *\nFROM `G`)");
    }

    @Test
    public void testQueryInFrom() {
        this.check("select * from (select * from emp) as e join (select * from dept) d", "SELECT *\nFROM (SELECT *\nFROM `EMP`) AS `E`\nINNER JOIN (SELECT *\nFROM `DEPT`) AS `D`");
    }

    @Test
    public void testQuotesInString() {
        this.checkExp("'a''b'", "'a''b'");
        this.checkExp("'''x'", "'''x'");
        this.checkExp("''", "''");
        this.checkExp("'Quoted strings aren''t \"hard\"'", "'Quoted strings aren''t \"hard\"'");
    }

    @Test
    public void testScalarQueryInWhere() {
        this.check("select * from emp where 3 = (select count(*) from dept where dept.deptno = emp.deptno)", "SELECT *\nFROM `EMP`\nWHERE (3 = (SELECT COUNT(*)\nFROM `DEPT`\nWHERE (`DEPT`.`DEPTNO` = `EMP`.`DEPTNO`)))");
    }

    @Test
    public void testScalarQueryInSelect() {
        this.check("select x, (select count(*) from dept where dept.deptno = emp.deptno) from emp", "SELECT `X`, (SELECT COUNT(*)\nFROM `DEPT`\nWHERE (`DEPT`.`DEPTNO` = `EMP`.`DEPTNO`))\nFROM `EMP`");
    }

    @Test
    public void testSelectList() {
        this.check("select * from emp, dept", "SELECT *\nFROM `EMP`,\n`DEPT`");
    }

    @Test
    public void testSelectList3() {
        this.check("select 1, emp.*, 2 from emp", "SELECT 1, `EMP`.*, 2\nFROM `EMP`");
    }

    @Test
    public void testSelectList4() {
        this.checkFails("select ^from^ emp", "(?s).*Encountered \"from\" at line .*");
    }

    @Test
    public void testStar() {
        this.check("select * from emp", "SELECT *\nFROM `EMP`");
    }

    @Test
    public void testSelectDistinct() {
        this.check("select distinct foo from bar", "SELECT DISTINCT `FOO`\nFROM `BAR`");
    }

    @Test
    public void testSelectAll() {
        this.check("select * from (select all foo from bar) as xyz", "SELECT *\nFROM (SELECT ALL `FOO`\nFROM `BAR`) AS `XYZ`");
    }

    @Test
    public void testWhere() {
        this.check("select * from emp where empno > 5 and gender = 'F'", "SELECT *\nFROM `EMP`\nWHERE ((`EMPNO` > 5) AND (`GENDER` = 'F'))");
    }

    @Test
    public void testNestedSelect() {
        this.check("select * from (select * from emp)", "SELECT *\nFROM (SELECT *\nFROM `EMP`)");
    }

    @Test
    public void testValues() {
        this.check("values(1,'two')", "(VALUES (ROW(1, 'two')))");
    }

    @Test
    public void testValuesExplicitRow() {
        this.check("values row(1,'two')", "(VALUES (ROW(1, 'two')))");
    }

    @Test
    public void testFromValues() {
        this.check("select * from (values(1,'two'), 3, (4, 'five'))", "SELECT *\nFROM (VALUES (ROW(1, 'two')), (ROW(3)), (ROW(4, 'five')))");
    }

    @Test
    public void testFromValuesWithoutParens() {
        this.checkFails("select 1 from ^values^('x')", "Encountered \"values\" at line 1, column 15\\.\nWas expecting one of:\n    <IDENTIFIER> \\.\\.\\.\n    <QUOTED_IDENTIFIER> \\.\\.\\.\n    <BACK_QUOTED_IDENTIFIER> \\.\\.\\.\n    <BRACKET_QUOTED_IDENTIFIER> \\.\\.\\.\n    <UNICODE_QUOTED_IDENTIFIER> \\.\\.\\.\n    \"LATERAL\" \\.\\.\\.\n    \"\\(\" \\.\\.\\.\n    \"UNNEST\" \\.\\.\\.\n    \"TABLE\" \\.\\.\\.\n    ");
    }

    @Test
    public void testEmptyValues() {
        this.checkFails("select * from (values^(^))", "(?s).*Encountered \"\\( \\)\" at .*");
    }

    @Test
    public void testExplicitTable() {
        this.check("table emp", "(TABLE `EMP`)");
        this.checkFails("^table^ 123", "(?s)Encountered \"table 123\" at line 1, column 1\\.\n.*");
    }

    @Test
    public void testExplicitTableOrdered() {
        this.check("table emp order by name", "(TABLE `EMP`)\nORDER BY `NAME`");
    }

    @Test
    public void testSelectFromExplicitTable() {
        this.check("select * from (table emp)", "SELECT *\nFROM (TABLE `EMP`)");
    }

    @Test
    public void testSelectFromBareExplicitTableFails() {
        this.checkFails("select * from ^table^ emp", "(?s).*Encountered \"table emp\" at .*");
        this.checkFails("select * from (^table^ (select empno from emp))", "(?s)Encountered \"table \\(\".*");
    }

    @Test
    public void testCollectionTable() {
        this.check("select * from table(ramp(3, 4))", "SELECT *\nFROM TABLE(`RAMP`(3, 4))");
    }

    @Test
    public void testCollectionTableWithCursorParam() {
        this.check("select * from table(dedup(cursor(select * from emps),'name'))", "SELECT *\nFROM TABLE(`DEDUP`((CURSOR ((SELECT *\nFROM `EMPS`))), 'name'))");
    }

    @Test
    public void testCollectionTableWithColumnListParam() {
        this.check("select * from table(dedup(cursor(select * from emps),row(empno, name)))", "SELECT *\nFROM TABLE(`DEDUP`((CURSOR ((SELECT *\nFROM `EMPS`))), (ROW(`EMPNO`, `NAME`))))");
    }

    @Test
    public void testIllegalCursors() {
        this.checkFails("select ^cursor^(select * from emps) from emps", "CURSOR expression encountered in illegal context");
        this.checkFails("call p(^cursor^(select * from emps))", "CURSOR expression encountered in illegal context");
        this.checkFails("select f(^cursor^(select * from emps)) from emps", "CURSOR expression encountered in illegal context");
    }

    @Test
    public void testExplain() {
        this.check("explain plan for select * from emps", "EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION FOR\nSELECT *\nFROM `EMPS`");
    }

    @Test
    public void testExplainWithImpl() {
        this.check("explain plan with implementation for select * from emps", "EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION FOR\nSELECT *\nFROM `EMPS`");
    }

    @Test
    public void testExplainWithoutImpl() {
        this.check("explain plan without implementation for select * from emps", "EXPLAIN PLAN INCLUDING ATTRIBUTES WITHOUT IMPLEMENTATION FOR\nSELECT *\nFROM `EMPS`");
    }

    @Test
    public void testExplainWithType() {
        this.check("explain plan with type for (values (true))", "EXPLAIN PLAN INCLUDING ATTRIBUTES WITH TYPE FOR\n(VALUES (ROW(TRUE)))");
    }

    @Test
    public void testInsertSelect() {
        this.check("insert into emps select * from emps", "INSERT INTO `EMPS`\n(SELECT *\nFROM `EMPS`)");
    }

    @Test
    public void testInsertUnion() {
        this.check("insert into emps select * from emps1 union select * from emps2", "INSERT INTO `EMPS`\n(SELECT *\nFROM `EMPS1`\nUNION\nSELECT *\nFROM `EMPS2`)");
    }

    @Test
    public void testInsertValues() {
        this.check("insert into emps values (1,'Fredkin')", "INSERT INTO `EMPS`\n(VALUES (ROW(1, 'Fredkin')))");
    }

    @Test
    public void testInsertColumnList() {
        this.check("insert into emps(x,y) select * from emps", "INSERT INTO `EMPS` (`X`, `Y`)\n(SELECT *\nFROM `EMPS`)");
    }

    @Test
    public void testExplainInsert() {
        this.check("explain plan for insert into emps1 select * from emps2", "EXPLAIN PLAN INCLUDING ATTRIBUTES WITH IMPLEMENTATION FOR\nINSERT INTO `EMPS1`\n(SELECT *\nFROM `EMPS2`)");
    }

    @Test
    public void testDelete() {
        this.check("delete from emps", "DELETE FROM `EMPS`");
    }

    @Test
    public void testDeleteWhere() {
        this.check("delete from emps where empno=12", "DELETE FROM `EMPS`\nWHERE (`EMPNO` = 12)");
    }

    @Test
    public void testMergeSelectSource() {
        this.check("merge into emps e using (select * from tempemps where deptno is null) t on e.empno = t.empno when matched then update set name = t.name, deptno = t.deptno, salary = t.salary * .1 when not matched then insert (name, dept, salary) values(t.name, 10, t.salary * .15)", "MERGE INTO `EMPS` AS `E`\nUSING (SELECT *\nFROM `TEMPEMPS`\nWHERE (`DEPTNO` IS NULL)) AS `T`\nON (`E`.`EMPNO` = `T`.`EMPNO`)\nWHEN MATCHED THEN UPDATE SET `NAME` = `T`.`NAME`\n, `DEPTNO` = `T`.`DEPTNO`\n, `SALARY` = (`T`.`SALARY` * 0.1)\nWHEN NOT MATCHED THEN INSERT (`NAME`, `DEPT`, `SALARY`) (VALUES (ROW(`T`.`NAME`, 10, (`T`.`SALARY` * 0.15))))");
    }

    @Test
    public void testMergeTableRefSource() {
        this.check("merge into emps e using tempemps as t on e.empno = t.empno when matched then update set name = t.name, deptno = t.deptno, salary = t.salary * .1 when not matched then insert (name, dept, salary) values(t.name, 10, t.salary * .15)", "MERGE INTO `EMPS` AS `E`\nUSING `TEMPEMPS` AS `T`\nON (`E`.`EMPNO` = `T`.`EMPNO`)\nWHEN MATCHED THEN UPDATE SET `NAME` = `T`.`NAME`\n, `DEPTNO` = `T`.`DEPTNO`\n, `SALARY` = (`T`.`SALARY` * 0.1)\nWHEN NOT MATCHED THEN INSERT (`NAME`, `DEPT`, `SALARY`) (VALUES (ROW(`T`.`NAME`, 10, (`T`.`SALARY` * 0.15))))");
    }

    @Test
    public void testBitStringNotImplemented() {
        this.checkFails("select B^'1011'^ || 'foobar' from (values (true))", "(?s).*Encountered \"\\\\'1011\\\\'\" at line 1, column 9.*");
    }

    @Test
    public void testHexAndBinaryString() {
        this.checkExp("x''=X'2'", "(X'' = X'2')");
        this.checkExp("x'fffff'=X''", "(X'FFFFF' = X'')");
        this.checkExp("x'1' \t\t\f\r \n'2'--hi this is a comment'FF'\r\r\t\f \n'34'", "X'1'\n'2'\n'34'");
        this.checkExp("x'1' \t\t\f\r \n'000'--\n'01'", "X'1'\n'000'\n'01'");
        this.checkExp("x'1234567890abcdef'=X'fFeEdDcCbBaA'", "(X'1234567890ABCDEF' = X'FFEEDDCCBBAA')");
        this.checkExp("x'001'=X'000102'", "(X'001' = X'000102')");
    }

    @Test
    public void testHexAndBinaryStringFails() {
        this.checkFails("select ^x'FeedGoats'^ from t", "Binary literal string must contain only characters '0' - '9', 'A' - 'F'");
        this.checkFails("select ^x'abcdefG'^ from t", "Binary literal string must contain only characters '0' - '9', 'A' - 'F'");
        this.checkFails("select x'1' ^x'2'^ from t", "(?s).*Encountered .x.*2.* at line 1, column 13.*");
        this.check("select x'1' '2' from t", "SELECT X'1'\n'2'\nFROM `T`");
    }

    @Test
    public void testStringLiteral() {
        this.checkExp("_latin1'hi'", "_LATIN1'hi'");
        this.checkExp("N'is it a plane? no it''s superman!'", "_ISO-8859-1'is it a plane? no it''s superman!'");
        this.checkExp("n'lowercase n'", "_ISO-8859-1'lowercase n'");
        this.checkExp("'boring string'", "'boring string'");
        this.checkExp("_iSo-8859-1'bye'", "_ISO-8859-1'bye'");
        this.checkExp("'three' \n ' blind'\n' mice'", "'three'\n' blind'\n' mice'");
        this.checkExp("'three' -- comment \n ' blind'\n' mice'", "'three'\n' blind'\n' mice'");
        this.checkExp("N'bye' \t\r\f\f\n' bye'", "_ISO-8859-1'bye'\n' bye'");
        this.checkExp("_iso-8859-1'bye' \n\n--\n-- this is a comment\n' bye'", "_ISO-8859-1'bye'\n' bye'");
        this.checkExp("'foo\rbar'", "'foo\rbar'");
        this.checkExp("'foo\nbar'", "'foo\nbar'");
        boolean[] linuxify = LINUXIFY.get();
        try {
            linuxify[0] = false;
            this.checkExp("'foo\r\nbar'", "'foo\r\nbar'");
        }
        finally {
            linuxify[0] = true;
        }
    }

    @Test
    public void testStringLiteralFails() {
        this.checkFails("select N ^'space'^", "(?s).*Encountered .*space.* at line 1, column ...*");
        this.checkFails("select _latin1 \n^'newline'^", "(?s).*Encountered.*newline.* at line 2, column ...*");
        this.checkFails("select ^_unknown-charset''^ from (values(true))", "Unknown character set 'unknown-charset'");
        this.check("select N'1' '2' from t", "SELECT _ISO-8859-1'1'\n'2'\nFROM `T`");
    }

    @Test
    public void testStringLiteralChain() {
        String fooBar = "'foo'\n'bar'";
        String fooBarBaz = "'foo'\n'bar'\n'baz'";
        this.checkExp("   'foo'\r'bar'", "'foo'\n'bar'");
        this.checkExp("   'foo'\r\n'bar'", "'foo'\n'bar'");
        this.checkExp("   'foo'\r\n\r\n'bar'  \n   'baz'", "'foo'\n'bar'\n'baz'");
        this.checkExp("   'foo' /* a comment */ 'bar'", "'foo'\n'bar'");
        this.checkExp("   'foo' -- a comment\r\n 'bar'", "'foo'\n'bar'");
        this.checkExp("   'foo' 'bar'", "'foo'\n'bar'");
    }

    @Test
    public void testCaseExpression() {
        this.checkExp("case \t col1 when 1 then 'one' end", "(CASE WHEN (`COL1` = 1) THEN 'one' ELSE NULL END)");
        this.checkExp("case when nbr is false then 'one' end", "(CASE WHEN (`NBR` IS FALSE) THEN 'one' ELSE NULL END)");
        this.checkExp("case col1 when \n1.2 then 'one' when 2 then 'two' else 'three' end", "(CASE WHEN (`COL1` = 1.2) THEN 'one' WHEN (`COL1` = 2) THEN 'two' ELSE 'three' END)");
        this.checkExp("case (select * from emp) when 1 then 2 end", "(CASE WHEN ((SELECT *\nFROM `EMP`) = 1) THEN 2 ELSE NULL END)");
        this.checkExp("case 1 when (select * from emp) then 2 end", "(CASE WHEN (1 = (SELECT *\nFROM `EMP`)) THEN 2 ELSE NULL END)");
        this.checkExp("case 1 when 2 then (select * from emp) end", "(CASE WHEN (1 = 2) THEN (SELECT *\nFROM `EMP`) ELSE NULL END)");
        this.checkExp("case 1 when 2 then 3 else (select * from emp) end", "(CASE WHEN (1 = 2) THEN 3 ELSE (SELECT *\nFROM `EMP`) END)");
        this.checkExp("case x when 2, 4 then 3 else 4 end", "(CASE WHEN (`X` IN (2, 4)) THEN 3 ELSE 4 END)");
        this.checkFails("case x when 2, 4 then 3 ^when^ then 5 else 4 end", "(?s)Encountered \"when then\" at .*");
        this.checkFails("case when b1, b2 ^when^ 2, 4 then 3 else 4 end", "(?s)Encountered \"when\" at .*");
    }

    @Test
    public void testCaseExpressionFails() {
        this.checkFails("select case col1 when 1 then 'one' ^from^ t", "(?s).*from.*");
        this.checkFails("select case col1 ^when1^ then 'one' end from t", "(?s).*when1.*");
    }

    @Test
    public void testNullIf() {
        this.checkExp("nullif(v1,v2)", "NULLIF(`V1`, `V2`)");
        this.checkExpFails("1 ^+^ nullif + 3", "(?s)Encountered \"\\+ nullif \\+\" at line 1, column 3.*");
    }

    @Test
    public void testCoalesce() {
        this.checkExp("coalesce(v1)", "COALESCE(`V1`)");
        this.checkExp("coalesce(v1,v2)", "COALESCE(`V1`, `V2`)");
        this.checkExp("coalesce(v1,v2,v3)", "COALESCE(`V1`, `V2`, `V3`)");
    }

    @Test
    public void testLiteralCollate() {
    }

    @Test
    public void testCharLength() {
        this.checkExp("char_length('string')", "CHAR_LENGTH('string')");
        this.checkExp("character_length('string')", "CHARACTER_LENGTH('string')");
    }

    @Test
    public void testPosition() {
        this.checkExp("posiTion('mouse' in 'house')", "POSITION('mouse' IN 'house')");
    }

    @Test
    public void testTimeDate() {
        this.checkExp("CURRENT_TIME(3)", "CURRENT_TIME(3)");
        this.checkExp("CURRENT_TIME", "`CURRENT_TIME`");
        this.checkExp("CURRENT_TIME(x+y)", "CURRENT_TIME((`X` + `Y`))");
        this.checkExp("LOCALTIME(3)", "LOCALTIME(3)");
        this.checkExp("LOCALTIME", "`LOCALTIME`");
        this.checkExp("LOCALTIME(x+y)", "LOCALTIME((`X` + `Y`))");
        this.checkExp("LOCALTIMESTAMP(3)", "LOCALTIMESTAMP(3)");
        this.checkExp("LOCALTIMESTAMP", "`LOCALTIMESTAMP`");
        this.checkExp("LOCALTIMESTAMP(x+y)", "LOCALTIMESTAMP((`X` + `Y`))");
        this.checkExp("CURRENT_DATE(3)", "CURRENT_DATE(3)");
        this.checkExp("CURRENT_DATE", "`CURRENT_DATE`");
        this.checkExp("CURRENT_TIMESTAMP(3)", "CURRENT_TIMESTAMP(3)");
        this.checkExp("CURRENT_TIMESTAMP", "`CURRENT_TIMESTAMP`");
        this.checkExp("CURRENT_TIMESTAMP(x+y)", "CURRENT_TIMESTAMP((`X` + `Y`))");
        this.checkExp("DATE '2004-12-01'", "DATE '2004-12-01'");
        this.checkExp("TIME '12:01:01'", "TIME '12:01:01'");
        this.checkExp("TIME '12:01:01.'", "TIME '12:01:01'");
        this.checkExp("TIME '12:01:01.000'", "TIME '12:01:01.000'");
        this.checkExp("TIME '12:01:01.001'", "TIME '12:01:01.001'");
        this.checkExp("TIMESTAMP '2004-12-01 12:01:01'", "TIMESTAMP '2004-12-01 12:01:01'");
        this.checkExp("TIMESTAMP '2004-12-01 12:01:01.1'", "TIMESTAMP '2004-12-01 12:01:01.1'");
        this.checkExp("TIMESTAMP '2004-12-01 12:01:01.'", "TIMESTAMP '2004-12-01 12:01:01'");
        this.checkExpSame("TIMESTAMP '2004-12-01 12:01:01.1'");
        this.checkFails("^DATE '12/21/99'^", "(?s).*Illegal DATE literal.*");
        this.checkFails("^TIME '1230:33'^", "(?s).*Illegal TIME literal.*");
        this.checkFails("^TIME '12:00:00 PM'^", "(?s).*Illegal TIME literal.*");
        this.checkFails("^TIMESTAMP '12-21-99, 12:30:00'^", "(?s).*Illegal TIMESTAMP literal.*");
    }

    @Test
    public void testDateTimeCast() {
        this.checkExp("CAST('2001-12-21' AS DATE)", "CAST('2001-12-21' AS DATE)");
        this.checkExp("CAST(12 AS DATE)", "CAST(12 AS DATE)");
        this.checkFails("CAST('2000-12-21' AS DATE ^NOT^ NULL)", "(?s).*Encountered \"NOT\" at line 1, column 27.*");
        this.checkFails("CAST('foo' as ^1^)", "(?s).*Encountered \"1\" at line 1, column 15.*");
        this.checkExp("Cast(DATE '2004-12-21' AS VARCHAR(10))", "CAST(DATE '2004-12-21' AS VARCHAR(10))");
    }

    @Test
    public void testTrim() {
        this.checkExp("trim('mustache' FROM 'beard')", "TRIM(BOTH 'mustache' FROM 'beard')");
        this.checkExp("trim('mustache')", "TRIM(BOTH ' ' FROM 'mustache')");
        this.checkExp("trim(TRAILING FROM 'mustache')", "TRIM(TRAILING ' ' FROM 'mustache')");
        this.checkExp("trim(bOth 'mustache' FROM 'beard')", "TRIM(BOTH 'mustache' FROM 'beard')");
        this.checkExp("trim( lEaDing       'mustache' FROM 'beard')", "TRIM(LEADING 'mustache' FROM 'beard')");
        this.checkExp("trim(\r\n\ttrailing\n  'mustache' FROM 'beard')", "TRIM(TRAILING 'mustache' FROM 'beard')");
        this.checkExp("trim (coalesce(cast(null as varchar(2)))||' '||coalesce('junk ',''))", "TRIM(BOTH ' ' FROM ((COALESCE(CAST(NULL AS VARCHAR(2))) || ' ') || COALESCE('junk ', '')))");
        this.checkFails("trim(^from^ 'beard')", "(?s).*'FROM' without operands preceding it is illegal.*");
    }

    @Test
    public void testConvertAndTranslate() {
        this.checkExp("convert('abc' using conversion)", "CONVERT('abc' USING `CONVERSION`)");
        this.checkExp("translate('abc' using lazy_translation)", "TRANSLATE('abc' USING `LAZY_TRANSLATION`)");
    }

    @Test
    public void testOverlay() {
        this.checkExp("overlay('ABCdef' placing 'abc' from 1)", "OVERLAY('ABCdef' PLACING 'abc' FROM 1)");
        this.checkExp("overlay('ABCdef' placing 'abc' from 1 for 3)", "OVERLAY('ABCdef' PLACING 'abc' FROM 1 FOR 3)");
    }

    @Test
    public void testJdbcFunctionCall() {
        this.checkExp("{fn apa(1,'1')}", "{fn APA(1, '1') }");
        this.checkExp("{ Fn apa(log10(ln(1))+2)}", "{fn APA((LOG10(LN(1)) + 2)) }");
        this.checkExp("{fN apa(*)}", "{fn APA(*) }");
        this.checkExp("{   FN\t\r\n apa()}", "{fn APA() }");
        this.checkExp("{fn insert()}", "{fn INSERT() }");
    }

    @Test
    public void testWindowReference() {
        this.checkExp("sum(sal) over (w)", "(SUM(`SAL`) OVER (`W`))");
        this.checkExpFails("sum(sal) over (w ^w1^ partition by deptno)", "(?s)Encountered \"w1\" at.*");
    }

    @Test
    public void testWindowInSubquery() {
        this.check("select * from ( select sum(x) over w, sum(y) over w from s window w as (range interval '1' minute preceding))", "SELECT *\nFROM (SELECT (SUM(`X`) OVER `W`), (SUM(`Y`) OVER `W`)\nFROM `S`\nWINDOW `W` AS (RANGE INTERVAL '1' MINUTE PRECEDING))");
    }

    @Test
    public void testWindowSpec() {
        this.check("select count(z) over w as foo from Bids window w as (partition by y + yy, yyy order by x rows between 2 preceding and 2 following)", "SELECT (COUNT(`Z`) OVER `W`) AS `FOO`\nFROM `BIDS`\nWINDOW `W` AS (PARTITION BY (`Y` + `YY`), `YYY` ORDER BY `X` ROWS BETWEEN 2 PRECEDING AND 2 FOLLOWING)");
        this.check("select count(*) over w from emp window w as (rows 2 preceding)", "SELECT (COUNT(*) OVER `W`)\nFROM `EMP`\nWINDOW `W` AS (ROWS 2 PRECEDING)");
        this.check("select count(*) over w from emp window w as (\n  rows 'foo' 'bar'\n       'baz' preceding)", "SELECT (COUNT(*) OVER `W`)\nFROM `EMP`\nWINDOW `W` AS (ROWS 'foobarbaz' PRECEDING)");
        this.checkFails("select count(z) over w as foo \nfrom Bids window w as (partition by y order by x ^partition^ by y)", "(?s).*Encountered \"partition\".*");
        this.checkFails("select count(z) over w as foo from Bids window w as (order by x ^partition^ by y)", "(?s).*Encountered \"partition\".*");
        this.checkFails("select sum(a) over (partition by ^(^select 1 from t), x) from t2", "Query expression encountered in illegal context");
        this.checkFails("select sum(x) over (order by x range between unbounded preceding ^unbounded^ following)", "(?s).*Encountered \"unbounded\".*");
        this.checkFails("select sum(x) ^over^ window (order by x) from bids", "(?s).*Encountered \"over window\".*");
        this.checkFails("select sum(x) over (rows 2 preceding ^order^ by x) from emp", "(?s).*Encountered \"order\".*");
    }

    @Test
    public void testWindowSpecPartial() {
        this.check("select sum(x) over (order by x allow partial) from bids", "SELECT (SUM(`X`) OVER (ORDER BY `X`))\nFROM `BIDS`");
        this.check("select sum(x) over (order by x) from bids", "SELECT (SUM(`X`) OVER (ORDER BY `X`))\nFROM `BIDS`");
        this.check("select sum(x) over (order by x disallow partial) from bids", "SELECT (SUM(`X`) OVER (ORDER BY `X` DISALLOW PARTIAL))\nFROM `BIDS`");
        this.check("select sum(x) over (order by x) from bids", "SELECT (SUM(`X`) OVER (ORDER BY `X`))\nFROM `BIDS`");
    }

    @Test
    public void testAs() {
        this.check("select x y from t", "SELECT `X` AS `Y`\nFROM `T`");
        this.check("select x AS y from t", "SELECT `X` AS `Y`\nFROM `T`");
        this.check("select sum(x) y from t group by z", "SELECT SUM(`X`) AS `Y`\nFROM `T`\nGROUP BY `Z`");
        this.check("select count(z) over w foo from Bids window w as (order by x)", "SELECT (COUNT(`Z`) OVER `W`) AS `FOO`\nFROM `BIDS`\nWINDOW `W` AS (ORDER BY `X`)");
        String expected = "SELECT `X`\nFROM `T` AS `T1`";
        this.check("select x from t as t1", "SELECT `X`\nFROM `T` AS `T1`");
        this.check("select x from t t1", "SELECT `X`\nFROM `T` AS `T1`");
        this.checkFails("select sum(x) over w from bids window w ^(order by x)", "(?s).*Encountered \"\\(\".*");
        this.checkFails("select count(*) as foo ^over^ w from Bids window w (order by x)", "(?s).*Encountered \"over\".*");
    }

    @Test
    public void testAsAliases() {
        this.check("select x from t as t1 (a, b) where foo", "SELECT `X`\nFROM `T` AS `T1` (`A`, `B`)\nWHERE `FOO`");
        this.check("select x from (values (1, 2), (3, 4)) as t1 (\"a\", b) where \"a\" > b", "SELECT `X`\nFROM (VALUES (ROW(1, 2)), (ROW(3, 4))) AS `T1` (`a`, `B`)\nWHERE (`a` > `B`)");
        this.checkFails("select x from (values (1, 2), (3, 4)) as t1 ^(^)", "(?s).*Encountered \"\\( \\)\" at .*");
        this.checkFails("select x from t as t1 (x ^+^ y)", "(?s).*Was expecting one of:\n    \"\\)\" \\.\\.\\.\n    \",\" \\.\\.\\..*");
        this.checkFails("select x from t as t1 (x^.^y)", "(?s).*Was expecting one of:\n    \"\\)\" \\.\\.\\.\n    \",\" \\.\\.\\..*");
    }

    @Test
    public void testOver() {
        this.checkExp("sum(sal) over ()", "(SUM(`SAL`) OVER ())");
        this.checkExp("sum(sal) over (partition by x, y)", "(SUM(`SAL`) OVER (PARTITION BY `X`, `Y`))");
        this.checkExp("sum(sal) over (order by x desc, y asc)", "(SUM(`SAL`) OVER (ORDER BY `X` DESC, `Y`))");
        this.checkExp("sum(sal) over (rows 5 preceding)", "(SUM(`SAL`) OVER (ROWS 5 PRECEDING))");
        this.checkExp("sum(sal) over (range between interval '1' second preceding and interval '1' second following)", "(SUM(`SAL`) OVER (RANGE BETWEEN INTERVAL '1' SECOND PRECEDING AND INTERVAL '1' SECOND FOLLOWING))");
        this.checkExp("sum(sal) over (range between interval '1:03' hour preceding and interval '2' minute following)", "(SUM(`SAL`) OVER (RANGE BETWEEN INTERVAL '1:03' HOUR PRECEDING AND INTERVAL '2' MINUTE FOLLOWING))");
        this.checkExp("sum(sal) over (range between interval '5' day preceding and current row)", "(SUM(`SAL`) OVER (RANGE BETWEEN INTERVAL '5' DAY PRECEDING AND CURRENT ROW))");
        this.checkExp("sum(sal) over (range interval '5' day preceding)", "(SUM(`SAL`) OVER (RANGE INTERVAL '5' DAY PRECEDING))");
        this.checkExp("sum(sal) over (range between unbounded preceding and current row)", "(SUM(`SAL`) OVER (RANGE BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW))");
        this.checkExp("sum(sal) over (range unbounded preceding)", "(SUM(`SAL`) OVER (RANGE UNBOUNDED PRECEDING))");
        this.checkExp("sum(sal) over (range between current row and unbounded preceding)", "(SUM(`SAL`) OVER (RANGE BETWEEN CURRENT ROW AND UNBOUNDED PRECEDING))");
        this.checkExp("sum(sal) over (range between current row and unbounded following)", "(SUM(`SAL`) OVER (RANGE BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING))");
        this.checkExp("sum(sal) over (range between 6 preceding and interval '1:03' hour preceding)", "(SUM(`SAL`) OVER (RANGE BETWEEN 6 PRECEDING AND INTERVAL '1:03' HOUR PRECEDING))");
        this.checkExp("sum(sal) over (range between interval '1' second following and interval '5' day following)", "(SUM(`SAL`) OVER (RANGE BETWEEN INTERVAL '1' SECOND FOLLOWING AND INTERVAL '5' DAY FOLLOWING))");
    }

    @Test
    public void testElementFunc() {
        this.checkExp("element(a)", "ELEMENT(`A`)");
    }

    @Test
    public void testCardinalityFunc() {
        this.checkExp("cardinality(a)", "CARDINALITY(`A`)");
    }

    @Test
    public void testMemberOf() {
        this.checkExp("a member of b", "(`A` MEMBER OF `B`)");
        this.checkExp("a member of multiset[b]", "(`A` MEMBER OF (MULTISET[`B`]))");
    }

    @Test
    public void testSubMultisetrOf() {
        this.checkExp("a submultiset of b", "(`A` SUBMULTISET OF `B`)");
    }

    @Test
    public void testIsASet() {
        this.checkExp("b is a set", "(`B` IS A SET)");
        this.checkExp("a is a set", "(`A` IS A SET)");
    }

    @Test
    public void testMultiset() {
        this.checkExp("multiset[1]", "(MULTISET[1])");
        this.checkExp("multiset[1,2.3]", "(MULTISET[1, 2.3])");
        this.checkExp("multiset[1,    '2']", "(MULTISET[1, '2'])");
        this.checkExp("multiset[ROW(1,2)]", "(MULTISET[(ROW(1, 2))])");
        this.checkExp("multiset[ROW(1,2),ROW(3,4)]", "(MULTISET[(ROW(1, 2)), (ROW(3, 4))])");
        this.checkExp("multiset(select*from T)", "(MULTISET ((SELECT *\nFROM `T`)))");
    }

    @Test
    public void testMultisetUnion() {
        this.checkExp("a multiset union b", "(`A` MULTISET UNION `B`)");
        this.checkExp("a multiset union all b", "(`A` MULTISET UNION ALL `B`)");
        this.checkExp("a multiset union distinct b", "(`A` MULTISET UNION `B`)");
    }

    @Test
    public void testMultisetExcept() {
        this.checkExp("a multiset EXCEPT b", "(`A` MULTISET EXCEPT `B`)");
        this.checkExp("a multiset EXCEPT all b", "(`A` MULTISET EXCEPT ALL `B`)");
        this.checkExp("a multiset EXCEPT distinct b", "(`A` MULTISET EXCEPT `B`)");
    }

    @Test
    public void testMultisetIntersect() {
        this.checkExp("a multiset INTERSECT b", "(`A` MULTISET INTERSECT `B`)");
        this.checkExp("a multiset INTERSECT all b", "(`A` MULTISET INTERSECT ALL `B`)");
        this.checkExp("a multiset INTERSECT distinct b", "(`A` MULTISET INTERSECT `B`)");
    }

    @Test
    public void testMultisetMixed() {
        this.checkExp("multiset[1] MULTISET union b", "((MULTISET[1]) MULTISET UNION `B`)");
        this.checkExp("a MULTISET union b multiset intersect c multiset except d multiset union e", "(((`A` MULTISET UNION (`B` MULTISET INTERSECT `C`)) MULTISET EXCEPT `D`) MULTISET UNION `E`)");
    }

    @Test
    public void testMapItem() {
        this.checkExp("a['foo']", "`A`['foo']");
        this.checkExp("a['x' || 'y']", "`A`[('x' || 'y')]");
        this.checkExp("a['foo'] ['bar']", "`A`['foo']['bar']");
        this.checkExp("a['foo']['bar']", "`A`['foo']['bar']");
    }

    @Test
    public void testMapItemPrecedence() {
        this.checkExp("1 + a['foo'] * 3", "(1 + (`A`['foo'] * 3))");
        this.checkExp("1 * a['foo'] + 3", "((1 * `A`['foo']) + 3)");
        this.checkExp("a['foo']['bar']", "`A`['foo']['bar']");
        this.checkExp("a[b['foo' || 'bar']]", "`A`[`B`[('foo' || 'bar')]]");
    }

    @Test
    public void testArrayElement() {
        this.checkExp("a[1]", "`A`[1]");
        this.checkExp("a[b[1]]", "`A`[`B`[1]]");
        this.checkExp("a[b[1 + 2] + 3]", "`A`[(`B`[(1 + 2)] + 3)]");
    }

    @Test
    public void testArrayValueConstructor() {
        this.checkExp("array[1, 2]", "(ARRAY[1, 2])");
        this.checkExp("array [1, 2]", "(ARRAY[1, 2])");
        this.checkExp("array[]", "(ARRAY[])");
        this.checkExp("array[(1, 'a'), (2, 'b')]", "(ARRAY[(ROW(1, 'a')), (ROW(2, 'b'))])");
    }

    @Test
    public void testMapValueConstructor() {
        this.checkExp("map[1, 'x', 2, 'y']", "(MAP[1, 'x', 2, 'y'])");
        this.checkExp("map [1, 'x', 2, 'y']", "(MAP[1, 'x', 2, 'y'])");
        this.checkExp("map[]", "(MAP[])");
    }

    public void subTestIntervalYearPositive() {
        this.checkExp("interval '1' year", "INTERVAL '1' YEAR");
        this.checkExp("interval '99' year", "INTERVAL '99' YEAR");
        this.checkExp("interval '1' year(2)", "INTERVAL '1' YEAR(2)");
        this.checkExp("interval '99' year(2)", "INTERVAL '99' YEAR(2)");
        this.checkExp("interval '2147483647' year(10)", "INTERVAL '2147483647' YEAR(10)");
        this.checkExp("interval '0' year(1)", "INTERVAL '0' YEAR(1)");
        this.checkExp("interval '1234' year(4)", "INTERVAL '1234' YEAR(4)");
        this.checkExp("interval '+1' year", "INTERVAL '+1' YEAR");
        this.checkExp("interval '-1' year", "INTERVAL '-1' YEAR");
        this.checkExp("interval +'1' year", "INTERVAL '1' YEAR");
        this.checkExp("interval +'+1' year", "INTERVAL '+1' YEAR");
        this.checkExp("interval +'-1' year", "INTERVAL '-1' YEAR");
        this.checkExp("interval -'1' year", "INTERVAL -'1' YEAR");
        this.checkExp("interval -'+1' year", "INTERVAL -'+1' YEAR");
        this.checkExp("interval -'-1' year", "INTERVAL -'-1' YEAR");
    }

    public void subTestIntervalYearToMonthPositive() {
        this.checkExp("interval '1-2' year to month", "INTERVAL '1-2' YEAR TO MONTH");
        this.checkExp("interval '99-11' year to month", "INTERVAL '99-11' YEAR TO MONTH");
        this.checkExp("interval '99-0' year to month", "INTERVAL '99-0' YEAR TO MONTH");
        this.checkExp("interval '1-2' year(2) to month", "INTERVAL '1-2' YEAR(2) TO MONTH");
        this.checkExp("interval '99-11' year(2) to month", "INTERVAL '99-11' YEAR(2) TO MONTH");
        this.checkExp("interval '99-0' year(2) to month", "INTERVAL '99-0' YEAR(2) TO MONTH");
        this.checkExp("interval '2147483647-11' year(10) to month", "INTERVAL '2147483647-11' YEAR(10) TO MONTH");
        this.checkExp("interval '0-0' year(1) to month", "INTERVAL '0-0' YEAR(1) TO MONTH");
        this.checkExp("interval '2006-2' year(4) to month", "INTERVAL '2006-2' YEAR(4) TO MONTH");
        this.checkExp("interval '-1-2' year to month", "INTERVAL '-1-2' YEAR TO MONTH");
        this.checkExp("interval '+1-2' year to month", "INTERVAL '+1-2' YEAR TO MONTH");
        this.checkExp("interval +'1-2' year to month", "INTERVAL '1-2' YEAR TO MONTH");
        this.checkExp("interval +'-1-2' year to month", "INTERVAL '-1-2' YEAR TO MONTH");
        this.checkExp("interval +'+1-2' year to month", "INTERVAL '+1-2' YEAR TO MONTH");
        this.checkExp("interval -'1-2' year to month", "INTERVAL -'1-2' YEAR TO MONTH");
        this.checkExp("interval -'-1-2' year to month", "INTERVAL -'-1-2' YEAR TO MONTH");
        this.checkExp("interval -'+1-2' year to month", "INTERVAL -'+1-2' YEAR TO MONTH");
    }

    public void subTestIntervalMonthPositive() {
        this.checkExp("interval '1' month", "INTERVAL '1' MONTH");
        this.checkExp("interval '99' month", "INTERVAL '99' MONTH");
        this.checkExp("interval '1' month(2)", "INTERVAL '1' MONTH(2)");
        this.checkExp("interval '99' month(2)", "INTERVAL '99' MONTH(2)");
        this.checkExp("interval '2147483647' month(10)", "INTERVAL '2147483647' MONTH(10)");
        this.checkExp("interval '0' month(1)", "INTERVAL '0' MONTH(1)");
        this.checkExp("interval '1234' month(4)", "INTERVAL '1234' MONTH(4)");
        this.checkExp("interval '+1' month", "INTERVAL '+1' MONTH");
        this.checkExp("interval '-1' month", "INTERVAL '-1' MONTH");
        this.checkExp("interval +'1' month", "INTERVAL '1' MONTH");
        this.checkExp("interval +'+1' month", "INTERVAL '+1' MONTH");
        this.checkExp("interval +'-1' month", "INTERVAL '-1' MONTH");
        this.checkExp("interval -'1' month", "INTERVAL -'1' MONTH");
        this.checkExp("interval -'+1' month", "INTERVAL -'+1' MONTH");
        this.checkExp("interval -'-1' month", "INTERVAL -'-1' MONTH");
    }

    public void subTestIntervalDayPositive() {
        this.checkExp("interval '1' day", "INTERVAL '1' DAY");
        this.checkExp("interval '99' day", "INTERVAL '99' DAY");
        this.checkExp("interval '1' day(2)", "INTERVAL '1' DAY(2)");
        this.checkExp("interval '99' day(2)", "INTERVAL '99' DAY(2)");
        this.checkExp("interval '2147483647' day(10)", "INTERVAL '2147483647' DAY(10)");
        this.checkExp("interval '0' day(1)", "INTERVAL '0' DAY(1)");
        this.checkExp("interval '1234' day(4)", "INTERVAL '1234' DAY(4)");
        this.checkExp("interval '+1' day", "INTERVAL '+1' DAY");
        this.checkExp("interval '-1' day", "INTERVAL '-1' DAY");
        this.checkExp("interval +'1' day", "INTERVAL '1' DAY");
        this.checkExp("interval +'+1' day", "INTERVAL '+1' DAY");
        this.checkExp("interval +'-1' day", "INTERVAL '-1' DAY");
        this.checkExp("interval -'1' day", "INTERVAL -'1' DAY");
        this.checkExp("interval -'+1' day", "INTERVAL -'+1' DAY");
        this.checkExp("interval -'-1' day", "INTERVAL -'-1' DAY");
    }

    public void subTestIntervalDayToHourPositive() {
        this.checkExp("interval '1 2' day to hour", "INTERVAL '1 2' DAY TO HOUR");
        this.checkExp("interval '99 23' day to hour", "INTERVAL '99 23' DAY TO HOUR");
        this.checkExp("interval '99 0' day to hour", "INTERVAL '99 0' DAY TO HOUR");
        this.checkExp("interval '1 2' day(2) to hour", "INTERVAL '1 2' DAY(2) TO HOUR");
        this.checkExp("interval '99 23' day(2) to hour", "INTERVAL '99 23' DAY(2) TO HOUR");
        this.checkExp("interval '99 0' day(2) to hour", "INTERVAL '99 0' DAY(2) TO HOUR");
        this.checkExp("interval '2147483647 23' day(10) to hour", "INTERVAL '2147483647 23' DAY(10) TO HOUR");
        this.checkExp("interval '0 0' day(1) to hour", "INTERVAL '0 0' DAY(1) TO HOUR");
        this.checkExp("interval '2345 2' day(4) to hour", "INTERVAL '2345 2' DAY(4) TO HOUR");
        this.checkExp("interval '-1 2' day to hour", "INTERVAL '-1 2' DAY TO HOUR");
        this.checkExp("interval '+1 2' day to hour", "INTERVAL '+1 2' DAY TO HOUR");
        this.checkExp("interval +'1 2' day to hour", "INTERVAL '1 2' DAY TO HOUR");
        this.checkExp("interval +'-1 2' day to hour", "INTERVAL '-1 2' DAY TO HOUR");
        this.checkExp("interval +'+1 2' day to hour", "INTERVAL '+1 2' DAY TO HOUR");
        this.checkExp("interval -'1 2' day to hour", "INTERVAL -'1 2' DAY TO HOUR");
        this.checkExp("interval -'-1 2' day to hour", "INTERVAL -'-1 2' DAY TO HOUR");
        this.checkExp("interval -'+1 2' day to hour", "INTERVAL -'+1 2' DAY TO HOUR");
    }

    public void subTestIntervalDayToMinutePositive() {
        this.checkExp("interval '1 2:3' day to minute", "INTERVAL '1 2:3' DAY TO MINUTE");
        this.checkExp("interval '99 23:59' day to minute", "INTERVAL '99 23:59' DAY TO MINUTE");
        this.checkExp("interval '99 0:0' day to minute", "INTERVAL '99 0:0' DAY TO MINUTE");
        this.checkExp("interval '1 2:3' day(2) to minute", "INTERVAL '1 2:3' DAY(2) TO MINUTE");
        this.checkExp("interval '99 23:59' day(2) to minute", "INTERVAL '99 23:59' DAY(2) TO MINUTE");
        this.checkExp("interval '99 0:0' day(2) to minute", "INTERVAL '99 0:0' DAY(2) TO MINUTE");
        this.checkExp("interval '2147483647 23:59' day(10) to minute", "INTERVAL '2147483647 23:59' DAY(10) TO MINUTE");
        this.checkExp("interval '0 0:0' day(1) to minute", "INTERVAL '0 0:0' DAY(1) TO MINUTE");
        this.checkExp("interval '2345 6:7' day(4) to minute", "INTERVAL '2345 6:7' DAY(4) TO MINUTE");
        this.checkExp("interval '-1 2:3' day to minute", "INTERVAL '-1 2:3' DAY TO MINUTE");
        this.checkExp("interval '+1 2:3' day to minute", "INTERVAL '+1 2:3' DAY TO MINUTE");
        this.checkExp("interval +'1 2:3' day to minute", "INTERVAL '1 2:3' DAY TO MINUTE");
        this.checkExp("interval +'-1 2:3' day to minute", "INTERVAL '-1 2:3' DAY TO MINUTE");
        this.checkExp("interval +'+1 2:3' day to minute", "INTERVAL '+1 2:3' DAY TO MINUTE");
        this.checkExp("interval -'1 2:3' day to minute", "INTERVAL -'1 2:3' DAY TO MINUTE");
        this.checkExp("interval -'-1 2:3' day to minute", "INTERVAL -'-1 2:3' DAY TO MINUTE");
        this.checkExp("interval -'+1 2:3' day to minute", "INTERVAL -'+1 2:3' DAY TO MINUTE");
    }

    public void subTestIntervalDayToSecondPositive() {
        this.checkExp("interval '1 2:3:4' day to second", "INTERVAL '1 2:3:4' DAY TO SECOND");
        this.checkExp("interval '99 23:59:59' day to second", "INTERVAL '99 23:59:59' DAY TO SECOND");
        this.checkExp("interval '99 0:0:0' day to second", "INTERVAL '99 0:0:0' DAY TO SECOND");
        this.checkExp("interval '99 23:59:59.999999' day to second", "INTERVAL '99 23:59:59.999999' DAY TO SECOND");
        this.checkExp("interval '99 0:0:0.0' day to second", "INTERVAL '99 0:0:0.0' DAY TO SECOND");
        this.checkExp("interval '1 2:3:4' day(2) to second", "INTERVAL '1 2:3:4' DAY(2) TO SECOND");
        this.checkExp("interval '99 23:59:59' day(2) to second", "INTERVAL '99 23:59:59' DAY(2) TO SECOND");
        this.checkExp("interval '99 0:0:0' day(2) to second", "INTERVAL '99 0:0:0' DAY(2) TO SECOND");
        this.checkExp("interval '99 23:59:59.999999' day to second(6)", "INTERVAL '99 23:59:59.999999' DAY TO SECOND(6)");
        this.checkExp("interval '99 0:0:0.0' day to second(6)", "INTERVAL '99 0:0:0.0' DAY TO SECOND(6)");
        this.checkExp("interval '2147483647 23:59:59' day(10) to second", "INTERVAL '2147483647 23:59:59' DAY(10) TO SECOND");
        this.checkExp("interval '2147483647 23:59:59.999999999' day(10) to second(9)", "INTERVAL '2147483647 23:59:59.999999999' DAY(10) TO SECOND(9)");
        this.checkExp("interval '0 0:0:0' day(1) to second", "INTERVAL '0 0:0:0' DAY(1) TO SECOND");
        this.checkExp("interval '0 0:0:0.0' day(1) to second(1)", "INTERVAL '0 0:0:0.0' DAY(1) TO SECOND(1)");
        this.checkExp("interval '2345 6:7:8' day(4) to second", "INTERVAL '2345 6:7:8' DAY(4) TO SECOND");
        this.checkExp("interval '2345 6:7:8.9012' day(4) to second(4)", "INTERVAL '2345 6:7:8.9012' DAY(4) TO SECOND(4)");
        this.checkExp("interval '-1 2:3:4' day to second", "INTERVAL '-1 2:3:4' DAY TO SECOND");
        this.checkExp("interval '+1 2:3:4' day to second", "INTERVAL '+1 2:3:4' DAY TO SECOND");
        this.checkExp("interval +'1 2:3:4' day to second", "INTERVAL '1 2:3:4' DAY TO SECOND");
        this.checkExp("interval +'-1 2:3:4' day to second", "INTERVAL '-1 2:3:4' DAY TO SECOND");
        this.checkExp("interval +'+1 2:3:4' day to second", "INTERVAL '+1 2:3:4' DAY TO SECOND");
        this.checkExp("interval -'1 2:3:4' day to second", "INTERVAL -'1 2:3:4' DAY TO SECOND");
        this.checkExp("interval -'-1 2:3:4' day to second", "INTERVAL -'-1 2:3:4' DAY TO SECOND");
        this.checkExp("interval -'+1 2:3:4' day to second", "INTERVAL -'+1 2:3:4' DAY TO SECOND");
    }

    public void subTestIntervalHourPositive() {
        this.checkExp("interval '1' hour", "INTERVAL '1' HOUR");
        this.checkExp("interval '99' hour", "INTERVAL '99' HOUR");
        this.checkExp("interval '1' hour(2)", "INTERVAL '1' HOUR(2)");
        this.checkExp("interval '99' hour(2)", "INTERVAL '99' HOUR(2)");
        this.checkExp("interval '2147483647' hour(10)", "INTERVAL '2147483647' HOUR(10)");
        this.checkExp("interval '0' hour(1)", "INTERVAL '0' HOUR(1)");
        this.checkExp("interval '1234' hour(4)", "INTERVAL '1234' HOUR(4)");
        this.checkExp("interval '+1' hour", "INTERVAL '+1' HOUR");
        this.checkExp("interval '-1' hour", "INTERVAL '-1' HOUR");
        this.checkExp("interval +'1' hour", "INTERVAL '1' HOUR");
        this.checkExp("interval +'+1' hour", "INTERVAL '+1' HOUR");
        this.checkExp("interval +'-1' hour", "INTERVAL '-1' HOUR");
        this.checkExp("interval -'1' hour", "INTERVAL -'1' HOUR");
        this.checkExp("interval -'+1' hour", "INTERVAL -'+1' HOUR");
        this.checkExp("interval -'-1' hour", "INTERVAL -'-1' HOUR");
    }

    public void subTestIntervalHourToMinutePositive() {
        this.checkExp("interval '2:3' hour to minute", "INTERVAL '2:3' HOUR TO MINUTE");
        this.checkExp("interval '23:59' hour to minute", "INTERVAL '23:59' HOUR TO MINUTE");
        this.checkExp("interval '99:0' hour to minute", "INTERVAL '99:0' HOUR TO MINUTE");
        this.checkExp("interval '2:3' hour(2) to minute", "INTERVAL '2:3' HOUR(2) TO MINUTE");
        this.checkExp("interval '23:59' hour(2) to minute", "INTERVAL '23:59' HOUR(2) TO MINUTE");
        this.checkExp("interval '99:0' hour(2) to minute", "INTERVAL '99:0' HOUR(2) TO MINUTE");
        this.checkExp("interval '2147483647:59' hour(10) to minute", "INTERVAL '2147483647:59' HOUR(10) TO MINUTE");
        this.checkExp("interval '0:0' hour(1) to minute", "INTERVAL '0:0' HOUR(1) TO MINUTE");
        this.checkExp("interval '2345:7' hour(4) to minute", "INTERVAL '2345:7' HOUR(4) TO MINUTE");
        this.checkExp("interval '-1:3' hour to minute", "INTERVAL '-1:3' HOUR TO MINUTE");
        this.checkExp("interval '+1:3' hour to minute", "INTERVAL '+1:3' HOUR TO MINUTE");
        this.checkExp("interval +'2:3' hour to minute", "INTERVAL '2:3' HOUR TO MINUTE");
        this.checkExp("interval +'-2:3' hour to minute", "INTERVAL '-2:3' HOUR TO MINUTE");
        this.checkExp("interval +'+2:3' hour to minute", "INTERVAL '+2:3' HOUR TO MINUTE");
        this.checkExp("interval -'2:3' hour to minute", "INTERVAL -'2:3' HOUR TO MINUTE");
        this.checkExp("interval -'-2:3' hour to minute", "INTERVAL -'-2:3' HOUR TO MINUTE");
        this.checkExp("interval -'+2:3' hour to minute", "INTERVAL -'+2:3' HOUR TO MINUTE");
    }

    public void subTestIntervalHourToSecondPositive() {
        this.checkExp("interval '2:3:4' hour to second", "INTERVAL '2:3:4' HOUR TO SECOND");
        this.checkExp("interval '23:59:59' hour to second", "INTERVAL '23:59:59' HOUR TO SECOND");
        this.checkExp("interval '99:0:0' hour to second", "INTERVAL '99:0:0' HOUR TO SECOND");
        this.checkExp("interval '23:59:59.999999' hour to second", "INTERVAL '23:59:59.999999' HOUR TO SECOND");
        this.checkExp("interval '99:0:0.0' hour to second", "INTERVAL '99:0:0.0' HOUR TO SECOND");
        this.checkExp("interval '2:3:4' hour(2) to second", "INTERVAL '2:3:4' HOUR(2) TO SECOND");
        this.checkExp("interval '99:59:59' hour(2) to second", "INTERVAL '99:59:59' HOUR(2) TO SECOND");
        this.checkExp("interval '99:0:0' hour(2) to second", "INTERVAL '99:0:0' HOUR(2) TO SECOND");
        this.checkExp("interval '23:59:59.999999' hour to second(6)", "INTERVAL '23:59:59.999999' HOUR TO SECOND(6)");
        this.checkExp("interval '99:0:0.0' hour to second(6)", "INTERVAL '99:0:0.0' HOUR TO SECOND(6)");
        this.checkExp("interval '2147483647:59:59' hour(10) to second", "INTERVAL '2147483647:59:59' HOUR(10) TO SECOND");
        this.checkExp("interval '2147483647:59:59.999999999' hour(10) to second(9)", "INTERVAL '2147483647:59:59.999999999' HOUR(10) TO SECOND(9)");
        this.checkExp("interval '0:0:0' hour(1) to second", "INTERVAL '0:0:0' HOUR(1) TO SECOND");
        this.checkExp("interval '0:0:0.0' hour(1) to second(1)", "INTERVAL '0:0:0.0' HOUR(1) TO SECOND(1)");
        this.checkExp("interval '2345:7:8' hour(4) to second", "INTERVAL '2345:7:8' HOUR(4) TO SECOND");
        this.checkExp("interval '2345:7:8.9012' hour(4) to second(4)", "INTERVAL '2345:7:8.9012' HOUR(4) TO SECOND(4)");
        this.checkExp("interval '-2:3:4' hour to second", "INTERVAL '-2:3:4' HOUR TO SECOND");
        this.checkExp("interval '+2:3:4' hour to second", "INTERVAL '+2:3:4' HOUR TO SECOND");
        this.checkExp("interval +'2:3:4' hour to second", "INTERVAL '2:3:4' HOUR TO SECOND");
        this.checkExp("interval +'-2:3:4' hour to second", "INTERVAL '-2:3:4' HOUR TO SECOND");
        this.checkExp("interval +'+2:3:4' hour to second", "INTERVAL '+2:3:4' HOUR TO SECOND");
        this.checkExp("interval -'2:3:4' hour to second", "INTERVAL -'2:3:4' HOUR TO SECOND");
        this.checkExp("interval -'-2:3:4' hour to second", "INTERVAL -'-2:3:4' HOUR TO SECOND");
        this.checkExp("interval -'+2:3:4' hour to second", "INTERVAL -'+2:3:4' HOUR TO SECOND");
    }

    public void subTestIntervalMinutePositive() {
        this.checkExp("interval '1' minute", "INTERVAL '1' MINUTE");
        this.checkExp("interval '99' minute", "INTERVAL '99' MINUTE");
        this.checkExp("interval '1' minute(2)", "INTERVAL '1' MINUTE(2)");
        this.checkExp("interval '99' minute(2)", "INTERVAL '99' MINUTE(2)");
        this.checkExp("interval '2147483647' minute(10)", "INTERVAL '2147483647' MINUTE(10)");
        this.checkExp("interval '0' minute(1)", "INTERVAL '0' MINUTE(1)");
        this.checkExp("interval '1234' minute(4)", "INTERVAL '1234' MINUTE(4)");
        this.checkExp("interval '+1' minute", "INTERVAL '+1' MINUTE");
        this.checkExp("interval '-1' minute", "INTERVAL '-1' MINUTE");
        this.checkExp("interval +'1' minute", "INTERVAL '1' MINUTE");
        this.checkExp("interval +'+1' minute", "INTERVAL '+1' MINUTE");
        this.checkExp("interval +'+1' minute", "INTERVAL '+1' MINUTE");
        this.checkExp("interval -'1' minute", "INTERVAL -'1' MINUTE");
        this.checkExp("interval -'+1' minute", "INTERVAL -'+1' MINUTE");
        this.checkExp("interval -'-1' minute", "INTERVAL -'-1' MINUTE");
    }

    public void subTestIntervalMinuteToSecondPositive() {
        this.checkExp("interval '2:4' minute to second", "INTERVAL '2:4' MINUTE TO SECOND");
        this.checkExp("interval '59:59' minute to second", "INTERVAL '59:59' MINUTE TO SECOND");
        this.checkExp("interval '99:0' minute to second", "INTERVAL '99:0' MINUTE TO SECOND");
        this.checkExp("interval '59:59.999999' minute to second", "INTERVAL '59:59.999999' MINUTE TO SECOND");
        this.checkExp("interval '99:0.0' minute to second", "INTERVAL '99:0.0' MINUTE TO SECOND");
        this.checkExp("interval '2:4' minute(2) to second", "INTERVAL '2:4' MINUTE(2) TO SECOND");
        this.checkExp("interval '59:59' minute(2) to second", "INTERVAL '59:59' MINUTE(2) TO SECOND");
        this.checkExp("interval '99:0' minute(2) to second", "INTERVAL '99:0' MINUTE(2) TO SECOND");
        this.checkExp("interval '99:59.999999' minute to second(6)", "INTERVAL '99:59.999999' MINUTE TO SECOND(6)");
        this.checkExp("interval '99:0.0' minute to second(6)", "INTERVAL '99:0.0' MINUTE TO SECOND(6)");
        this.checkExp("interval '2147483647:59' minute(10) to second", "INTERVAL '2147483647:59' MINUTE(10) TO SECOND");
        this.checkExp("interval '2147483647:59.999999999' minute(10) to second(9)", "INTERVAL '2147483647:59.999999999' MINUTE(10) TO SECOND(9)");
        this.checkExp("interval '0:0' minute(1) to second", "INTERVAL '0:0' MINUTE(1) TO SECOND");
        this.checkExp("interval '0:0.0' minute(1) to second(1)", "INTERVAL '0:0.0' MINUTE(1) TO SECOND(1)");
        this.checkExp("interval '2345:8' minute(4) to second", "INTERVAL '2345:8' MINUTE(4) TO SECOND");
        this.checkExp("interval '2345:7.8901' minute(4) to second(4)", "INTERVAL '2345:7.8901' MINUTE(4) TO SECOND(4)");
        this.checkExp("interval '-3:4' minute to second", "INTERVAL '-3:4' MINUTE TO SECOND");
        this.checkExp("interval '+3:4' minute to second", "INTERVAL '+3:4' MINUTE TO SECOND");
        this.checkExp("interval +'3:4' minute to second", "INTERVAL '3:4' MINUTE TO SECOND");
        this.checkExp("interval +'-3:4' minute to second", "INTERVAL '-3:4' MINUTE TO SECOND");
        this.checkExp("interval +'+3:4' minute to second", "INTERVAL '+3:4' MINUTE TO SECOND");
        this.checkExp("interval -'3:4' minute to second", "INTERVAL -'3:4' MINUTE TO SECOND");
        this.checkExp("interval -'-3:4' minute to second", "INTERVAL -'-3:4' MINUTE TO SECOND");
        this.checkExp("interval -'+3:4' minute to second", "INTERVAL -'+3:4' MINUTE TO SECOND");
    }

    public void subTestIntervalSecondPositive() {
        this.checkExp("interval '1' second", "INTERVAL '1' SECOND");
        this.checkExp("interval '99' second", "INTERVAL '99' SECOND");
        this.checkExp("interval '1' second(2)", "INTERVAL '1' SECOND(2)");
        this.checkExp("interval '99' second(2)", "INTERVAL '99' SECOND(2)");
        this.checkExp("interval '1' second(2,6)", "INTERVAL '1' SECOND(2, 6)");
        this.checkExp("interval '99' second(2,6)", "INTERVAL '99' SECOND(2, 6)");
        this.checkExp("interval '2147483647' second(10)", "INTERVAL '2147483647' SECOND(10)");
        this.checkExp("interval '2147483647.999999999' second(9,9)", "INTERVAL '2147483647.999999999' SECOND(9, 9)");
        this.checkExp("interval '0' second(1)", "INTERVAL '0' SECOND(1)");
        this.checkExp("interval '0.0' second(1,1)", "INTERVAL '0.0' SECOND(1, 1)");
        this.checkExp("interval '1234' second(4)", "INTERVAL '1234' SECOND(4)");
        this.checkExp("interval '1234.56789' second(4,5)", "INTERVAL '1234.56789' SECOND(4, 5)");
        this.checkExp("interval '+1' second", "INTERVAL '+1' SECOND");
        this.checkExp("interval '-1' second", "INTERVAL '-1' SECOND");
        this.checkExp("interval +'1' second", "INTERVAL '1' SECOND");
        this.checkExp("interval +'+1' second", "INTERVAL '+1' SECOND");
        this.checkExp("interval +'-1' second", "INTERVAL '-1' SECOND");
        this.checkExp("interval -'1' second", "INTERVAL -'1' SECOND");
        this.checkExp("interval -'+1' second", "INTERVAL -'+1' SECOND");
        this.checkExp("interval -'-1' second", "INTERVAL -'-1' SECOND");
    }

    public void subTestIntervalYearFailsValidation() {
        this.checkExp("INTERVAL '-' YEAR", "INTERVAL '-' YEAR");
        this.checkExp("INTERVAL '1-2' YEAR", "INTERVAL '1-2' YEAR");
        this.checkExp("INTERVAL '1.2' YEAR", "INTERVAL '1.2' YEAR");
        this.checkExp("INTERVAL '1 2' YEAR", "INTERVAL '1 2' YEAR");
        this.checkExp("INTERVAL '1-2' YEAR(2)", "INTERVAL '1-2' YEAR(2)");
        this.checkExp("INTERVAL 'bogus text' YEAR", "INTERVAL 'bogus text' YEAR");
        this.checkExp("INTERVAL '--1' YEAR", "INTERVAL '--1' YEAR");
        this.checkExp("INTERVAL '100' YEAR", "INTERVAL '100' YEAR");
        this.checkExp("INTERVAL '100' YEAR(2)", "INTERVAL '100' YEAR(2)");
        this.checkExp("INTERVAL '1000' YEAR(3)", "INTERVAL '1000' YEAR(3)");
        this.checkExp("INTERVAL '-1000' YEAR(3)", "INTERVAL '-1000' YEAR(3)");
        this.checkExp("INTERVAL '2147483648' YEAR(10)", "INTERVAL '2147483648' YEAR(10)");
        this.checkExp("INTERVAL '-2147483648' YEAR(10)", "INTERVAL '-2147483648' YEAR(10)");
        this.checkExp("INTERVAL '1' YEAR(11)", "INTERVAL '1' YEAR(11)");
        this.checkExp("INTERVAL '0' YEAR(0)", "INTERVAL '0' YEAR(0)");
    }

    public void subTestIntervalYearToMonthFailsValidation() {
        this.checkExp("INTERVAL '-' YEAR TO MONTH", "INTERVAL '-' YEAR TO MONTH");
        this.checkExp("INTERVAL '1' YEAR TO MONTH", "INTERVAL '1' YEAR TO MONTH");
        this.checkExp("INTERVAL '1:2' YEAR TO MONTH", "INTERVAL '1:2' YEAR TO MONTH");
        this.checkExp("INTERVAL '1.2' YEAR TO MONTH", "INTERVAL '1.2' YEAR TO MONTH");
        this.checkExp("INTERVAL '1 2' YEAR TO MONTH", "INTERVAL '1 2' YEAR TO MONTH");
        this.checkExp("INTERVAL '1:2' YEAR(2) TO MONTH", "INTERVAL '1:2' YEAR(2) TO MONTH");
        this.checkExp("INTERVAL 'bogus text' YEAR TO MONTH", "INTERVAL 'bogus text' YEAR TO MONTH");
        this.checkExp("INTERVAL '--1-2' YEAR TO MONTH", "INTERVAL '--1-2' YEAR TO MONTH");
        this.checkExp("INTERVAL '1--2' YEAR TO MONTH", "INTERVAL '1--2' YEAR TO MONTH");
        this.checkExp("INTERVAL '100-0' YEAR TO MONTH", "INTERVAL '100-0' YEAR TO MONTH");
        this.checkExp("INTERVAL '100-0' YEAR(2) TO MONTH", "INTERVAL '100-0' YEAR(2) TO MONTH");
        this.checkExp("INTERVAL '1000-0' YEAR(3) TO MONTH", "INTERVAL '1000-0' YEAR(3) TO MONTH");
        this.checkExp("INTERVAL '-1000-0' YEAR(3) TO MONTH", "INTERVAL '-1000-0' YEAR(3) TO MONTH");
        this.checkExp("INTERVAL '2147483648-0' YEAR(10) TO MONTH", "INTERVAL '2147483648-0' YEAR(10) TO MONTH");
        this.checkExp("INTERVAL '-2147483648-0' YEAR(10) TO MONTH", "INTERVAL '-2147483648-0' YEAR(10) TO MONTH");
        this.checkExp("INTERVAL '1-12' YEAR TO MONTH", "INTERVAL '1-12' YEAR TO MONTH");
        this.checkExp("INTERVAL '1-1' YEAR(11) TO MONTH", "INTERVAL '1-1' YEAR(11) TO MONTH");
        this.checkExp("INTERVAL '0-0' YEAR(0) TO MONTH", "INTERVAL '0-0' YEAR(0) TO MONTH");
    }

    public void subTestIntervalMonthFailsValidation() {
        this.checkExp("INTERVAL '-' MONTH", "INTERVAL '-' MONTH");
        this.checkExp("INTERVAL '1-2' MONTH", "INTERVAL '1-2' MONTH");
        this.checkExp("INTERVAL '1.2' MONTH", "INTERVAL '1.2' MONTH");
        this.checkExp("INTERVAL '1 2' MONTH", "INTERVAL '1 2' MONTH");
        this.checkExp("INTERVAL '1-2' MONTH(2)", "INTERVAL '1-2' MONTH(2)");
        this.checkExp("INTERVAL 'bogus text' MONTH", "INTERVAL 'bogus text' MONTH");
        this.checkExp("INTERVAL '--1' MONTH", "INTERVAL '--1' MONTH");
        this.checkExp("INTERVAL '100' MONTH", "INTERVAL '100' MONTH");
        this.checkExp("INTERVAL '100' MONTH(2)", "INTERVAL '100' MONTH(2)");
        this.checkExp("INTERVAL '1000' MONTH(3)", "INTERVAL '1000' MONTH(3)");
        this.checkExp("INTERVAL '-1000' MONTH(3)", "INTERVAL '-1000' MONTH(3)");
        this.checkExp("INTERVAL '2147483648' MONTH(10)", "INTERVAL '2147483648' MONTH(10)");
        this.checkExp("INTERVAL '-2147483648' MONTH(10)", "INTERVAL '-2147483648' MONTH(10)");
        this.checkExp("INTERVAL '1' MONTH(11)", "INTERVAL '1' MONTH(11)");
        this.checkExp("INTERVAL '0' MONTH(0)", "INTERVAL '0' MONTH(0)");
    }

    public void subTestIntervalDayFailsValidation() {
        this.checkExp("INTERVAL '-' DAY", "INTERVAL '-' DAY");
        this.checkExp("INTERVAL '1-2' DAY", "INTERVAL '1-2' DAY");
        this.checkExp("INTERVAL '1.2' DAY", "INTERVAL '1.2' DAY");
        this.checkExp("INTERVAL '1 2' DAY", "INTERVAL '1 2' DAY");
        this.checkExp("INTERVAL '1:2' DAY", "INTERVAL '1:2' DAY");
        this.checkExp("INTERVAL '1-2' DAY(2)", "INTERVAL '1-2' DAY(2)");
        this.checkExp("INTERVAL 'bogus text' DAY", "INTERVAL 'bogus text' DAY");
        this.checkExp("INTERVAL '--1' DAY", "INTERVAL '--1' DAY");
        this.checkExp("INTERVAL '100' DAY", "INTERVAL '100' DAY");
        this.checkExp("INTERVAL '100' DAY(2)", "INTERVAL '100' DAY(2)");
        this.checkExp("INTERVAL '1000' DAY(3)", "INTERVAL '1000' DAY(3)");
        this.checkExp("INTERVAL '-1000' DAY(3)", "INTERVAL '-1000' DAY(3)");
        this.checkExp("INTERVAL '2147483648' DAY(10)", "INTERVAL '2147483648' DAY(10)");
        this.checkExp("INTERVAL '-2147483648' DAY(10)", "INTERVAL '-2147483648' DAY(10)");
        this.checkExp("INTERVAL '1' DAY(11)", "INTERVAL '1' DAY(11)");
        this.checkExp("INTERVAL '0' DAY(0)", "INTERVAL '0' DAY(0)");
    }

    public void subTestIntervalDayToHourFailsValidation() {
        this.checkExp("INTERVAL '-' DAY TO HOUR", "INTERVAL '-' DAY TO HOUR");
        this.checkExp("INTERVAL '1' DAY TO HOUR", "INTERVAL '1' DAY TO HOUR");
        this.checkExp("INTERVAL '1:2' DAY TO HOUR", "INTERVAL '1:2' DAY TO HOUR");
        this.checkExp("INTERVAL '1.2' DAY TO HOUR", "INTERVAL '1.2' DAY TO HOUR");
        this.checkExp("INTERVAL '1 x' DAY TO HOUR", "INTERVAL '1 x' DAY TO HOUR");
        this.checkExp("INTERVAL ' ' DAY TO HOUR", "INTERVAL ' ' DAY TO HOUR");
        this.checkExp("INTERVAL '1:2' DAY(2) TO HOUR", "INTERVAL '1:2' DAY(2) TO HOUR");
        this.checkExp("INTERVAL 'bogus text' DAY TO HOUR", "INTERVAL 'bogus text' DAY TO HOUR");
        this.checkExp("INTERVAL '--1 1' DAY TO HOUR", "INTERVAL '--1 1' DAY TO HOUR");
        this.checkExp("INTERVAL '1 -1' DAY TO HOUR", "INTERVAL '1 -1' DAY TO HOUR");
        this.checkExp("INTERVAL '100 0' DAY TO HOUR", "INTERVAL '100 0' DAY TO HOUR");
        this.checkExp("INTERVAL '100 0' DAY(2) TO HOUR", "INTERVAL '100 0' DAY(2) TO HOUR");
        this.checkExp("INTERVAL '1000 0' DAY(3) TO HOUR", "INTERVAL '1000 0' DAY(3) TO HOUR");
        this.checkExp("INTERVAL '-1000 0' DAY(3) TO HOUR", "INTERVAL '-1000 0' DAY(3) TO HOUR");
        this.checkExp("INTERVAL '2147483648 0' DAY(10) TO HOUR", "INTERVAL '2147483648 0' DAY(10) TO HOUR");
        this.checkExp("INTERVAL '-2147483648 0' DAY(10) TO HOUR", "INTERVAL '-2147483648 0' DAY(10) TO HOUR");
        this.checkExp("INTERVAL '1 24' DAY TO HOUR", "INTERVAL '1 24' DAY TO HOUR");
        this.checkExp("INTERVAL '1 1' DAY(11) TO HOUR", "INTERVAL '1 1' DAY(11) TO HOUR");
        this.checkExp("INTERVAL '0 0' DAY(0) TO HOUR", "INTERVAL '0 0' DAY(0) TO HOUR");
    }

    public void subTestIntervalDayToMinuteFailsValidation() {
        this.checkExp("INTERVAL ' :' DAY TO MINUTE", "INTERVAL ' :' DAY TO MINUTE");
        this.checkExp("INTERVAL '1' DAY TO MINUTE", "INTERVAL '1' DAY TO MINUTE");
        this.checkExp("INTERVAL '1 2' DAY TO MINUTE", "INTERVAL '1 2' DAY TO MINUTE");
        this.checkExp("INTERVAL '1:2' DAY TO MINUTE", "INTERVAL '1:2' DAY TO MINUTE");
        this.checkExp("INTERVAL '1.2' DAY TO MINUTE", "INTERVAL '1.2' DAY TO MINUTE");
        this.checkExp("INTERVAL 'x 1:1' DAY TO MINUTE", "INTERVAL 'x 1:1' DAY TO MINUTE");
        this.checkExp("INTERVAL '1 x:1' DAY TO MINUTE", "INTERVAL '1 x:1' DAY TO MINUTE");
        this.checkExp("INTERVAL '1 1:x' DAY TO MINUTE", "INTERVAL '1 1:x' DAY TO MINUTE");
        this.checkExp("INTERVAL '1 1:2:3' DAY TO MINUTE", "INTERVAL '1 1:2:3' DAY TO MINUTE");
        this.checkExp("INTERVAL '1 1:1:1.2' DAY TO MINUTE", "INTERVAL '1 1:1:1.2' DAY TO MINUTE");
        this.checkExp("INTERVAL '1 1:2:3' DAY(2) TO MINUTE", "INTERVAL '1 1:2:3' DAY(2) TO MINUTE");
        this.checkExp("INTERVAL '1 1' DAY(2) TO MINUTE", "INTERVAL '1 1' DAY(2) TO MINUTE");
        this.checkExp("INTERVAL 'bogus text' DAY TO MINUTE", "INTERVAL 'bogus text' DAY TO MINUTE");
        this.checkExp("INTERVAL '--1 1:1' DAY TO MINUTE", "INTERVAL '--1 1:1' DAY TO MINUTE");
        this.checkExp("INTERVAL '1 -1:1' DAY TO MINUTE", "INTERVAL '1 -1:1' DAY TO MINUTE");
        this.checkExp("INTERVAL '1 1:-1' DAY TO MINUTE", "INTERVAL '1 1:-1' DAY TO MINUTE");
        this.checkExp("INTERVAL '100 0' DAY TO MINUTE", "INTERVAL '100 0' DAY TO MINUTE");
        this.checkExp("INTERVAL '100 0' DAY(2) TO MINUTE", "INTERVAL '100 0' DAY(2) TO MINUTE");
        this.checkExp("INTERVAL '1000 0' DAY(3) TO MINUTE", "INTERVAL '1000 0' DAY(3) TO MINUTE");
        this.checkExp("INTERVAL '-1000 0' DAY(3) TO MINUTE", "INTERVAL '-1000 0' DAY(3) TO MINUTE");
        this.checkExp("INTERVAL '2147483648 0' DAY(10) TO MINUTE", "INTERVAL '2147483648 0' DAY(10) TO MINUTE");
        this.checkExp("INTERVAL '-2147483648 0' DAY(10) TO MINUTE", "INTERVAL '-2147483648 0' DAY(10) TO MINUTE");
        this.checkExp("INTERVAL '1 24:1' DAY TO MINUTE", "INTERVAL '1 24:1' DAY TO MINUTE");
        this.checkExp("INTERVAL '1 1:60' DAY TO MINUTE", "INTERVAL '1 1:60' DAY TO MINUTE");
        this.checkExp("INTERVAL '1 1' DAY(11) TO MINUTE", "INTERVAL '1 1' DAY(11) TO MINUTE");
        this.checkExp("INTERVAL '0 0' DAY(0) TO MINUTE", "INTERVAL '0 0' DAY(0) TO MINUTE");
    }

    public void subTestIntervalDayToSecondFailsValidation() {
        this.checkExp("INTERVAL ' ::' DAY TO SECOND", "INTERVAL ' ::' DAY TO SECOND");
        this.checkExp("INTERVAL ' ::.' DAY TO SECOND", "INTERVAL ' ::.' DAY TO SECOND");
        this.checkExp("INTERVAL '1' DAY TO SECOND", "INTERVAL '1' DAY TO SECOND");
        this.checkExp("INTERVAL '1 2' DAY TO SECOND", "INTERVAL '1 2' DAY TO SECOND");
        this.checkExp("INTERVAL '1:2' DAY TO SECOND", "INTERVAL '1:2' DAY TO SECOND");
        this.checkExp("INTERVAL '1.2' DAY TO SECOND", "INTERVAL '1.2' DAY TO SECOND");
        this.checkExp("INTERVAL '1 1:2' DAY TO SECOND", "INTERVAL '1 1:2' DAY TO SECOND");
        this.checkExp("INTERVAL '1 1:2:x' DAY TO SECOND", "INTERVAL '1 1:2:x' DAY TO SECOND");
        this.checkExp("INTERVAL '1:2:3' DAY TO SECOND", "INTERVAL '1:2:3' DAY TO SECOND");
        this.checkExp("INTERVAL '1:1:1.2' DAY TO SECOND", "INTERVAL '1:1:1.2' DAY TO SECOND");
        this.checkExp("INTERVAL '1 1:2' DAY(2) TO SECOND", "INTERVAL '1 1:2' DAY(2) TO SECOND");
        this.checkExp("INTERVAL '1 1' DAY(2) TO SECOND", "INTERVAL '1 1' DAY(2) TO SECOND");
        this.checkExp("INTERVAL 'bogus text' DAY TO SECOND", "INTERVAL 'bogus text' DAY TO SECOND");
        this.checkExp("INTERVAL '2345 6:7:8901' DAY TO SECOND(4)", "INTERVAL '2345 6:7:8901' DAY TO SECOND(4)");
        this.checkExp("INTERVAL '--1 1:1:1' DAY TO SECOND", "INTERVAL '--1 1:1:1' DAY TO SECOND");
        this.checkExp("INTERVAL '1 -1:1:1' DAY TO SECOND", "INTERVAL '1 -1:1:1' DAY TO SECOND");
        this.checkExp("INTERVAL '1 1:-1:1' DAY TO SECOND", "INTERVAL '1 1:-1:1' DAY TO SECOND");
        this.checkExp("INTERVAL '1 1:1:-1' DAY TO SECOND", "INTERVAL '1 1:1:-1' DAY TO SECOND");
        this.checkExp("INTERVAL '1 1:1:1.-1' DAY TO SECOND", "INTERVAL '1 1:1:1.-1' DAY TO SECOND");
        this.checkExp("INTERVAL '100 0' DAY TO SECOND", "INTERVAL '100 0' DAY TO SECOND");
        this.checkExp("INTERVAL '100 0' DAY(2) TO SECOND", "INTERVAL '100 0' DAY(2) TO SECOND");
        this.checkExp("INTERVAL '1000 0' DAY(3) TO SECOND", "INTERVAL '1000 0' DAY(3) TO SECOND");
        this.checkExp("INTERVAL '-1000 0' DAY(3) TO SECOND", "INTERVAL '-1000 0' DAY(3) TO SECOND");
        this.checkExp("INTERVAL '2147483648 0' DAY(10) TO SECOND", "INTERVAL '2147483648 0' DAY(10) TO SECOND");
        this.checkExp("INTERVAL '-2147483648 0' DAY(10) TO SECOND", "INTERVAL '-2147483648 0' DAY(10) TO SECOND");
        this.checkExp("INTERVAL '1 24:1:1' DAY TO SECOND", "INTERVAL '1 24:1:1' DAY TO SECOND");
        this.checkExp("INTERVAL '1 1:60:1' DAY TO SECOND", "INTERVAL '1 1:60:1' DAY TO SECOND");
        this.checkExp("INTERVAL '1 1:1:60' DAY TO SECOND", "INTERVAL '1 1:1:60' DAY TO SECOND");
        this.checkExp("INTERVAL '1 1:1:1.0000001' DAY TO SECOND", "INTERVAL '1 1:1:1.0000001' DAY TO SECOND");
        this.checkExp("INTERVAL '1 1:1:1.0001' DAY TO SECOND(3)", "INTERVAL '1 1:1:1.0001' DAY TO SECOND(3)");
        this.checkExp("INTERVAL '1 1' DAY(11) TO SECOND", "INTERVAL '1 1' DAY(11) TO SECOND");
        this.checkExp("INTERVAL '1 1' DAY TO SECOND(10)", "INTERVAL '1 1' DAY TO SECOND(10)");
        this.checkExp("INTERVAL '0 0:0:0' DAY(0) TO SECOND", "INTERVAL '0 0:0:0' DAY(0) TO SECOND");
        this.checkExp("INTERVAL '0 0:0:0' DAY TO SECOND(0)", "INTERVAL '0 0:0:0' DAY TO SECOND(0)");
    }

    public void subTestIntervalHourFailsValidation() {
        this.checkExp("INTERVAL '-' HOUR", "INTERVAL '-' HOUR");
        this.checkExp("INTERVAL '1-2' HOUR", "INTERVAL '1-2' HOUR");
        this.checkExp("INTERVAL '1.2' HOUR", "INTERVAL '1.2' HOUR");
        this.checkExp("INTERVAL '1 2' HOUR", "INTERVAL '1 2' HOUR");
        this.checkExp("INTERVAL '1:2' HOUR", "INTERVAL '1:2' HOUR");
        this.checkExp("INTERVAL '1-2' HOUR(2)", "INTERVAL '1-2' HOUR(2)");
        this.checkExp("INTERVAL 'bogus text' HOUR", "INTERVAL 'bogus text' HOUR");
        this.checkExp("INTERVAL '--1' HOUR", "INTERVAL '--1' HOUR");
        this.checkExp("INTERVAL '100' HOUR", "INTERVAL '100' HOUR");
        this.checkExp("INTERVAL '100' HOUR(2)", "INTERVAL '100' HOUR(2)");
        this.checkExp("INTERVAL '1000' HOUR(3)", "INTERVAL '1000' HOUR(3)");
        this.checkExp("INTERVAL '-1000' HOUR(3)", "INTERVAL '-1000' HOUR(3)");
        this.checkExp("INTERVAL '2147483648' HOUR(10)", "INTERVAL '2147483648' HOUR(10)");
        this.checkExp("INTERVAL '-2147483648' HOUR(10)", "INTERVAL '-2147483648' HOUR(10)");
        this.checkExp("INTERVAL '--1' HOUR", "INTERVAL '--1' HOUR");
        this.checkExp("INTERVAL '1' HOUR(11)", "INTERVAL '1' HOUR(11)");
        this.checkExp("INTERVAL '0' HOUR(0)", "INTERVAL '0' HOUR(0)");
    }

    public void subTestIntervalHourToMinuteFailsValidation() {
        this.checkExp("INTERVAL ':' HOUR TO MINUTE", "INTERVAL ':' HOUR TO MINUTE");
        this.checkExp("INTERVAL '1' HOUR TO MINUTE", "INTERVAL '1' HOUR TO MINUTE");
        this.checkExp("INTERVAL '1:x' HOUR TO MINUTE", "INTERVAL '1:x' HOUR TO MINUTE");
        this.checkExp("INTERVAL '1.2' HOUR TO MINUTE", "INTERVAL '1.2' HOUR TO MINUTE");
        this.checkExp("INTERVAL '1 2' HOUR TO MINUTE", "INTERVAL '1 2' HOUR TO MINUTE");
        this.checkExp("INTERVAL '1:2:3' HOUR TO MINUTE", "INTERVAL '1:2:3' HOUR TO MINUTE");
        this.checkExp("INTERVAL '1 2' HOUR(2) TO MINUTE", "INTERVAL '1 2' HOUR(2) TO MINUTE");
        this.checkExp("INTERVAL 'bogus text' HOUR TO MINUTE", "INTERVAL 'bogus text' HOUR TO MINUTE");
        this.checkExp("INTERVAL '--1:1' HOUR TO MINUTE", "INTERVAL '--1:1' HOUR TO MINUTE");
        this.checkExp("INTERVAL '1:-1' HOUR TO MINUTE", "INTERVAL '1:-1' HOUR TO MINUTE");
        this.checkExp("INTERVAL '100:0' HOUR TO MINUTE", "INTERVAL '100:0' HOUR TO MINUTE");
        this.checkExp("INTERVAL '100:0' HOUR(2) TO MINUTE", "INTERVAL '100:0' HOUR(2) TO MINUTE");
        this.checkExp("INTERVAL '1000:0' HOUR(3) TO MINUTE", "INTERVAL '1000:0' HOUR(3) TO MINUTE");
        this.checkExp("INTERVAL '-1000:0' HOUR(3) TO MINUTE", "INTERVAL '-1000:0' HOUR(3) TO MINUTE");
        this.checkExp("INTERVAL '2147483648:0' HOUR(10) TO MINUTE", "INTERVAL '2147483648:0' HOUR(10) TO MINUTE");
        this.checkExp("INTERVAL '-2147483648:0' HOUR(10) TO MINUTE", "INTERVAL '-2147483648:0' HOUR(10) TO MINUTE");
        this.checkExp("INTERVAL '1:24' HOUR TO MINUTE", "INTERVAL '1:24' HOUR TO MINUTE");
        this.checkExp("INTERVAL '1:1' HOUR(11) TO MINUTE", "INTERVAL '1:1' HOUR(11) TO MINUTE");
        this.checkExp("INTERVAL '0:0' HOUR(0) TO MINUTE", "INTERVAL '0:0' HOUR(0) TO MINUTE");
    }

    public void subTestIntervalHourToSecondFailsValidation() {
        this.checkExp("INTERVAL '::' HOUR TO SECOND", "INTERVAL '::' HOUR TO SECOND");
        this.checkExp("INTERVAL '::.' HOUR TO SECOND", "INTERVAL '::.' HOUR TO SECOND");
        this.checkExp("INTERVAL '1' HOUR TO SECOND", "INTERVAL '1' HOUR TO SECOND");
        this.checkExp("INTERVAL '1 2' HOUR TO SECOND", "INTERVAL '1 2' HOUR TO SECOND");
        this.checkExp("INTERVAL '1:2' HOUR TO SECOND", "INTERVAL '1:2' HOUR TO SECOND");
        this.checkExp("INTERVAL '1.2' HOUR TO SECOND", "INTERVAL '1.2' HOUR TO SECOND");
        this.checkExp("INTERVAL '1 1:2' HOUR TO SECOND", "INTERVAL '1 1:2' HOUR TO SECOND");
        this.checkExp("INTERVAL '1:2:x' HOUR TO SECOND", "INTERVAL '1:2:x' HOUR TO SECOND");
        this.checkExp("INTERVAL '1:x:3' HOUR TO SECOND", "INTERVAL '1:x:3' HOUR TO SECOND");
        this.checkExp("INTERVAL '1:1:1.x' HOUR TO SECOND", "INTERVAL '1:1:1.x' HOUR TO SECOND");
        this.checkExp("INTERVAL '1 1:2' HOUR(2) TO SECOND", "INTERVAL '1 1:2' HOUR(2) TO SECOND");
        this.checkExp("INTERVAL '1 1' HOUR(2) TO SECOND", "INTERVAL '1 1' HOUR(2) TO SECOND");
        this.checkExp("INTERVAL 'bogus text' HOUR TO SECOND", "INTERVAL 'bogus text' HOUR TO SECOND");
        this.checkExp("INTERVAL '6:7:8901' HOUR TO SECOND(4)", "INTERVAL '6:7:8901' HOUR TO SECOND(4)");
        this.checkExp("INTERVAL '--1:1:1' HOUR TO SECOND", "INTERVAL '--1:1:1' HOUR TO SECOND");
        this.checkExp("INTERVAL '1:-1:1' HOUR TO SECOND", "INTERVAL '1:-1:1' HOUR TO SECOND");
        this.checkExp("INTERVAL '1:1:-1' HOUR TO SECOND", "INTERVAL '1:1:-1' HOUR TO SECOND");
        this.checkExp("INTERVAL '1:1:1.-1' HOUR TO SECOND", "INTERVAL '1:1:1.-1' HOUR TO SECOND");
        this.checkExp("INTERVAL '100:0:0' HOUR TO SECOND", "INTERVAL '100:0:0' HOUR TO SECOND");
        this.checkExp("INTERVAL '100:0:0' HOUR(2) TO SECOND", "INTERVAL '100:0:0' HOUR(2) TO SECOND");
        this.checkExp("INTERVAL '1000:0:0' HOUR(3) TO SECOND", "INTERVAL '1000:0:0' HOUR(3) TO SECOND");
        this.checkExp("INTERVAL '-1000:0:0' HOUR(3) TO SECOND", "INTERVAL '-1000:0:0' HOUR(3) TO SECOND");
        this.checkExp("INTERVAL '2147483648:0:0' HOUR(10) TO SECOND", "INTERVAL '2147483648:0:0' HOUR(10) TO SECOND");
        this.checkExp("INTERVAL '-2147483648:0:0' HOUR(10) TO SECOND", "INTERVAL '-2147483648:0:0' HOUR(10) TO SECOND");
        this.checkExp("INTERVAL '1:60:1' HOUR TO SECOND", "INTERVAL '1:60:1' HOUR TO SECOND");
        this.checkExp("INTERVAL '1:1:60' HOUR TO SECOND", "INTERVAL '1:1:60' HOUR TO SECOND");
        this.checkExp("INTERVAL '1:1:1.0000001' HOUR TO SECOND", "INTERVAL '1:1:1.0000001' HOUR TO SECOND");
        this.checkExp("INTERVAL '1:1:1.0001' HOUR TO SECOND(3)", "INTERVAL '1:1:1.0001' HOUR TO SECOND(3)");
        this.checkExp("INTERVAL '1:1:1' HOUR(11) TO SECOND", "INTERVAL '1:1:1' HOUR(11) TO SECOND");
        this.checkExp("INTERVAL '1:1:1' HOUR TO SECOND(10)", "INTERVAL '1:1:1' HOUR TO SECOND(10)");
        this.checkExp("INTERVAL '0:0:0' HOUR(0) TO SECOND", "INTERVAL '0:0:0' HOUR(0) TO SECOND");
        this.checkExp("INTERVAL '0:0:0' HOUR TO SECOND(0)", "INTERVAL '0:0:0' HOUR TO SECOND(0)");
    }

    public void subTestIntervalMinuteFailsValidation() {
        this.checkExp("INTERVAL '-' MINUTE", "INTERVAL '-' MINUTE");
        this.checkExp("INTERVAL '1-2' MINUTE", "INTERVAL '1-2' MINUTE");
        this.checkExp("INTERVAL '1.2' MINUTE", "INTERVAL '1.2' MINUTE");
        this.checkExp("INTERVAL '1 2' MINUTE", "INTERVAL '1 2' MINUTE");
        this.checkExp("INTERVAL '1:2' MINUTE", "INTERVAL '1:2' MINUTE");
        this.checkExp("INTERVAL '1-2' MINUTE(2)", "INTERVAL '1-2' MINUTE(2)");
        this.checkExp("INTERVAL 'bogus text' MINUTE", "INTERVAL 'bogus text' MINUTE");
        this.checkExp("INTERVAL '--1' MINUTE", "INTERVAL '--1' MINUTE");
        this.checkExp("INTERVAL '100' MINUTE", "INTERVAL '100' MINUTE");
        this.checkExp("INTERVAL '100' MINUTE(2)", "INTERVAL '100' MINUTE(2)");
        this.checkExp("INTERVAL '1000' MINUTE(3)", "INTERVAL '1000' MINUTE(3)");
        this.checkExp("INTERVAL '-1000' MINUTE(3)", "INTERVAL '-1000' MINUTE(3)");
        this.checkExp("INTERVAL '2147483648' MINUTE(10)", "INTERVAL '2147483648' MINUTE(10)");
        this.checkExp("INTERVAL '-2147483648' MINUTE(10)", "INTERVAL '-2147483648' MINUTE(10)");
        this.checkExp("INTERVAL '1' MINUTE(11)", "INTERVAL '1' MINUTE(11)");
        this.checkExp("INTERVAL '0' MINUTE(0)", "INTERVAL '0' MINUTE(0)");
    }

    public void subTestIntervalMinuteToSecondFailsValidation() {
        this.checkExp("INTERVAL ':' MINUTE TO SECOND", "INTERVAL ':' MINUTE TO SECOND");
        this.checkExp("INTERVAL ':.' MINUTE TO SECOND", "INTERVAL ':.' MINUTE TO SECOND");
        this.checkExp("INTERVAL '1' MINUTE TO SECOND", "INTERVAL '1' MINUTE TO SECOND");
        this.checkExp("INTERVAL '1 2' MINUTE TO SECOND", "INTERVAL '1 2' MINUTE TO SECOND");
        this.checkExp("INTERVAL '1.2' MINUTE TO SECOND", "INTERVAL '1.2' MINUTE TO SECOND");
        this.checkExp("INTERVAL '1 1:2' MINUTE TO SECOND", "INTERVAL '1 1:2' MINUTE TO SECOND");
        this.checkExp("INTERVAL '1:x' MINUTE TO SECOND", "INTERVAL '1:x' MINUTE TO SECOND");
        this.checkExp("INTERVAL 'x:3' MINUTE TO SECOND", "INTERVAL 'x:3' MINUTE TO SECOND");
        this.checkExp("INTERVAL '1:1.x' MINUTE TO SECOND", "INTERVAL '1:1.x' MINUTE TO SECOND");
        this.checkExp("INTERVAL '1 1:2' MINUTE(2) TO SECOND", "INTERVAL '1 1:2' MINUTE(2) TO SECOND");
        this.checkExp("INTERVAL '1 1' MINUTE(2) TO SECOND", "INTERVAL '1 1' MINUTE(2) TO SECOND");
        this.checkExp("INTERVAL 'bogus text' MINUTE TO SECOND", "INTERVAL 'bogus text' MINUTE TO SECOND");
        this.checkExp("INTERVAL '7:8901' MINUTE TO SECOND(4)", "INTERVAL '7:8901' MINUTE TO SECOND(4)");
        this.checkExp("INTERVAL '--1:1' MINUTE TO SECOND", "INTERVAL '--1:1' MINUTE TO SECOND");
        this.checkExp("INTERVAL '1:-1' MINUTE TO SECOND", "INTERVAL '1:-1' MINUTE TO SECOND");
        this.checkExp("INTERVAL '1:1.-1' MINUTE TO SECOND", "INTERVAL '1:1.-1' MINUTE TO SECOND");
        this.checkExp("INTERVAL '100:0' MINUTE TO SECOND", "INTERVAL '100:0' MINUTE TO SECOND");
        this.checkExp("INTERVAL '100:0' MINUTE(2) TO SECOND", "INTERVAL '100:0' MINUTE(2) TO SECOND");
        this.checkExp("INTERVAL '1000:0' MINUTE(3) TO SECOND", "INTERVAL '1000:0' MINUTE(3) TO SECOND");
        this.checkExp("INTERVAL '-1000:0' MINUTE(3) TO SECOND", "INTERVAL '-1000:0' MINUTE(3) TO SECOND");
        this.checkExp("INTERVAL '2147483648:0' MINUTE(10) TO SECOND", "INTERVAL '2147483648:0' MINUTE(10) TO SECOND");
        this.checkExp("INTERVAL '-2147483648:0' MINUTE(10) TO SECOND", "INTERVAL '-2147483648:0' MINUTE(10) TO SECOND");
        this.checkExp("INTERVAL '1:60' MINUTE TO SECOND", "INTERVAL '1:60' MINUTE TO SECOND");
        this.checkExp("INTERVAL '1:1.0000001' MINUTE TO SECOND", "INTERVAL '1:1.0000001' MINUTE TO SECOND");
        this.checkExp("INTERVAL '1:1:1.0001' MINUTE TO SECOND(3)", "INTERVAL '1:1:1.0001' MINUTE TO SECOND(3)");
        this.checkExp("INTERVAL '1:1' MINUTE(11) TO SECOND", "INTERVAL '1:1' MINUTE(11) TO SECOND");
        this.checkExp("INTERVAL '1:1' MINUTE TO SECOND(10)", "INTERVAL '1:1' MINUTE TO SECOND(10)");
        this.checkExp("INTERVAL '0:0' MINUTE(0) TO SECOND", "INTERVAL '0:0' MINUTE(0) TO SECOND");
        this.checkExp("INTERVAL '0:0' MINUTE TO SECOND(0)", "INTERVAL '0:0' MINUTE TO SECOND(0)");
    }

    public void subTestIntervalSecondFailsValidation() {
        this.checkExp("INTERVAL ':' SECOND", "INTERVAL ':' SECOND");
        this.checkExp("INTERVAL '.' SECOND", "INTERVAL '.' SECOND");
        this.checkExp("INTERVAL '1-2' SECOND", "INTERVAL '1-2' SECOND");
        this.checkExp("INTERVAL '1.x' SECOND", "INTERVAL '1.x' SECOND");
        this.checkExp("INTERVAL 'x.1' SECOND", "INTERVAL 'x.1' SECOND");
        this.checkExp("INTERVAL '1 2' SECOND", "INTERVAL '1 2' SECOND");
        this.checkExp("INTERVAL '1:2' SECOND", "INTERVAL '1:2' SECOND");
        this.checkExp("INTERVAL '1-2' SECOND(2)", "INTERVAL '1-2' SECOND(2)");
        this.checkExp("INTERVAL 'bogus text' SECOND", "INTERVAL 'bogus text' SECOND");
        this.checkExp("INTERVAL '--1' SECOND", "INTERVAL '--1' SECOND");
        this.checkExp("INTERVAL '1.-1' SECOND", "INTERVAL '1.-1' SECOND");
        this.checkExp("INTERVAL '100' SECOND", "INTERVAL '100' SECOND");
        this.checkExp("INTERVAL '100' SECOND(2)", "INTERVAL '100' SECOND(2)");
        this.checkExp("INTERVAL '1000' SECOND(3)", "INTERVAL '1000' SECOND(3)");
        this.checkExp("INTERVAL '-1000' SECOND(3)", "INTERVAL '-1000' SECOND(3)");
        this.checkExp("INTERVAL '2147483648' SECOND(10)", "INTERVAL '2147483648' SECOND(10)");
        this.checkExp("INTERVAL '-2147483648' SECOND(10)", "INTERVAL '-2147483648' SECOND(10)");
        this.checkExp("INTERVAL '1.0000001' SECOND", "INTERVAL '1.0000001' SECOND");
        this.checkExp("INTERVAL '1.0000001' SECOND(2)", "INTERVAL '1.0000001' SECOND(2)");
        this.checkExp("INTERVAL '1.0001' SECOND(2, 3)", "INTERVAL '1.0001' SECOND(2, 3)");
        this.checkExp("INTERVAL '1.000000001' SECOND(2, 9)", "INTERVAL '1.000000001' SECOND(2, 9)");
        this.checkExp("INTERVAL '1' SECOND(11)", "INTERVAL '1' SECOND(11)");
        this.checkExp("INTERVAL '1.1' SECOND(1, 10)", "INTERVAL '1.1' SECOND(1, 10)");
        this.checkExp("INTERVAL '0' SECOND(0)", "INTERVAL '0' SECOND(0)");
        this.checkExp("INTERVAL '0' SECOND(1, 0)", "INTERVAL '0' SECOND(1, 0)");
    }

    @Test
    public void testIntervalLiterals() {
        this.subTestIntervalYearPositive();
        this.subTestIntervalYearToMonthPositive();
        this.subTestIntervalMonthPositive();
        this.subTestIntervalDayPositive();
        this.subTestIntervalDayToHourPositive();
        this.subTestIntervalDayToMinutePositive();
        this.subTestIntervalDayToSecondPositive();
        this.subTestIntervalHourPositive();
        this.subTestIntervalHourToMinutePositive();
        this.subTestIntervalHourToSecondPositive();
        this.subTestIntervalMinutePositive();
        this.subTestIntervalMinuteToSecondPositive();
        this.subTestIntervalSecondPositive();
        this.subTestIntervalYearFailsValidation();
        this.subTestIntervalYearToMonthFailsValidation();
        this.subTestIntervalMonthFailsValidation();
        this.subTestIntervalDayFailsValidation();
        this.subTestIntervalDayToHourFailsValidation();
        this.subTestIntervalDayToMinuteFailsValidation();
        this.subTestIntervalDayToSecondFailsValidation();
        this.subTestIntervalHourFailsValidation();
        this.subTestIntervalHourToMinuteFailsValidation();
        this.subTestIntervalHourToSecondFailsValidation();
        this.subTestIntervalMinuteFailsValidation();
        this.subTestIntervalMinuteToSecondFailsValidation();
        this.subTestIntervalSecondFailsValidation();
    }

    @Test
    public void testUnparseableIntervalQualifiers() {
        this.checkExpFails("interval '1^'^", "Encountered \"<EOF>\" at line 1, column 12\\.\nWas expecting one of:\n    \"YEAR\" \\.\\.\\.\n    \"MONTH\" \\.\\.\\.\n    \"DAY\" \\.\\.\\.\n    \"HOUR\" \\.\\.\\.\n    \"MINUTE\" \\.\\.\\.\n    \"SECOND\" \\.\\.\\.\n    ");
        this.checkExpFails("interval '1' year ^to^ year", "(?s)Encountered \"to year\" at line 1, column 19.\nWas expecting one of:\n    <EOF> \n    \"NOT\" \\.\\.\\..*");
        this.checkExpFails("interval '1-2' year ^to^ day", ANY);
        this.checkExpFails("interval '1-2' year ^to^ hour", ANY);
        this.checkExpFails("interval '1-2' year ^to^ minute", ANY);
        this.checkExpFails("interval '1-2' year ^to^ second", ANY);
        this.checkExpFails("interval '1-2' month ^to^ year", ANY);
        this.checkExpFails("interval '1-2' month ^to^ month", ANY);
        this.checkExpFails("interval '1-2' month ^to^ day", ANY);
        this.checkExpFails("interval '1-2' month ^to^ hour", ANY);
        this.checkExpFails("interval '1-2' month ^to^ minute", ANY);
        this.checkExpFails("interval '1-2' month ^to^ second", ANY);
        this.checkExpFails("interval '1-2' day ^to^ year", ANY);
        this.checkExpFails("interval '1-2' day ^to^ month", ANY);
        this.checkExpFails("interval '1-2' day ^to^ day", ANY);
        this.checkExpFails("interval '1-2' hour ^to^ year", ANY);
        this.checkExpFails("interval '1-2' hour ^to^ month", ANY);
        this.checkExpFails("interval '1-2' hour ^to^ day", ANY);
        this.checkExpFails("interval '1-2' hour ^to^ hour", ANY);
        this.checkExpFails("interval '1-2' minute ^to^ year", ANY);
        this.checkExpFails("interval '1-2' minute ^to^ month", ANY);
        this.checkExpFails("interval '1-2' minute ^to^ day", ANY);
        this.checkExpFails("interval '1-2' minute ^to^ hour", ANY);
        this.checkExpFails("interval '1-2' minute ^to^ minute", ANY);
        this.checkExpFails("interval '1-2' second ^to^ year", ANY);
        this.checkExpFails("interval '1-2' second ^to^ month", ANY);
        this.checkExpFails("interval '1-2' second ^to^ day", ANY);
        this.checkExpFails("interval '1-2' second ^to^ hour", ANY);
        this.checkExpFails("interval '1-2' second ^to^ minute", ANY);
        this.checkExpFails("interval '1-2' second ^to^ second", ANY);
        this.checkExpFails("interval '1' year(3) ^to^ year", ANY);
        this.checkExpFails("interval '1-2' year(3) ^to^ day", ANY);
        this.checkExpFails("interval '1-2' year(3) ^to^ hour", ANY);
        this.checkExpFails("interval '1-2' year(3) ^to^ minute", ANY);
        this.checkExpFails("interval '1-2' year(3) ^to^ second", ANY);
        this.checkExpFails("interval '1-2' month(3) ^to^ year", ANY);
        this.checkExpFails("interval '1-2' month(3) ^to^ month", ANY);
        this.checkExpFails("interval '1-2' month(3) ^to^ day", ANY);
        this.checkExpFails("interval '1-2' month(3) ^to^ hour", ANY);
        this.checkExpFails("interval '1-2' month(3) ^to^ minute", ANY);
        this.checkExpFails("interval '1-2' month(3) ^to^ second", ANY);
        this.checkExpFails("interval '1-2' day(3) ^to^ year", ANY);
        this.checkExpFails("interval '1-2' day(3) ^to^ month", ANY);
        this.checkExpFails("interval '1-2' hour(3) ^to^ year", ANY);
        this.checkExpFails("interval '1-2' hour(3) ^to^ month", ANY);
        this.checkExpFails("interval '1-2' hour(3) ^to^ day", ANY);
        this.checkExpFails("interval '1-2' minute(3) ^to^ year", ANY);
        this.checkExpFails("interval '1-2' minute(3) ^to^ month", ANY);
        this.checkExpFails("interval '1-2' minute(3) ^to^ day", ANY);
        this.checkExpFails("interval '1-2' minute(3) ^to^ hour", ANY);
        this.checkExpFails("interval '1-2' second(3) ^to^ year", ANY);
        this.checkExpFails("interval '1-2' second(3) ^to^ month", ANY);
        this.checkExpFails("interval '1-2' second(3) ^to^ day", ANY);
        this.checkExpFails("interval '1-2' second(3) ^to^ hour", ANY);
        this.checkExpFails("interval '1-2' second(3) ^to^ minute", ANY);
        this.checkExpFails("interval '1' year ^to^ year(2)", ANY);
        this.checkExpFails("interval '1-2' year to month^(^2)", ANY);
        this.checkExpFails("interval '1-2' year ^to^ day(2)", ANY);
        this.checkExpFails("interval '1-2' year ^to^ hour(2)", ANY);
        this.checkExpFails("interval '1-2' year ^to^ minute(2)", ANY);
        this.checkExpFails("interval '1-2' year ^to^ second(2)", ANY);
        this.checkExpFails("interval '1-2' year ^to^ second(2,6)", ANY);
        this.checkExpFails("interval '1-2' month ^to^ year(2)", ANY);
        this.checkExpFails("interval '1-2' month ^to^ month(2)", ANY);
        this.checkExpFails("interval '1-2' month ^to^ day(2)", ANY);
        this.checkExpFails("interval '1-2' month ^to^ hour(2)", ANY);
        this.checkExpFails("interval '1-2' month ^to^ minute(2)", ANY);
        this.checkExpFails("interval '1-2' month ^to^ second(2)", ANY);
        this.checkExpFails("interval '1-2' month ^to^ second(2,6)", ANY);
        this.checkExpFails("interval '1-2' day ^to^ year(2)", ANY);
        this.checkExpFails("interval '1-2' day ^to^ month(2)", ANY);
        this.checkExpFails("interval '1-2' day ^to^ day(2)", ANY);
        this.checkExpFails("interval '1-2' day to hour^(^2)", ANY);
        this.checkExpFails("interval '1-2' day to minute^(^2)", ANY);
        this.checkExpFails("interval '1-2' day to second(2^,^6)", ANY);
        this.checkExpFails("interval '1-2' hour ^to^ year(2)", ANY);
        this.checkExpFails("interval '1-2' hour ^to^ month(2)", ANY);
        this.checkExpFails("interval '1-2' hour ^to^ day(2)", ANY);
        this.checkExpFails("interval '1-2' hour ^to^ hour(2)", ANY);
        this.checkExpFails("interval '1-2' hour to minute^(^2)", ANY);
        this.checkExpFails("interval '1-2' hour to second(2^,^6)", ANY);
        this.checkExpFails("interval '1-2' minute ^to^ year(2)", ANY);
        this.checkExpFails("interval '1-2' minute ^to^ month(2)", ANY);
        this.checkExpFails("interval '1-2' minute ^to^ day(2)", ANY);
        this.checkExpFails("interval '1-2' minute ^to^ hour(2)", ANY);
        this.checkExpFails("interval '1-2' minute ^to^ minute(2)", ANY);
        this.checkExpFails("interval '1-2' minute to second(2^,^6)", ANY);
        this.checkExpFails("interval '1-2' second ^to^ year(2)", ANY);
        this.checkExpFails("interval '1-2' second ^to^ month(2)", ANY);
        this.checkExpFails("interval '1-2' second ^to^ day(2)", ANY);
        this.checkExpFails("interval '1-2' second ^to^ hour(2)", ANY);
        this.checkExpFails("interval '1-2' second ^to^ minute(2)", ANY);
        this.checkExpFails("interval '1-2' second ^to^ second(2)", ANY);
        this.checkExpFails("interval '1-2' second ^to^ second(2,6)", ANY);
        this.checkExpFails("interval '1' year(3) ^to^ year(2)", ANY);
        this.checkExpFails("interval '1-2' year(3) to month^(^2)", ANY);
        this.checkExpFails("interval '1-2' year(3) ^to^ day(2)", ANY);
        this.checkExpFails("interval '1-2' year(3) ^to^ hour(2)", ANY);
        this.checkExpFails("interval '1-2' year(3) ^to^ minute(2)", ANY);
        this.checkExpFails("interval '1-2' year(3) ^to^ second(2)", ANY);
        this.checkExpFails("interval '1-2' year(3) ^to^ second(2,6)", ANY);
        this.checkExpFails("interval '1-2' month(3) ^to^ year(2)", ANY);
        this.checkExpFails("interval '1-2' month(3) ^to^ month(2)", ANY);
        this.checkExpFails("interval '1-2' month(3) ^to^ day(2)", ANY);
        this.checkExpFails("interval '1-2' month(3) ^to^ hour(2)", ANY);
        this.checkExpFails("interval '1-2' month(3) ^to^ minute(2)", ANY);
        this.checkExpFails("interval '1-2' month(3) ^to^ second(2)", ANY);
        this.checkExpFails("interval '1-2' month(3) ^to^ second(2,6)", ANY);
        this.checkExpFails("interval '1-2' day(3) ^to^ year(2)", ANY);
        this.checkExpFails("interval '1-2' day(3) ^to^ month(2)", ANY);
        this.checkExpFails("interval '1-2' day(3) ^to^ day(2)", ANY);
        this.checkExpFails("interval '1-2' day(3) to hour^(^2)", ANY);
        this.checkExpFails("interval '1-2' day(3) to minute^(^2)", ANY);
        this.checkExpFails("interval '1-2' day(3) to second(2^,^6)", ANY);
        this.checkExpFails("interval '1-2' hour(3) ^to^ year(2)", ANY);
        this.checkExpFails("interval '1-2' hour(3) ^to^ month(2)", ANY);
        this.checkExpFails("interval '1-2' hour(3) ^to^ day(2)", ANY);
        this.checkExpFails("interval '1-2' hour(3) ^to^ hour(2)", ANY);
        this.checkExpFails("interval '1-2' hour(3) to minute^(^2)", ANY);
        this.checkExpFails("interval '1-2' hour(3) to second(2^,^6)", ANY);
        this.checkExpFails("interval '1-2' minute(3) ^to^ year(2)", ANY);
        this.checkExpFails("interval '1-2' minute(3) ^to^ month(2)", ANY);
        this.checkExpFails("interval '1-2' minute(3) ^to^ day(2)", ANY);
        this.checkExpFails("interval '1-2' minute(3) ^to^ hour(2)", ANY);
        this.checkExpFails("interval '1-2' minute(3) ^to^ minute(2)", ANY);
        this.checkExpFails("interval '1-2' minute(3) to second(2^,^6)", ANY);
        this.checkExpFails("interval '1-2' second(3) ^to^ year(2)", ANY);
        this.checkExpFails("interval '1-2' second(3) ^to^ month(2)", ANY);
        this.checkExpFails("interval '1-2' second(3) ^to^ day(2)", ANY);
        this.checkExpFails("interval '1-2' second(3) ^to^ hour(2)", ANY);
        this.checkExpFails("interval '1-2' second(3) ^to^ minute(2)", ANY);
        this.checkExpFails("interval '1-2' second(3) ^to^ second(2)", ANY);
        this.checkExpFails("interval '1-2' second(3) ^to^ second(2,6)", ANY);
        this.checkExpFails("INTERVAL '0' YEAR^(^-1)", ANY);
        this.checkExpFails("INTERVAL '0-0' YEAR^(^-1) TO MONTH", ANY);
        this.checkExpFails("INTERVAL '0' MONTH^(^-1)", ANY);
        this.checkExpFails("INTERVAL '0' DAY^(^-1)", ANY);
        this.checkExpFails("INTERVAL '0 0' DAY^(^-1) TO HOUR", ANY);
        this.checkExpFails("INTERVAL '0 0' DAY^(^-1) TO MINUTE", ANY);
        this.checkExpFails("INTERVAL '0 0:0:0' DAY^(^-1) TO SECOND", ANY);
        this.checkExpFails("INTERVAL '0 0:0:0' DAY TO SECOND^(^-1)", ANY);
        this.checkExpFails("INTERVAL '0' HOUR^(^-1)", ANY);
        this.checkExpFails("INTERVAL '0:0' HOUR^(^-1) TO MINUTE", ANY);
        this.checkExpFails("INTERVAL '0:0:0' HOUR^(^-1) TO SECOND", ANY);
        this.checkExpFails("INTERVAL '0:0:0' HOUR TO SECOND^(^-1)", ANY);
        this.checkExpFails("INTERVAL '0' MINUTE^(^-1)", ANY);
        this.checkExpFails("INTERVAL '0:0' MINUTE^(^-1) TO SECOND", ANY);
        this.checkExpFails("INTERVAL '0:0' MINUTE TO SECOND^(^-1)", ANY);
        this.checkExpFails("INTERVAL '0' SECOND^(^-1)", ANY);
        this.checkExpFails("INTERVAL '0' SECOND(1^,^ -1)", ANY);
        this.checkExpFails("interval '1' day(3) ^to^ day", ANY);
        this.checkExpFails("interval '1' hour(3) ^to^ hour", ANY);
        this.checkExpFails("interval '1' minute(3) ^to^ minute", ANY);
        this.checkExpFails("interval '1' second(3) ^to^ second", ANY);
        this.checkExpFails("interval '1' second(3,1) ^to^ second", ANY);
        this.checkExpFails("interval '1' second(2,3) ^to^ second", ANY);
        this.checkExpFails("interval '1' second(2,2) ^to^ second(3)", ANY);
    }

    @Test
    public void testMiscIntervalQualifier() {
        this.checkExp("interval '-' day", "INTERVAL '-' DAY");
        this.checkExpFails("interval '1 2:3:4.567' day to hour ^to^ second", "(?s)Encountered \"to\" at.*");
        this.checkExpFails("interval '1:2' minute to second(2^,^ 2)", "(?s)Encountered \",\" at.*");
        this.checkExp("interval '1:x' hour to minute", "INTERVAL '1:x' HOUR TO MINUTE");
        this.checkExp("interval '1:x:2' hour to second", "INTERVAL '1:x:2' HOUR TO SECOND");
    }

    @Test
    public void testIntervalOperators() {
        this.checkExp("-interval '1' day", "(- INTERVAL '1' DAY)");
        this.checkExp("interval '1' day + interval '1' day", "(INTERVAL '1' DAY + INTERVAL '1' DAY)");
        this.checkExp("interval '1' day - interval '1:2:3' hour to second", "(INTERVAL '1' DAY - INTERVAL '1:2:3' HOUR TO SECOND)");
        this.checkExp("interval -'1' day", "INTERVAL -'1' DAY");
        this.checkExp("interval '-1' day", "INTERVAL '-1' DAY");
        this.checkExpFails("interval 'wael was here^'^", "(?s)Encountered \"<EOF>\".*");
        this.checkExp("interval 'wael was here' HOUR", "INTERVAL 'wael was here' HOUR");
    }

    @Test
    public void testDateMinusDate() {
        this.checkExp("(date1 - date2) HOUR", "((`DATE1` - `DATE2`) HOUR)");
        this.checkExp("(date1 - date2) YEAR TO MONTH", "((`DATE1` - `DATE2`) YEAR TO MONTH)");
        this.checkExp("(date1 - date2) HOUR > interval '1' HOUR", "(((`DATE1` - `DATE2`) HOUR) > INTERVAL '1' HOUR)");
        this.checkExpFails("^(date1 + date2) second^", "(?s).*Illegal expression. Was expecting ..DATETIME - DATETIME. INTERVALQUALIFIER.*");
        this.checkExpFails("^(date1,date2,date2) second^", "(?s).*Illegal expression. Was expecting ..DATETIME - DATETIME. INTERVALQUALIFIER.*");
    }

    @Test
    public void testExtract() {
        this.checkExp("extract(year from x)", "EXTRACT(YEAR FROM `X`)");
        this.checkExp("extract(month from x)", "EXTRACT(MONTH FROM `X`)");
        this.checkExp("extract(day from x)", "EXTRACT(DAY FROM `X`)");
        this.checkExp("extract(hour from x)", "EXTRACT(HOUR FROM `X`)");
        this.checkExp("extract(minute from x)", "EXTRACT(MINUTE FROM `X`)");
        this.checkExp("extract(second from x)", "EXTRACT(SECOND FROM `X`)");
        this.checkExpFails("extract(day ^to^ second from x)", "(?s)Encountered \"to\".*");
    }

    @Test
    public void testIntervalArithmetics() {
        this.checkExp("TIME '23:59:59' - interval '1' hour ", "(TIME '23:59:59' - INTERVAL '1' HOUR)");
        this.checkExp("TIMESTAMP '2000-01-01 23:59:59.1' - interval '1' hour ", "(TIMESTAMP '2000-01-01 23:59:59.1' - INTERVAL '1' HOUR)");
        this.checkExp("DATE '2000-01-01' - interval '1' hour ", "(DATE '2000-01-01' - INTERVAL '1' HOUR)");
        this.checkExp("TIME '23:59:59' + interval '1' hour ", "(TIME '23:59:59' + INTERVAL '1' HOUR)");
        this.checkExp("TIMESTAMP '2000-01-01 23:59:59.1' + interval '1' hour ", "(TIMESTAMP '2000-01-01 23:59:59.1' + INTERVAL '1' HOUR)");
        this.checkExp("DATE '2000-01-01' + interval '1' hour ", "(DATE '2000-01-01' + INTERVAL '1' HOUR)");
        this.checkExp("interval '1' hour + TIME '23:59:59' ", "(INTERVAL '1' HOUR + TIME '23:59:59')");
        this.checkExp("interval '1' hour * 8", "(INTERVAL '1' HOUR * 8)");
        this.checkExp("1 * interval '1' hour", "(1 * INTERVAL '1' HOUR)");
        this.checkExp("interval '1' hour / 8", "(INTERVAL '1' HOUR / 8)");
    }

    @Test
    public void testIntervalCompare() {
        this.checkExp("interval '1' hour = interval '1' second", "(INTERVAL '1' HOUR = INTERVAL '1' SECOND)");
        this.checkExp("interval '1' hour <> interval '1' second", "(INTERVAL '1' HOUR <> INTERVAL '1' SECOND)");
        this.checkExp("interval '1' hour < interval '1' second", "(INTERVAL '1' HOUR < INTERVAL '1' SECOND)");
        this.checkExp("interval '1' hour <= interval '1' second", "(INTERVAL '1' HOUR <= INTERVAL '1' SECOND)");
        this.checkExp("interval '1' hour > interval '1' second", "(INTERVAL '1' HOUR > INTERVAL '1' SECOND)");
        this.checkExp("interval '1' hour >= interval '1' second", "(INTERVAL '1' HOUR >= INTERVAL '1' SECOND)");
    }

    @Test
    public void testCastToInterval() {
        this.checkExp("cast(x as interval year)", "CAST(`X` AS INTERVAL YEAR)");
        this.checkExp("cast(x as interval month)", "CAST(`X` AS INTERVAL MONTH)");
        this.checkExp("cast(x as interval year to month)", "CAST(`X` AS INTERVAL YEAR TO MONTH)");
        this.checkExp("cast(x as interval day)", "CAST(`X` AS INTERVAL DAY)");
        this.checkExp("cast(x as interval hour)", "CAST(`X` AS INTERVAL HOUR)");
        this.checkExp("cast(x as interval minute)", "CAST(`X` AS INTERVAL MINUTE)");
        this.checkExp("cast(x as interval second)", "CAST(`X` AS INTERVAL SECOND)");
        this.checkExp("cast(x as interval day to hour)", "CAST(`X` AS INTERVAL DAY TO HOUR)");
        this.checkExp("cast(x as interval day to minute)", "CAST(`X` AS INTERVAL DAY TO MINUTE)");
        this.checkExp("cast(x as interval day to second)", "CAST(`X` AS INTERVAL DAY TO SECOND)");
        this.checkExp("cast(x as interval hour to minute)", "CAST(`X` AS INTERVAL HOUR TO MINUTE)");
        this.checkExp("cast(x as interval hour to second)", "CAST(`X` AS INTERVAL HOUR TO SECOND)");
        this.checkExp("cast(x as interval minute to second)", "CAST(`X` AS INTERVAL MINUTE TO SECOND)");
    }

    @Test
    public void testUnnest() {
        this.check("select*from unnest(x)", "SELECT *\nFROM (UNNEST(`X`))");
        this.check("select*from unnest(x) AS T", "SELECT *\nFROM (UNNEST(`X`)) AS `T`");
        this.checkFails("^unnest^(x)", "(?s)Encountered \"unnest\" at.*");
    }

    @Test
    public void testParensInFrom() {
        this.checkFails("select *from ^(^unnest(x))", "(?s)Encountered \"\\( unnest\" at .*");
        this.checkFails("select * from (^emp^)", "(?s)Non-query expression encountered in illegal context.*");
        this.checkFails("select * from (^emp^ as x)", "(?s)Non-query expression encountered in illegal context.*");
        this.checkFails("select * from (^emp^) as x", "(?s)Non-query expression encountered in illegal context.*");
    }

    @Test
    public void testProcedureCall() {
        this.check("call blubber(5)", "(CALL `BLUBBER`(5))");
        this.check("call \"blubber\"(5)", "(CALL `blubber`(5))");
        this.check("call whale.blubber(5)", "(CALL `WHALE`.`BLUBBER`(5))");
    }

    @Test
    public void testNewSpecification() {
        this.checkExp("new udt()", "(NEW `UDT`())");
        this.checkExp("new my.udt(1, 'hey')", "(NEW `MY`.`UDT`(1, 'hey'))");
        this.checkExp("new udt() is not null", "((NEW `UDT`()) IS NOT NULL)");
        this.checkExp("1 + new udt()", "(1 + (NEW `UDT`()))");
    }

    @Test
    public void testMultisetCast() {
        this.checkExp("cast(multiset[1] as double multiset)", "CAST((MULTISET[1]) AS DOUBLE MULTISET)");
    }

    @Test
    public void testAddCarets() {
        Assert.assertEquals((Object)"values (^foo^)", (Object)SqlParserUtil.addCarets((String)"values (foo)", (int)1, (int)9, (int)1, (int)12));
        Assert.assertEquals((Object)"abc^def", (Object)SqlParserUtil.addCarets((String)"abcdef", (int)1, (int)4, (int)1, (int)4));
        Assert.assertEquals((Object)"abcdef^", (Object)SqlParserUtil.addCarets((String)"abcdef", (int)1, (int)7, (int)1, (int)7));
    }

    @Test
    public void testMetadata() {
        SqlAbstractParserImpl.Metadata metadata = this.getParserMetadata();
        Assert.assertTrue((boolean)metadata.isReservedFunctionName("ABS"));
        Assert.assertFalse((boolean)metadata.isReservedFunctionName("FOO"));
        Assert.assertTrue((boolean)metadata.isContextVariableName("CURRENT_USER"));
        Assert.assertTrue((boolean)metadata.isContextVariableName("CURRENT_CATALOG"));
        Assert.assertTrue((boolean)metadata.isContextVariableName("CURRENT_SCHEMA"));
        Assert.assertFalse((boolean)metadata.isContextVariableName("ABS"));
        Assert.assertFalse((boolean)metadata.isContextVariableName("FOO"));
        Assert.assertTrue((boolean)metadata.isNonReservedKeyword("A"));
        Assert.assertTrue((boolean)metadata.isNonReservedKeyword("KEY"));
        Assert.assertFalse((boolean)metadata.isNonReservedKeyword("SELECT"));
        Assert.assertFalse((boolean)metadata.isNonReservedKeyword("FOO"));
        Assert.assertFalse((boolean)metadata.isNonReservedKeyword("ABS"));
        Assert.assertTrue((boolean)metadata.isKeyword("ABS"));
        Assert.assertTrue((boolean)metadata.isKeyword("CURRENT_USER"));
        Assert.assertTrue((boolean)metadata.isKeyword("CURRENT_CATALOG"));
        Assert.assertTrue((boolean)metadata.isKeyword("CURRENT_SCHEMA"));
        Assert.assertTrue((boolean)metadata.isKeyword("KEY"));
        Assert.assertTrue((boolean)metadata.isKeyword("SELECT"));
        Assert.assertTrue((boolean)metadata.isKeyword("HAVING"));
        Assert.assertTrue((boolean)metadata.isKeyword("A"));
        Assert.assertFalse((boolean)metadata.isKeyword("BAR"));
        Assert.assertTrue((boolean)metadata.isReservedWord("SELECT"));
        Assert.assertTrue((boolean)metadata.isReservedWord("CURRENT_CATALOG"));
        Assert.assertTrue((boolean)metadata.isReservedWord("CURRENT_SCHEMA"));
        Assert.assertFalse((boolean)metadata.isReservedWord("KEY"));
        String jdbcKeywords = metadata.getJdbcKeywords();
        Assert.assertTrue((boolean)jdbcKeywords.contains(",COLLECT,"));
        Assert.assertTrue((!jdbcKeywords.contains(",SELECT,") ? 1 : 0) != 0);
    }

    @Test
    public void testTabStop() {
        this.check("SELECT *\n\tFROM mytable", "SELECT *\nFROM `MYTABLE`");
        this.checkFails("SELECT *\tFROM mytable\t\tWHERE x ^=^ = y AND b = 1", "(?s).*Encountered \"= =\" at line 1, column 32\\..*");
    }

    @Test
    public void testLongIdentifiers() {
        StringBuilder ident128Builder = new StringBuilder();
        int i = 0;
        while (i < 128) {
            ident128Builder.append((char)(97 + i % 26));
            ++i;
        }
        String ident128 = ident128Builder.toString();
        String ident128Upper = ident128.toUpperCase(Locale.US);
        String ident129 = "x" + ident128;
        String ident129Upper = ident129.toUpperCase(Locale.US);
        this.check("select * from " + ident128, "SELECT *\nFROM `" + ident128Upper + "`");
        this.checkFails("select * from ^" + ident129 + "^", "Length of identifier '" + ident129Upper + "' must be less than or equal to 128 characters");
        this.check("select " + ident128 + " from mytable", "SELECT `" + ident128Upper + "`\n" + "FROM `MYTABLE`");
        this.checkFails("select ^" + ident129 + "^ from mytable", "Length of identifier '" + ident129Upper + "' must be less than or equal to 128 characters");
    }

    @Test
    public void testQuotedFunction() {
        this.checkExpFails("\"CAST\"(1 ^as^ double)", "(?s).*Encountered \"as\" at .*");
        this.checkExpFails("\"POSITION\"('b' ^in^ 'alphabet')", "(?s).*Encountered \"in \\\\'alphabet\\\\'\" at .*");
        this.checkExpFails("\"OVERLAY\"('a' ^PLAcing^ 'b' from 1)", "(?s).*Encountered \"PLAcing\" at.*");
        this.checkExpFails("\"SUBSTRING\"('a' ^from^ 1)", "(?s).*Encountered \"from\" at .*");
    }

    @Test
    public void testUnicodeLiteral() {
        String in1 = "values _UTF16'\u03b1\u03bd\u03b8\u03c1\u03c9\u03c0\u03bf\u03c2'";
        String out1 = "(VALUES (ROW(_UTF16'\u03b1\u03bd\u03b8\u03c1\u03c9\u03c0\u03bf\u03c2')))";
        this.check(in1, out1);
        String in2 = "values '\\03B1\\03BD\\03B8\\03C1\\03C9\\03C0\\03BF\\03C2'";
        String out2 = "(VALUES (ROW('\\03B1\\03BD\\03B8\\03C1\\03C9\\03C0\\03BF\\03C2')))";
        this.check(in2, out2);
        String in3 = "values U&'\\03B1\\03BD\\03B8\\03C1\\03C9\\03C0\\03BF\\03C2' UESCAPE '!'";
        String out3 = "(VALUES (ROW(_UTF16'\\03B1\\03BD\\03B8\\03C1\\03C9\\03C0\\03BF\\03C2')))";
        this.check(in3, out3);
    }

    @Test
    public void testUnicodeEscapedLiteral() {
        String in = "values U&'\\03B1\\03BD\\03B8\\03C1\\03C9\\03C0\\03BF\\03C2'";
        String out = "(VALUES (ROW(_UTF16'\u03b1\u03bd\u03b8\u03c1\u03c9\u03c0\u03bf\u03c2')))";
        this.check(in, out);
        this.check(String.valueOf(in.replaceAll("\\\\", "!")) + "UESCAPE '!'", out);
    }

    @Test
    public void testIllegalUnicodeEscape() {
        this.checkExpFails("U&'abc' UESCAPE '!!'", ".*must be exactly one character.*");
        this.checkExpFails("U&'abc' UESCAPE ''", ".*must be exactly one character.*");
        this.checkExpFails("U&'abc' UESCAPE '0'", ".*hex digit.*");
        this.checkExpFails("U&'abc' UESCAPE 'a'", ".*hex digit.*");
        this.checkExpFails("U&'abc' UESCAPE 'F'", ".*hex digit.*");
        this.checkExpFails("U&'abc' UESCAPE ' '", ".*whitespace.*");
        this.checkExpFails("U&'abc' UESCAPE '+'", ".*plus sign.*");
        this.checkExpFails("U&'abc' UESCAPE '\"'", ".*double quote.*");
        this.checkExpFails("'abc' UESCAPE ^'!'^", ".*without Unicode literal introducer.*");
        this.checkExpFails("^U&'\\0A'^", ".*is not exactly four hex digits.*");
        this.checkExpFails("^U&'\\wxyz'^", ".*is not exactly four hex digits.*");
    }

    protected static interface Tester {
        public void check(String var1, String var2);

        public void checkExp(String var1, String var2);

        public void checkFails(String var1, String var2);

        public void checkExpFails(String var1, String var2);
    }

    protected class TesterImpl
    implements Tester {
        protected TesterImpl() {
        }

        public void check(String sql, String expected) {
            SqlNode sqlNode = this.parseStmtAndHandleEx(sql);
            String actual = sqlNode.toSqlString(null, true).getSql();
            if (((boolean[])LINUXIFY.get())[0]) {
                actual = Util.toLinux((String)actual);
            }
            TestUtil.assertEqualsVerbose(expected, actual);
        }

        protected SqlNode parseStmtAndHandleEx(String sql) {
            SqlNode sqlNode;
            try {
                sqlNode = SqlParserTest.this.parseStmt(sql);
            }
            catch (SqlParseException e) {
                e.printStackTrace();
                String message = "Received error while parsing SQL '" + sql + "'; error is:\n" + e.toString();
                throw new AssertionError((Object)message);
            }
            return sqlNode;
        }

        public void checkExp(String sql, String expected) {
            SqlNode sqlNode = this.parseExpressionAndHandleEx(sql);
            String actual = sqlNode.toSqlString(null, true).getSql();
            if (((boolean[])LINUXIFY.get())[0]) {
                actual = Util.toLinux((String)actual);
            }
            TestUtil.assertEqualsVerbose(expected, actual);
        }

        protected SqlNode parseExpressionAndHandleEx(String sql) {
            SqlNode sqlNode;
            try {
                sqlNode = SqlParserTest.this.parseExpression(sql);
            }
            catch (SqlParseException e) {
                String message = "Received error while parsing SQL '" + sql + "'; error is:\n" + e.toString();
                throw new RuntimeException(message, e);
            }
            return sqlNode;
        }

        public void checkFails(String sql, String expectedMsgPattern) {
            SqlParserUtil.StringAndPos sap = SqlParserUtil.findPos((String)sql);
            Throwable thrown = null;
            try {
                SqlNode sqlNode = SqlParserTest.this.parseStmt(sap.sql);
                Util.discard((Object)sqlNode);
            }
            catch (Throwable ex) {
                thrown = ex;
            }
            SqlValidatorTestCase.checkEx(thrown, expectedMsgPattern, sap);
        }

        public void checkExpFails(String sql, String expectedMsgPattern) {
            SqlParserUtil.StringAndPos sap = SqlParserUtil.findPos((String)sql);
            Throwable thrown = null;
            try {
                SqlNode sqlNode = SqlParserTest.this.parseExpression(sap.sql);
                Util.discard((Object)sqlNode);
            }
            catch (Throwable ex) {
                thrown = ex;
            }
            SqlValidatorTestCase.checkEx(thrown, expectedMsgPattern, sap);
        }
    }

    public class UnparsingTesterImpl
    extends TesterImpl {
        public void check(String sql, String expected) {
            SqlNode sqlNode = this.parseStmtAndHandleEx(sql);
            String actual = sqlNode.toSqlString(null, true).getSql();
            Assert.assertEquals((Object)expected, (Object)actual);
            String sql1 = sqlNode.toSqlString(SqlDialect.EIGENBASE, false).getSql();
            SqlNode sqlNode2 = this.parseStmtAndHandleEx(sql1);
            String sql2 = sqlNode2.toSqlString(SqlDialect.EIGENBASE, false).getSql();
            Assert.assertEquals((Object)sql1, (Object)sql2);
            String actual2 = sqlNode2.toSqlString(null, true).getSql();
            Assert.assertEquals((Object)expected, (Object)actual2);
        }

        public void checkExp(String sql, String expected) {
            SqlNode sqlNode = this.parseExpressionAndHandleEx(sql);
            String actual = sqlNode.toSqlString(null, true).getSql();
            Assert.assertEquals((Object)expected, (Object)actual);
            String sql1 = sqlNode.toSqlString(SqlDialect.EIGENBASE, false).getSql();
            SqlNode sqlNode2 = this.parseExpressionAndHandleEx(sql1);
            String sql2 = sqlNode2.toSqlString(SqlDialect.EIGENBASE, false).getSql();
            Assert.assertEquals((Object)sql1, (Object)sql2);
            String actual2 = sqlNode2.toSqlString(null, true).getSql();
            Assert.assertEquals((Object)expected, (Object)actual2);
        }

        public void checkFails(String sql, String expectedMsgPattern) {
        }

        public void checkExpFails(String sql, String expectedMsgPattern) {
        }
    }
}

