/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.tools;

import java.util.ArrayList;
import java.util.List;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.config.Lex;
import net.hydromatic.optiq.impl.java.ReflectiveSchema;
import net.hydromatic.optiq.impl.jdbc.JdbcConvention;
import net.hydromatic.optiq.impl.jdbc.JdbcImplementor;
import net.hydromatic.optiq.impl.jdbc.JdbcRel;
import net.hydromatic.optiq.impl.jdbc.JdbcRules;
import net.hydromatic.optiq.rules.java.EnumerableConvention;
import net.hydromatic.optiq.rules.java.JavaRules;
import net.hydromatic.optiq.test.JdbcTest;
import net.hydromatic.optiq.tools.Frameworks;
import net.hydromatic.optiq.tools.Planner;
import net.hydromatic.optiq.tools.RuleSet;
import net.hydromatic.optiq.tools.RuleSets;
import net.hydromatic.optiq.tools.ValidationException;
import org.eigenbase.rel.RelCollationTraitDef;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.TableAccessRelBase;
import org.eigenbase.rel.convert.ConverterRule;
import org.eigenbase.rel.rules.MergeFilterRule;
import org.eigenbase.relopt.ConventionTraitDef;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.relopt.RelTraitDef;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.sql.SqlDialect;
import org.eigenbase.sql.SqlExplainLevel;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParseException;
import org.eigenbase.sql.parser.SqlParserImplFactory;
import org.eigenbase.sql.parser.impl.SqlParserImpl;
import org.eigenbase.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlannerTest {
    @Test
    public void testParseAndConvert() throws Exception {
        Planner planner = this.getPlanner(null, new RuleSet[0]);
        SqlNode parse = planner.parse("select * from \"emps\" where \"name\" like '%e%'");
        Assert.assertThat((Object)Util.toLinux((String)parse.toString()), (Matcher)CoreMatchers.equalTo((Object)"SELECT *\nFROM `emps`\nWHERE `name` LIKE '%e%'"));
        SqlNode validate = planner.validate(parse);
        RelNode rel = planner.convert(validate);
        Assert.assertThat((Object)this.toString(rel), (Matcher)CoreMatchers.equalTo((Object)"ProjectRel(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4])\n  FilterRel(condition=[LIKE($2, '%e%')])\n    EnumerableTableAccessRel(table=[[hr, emps]])\n"));
    }

    private String toString(RelNode rel) {
        return Util.toLinux((String)RelOptUtil.dumpPlan((String)"", (RelNode)rel, (boolean)false, (SqlExplainLevel)SqlExplainLevel.DIGEST_ATTRIBUTES));
    }

    @Test
    public void testParseFails() throws SqlParseException {
        Planner planner = this.getPlanner(null, new RuleSet[0]);
        try {
            SqlNode parse = planner.parse("select * * from \"emps\"");
            Assert.fail((String)("expected error, got " + parse));
        }
        catch (SqlParseException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Encountered \"*\" at line 1, column 10."));
        }
    }

    @Test
    public void testValidateFails() throws SqlParseException {
        Planner planner = this.getPlanner(null, new RuleSet[0]);
        SqlNode parse = planner.parse("select * from \"emps\" where \"Xname\" like '%e%'");
        Assert.assertThat((Object)Util.toLinux((String)parse.toString()), (Matcher)CoreMatchers.equalTo((Object)"SELECT *\nFROM `emps`\nWHERE `Xname` LIKE '%e%'"));
        try {
            SqlNode validate = planner.validate(parse);
            Assert.fail((String)("expected error, got " + validate));
        }
        catch (ValidationException e) {
            Assert.assertThat((Object)Util.getStackTrace((Throwable)e), (Matcher)CoreMatchers.containsString((String)"Column 'Xname' not found in any table"));
        }
    }

    private Planner getPlanner(List<RelTraitDef> traitDefs, RuleSet ... ruleSets) {
        return Frameworks.getPlanner((Lex)Lex.ORACLE, (SqlParserImplFactory)SqlParserImpl.FACTORY, (Function1)new Function1<SchemaPlus, Schema>(){

            public Schema apply(SchemaPlus parentSchema) {
                return new ReflectiveSchema(parentSchema, "hr", (Object)new JdbcTest.HrSchema());
            }
        }, (SqlStdOperatorTable)SqlStdOperatorTable.instance(), traitDefs, (RuleSet[])ruleSets);
    }

    @Test
    public void testConvertWithoutValidateFails() throws Exception {
        Planner planner = this.getPlanner(null, new RuleSet[0]);
        SqlNode parse = planner.parse("select * from \"emps\"");
        try {
            RelNode rel = planner.convert(parse);
            Assert.fail((String)("expected error, got " + rel));
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"cannot move from STATE_3_PARSED to STATE_4_VALIDATED"));
        }
    }

    @Test
    public void testPlan() throws Exception {
        RuleSet ruleSet = RuleSets.ofList((RelOptRule[])new RelOptRule[]{MergeFilterRule.INSTANCE, JavaRules.ENUMERABLE_FILTER_RULE, JavaRules.ENUMERABLE_PROJECT_RULE});
        Planner planner = this.getPlanner(null, ruleSet);
        SqlNode parse = planner.parse("select * from \"emps\"");
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.convert(validate);
        RelTraitSet traitSet = planner.getEmptyTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelNode transform = planner.transform(0, traitSet, convert);
        Assert.assertThat((Object)this.toString(transform), (Matcher)CoreMatchers.equalTo((Object)"EnumerableProjectRel(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4])\n  EnumerableTableAccessRel(table=[[hr, emps]])\n"));
    }

    @Test
    public void testPlanWithExplicitTraitDefs() throws Exception {
        RuleSet ruleSet = RuleSets.ofList((RelOptRule[])new RelOptRule[]{MergeFilterRule.INSTANCE, JavaRules.ENUMERABLE_FILTER_RULE, JavaRules.ENUMERABLE_PROJECT_RULE});
        ArrayList<RelTraitDef> traitDefs = new ArrayList<RelTraitDef>();
        traitDefs.add((RelTraitDef)ConventionTraitDef.INSTANCE);
        traitDefs.add((RelTraitDef)RelCollationTraitDef.INSTANCE);
        Planner planner = this.getPlanner(traitDefs, ruleSet);
        SqlNode parse = planner.parse("select * from \"emps\"");
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.convert(validate);
        RelTraitSet traitSet = planner.getEmptyTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelNode transform = planner.transform(0, traitSet, convert);
        Assert.assertThat((Object)this.toString(transform), (Matcher)CoreMatchers.equalTo((Object)"EnumerableProjectRel(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4])\n  EnumerableTableAccessRel(table=[[hr, emps]])\n"));
    }

    @Test
    public void testPlanTransformTwice() throws Exception {
        RuleSet ruleSet = RuleSets.ofList((RelOptRule[])new RelOptRule[]{MergeFilterRule.INSTANCE, JavaRules.ENUMERABLE_FILTER_RULE, JavaRules.ENUMERABLE_PROJECT_RULE});
        Planner planner = this.getPlanner(null, ruleSet);
        SqlNode parse = planner.parse("select * from \"emps\"");
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.convert(validate);
        RelTraitSet traitSet = planner.getEmptyTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelNode transform = planner.transform(0, traitSet, convert);
        RelNode transform2 = planner.transform(0, traitSet, transform);
        Assert.assertThat((Object)this.toString(transform2), (Matcher)CoreMatchers.equalTo((Object)"EnumerableProjectRel(empid=[$0], deptno=[$1], name=[$2], salary=[$3], commission=[$4])\n  EnumerableTableAccessRel(table=[[hr, emps]])\n"));
    }

    @Test
    public void testHiveDialect() throws SqlParseException {
        Planner planner = this.getPlanner(null, new RuleSet[0]);
        SqlNode parse = planner.parse("select * from (select * from \"emps\") as t\nwhere \"name\" like '%e%'");
        SqlDialect hiveDialect = new SqlDialect(SqlDialect.DatabaseProduct.HIVE, "Hive", null);
        Assert.assertThat((Object)Util.toLinux((String)parse.toSqlString(hiveDialect).getSql()), (Matcher)CoreMatchers.equalTo((Object)"SELECT *\nFROM (SELECT *\nFROM emps) T\nWHERE name LIKE '%e%'"));
    }

    @Test
    public void testPlanTransformWithDiffRuleSetAndConvention() throws Exception {
        RuleSet ruleSet0 = RuleSets.ofList((RelOptRule[])new RelOptRule[]{MergeFilterRule.INSTANCE, JavaRules.ENUMERABLE_FILTER_RULE, JavaRules.ENUMERABLE_PROJECT_RULE});
        JdbcConvention out = new JdbcConvention(null, "myjdbc");
        RuleSet ruleSet1 = RuleSets.ofList((RelOptRule[])new RelOptRule[]{new MockJdbcProjectRule(out), new MockJdbcTableRule(out)});
        Planner planner = this.getPlanner(null, ruleSet0, ruleSet1);
        SqlNode parse = planner.parse("select T1.\"name\" from \"emps\" as T1 ");
        SqlNode validate = planner.validate(parse);
        RelNode convert = planner.convert(validate);
        RelTraitSet traitSet0 = planner.getEmptyTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE);
        RelTraitSet traitSet1 = planner.getEmptyTraitSet().replace((RelTrait)out);
        RelNode transform = planner.transform(0, traitSet0, convert);
        RelNode transform2 = planner.transform(1, traitSet1, transform);
        Assert.assertThat((Object)this.toString(transform2), (Matcher)CoreMatchers.equalTo((Object)"JdbcProjectRel(name=[$2])\n  MockJdbcTableScan(table=[[hr, emps]])\n"));
    }

    private class MockJdbcProjectRule
    extends ConverterRule {
        private MockJdbcProjectRule(JdbcConvention out) {
            super(JavaRules.EnumerableProjectRel.class, (RelTrait)EnumerableConvention.INSTANCE, (RelTrait)out, "MockJdbcProjectRule");
        }

        public RelNode convert(RelNode rel) {
            JavaRules.EnumerableProjectRel project = (JavaRules.EnumerableProjectRel)rel;
            return new JdbcRules.JdbcProjectRel(rel.getCluster(), rel.getTraitSet().replace((RelTrait)this.getOutConvention()), MockJdbcProjectRule.convert((RelNode)project.getChild(), (RelTraitSet)project.getChild().getTraitSet().replace((RelTrait)this.getOutConvention())), project.getProjects(), project.getRowType(), 1);
        }
    }

    private class MockJdbcTableRule
    extends ConverterRule {
        private MockJdbcTableRule(JdbcConvention out) {
            super(JavaRules.EnumerableTableAccessRel.class, (RelTrait)EnumerableConvention.INSTANCE, (RelTrait)out, "MockJdbcTableRule");
        }

        public RelNode convert(RelNode rel) {
            JavaRules.EnumerableTableAccessRel scan = (JavaRules.EnumerableTableAccessRel)rel;
            return new MockJdbcTableScan(scan.getCluster(), scan.getTable(), (JdbcConvention)this.getOutConvention());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MockJdbcTableScan
    extends TableAccessRelBase
    implements JdbcRel {
        public MockJdbcTableScan(RelOptCluster cluster, RelOptTable table, JdbcConvention jdbcConvention) {
            super(cluster, cluster.traitSetOf(new RelTrait[]{jdbcConvention}), table);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new MockJdbcTableScan(this.getCluster(), this.table, (JdbcConvention)this.getConvention());
        }

        public void register(RelOptPlanner planner) {
            JdbcConvention out = (JdbcConvention)this.getConvention();
            for (RelOptRule rule : JdbcRules.rules((JdbcConvention)out)) {
                planner.addRule(rule);
            }
        }

        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            return null;
        }
    }
}

