/*
 * Decompiled with CFR 0.152.
 */
package parquet.tools.command;

import org.apache.commons.cli.CommandLine;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.tools.command.ArgsOnlyCommand;
import parquet.tools.util.MetadataUtils;
import parquet.tools.util.PrettyPrintWriter;

public class ShowMetaCommand
extends ArgsOnlyCommand {
    public static final String TABS = "    ";
    public static final int BLOCK_BUFFER_SIZE = 65536;
    public static final String[] USAGE = new String[]{"<input>", "where <input> is the parquet file to print to stdout"};

    public ShowMetaCommand() {
        super(1, 1);
    }

    @Override
    public String[] getUsageDescription() {
        return USAGE;
    }

    @Override
    public void execute(CommandLine options) throws Exception {
        super.execute(options);
        String[] args = options.getArgs();
        String input = args[0];
        Configuration conf = new Configuration();
        ParquetMetadata metaData = ParquetFileReader.readFooter((Configuration)conf, (Path)new Path(input));
        PrettyPrintWriter out = PrettyPrintWriter.stdoutPrettyPrinter().withAutoColumn().withAutoCrop().withWhitespaceHandler(PrettyPrintWriter.WhiteSpaceHandler.COLLAPSE_WHITESPACE).withColumnPadding(1).build();
        MetadataUtils.showDetails(out, metaData);
        out.flushColumns();
    }
}

