/*
 * Decompiled with CFR 0.152.
 */
package parquet.tools.command;

import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.hadoop.fs.Path;
import parquet.hadoop.ParquetReader;
import parquet.hadoop.api.ReadSupport;
import parquet.tools.Main;
import parquet.tools.command.ArgsOnlyCommand;
import parquet.tools.read.SimpleReadSupport;
import parquet.tools.read.SimpleRecord;

public class CatCommand
extends ArgsOnlyCommand {
    public static final String[] USAGE = new String[]{"<input>", "where <input> is the parquet file to print to stdout"};

    public CatCommand() {
        super(1, 1);
    }

    @Override
    public String[] getUsageDescription() {
        return USAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandLine options) throws Exception {
        super.execute(options);
        String[] args = options.getArgs();
        String input = args[0];
        ParquetReader reader = null;
        try {
            PrintWriter writer = new PrintWriter(Main.out, true);
            reader = new ParquetReader(new Path(input), (ReadSupport)new SimpleReadSupport());
            SimpleRecord value = (SimpleRecord)reader.read();
            while (value != null) {
                value.prettyPrint(writer);
                writer.println();
                value = (SimpleRecord)reader.read();
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception ex) {}
            }
        }
    }
}

